<xsl:stylesheet
  version = "2.0"
  xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes = "cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi"
  xmlns:cac = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
  xmlns:ccts = "urn:un:unece:uncefact:documentation:2"
  xmlns:clm54217 = "urn:un:unece:uncefact:codelist:specification:54217:2001"
  xmlns:clm5639 = "urn:un:unece:uncefact:codelist:specification:5639:1988"
  xmlns:clm66411 = "urn:un:unece:uncefact:codelist:specification:66411:2001"
  xmlns:clmIANAMIMEMediaType = "urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003"
  xmlns:fn = "http://www.w3.org/2005/xpath-functions"
  xmlns:link = "http://www.xbrl.org/2003/linkbase"
  xmlns:n1 = "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
  xmlns:qdt = "urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
  xmlns:udt = "urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
  xmlns:xbrldi = "http://xbrl.org/2006/xbrldi"
  xmlns:xbrli = "http://www.xbrl.org/2003/instance"
  xmlns:xdt = "http://www.w3.org/2005/xpath-datatypes"
  xmlns:xlink = "http://www.w3.org/1999/xlink"
  xmlns:xs = "http://www.w3.org/2001/XMLSchema"
  xmlns:xsd = "http://www.w3.org/2001/XMLSchema"
  xmlns:cbc = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
  xmlns:ds = "http://www.w3.org/2000/09/xmldsig#"
  xmlns:ext = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
  xmlns:xsi = "http://www.w3.org/2001/XMLSchema-instance"
  xmlns:xades = "http://uri.etsi.org/01903/v1.3.2#">

  <xsl:decimal-format name = "european" decimal-separator = "," grouping-separator = "." NaN = ""/>

  <xsl:output
    version = "4.0"
    method = "html"
    indent = "no"
    encoding = "UTF-8"
    doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system = "http://www.w3.org/TR/html4/loose.dtd"/>

  <xsl:param name = "SV_OutputFormat" select = "'HTML'"/>

  <xsl:variable name = "XML" select = "/"/>

  <xsl:template match = "/">

    <html>
      <head>
        <title/>

        <!-- #Stiller -->

        <style type = "text/css">
          body {
            width: 800px;
            color: black;
            margin: 10px;
            font-size: 9pt;
            margin-bottom: 10px;
            background-color: white;
            font-family: 'Calibri', 'Segoe UI', 'Tahoma', 'Times New Roman', 'Times', 'Serif';
          }
          table {
            margin: 0px;
            border: 2px solid silver;
            border-collapse: collapse;
          }
          td {
            padding: 2px;
            border: 1px solid silver;
          }
          a {
            color: black;
            text-decoration: none;
          }
          a:hover {
            color: red;
          }
          .dis_tablo {
            border: 0px;
            width: 98%;
          }
          .dis_tablo td {
            border: 0px;
            padding: 0px;
          }
          .kelime_kaydirma {
            white-space: nowrap;
          }
          .satici_unvan_tablosu {
            width: 98%;
            margin-bottom: 10px;
          }
          .satici_unvan_tablosu th {
            font-size: 16pt;
            background-color: #f0f0f0;
          }
          .satici_unvan_tablosu tr:hover th,
          .satici_unvan_tablosu tr:hover td {
            background-color: #ffee77;
          }
          .satici_tablosu {
            width: 90%;
          }
          .satici_tablosu th {
            text-align: center;
            background-color: #f0f0f0;
          }
          .satici_tablosu td {
            padding: 2px;
            border: 1px solid silver;
          }
          .satici_tablosu tr:hover th,
          .satici_tablosu tr:hover td {
            background-color: #ffee77;
          }
          .satici_tablosu_sube {
            width: 90%;
            float: right;
          }
          .satici_tablosu_sube th {
            text-align: center;
            background-color: #f0f0f0;
          }
          .satici_tablosu_sube td {
            padding: 2px;
            border: 1px solid silver;
          }
          .satici_tablosu_sube tr:hover th,
          .satici_tablosu_sube tr:hover td {
            background-color: #ffee77;
          }
          .alici_tablosu {
            width: 94%;
            margin-top: 10px;
          }
          .alici_tablosu th {
            text-align: center;
            background-color: #f0f0f0;
          }
          .alici_tablosu td {
            padding: 2px;
            border: 1px solid silver;
          }
          .alici_tablosu tr:hover th,
          .alici_tablosu tr:hover td {
            background-color: #ffee77;
          }
          .belge_tablosu {
            width: 98%;
          }
          .belge_tablosu th {
            text-align: center;
            background-color: #f0f0f0;
          }
          .belge_tablosu td {
            padding: 2px;
            border: 1px solid silver;
          }
          .belge_tablosu tr:hover th,
          .belge_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@Fatura_Id_leri ~ @Fatura_Id_leri -->

          .fatura_id_tablosu {
            width: 98%;
            margin-top: 9px;
          }
          .fatura_id_tablosu tr:hover th,
          .fatura_id_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@Fatura_Id_leri ~ @Fatura_Id_leri -->

          .fatura_satirlari_tablosu {
            width: 98%;
            max-width: 800px;
            margin-top: 10px;
          }
          .fatura_satirlari_tablosu th {
            padding: 2px;
            text-align: left;
            white-space: nowrap;
            vertical-align: bottom;
            border: 1px solid silver;
            background-color: #f0f0f0;
          }
          .fatura_satirlari_tablosu tr:hover th,
          .fatura_satirlari_tablosu tr:hover td {
            background-color: #ffee77;
          }
          .ihracat_bilgileri_tablosu {
            float: left;
            margin-top: 10px;
          }
          .ihracat_bilgileri_tablosu td {
            padding: 2px;
            white-space: nowrap;
            border: 1px solid silver;
          }
          .ihracat_bilgileri_tablosu tr:hover th,
          .ihracat_bilgileri_tablosu tr:hover td {
            background-color: #ffee77;
          }
          .fatura_dip_toplamlari_tablosu {
            float: right;
            margin-top: 10px;
          }
          .fatura_dip_toplamlari_tablosu td {
            padding: 2px;
            white-space: nowrap;
            border: 1px solid silver;
          }
          .fatura_dip_toplamlari_tablosu tr:hover th,
          .fatura_dip_toplamlari_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@Notlar ~ #Notlar/@Notlar -->

          .notlar_tablosu {
            width: 98%;
            float: right;
            margin-top: 10px;
          }
          .notlar_tablosu td {
            padding: 2px;
            border: 1px solid silver;
          }
          .notlar_tablosu tr:hover th,
          .notlar_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@Notlar ~ #Notlar/@Notlar -->

          <!-- #Stiller/@İrsaliyeler ~ @İrsaliyeler -->

          .irsaliyeler_tablosu {
            width: 98%;
            float: right;
            margin-top: 10px;
          }
          .irsaliyeler_tablosu td {
            padding: 2px;
            border: 1px solid silver;
          }
          .irsaliyeler_tablosu th {
            padding: 2px;
            text-align: left;
            border: 1px solid silver;
            background-color: #f0f0f0;
          }
          .irsaliyeler_tablosu tr:hover th,
          .irsaliyeler_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@İrsaliyeler ~ @İrsaliyeler -->
          
          <!-- #Stiller/@Bankalar ~ @Bankalar -->

          .bankalar_tablosu {
            width: 98%;
            float: right;
            margin-top: 10px;
          }
          .bankalar_tablosu th {
            padding: 2px;
            text-align: left;
            border: 1px solid silver;
            background-color: #f0f0f0;
          }
          .bankalar_tablosu td {
            padding: 2px;
            text-align: left;
          }
          .bankalar_tablosu tr:hover th,
          .bankalar_tablosu tr:hover td {
            background-color: #ffee77;
          }

          <!-- #Stiller/@Bankalar ~ @Bankalar -->

        </style>

        <!-- #Stiller -->

        <title>e-Fatura</title>
      </head>
      <body>
        <xsl:for-each select = "$XML">
          <table class = "dis_tablo">
            <tbody>
              <tr>
                <td colspan = "3">
                  <table class = "satici_unvan_tablosu">
                    <tbody>
                      <tr>
                        <th>AZİM TEKSTİL KONFEKSİYON GIDA TURİZM SAN. VE DIŞ TİC. LTD. ŞTİ.</th>
                      </tr>
                    </tbody>
                  </table>
                </td>
              </tr>
              <tr>
                <td style = "width: 50%">

                  <!-- #Satıcı -->

                  <table class = "satici_tablosu">
                    <tbody>

                      <!-- #Satıcı/#Unvan -->

                      <tr>
                        <th style = "font-size: 11pt" colspan = "2">
                          <strong>Merkez</strong>
                        </th>
                      </tr>

                      <!-- #Satıcı/#Unvan -->

                      <!-- #Satıcı/#Adres -->

                      <tr>
                        <td style = "width: 30%; text-align: right; vertical-align: top"><strong>Adres:</strong></td>
                        <td style = "width: 70%">Cumhuriyet Mah. Çetin Sok. No: 6 Yakacık, Kartal - İstanbul</td>
                      </tr>

                      <!-- #Satıcı/#Adres -->

                      <!-- #Satıcı/@Telefon -->

                      <tr>
                        <td align = "right"><strong>Telefon:</strong></td>
                        <td>+90 (216) 451 51 73-74</td>
                      </tr>

                      <!-- #Satıcı/@Telefon -->

                      <!-- #Satıcı/@Faks -->

                      <tr>
                        <td align = "right"><strong>Faks:</strong></td>
                        <td>+90 (216) 518 65 33</td>
                      </tr>

                      <!-- #Satıcı/@Faks -->

                      <!-- #Satıcı/@Web -->

                      <tr>
                        <td align = "right"><strong>Web:</strong></td>
                        <td><a href = "http://www.azimtextil.com" target = "_blank">http://www.azimtextil.com</a></td>
                      </tr>

                      <!-- #Satıcı/@Web -->

                      <!-- #Satıcı/@EPosta -->

                      <tr>
                        <td align = "right"><strong>E-Posta:</strong></td>
                        <td><a href = "mailto:info@azimtextil.com">humeyrakaya@azimtextil.com</a></td>
                      </tr>

                      <!-- #Satıcı/@EPosta -->

                      <!-- #Satıcı/@Vergi_Dairesi -->

                      <tr>
                        <td align = "right"><strong>Vergi Dairesi:</strong></td>
                        <td>Yakacık</td>
                      </tr>

                      <!-- #Satıcı/@Vergi_Dairesi -->

                      <!-- #Satıcı/@Vergi_No -->

                      <tr>
                        <td align = "right"><strong>Vergi No:</strong></td>
                        <td>1270334552</td>
                      </tr>

                      <!-- #Satıcı/@Vergi_No -->

                      <!-- #Satıcı/@Ticaret_Sicil_No -->

                      <tr>
                        <td align = "right"><strong>Ticaret Sicil No:</strong></td>
                        <td>593377</td>
                      </tr>

                      <!-- #Satıcı/@Ticaret_Sicil_No -->

                      <!-- #Satıcı/@MerSis_No -->

                      <tr>
                        <td align = "right"><strong>Mersis No:</strong></td>
                        <td>0127033455200013</td>
                      </tr>

                      <!-- #Satıcı/@MerSis_No -->

                    </tbody>
                  </table>
                  <!-- #Satıcı -->
                </td>
                <td name = "efatura_simgesi" align = "center" valign = "top">                
                <img alt = "E-Fatura Logo" src = "data:image/jpeg;base64,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"/>
<br />
                <span style = "font-size: 9pt"><strong>e-FATURA</strong></span>
                <img alt="şirket Yetkili İmzâsı" src="data:image/png;base64,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"/>


<br />

                </td>

                <td style = "width: 50%">

                  <!-- #Satıcı -->

                  <table class = "satici_tablosu_sube">
                    <tbody>

                      <!-- #Satıcı/#Unvan -->

                      <tr>
                        <th style = "font-size: 10pt" colspan = "2">
                          <strong>Şube</strong>
                        </th>
                      </tr>

                      <!-- #Satıcı/#Unvan -->

                      <!-- #Satıcı/#Adres -->

                      <tr>
                        <td style = "width: 30%; text-align: right; vertical-align: top"><strong>Adres:</strong></td>
                        <td style = "width: 70%">Firuzköy Mah.Necip Fazıl Kısakürek Cad.Doğu Sok. No:9/3-4 Avcılar-İstanbul</td>
                      </tr>

                      <!-- #Satıcı/#Adres -->

                      <!-- #Satıcı/@Telefon -->

                      <tr>
                        <td align = "right"><strong>Telefon:</strong></td>
                        <td>+90 (212) 428 33 38</td>
                      </tr>

                      <!-- #Satıcı/@Telefon -->

                      <!-- #Satıcı/@Faks -->

                      <tr>
                        <td align = "right"><strong>Faks:</strong></td>
                        <td>+90 (216) 518 65 33</td>
                      </tr>

                      <!-- #Satıcı/@Faks -->

                      <!-- #Satıcı/@Web -->

                      <tr>
                        <td align = "right"><strong>Web:</strong></td>
                        <td><a href = "http://www.azimtextil.com" target = "_blank">http://www.azimtextil.com</a></td>
                      </tr>

                      <!-- #Satıcı/@Web -->

                      <!-- #Satıcı/@EPosta -->

                      <tr>
                        <td align = "right"><strong>E-Posta:</strong></td>
                        <td><a href = "mailto:info@azimtextil.com">azimsube@azimtextil.com</a></td>
                      </tr>

                      <!-- #Satıcı/@EPosta -->

                      <!-- #Satıcı/@Vergi_Dairesi -->

                      <tr>
                        <td align = "right"><strong>Vergi Dairesi:</strong></td>
                        <td>Yakacık</td>
                      </tr>

                      <!-- #Satıcı/@Vergi_Dairesi -->

                      <!-- #Satıcı/@Vergi_No -->

                      <tr>
                        <td align = "right"><strong>Vergi No:</strong></td>
                        <td>1270334552</td>
                      </tr>

                      <!-- #Satıcı/@Vergi_No -->

                      <!-- #Satıcı/@Ticaret_Sicil_No -->

                      <tr>
                        <td align = "right"><strong>Ticaret Sicil No:</strong></td>
                        <td>92074-5</td>
                      </tr>

                      <!-- #Satıcı/@Ticaret_Sicil_No -->

                      <!-- #Satıcı/@MerSis_No -->

                      <tr>
                        <td align = "right"><strong>Mersis No:</strong></td>
                        <td>0127033455200013</td>
                      </tr>

                      <!-- #Satıcı/@MerSis_No -->

                    </tbody>
                  </table>

                  <!-- #Satıcı -->

                </td>

              </tr>
              <tr>

                <td>

                  <!-- #Alıcı -->

                  <table class = "alici_tablosu">
                    <tbody>

                      <!-- #Alıcı/#Unvan -->

                      <tr>
                        <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                          <th colspan = "2">
                            <xsl:if test = "cac:PartyName">
                              <strong style = "font-size: 10pt">
                                <xsl:value-of select = "cac:PartyName/cbc:Name"/>
                              </strong>
                              <br/>
                            </xsl:if>
                            <xsl:for-each select = "cac:Person">
                              <xsl:for-each select = "cbc:Title"><xsl:value-of select = "."/><xsl:text>&#160;</xsl:text></xsl:for-each>
                              <xsl:for-each select = "cbc:FirstName"><xsl:value-of select = "."/><xsl:text>&#160;</xsl:text></xsl:for-each>
                              <xsl:for-each select = "cbc:MiddleName"><xsl:value-of select = "."/><xsl:text>&#160;</xsl:text></xsl:for-each>
                              <xsl:for-each select = "cbc:FamilyName"><xsl:value-of select = "."/><xsl:text>&#160;</xsl:text></xsl:for-each>
                              <xsl:for-each select = "cbc:NameSuffix"><xsl:value-of select = "."/></xsl:for-each>
                            </xsl:for-each>
                          </th>
                        </xsl:for-each>
                      </tr>

                      <!-- #Alıcı/#Unvan -->

                      <!-- #Alıcı/#Adres -->

                      <tr>
                        <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                          <td style = "width: 30%; text-align: right; vertical-align: top"><strong>Adres:</strong></td>
                          <td style = "width: 70%">
                            <xsl:for-each select = "cac:PostalAddress">

                              <!-- #Alıcı/#Adres/@Sokak -->

                              <xsl:for-each select = "cbc:StreetName">
                                <xsl:value-of select = "."/>
                              </xsl:for-each>
                              <br/>

                              <!-- #Alıcı/#Adres/@Sokak -->

                              <xsl:if test = "cbc:BuildingName != '' or cbc:BuildingNumber != '' or cbc:Room != ''">

                                <!-- #Alıcı/#Adres/@Bina_Adı -->

                                <xsl:for-each select = "cbc:BuildingName">
                                  <span>Bina Adı: </span>
                                  <span><xsl:value-of select = "."/></span>
                                  <span>, </span>
                                </xsl:for-each>

                                <!-- #Alıcı/#Adres/@Bina_Adı -->

                                <!-- #Alıcı/#Adres/@Bina_No -->

                                <xsl:for-each select = "cbc:BuildingNumber">
                                  <span>Bina No: </span>
                                  <span><xsl:value-of select = "."/></span>
                                  <span>, </span>
                                </xsl:for-each>

                                <!-- #Alıcı/#Adres/@Bina_No -->

                                <!-- #Alıcı/#Adres/@Kapı_No -->

                                <xsl:for-each select = "cbc:Room">
                                  <span>Kapı No: </span>
                                  <span><xsl:value-of select = "."/></span>
                                </xsl:for-each>

                                <!-- #Alıcı/#Adres/@Kapı_No -->

                                <br/>

                              </xsl:if>

                              <!-- #Alıcı/#Adres/@Posta_Kodu -->

                              <xsl:for-each select = "cbc:PostalZone">
                                <xsl:if test = ". != ''">
                                  <xsl:value-of select = "."/><xsl:text>&#160;</xsl:text>
                                </xsl:if>
                              </xsl:for-each>

                              <!-- #Alıcı/#Adres/@Posta_Kodu -->

                              <!-- #Alıcı/#Adres/@Mahalle_İlçe -->

                              <xsl:for-each select = "cbc:CitySubdivisionName">
                                <xsl:value-of select = "."/>
                              </xsl:for-each>

                              <!-- #Alıcı/#Adres/@Mahalle_İlçe -->

                              <xsl:text> - </xsl:text>

                              <!-- #Alıcı/#Adres/@İl -->

                              <xsl:for-each select = "cbc:CityName">
                                <xsl:value-of select = "."/>
                              </xsl:for-each>

                              <!-- #Alıcı/#Adres/@İl -->

                            </xsl:for-each>
                          </td>
                        </xsl:for-each>
                      </tr>

                      <!-- #Alıcı/#Adres -->

                      <!-- #Alıcı/@Telefon -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telephone">
                        <tr>
                          <td align = "right"><strong>Telefon:</strong></td>
                          <td><xsl:value-of select = "."/></td>
                        </tr>
                      </xsl:for-each>

                      <!-- #Alıcı/@Telefon -->

                      <!-- #Alıcı/@Faks -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telefax">
                        <tr>
                          <td align = "right"><strong>Faks:</strong></td>
                          <td><xsl:value-of select = "."/></td>
                        </tr>
                      </xsl:for-each>

                      <!-- #Alıcı/@Faks -->

                      <!-- #Alıcı/@Web -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cbc:WebsiteURI">
                        <tr>
                          <td align = "right"><strong>Web:</strong></td>
                          <td><a href = "{.}" target = "_blank"><xsl:value-of select = "."/></a></td>
                        </tr>
                      </xsl:for-each>

                      <!-- #Alıcı/@Web -->

                      <!-- #Alıcı/@EPosta -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail">
                        <tr>
                          <td align = "right"><strong>E-Posta:</strong></td>
                          <td><a href = "mailto:{.}"><xsl:value-of select = "."/></a></td>
                        </tr>
                      </xsl:for-each>

                      <!-- #Alıcı/@EPosta -->

                      <!-- #Alıcı/@Vergi_Dairesi -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
                        <tr>
                          <td align = "right"><strong>Vergi Dairesi:</strong></td>
                          <td><xsl:value-of select = "."/></td>
                        </tr>
                      </xsl:for-each>

                      <!-- #Alıcı/@Vergi_Dairesi -->

                      <!-- #Alıcı/@Vergi_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification">
                        <xsl:if test = "cbc:ID/@schemeID = 'VKN'">
                          <tr>
                            <td align = "right"><strong>Vergi No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@Vergi_No -->

                      <!-- #Alıcı/@TC_Kimlik_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification">
                        <xsl:if test = "cbc:ID/@schemeID = 'TCKN'">
                          <tr>
                            <td align = "right"><strong>T.C. Kimlik No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@TC_Kimlik_No -->

                      <!-- #Alıcı/@Ticaret_Sicil_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification">
                        <xsl:if test = "cbc:ID/@schemeID = 'TICARETSICILNO'">
                          <tr>
                            <td align = "right"><strong>Ticaret Sicil No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@Ticaret_Sicil_No -->

                      <!-- #Alıcı/@MerSis_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification">
                        <xsl:if test = "cbc:ID/@schemeID = 'MERSISNO'">
                          <tr>
                            <td align = "right"><strong>MerSis No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@MerSis_No -->

                      <!-- #Alıcı/@Müşteri_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:AgentParty/cac:PartyIdentification">
                        <xsl:if test = "./cbc:ID/@schemeID = 'MUSTERINO'">
                          <tr>
                            <td align = "right"><strong>Müşteri No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@Müşteri_No -->

                      <!-- #Alıcı/@Bayi_No -->

                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:AgentParty/cac:PartyIdentification">
                        <xsl:if test = "./cbc:ID/@schemeID = 'BAYINO'">
                          <tr>
                            <td align = "right"><strong>Bayi No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Alıcı/@Bayi_No -->

                    </tbody>
                  </table>
                </td>

                <td>
<img style = "margin-top: 21px" alt = "E-Fatura Logo" src = "data:image/jpeg;base64,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"/>
                </td>

                <td valign = "bottom">

                  <!-- #Belge -->

                  <table class = "belge_tablosu">
                    <tbody>

                      <tr>
                        <th style = "font-size: 10pt" colspan = "2">
                          <strong>Belge</strong>
                        </th>
                      </tr>
                      
                      <!-- #Belge/#Özelleştirme_No -->

                      <tr>
                        <td style = "width: 30%; text-align: right; vertical-align: top" align = "right"><strong>Özelleştirme No:</strong></td>
                        <td>
                          <xsl:for-each select = "//n1:Invoice/cbc:CustomizationID">
                            <xsl:value-of select = "."/>
                          </xsl:for-each>
                        </td>
                      </tr>

                      <!-- #Belge/#Özelleştirme_No -->

                      <!-- #Belge/#Senaryo -->

                      <tr>
                        <td align = "right"><strong>Senaryo:</strong></td>
                        <td>
                          <xsl:for-each select = "//n1:Invoice/cbc:ProfileID">
                            <xsl:value-of select = "."/>
                          </xsl:for-each>
                        </td>
                      </tr>

                      <!-- #Belge/#Senaryo -->

                      <!-- #Belge/#Fatura_Tipi -->

                      <tr>
                        <td align = "right"><strong>Fatura Tipi:</strong></td>
                        <td>
                          <xsl:for-each select = "//n1:Invoice/cbc:InvoiceTypeCode">
                            <xsl:value-of select = "."/>
                          </xsl:for-each>
                        </td>
                      </tr>

                      <!-- #Belge/#Fatura_Tipi -->

                      <!-- #Belge/#Fatura_No -->

                      <tr>
                        <td align = "right"><strong>Fatura No:</strong></td>
                        <td>
                          <xsl:for-each select = "//n1:Invoice/cbc:ID">
                            <xsl:value-of select = "."/>
                          </xsl:for-each>
                        </td>
                      </tr>

                      <!-- #Belge/#Fatura_No -->

                      <!-- #Belge/#Fatura_Tarihi -->

                      <tr>
                        <td align = "right"><strong>Fatura Tarihi:</strong></td>
                        <td>
                          <xsl:for-each select = "//n1:Invoice/cbc:IssueDate">
                            <xsl:call-template name = "tarih_bicimlendirici"/>
                          </xsl:for-each>
                        </td>
                      </tr>

                      <!-- #Belge/#Fatura_Tarihi -->

                      <!-- #Belge/@Fatura_Saati -->

                      <xsl:if test = "//n1:Invoice/cbc:IssueTime">
                        <tr>
                          <td align = "right"><strong>Fatura Saati:</strong></td>
                          <td>
                            <xsl:for-each select = "//n1:Invoice/cbc:IssueTime">
                              <xsl:call-template name = "saat_bicimlendirici"/>
                            </xsl:for-each>
                          </td>
                        </tr>
                      </xsl:if>

                      <!-- #Belge/@Fatura_Saati -->

                      <!-- #Belge/@Son_Ödeme_Tarihi -->

                      <xsl:if test = "//n1:Invoice/cac:PaymentMeans/cbc:PaymentDueDate">
                        <tr>
                          <td align = "right"><strong>Son Ödeme Tarihi:</strong></td>
                          <td>
                            <xsl:for-each select = "//n1:Invoice/cac:PaymentMeans">
                              <xsl:for-each select = "cbc:PaymentDueDate">
                                <xsl:call-template name = "tarih_bicimlendirici"/>
                              </xsl:for-each>
                            </xsl:for-each>
                          </td>
                        </tr>
                      </xsl:if>

                      <!-- #Belge/@Son_Ödeme_Tarihi -->

                      <!-- #Belge/@İrsaliye[1] -->

                      <xsl:if test = "//n1:Invoice/cac:DespatchDocumentReference[1]">
                        <xsl:for-each select = "//n1:Invoice/cac:DespatchDocumentReference[1]">

                          <!-- #Belge/@İrsaliye[1]/#İrsaliye_No -->

                          <tr>
                            <td align = "right"><strong>İrsaliye No (1):</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>

                          <!-- #Belge/@İrsaliye[1]/#İrsaliye_No -->

                          <!-- #Belge/@İrsaliye[1]/#İrsaliye_Tarihi -->

                          <tr>
                            <td align = "right"><strong>İrsaliye Tarihi (1):</strong></td>
                            <td>
                              <xsl:for-each select = "cbc:IssueDate">
                                <xsl:call-template name = "tarih_bicimlendirici"/>
                              </xsl:for-each>
                            </td>
                          </tr>

                          <!-- #Belge/@İrsaliye[1]/#İrsaliye_Tarihi -->

                        </xsl:for-each>
                      </xsl:if>

                      <!-- #Belge/@İrsaliye[1] -->

                      <!-- #Belge/@İrsaliye[2] -->

                      <xsl:if test = "//n1:Invoice/cac:DespatchDocumentReference[2]">
                        <xsl:for-each select = "//n1:Invoice/cac:DespatchDocumentReference[2]">

                          <!-- #Belge/@İrsaliye[2]/#İrsaliye_No -->

                          <tr>
                            <td align = "right"><strong>İrsaliye No (2):</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>

                          <!-- #Belge/@İrsaliye[2]/#İrsaliye_No -->

                          <!-- #Belge/@İrsaliye[2]/#İrsaliye_Tarihi -->

                          <tr>
                            <td align = "right"><strong>İrsaliye Tarihi (2):</strong></td>
                            <td>
                              <xsl:for-each select = "cbc:IssueDate">
                                <xsl:call-template name = "tarih_bicimlendirici"/>
                              </xsl:for-each>
                            </td>
                          </tr>

                          <!-- #Belge/@İrsaliye[2]/#İrsaliye_Tarihi -->

                        </xsl:for-each>
                      </xsl:if>

                      <!-- #Belge/@İrsaliye[2] -->

                      <!-- #Belge/@Sipariş_No -->

                      <xsl:if test = "//n1:Invoice/cac:OrderReference">
                        <tr>
                          <td align = "right"><strong>Sipariş No:</strong></td>
                          <td>
                            <xsl:for-each select = "//n1:Invoice/cac:OrderReference">
                              <xsl:for-each select = "cbc:ID">
                                <xsl:apply-templates/>
                              </xsl:for-each>
                            </xsl:for-each>
                          </td>
                        </tr>
                      </xsl:if>

                      <!-- #Belge/@Sipariş_No -->

                      <!-- #Belge/@Sipariş_Tarihi -->

                      <xsl:if test = "//n1:Invoice/cac:OrderReference/cbc:IssueDate">
                        <tr>
                          <td align = "right"><strong>Sipariş Tarihi:</strong></td>
                          <td>
                            <xsl:for-each select = "//n1:Invoice/cac:OrderReference">
                              <xsl:for-each select = "cbc:IssueDate">
                                <xsl:call-template name = "tarih_bicimlendirici"/>
                              </xsl:for-each>
                            </xsl:for-each>
                          </td>
                        </tr>
                      </xsl:if>

                      <!-- #Belge/@Sipariş_Tarihi -->

                      <!-- #Belge/@Müşteri_No ? #Alıcı/@Müşteri_No -->

                      <!--
                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:AgentParty/cac:PartyIdentification">
                        <xsl:if test = "./cbc:ID/@schemeID = 'MUSTERINO'">
                          <tr>
                            <td align = "right"><strong>Müşteri No:</strong></td>
                            <td><xsl:value-of select = "cbc:ID"/></td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>
                      -->

                      <!-- #Belge/@Müşteri_No ? #Alıcı/@Müşteri_No -->

                      <!-- #Belge/@Bayi_No ? #Alıcı/@Bayi_No -->

                      <!--
                      <xsl:for-each select = "//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:AgentParty/cac:PartyIdentification">
                        <xsl:if test = "./cbc:ID/@schemeID = 'BAYINO'">
                          <tr>
                            <td align = "right"><strong>Bayi No:</strong></td>
                            <td>
                              <xsl:value-of select = "cbc:ID"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>
                      -->

                      <!-- #Belge/@Bayi_No ? #Alıcı/@Bayi_No -->

                      <!-- #Belge/@Aracı_Kurum_VKN -->

                      <xsl:for-each select = "//n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID = 'ARACIKURUMVKN']">
                        <xsl:if test = ". != ''">
                          <tr>
                            <td align = "right"><strong>Aracı Kurum VKN:</strong></td>
                            <td>
                              <xsl:value-of select = "."/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Belge/@Aracı_Kurum_VKN -->

                      <!-- #Belge/@Aracı_Kurum_Unvan -->

                      <xsl:for-each select = "//n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID = 'ARACIKURUMVKN']">
                        <xsl:if test = "../../cac:PartyName/cbc:Name != ''">
                          <tr>
                            <td align = "right"><strong>Aracı Kurum Unvan:</strong></td>
                            <td>
                              <xsl:value-of select = "../../cac:PartyName/cbc:Name"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:for-each>

                      <!-- #Belge/@Aracı_Kurum_Unvan -->

                    </tbody>
                  </table>

                  <!-- #Belge -->

                </td>
              </tr>

              <!-- @Fatura_Id_leri ~ #Stiller/@Fatura_Id_leri -->

              <tr>
                <table class = "fatura_id_tablosu">

                  <!-- @Fatura_Id_leri/@Fatura_Id -->

                  <tr>
                    <td width = "13%" align = "right"><strong>ETTN:</strong></td>
                    <td><xsl:value-of select = "//n1:Invoice/cbc:UUID"/></td>
                  </tr>

                  <!-- @Fatura_Id_leri/@Fatura_Id -->

                  <!-- @Fatura_Id_leri/@GTB_Ref_No -->

                  <xsl:for-each select = "//n1:Invoice/cac:SenderParty/cac:PartyIdentification">
                    <xsl:if test = "cbc:ID/@schemeID = 'GTB_REFNO'">
                      <tr>
                        <td width = "13%" align = "right"><strong>GTB:</strong></td>
                        <td><xsl:value-of select = "cbc:ID"/></td>
                      </tr>
                    </xsl:if>
                  </xsl:for-each>

                  <!-- @Fatura_Id_leri/@GTB_Ref_No -->

                  <!-- @Fatura_Id_leri/@GTB_GCB_Tescil_No -->

                  <xsl:for-each select = "//n1:Invoice/cac:SenderParty/cac:PartyIdentification">
                    <xsl:if test = "cbc:ID/@schemeID = 'GTB_GCB_TESCILNO'">
                      <tr>
                        <td width = "13%" align = "right"><strong>GCB:</strong></td>
                        <td><xsl:value-of select = "cbc:ID"/></td>
                      </tr>
                    </xsl:if>
                  </xsl:for-each>

                  <!-- @Fatura_Id_leri/@GTB_GCB_Tescil_No -->

                </table>
              </tr>

              <!-- @Fatura_Id_leri ~ #Stiller/@Fatura_Id_leri -->

            </tbody>
          </table>

          <!-- #Fatura_Satırları -->

          <table class = "fatura_satirlari_tablosu">
            <tbody>

              <tr>

                <!-- #Fatura_Satırları/@Sıra_No ~ &Sıra_No -->

                <th style = "text-align: right">Sıra<br/>No</th>

                <!-- #Fatura_Satırları/@Sıra_No ~ &Sıra_No -->

                <!-- #Fatura_Satırları/@Satıcı_Ürün_Kodu ~ &Satıcı_Ürün_Kodu -->

                <xsl:if test = "count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification/cbc:ID[text() != '']) > 0">
                  <th>Satıcı<br/>Ürün Kodu</th>
                </xsl:if>

                <!-- #Fatura_Satırları/@Satıcı_Ürün_Kodu ~ &Satıcı_Ürün_Kodu -->

                <!-- #Fatura_Satırları/@Alıcı_Ürün_Kodu ~ &Alıcı_Ürün_Kodu -->

                <xsl:if test = "count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:BuyersItemIdentification/cbc:ID[text() != '']) > 0">
                  <th>Alıcı<br/>Ürün Kodu</th>
                </xsl:if>

                <!-- #Fatura_Satırları/@Alıcı_Ürün_Kodu ~ &Alıcı_Ürün_Kodu -->

                <!-- #Fatura_Satırları/@Künye ~ &Künye -->

                <!--
                <th>Künye</th>
                -->

                <!-- #Fatura_Satırları/@Künye ~ &Künye -->

                <!-- #Fatura_Satırları/@Mal_Hizmet ~ &Mal_Hizmet -->

                <th>Mal / Hizmet<br/>Adı</th>

                <!-- #Fatura_Satırları/@Mal_Hizmet ~ &Mal_Hizmet -->

                <!-- #Fatura_Satırları/@Miktar ~ &Miktar -->

                <th style = "text-align: right" valign = "top">Miktar<br/>Birim</th>

                <!-- #Fatura_Satırları/@Miktar ~ &Miktar -->

                <!-- #Fatura_Satırları/@Birim_Fiyat ~ &Birim_Fiyat -->

                <th style = "text-align: right">Birim<br/>Fiyat</th>

                <!-- #Fatura_Satırları/@Birim_Fiyat ~ &Birim_Fiyat -->

                <!-- #Fatura_Satırları/@Brüt_Fiyat ~ &Brüt_Fiyat -->

                <th style = "text-align: right">Brüt<br/>Fiyat</th>

                <!-- #Fatura_Satırları/@Brüt_Fiyat ~ &Brüt_Fiyat -->

                <!-- #Fatura_Satırları/@İndirim_Oranı ~ &İndirim_Oranı -->

                <xsl:if test = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount > 0">
                  <th style = "text-align: right">İndirim<br/>Oranı</th>
                </xsl:if>

                <!-- #Fatura_Satırları/@İndirim_Oranı ~ &İndirim_Oranı -->

                <!-- #Fatura_Satırları/@İndirim_Tutarı ~ &İndirim_Tutarı -->

                <xsl:if test = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount > 0">
                  <th style = "text-align: right">İndirim<br/>Tutarı</th>
                </xsl:if>

                <!-- #Fatura_Satırları/@İndirim_Tutarı ~ &İndirim_Tutarı -->

                <!-- #Fatura_Satırları/@KDV_Oranı ~ &KDV_Oranı -->

                <th style = "text-align: right">KDV<br/>Oranı</th>

                <!-- #Fatura_Satırları/@KDV_Oranı ~ &KDV_Oranı -->

                <!-- #Fatura_Satırları/@KDV_Tutarı ~ &KDV_Tutarı -->

                <th style = "text-align: right">KDV<br/>Tutarı</th>

                <!-- #Fatura_Satırları/@KDV_Tutarı ~ &KDV_Tutarı -->

                <!-- #Fatura_Satırları/@Diğer ~ &Diğer -->

                <th style = "text-align: right">Diğer<br/>Vergiler</th>

                <!-- #Fatura_Satırları/@Diğer ~ &Diğer -->

                <!-- #Fatura_Satırları/@Mal_Hizmet_Tutarı ~ &Mal_Hizmet_Tutarı -->

                <th style = "text-align: right">Mal / Hizmet<br/>Tutarı</th>

                <!-- #Fatura_Satırları/@Mal_Hizmet_Tutarı ~ &Mal_Hizmet_Tutarı -->

              </tr>

              <xsl:apply-templates select = "//n1:Invoice/cac:InvoiceLine"/>

            </tbody>
          </table>
        </xsl:for-each>

        <!-- #Fatura_Satırları -->

        <!-- #Fatura_Dip_Toplamları -->

        <table class = "fatura_dip_toplamlari_tablosu">

          <!-- #Fatura_Dip_Toplamları/@Mal_Hizmet_Toplam_Tutarı -->

          <tr>
            <td align = "right"><strong>Mal / Hizmet Toplam Tutarı:</strong></td>
            <td align = "right">
              <xsl:value-of select = "format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
              <xsl:call-template name = "para_birimi">
                <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID"/>
              </xsl:call-template>
            </td>
          </tr>

          <!-- #Fatura_Dip_Toplamları/@Mal_Hizmet_Toplam_Tutarı -->

          <!-- #Fatura_Dip_Toplamları/@Teslim_Bedeli -->

          <xsl:for-each select = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
            <xsl:if test = "cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '4171'">
              <tr>
                <td align = "right"><strong>Teslim Bedeli:</strong></td>
                <td align = "right">
                  <xsl:call-template name = "para_birimi">
                    <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount"/>
                  </xsl:call-template>
                </td>
              </tr>
            </xsl:if>
          </xsl:for-each>

          <!-- #Fatura_Dip_Toplamları/@Teslim_Bedeli -->

          <!-- #Fatura_Dip_Toplamları/@Toplam_İndirim -->

          <xsl:if test = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount > 0">
            <tr>
              <td align = "right">
                <strong>
                  <xsl:text>Toplam İndirim (%</xsl:text>
                  <xsl:value-of select = "format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount div //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * 100, '##0,00##', 'european')"/>
                  <xsl:text>):</xsl:text>
                </strong>
              </td>
              <td align = "right">
                <xsl:value-of select = "format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount, '###.##0,00', 'european')"/>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID"/>
                </xsl:call-template>
              </td>
            </tr>
          </xsl:if>

          <!-- #Fatura_Dip_Toplamları/@Toplam_İndirim -->

          <xsl:for-each select = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">

            <xsl:if test = "cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015'">

              <!-- #Fatura_Dip_Toplamları/@KDV_Matrahı_0015 -->

              <tr>
                <td align = "right">
                  <strong>
                    <xsl:value-of select = "cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                    <xsl:text> Matrahı</xsl:text>
                    <xsl:text> (%</xsl:text>
                    <xsl:value-of select = "cbc:Percent"/>
                    <xsl:text>):</xsl:text>
                  </strong>
                </td>
                <td align = "right">
                  <xsl:for-each select = "cac:TaxCategory/cac:TaxScheme">
                    <xsl:value-of select = "format-number(../../cbc:TaxableAmount, '###.##0,00', 'european')"/>
                    <xsl:call-template name = "para_birimi">
                      <xsl:with-param name = "pb_id" select = "../../cbc:TaxableAmount/@currencyID"/>
                    </xsl:call-template>
                  </xsl:for-each>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@KDV_Matrahı_0015 -->

              <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_0015 -->

              <tr>
                <td align = "right">
                  <strong>
                    <xsl:text>Hesaplanan </xsl:text>
                    <xsl:value-of select = "cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                    <xsl:text> (%</xsl:text>
                    <xsl:value-of select = "cbc:Percent"/>
                    <xsl:text>):</xsl:text>
                  </strong>
                </td>
                <td align = "right">
                  <xsl:for-each select = "cac:TaxCategory/cac:TaxScheme">
                    <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
                    <xsl:call-template name = "para_birimi">
                      <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
                    </xsl:call-template>
                  </xsl:for-each>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_0015 -->

            </xsl:if>

          </xsl:for-each>

          <xsl:for-each select = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">

            <xsl:if test = "cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode != '0015'">

              <!-- #Fatura_Dip_Toplamları/@Hesaplanan_Diğer -->

              <tr>
                <td align = "right">
                  <strong>
                    <xsl:text>Hesaplanan </xsl:text>
                    <xsl:value-of select = "cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                    <xsl:text> (%</xsl:text>
                    <xsl:value-of select = "cbc:Percent"/>
                    <xsl:text>):</xsl:text>
                  </strong>
                </td>
                <td align = "right">
                  <xsl:for-each select = "cac:TaxCategory/cac:TaxScheme">
                    <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
                      <xsl:call-template name = "para_birimi">
                      <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
                    </xsl:call-template>
                  </xsl:for-each>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@Hesaplanan_Diğer -->

            </xsl:if>

          </xsl:for-each>

          <xsl:for-each select = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">

            <xsl:if test = "cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '4171'">

              <!-- #Fatura_Dip_Toplamları/@KDV_Matrahı_4171 -->

              <tr>
                <td align = "right"><strong>KDV Matrahı:</strong></td>
                <td align = "right">
                  <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015']/cbc:TaxableAmount), '###.##0,00', 'european')"/>
                  <xsl:call-template name = "para_birimi">
                    <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID"/>
                  </xsl:call-template>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@KDV_Matrahı_4171 -->

              <!-- #Fatura_Dip_Toplamları/@Tevkifat_Dahil_Toplam_Tutar -->

              <tr>
                <td align = "right"><strong>Tevkifat Dahil Toplam Tutar:</strong></td>
                <td align = "right">
                  <xsl:value-of select = "format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount, '###.##0,00', 'european')"/>
                  <xsl:call-template name = "para_birimi">
                    <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID"/>
                  </xsl:call-template>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@Tevkifat_Dahil_Toplam_Tutar -->

              <!-- #Fatura_Dip_Toplamları/@Tevkifat_Hariç_Toplam_Tutar -->

              <tr>
                <td align = "right"><strong>Tevkifat Hariç Toplam Tutar:</strong></td>
                <td align = "right">
                  <xsl:value-of select = "format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount, '###.##0,00', 'european')"/>
                  <xsl:call-template name = "para_birimi">
                    <xsl:with-param name = "pb_id" select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID"/>
                  </xsl:call-template>
                </td>
              </tr>

              <!-- #Fatura_Dip_Toplamları/@Tevkifat_Hariç_Toplam_Tutar -->

            </xsl:if>

          </xsl:for-each>

          <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_Tevkifatı -->

          <xsl:if test = "//n1:Invoice/cac:WithholdingTaxTotal">
            <xsl:for-each select = "//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
              <tr>
                <td align = "right"><strong>Hesaplanan KDV Tevkifatı (%<xsl:value-of select = "cbc:Percent"/>):</strong></td>
                <td align = "right">
                  <xsl:for-each select = "cac:TaxCategory/cac:TaxScheme">
                    <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
                    <xsl:call-template name = "para_birimi">
                      <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
                    </xsl:call-template>
                  </xsl:for-each>
                </td>
              </tr>
            </xsl:for-each>
          </xsl:if>

          <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_Tevkifatı -->

          <xsl:if test = "sum(//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015']/cbc:TaxableAmount) > 0">

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Tutarı_Eski -->

            <tr>
              <td align = "right"><strong>Tevkifata Tabi İşlem Tutarı:</strong></td>
              <td align = "right">
                <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015']/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "//n1:Invoice/cbc:DocumentCurrencyCode"/>
                </xsl:call-template>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Tutarı_Eski -->

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Üzerinden_Hesaplanan_KDV_Eski -->

            <tr>
              <td align = "right"><strong>Tevkifata Tabi İşlem Üzerinden Hes. KDV:</strong></td>
              <td align = "right">
                <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015']/cbc:TaxableAmount), '###.##0,00', 'european')"/>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "//n1:Invoice/cbc:DocumentCurrencyCode"/>
                </xsl:call-template>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Üzerinden_Hesaplanan_KDV_Eski -->

          </xsl:if>

          <xsl:if test = "//n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Tutarı_Yeni -->

            <tr>
              <td align = "right"><strong>Tevkifata Tabi İşlem Tutarı:</strong></td>
              <td align = "right">
                <xsl:if test = "//n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                  <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                </xsl:if>
                <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015'">
                  <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015']/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                </xsl:if>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "//n1:Invoice/cbc:DocumentCurrencyCode"/>
                </xsl:call-template>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Tutarı_Yeni -->

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Üzerinden_Hesaplanan_KDV_Yeni -->

            <tr>
              <td align = "right"><strong>Tevkifata Tabi İşlem Üzerinden Hes. KDV:</strong></td>
              <td align = "right">
                <xsl:if test = "//n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                  <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
                </xsl:if>
                <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015'">
                  <xsl:value-of select = "format-number(sum(//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '9015']/cbc:TaxableAmount), '###.##0,00', 'european')"/>
                </xsl:if>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "//n1:Invoice/cbc:DocumentCurrencyCode"/>
                </xsl:call-template>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Tevkifata_Tabi_İşlem_Üzerinden_Hesaplanan_KDV_Yeni -->

          </xsl:if>

          <!-- #Fatura_Dip_Toplamları/@Vergiler_Dahil_Toplam_Tutar -->

          <tr>
            <td align = "right"><strong>Vergiler Dahil Toplam Tutar:</strong></td>
            <td align = "right">
              <xsl:for-each select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount">
                <xsl:value-of select = "format-number(., '###.##0,00', 'european')"/>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "./@currencyID"/>
                </xsl:call-template>
              </xsl:for-each>
            </td>
          </tr>

          <!-- #Fatura_Dip_Toplamları/@Vergiler_Dahil_Toplam_Tutar -->

          <!-- #Fatura_Dip_Toplamları/@Ödenecek_Tutar -->

          <tr>
            <td align = "right"><strong>Ödenecek Tutar:</strong></td>
            <td align = "right">
              <xsl:for-each select = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
                <xsl:value-of select = "format-number(., '###.##0,00', 'european')"/>
                <xsl:call-template name = "para_birimi">
                  <xsl:with-param name = "pb_id" select = "./@currencyID"/>
                </xsl:call-template>
              </xsl:for-each>
            </td>
          </tr>

          <!-- #Fatura_Dip_Toplamları/@Ödenecek_Tutar -->

          <xsl:if test = "//n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' and //n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">

            <!-- #Fatura_Dip_Toplamları/@Döviz_Kuru -->

            <tr>
              <td align = "right"><strong>Döviz Kuru:</strong></td>
              <td align = "right">
                <xsl:for-each select = "//n1:Invoice">
                  <xsl:for-each select = "cac:PricingExchangeRate">
                    <xsl:for-each select = "cbc:CalculationRate">
                      <xsl:value-of select = "format-number(., '###.##0,00###', 'european')"/>
                    </xsl:for-each>
                  </xsl:for-each>
                </xsl:for-each>
                <xsl:text> TL</xsl:text>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Döviz_Kuru -->

            <!-- #Fatura_Dip_Toplamları/@Mal_Hizmet_Toplam_Tutarı_TL -->

            <tr>
              <td align = "right"><strong>Mal / Hizmet Toplam Tutarı (TL):</strong></td>
              <td align = "right">
                <xsl:for-each select = "//n1:Invoice">
                  <xsl:variable name = "doviz_kuru" select = "./cac:PricingExchangeRate/cbc:CalculationRate"/>
                  <xsl:for-each select = "cac:LegalMonetaryTotal">
                    <xsl:for-each select = "cbc:LineExtensionAmount">
                      <xsl:value-of select = "format-number(. * $doviz_kuru, '###.##0,00', 'european')"/>
                      <xsl:text> TL</xsl:text>
                    </xsl:for-each>
                  </xsl:for-each>
                </xsl:for-each>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Mal_Hizmet_Toplam_Tutarı_TL -->

            <xsl:for-each select = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">

              <xsl:if test = "cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015'">

                <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_0015_TL -->

                <tr>
                  <td align = "right">
                    <strong>
                      <xsl:text>Hesaplanan </xsl:text>
                      <xsl:value-of select = "cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                      <xsl:text> (%</xsl:text>
                      <xsl:value-of select = "cbc:Percent"/>
                      <xsl:text>) (TL):</xsl:text>
                    </strong>
                  </td>
                  <td align = "right">
                    <xsl:for-each select = "cac:TaxCategory/cac:TaxScheme">
                      <xsl:variable name = "doviz_kuru" select = "../../../../cac:PricingExchangeRate/cbc:CalculationRate"/>
                      <xsl:value-of select = "format-number(../../cbc:TaxAmount * $doviz_kuru, '###.##0,00', 'european')"/>
                      <xsl:text> TL</xsl:text>
                    </xsl:for-each>
                  </td>
                </tr>

                <!-- #Fatura_Dip_Toplamları/@Hesaplanan_KDV_0015_TL -->

              </xsl:if>

            </xsl:for-each>

            <!-- #Fatura_Dip_Toplamları/@Vergiler_Dahil_Toplam_Tutar_TL -->

            <tr>
              <td align = "right"><strong>Vergiler Dahil Toplam Tutar (TL):</strong></td>
              <td align = "right">
                <xsl:for-each select = "//n1:Invoice">
                  <xsl:variable name = "doviz_kuru" select = "./cac:PricingExchangeRate/cbc:CalculationRate"/>
                  <xsl:for-each select = "cac:LegalMonetaryTotal">
                    <xsl:for-each select = "cbc:TaxInclusiveAmount">
                      <xsl:value-of select = "format-number(. * $doviz_kuru, '###.##0,00', 'european')"/>
                      <xsl:text> TL</xsl:text>
                    </xsl:for-each>
                  </xsl:for-each>
                </xsl:for-each>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Vergiler_Dahil_Toplam_Tutar_TL -->

            <!-- #Fatura_Dip_Toplamları/@Ödenecek_Tutar_TL -->

            <tr>
              <td align = "right"><strong>Ödenecek Tutar (TL):</strong></td>
              <td align = "right">
                <xsl:for-each select = "//n1:Invoice">
                  <xsl:variable name = "doviz_kuru" select = "./cac:PricingExchangeRate/cbc:CalculationRate"/>
                  <xsl:for-each select = "cac:LegalMonetaryTotal">
                    <xsl:for-each select = "cbc:PayableAmount">
                      <xsl:value-of select = "format-number(. * $doviz_kuru, '###.##0,00', 'european')"/>
                      <xsl:text> TL</xsl:text>
                    </xsl:for-each>
                  </xsl:for-each>
                </xsl:for-each>
              </td>
            </tr>

            <!-- #Fatura_Dip_Toplamları/@Ödenecek_Tutar_TL -->

          </xsl:if>

        </table>

        <!-- #Fatura_Dip_Toplamları -->

        <!-- #Notlar -->

        <table class = "notlar_tablosu">
          <tbody>

            <!-- #Notlar/@Satır_Vergi_İstisna_Muafiyet_Sebebi -->

            <!--
            <xsl:for-each select = "//n1:Invoice/cac:InvoiceLine">
              <xsl:if test = "./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cbc:TaxExemptionReason != ''">
                <tr>
                  <td>
                    <strong><xsl:value-of select = "cbc:ID"/>. Kalem Vergi İstisna Muafiyet Sebebi: </strong>
                    <xsl:value-of select = "./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cbc:TaxExemptionReason"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:for-each>
            -->

            <!-- #Notlar/@Satır_Vergi_İstisna_Muafiyet_Sebebi -->

            <!-- #Notlar/@Vergi_İstisna_Muafiyet_Sebebi -->

            <xsl:for-each select = "//n1:Invoice/cac:TaxTotal">
              <xsl:if test = "./cac:TaxSubtotal/cac:TaxCategory/cbc:TaxExemptionReason != ''">
                <tr>
                  <td>
                    <strong>Vergi İstisna Muafiyet Sebebi: </strong>
                    <xsl:value-of select = "./cac:TaxSubtotal/cac:TaxCategory/cbc:TaxExemptionReason"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:for-each>

            <!-- #Notlar/@Vergi_İstisna_Muafiyet_Sebebi -->

            <!-- #Notlar/@Notlar ~ #Stiller/@Notlar -->

            <xsl:for-each select = "//n1:Invoice/cbc:Note">
              <xsl:if test = ".">
                <tr><td><xsl:value-of select = "."/></td></tr>
              </xsl:if>
            </xsl:for-each>

            <!-- #Notlar/@Notlar ~ #Stiller/@Notlar -->

            <!-- #Notlar/@Ödeme_Notu -->

            <xsl:if test = "//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote">
              <tr>
                <td>
                  <strong>Ödeme Notu: </strong>
                  <xsl:value-of select = "//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote"/>
                </td>
              </tr>
            </xsl:if>

            <!-- #Notlar/@Ödeme_Notu -->

            <!-- #Notlar/@Hesap_Açıklaması -->

            <xsl:if test = "//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote">
              <tr>
                <td>
                  <strong>Hesap Açıklaması: </strong>
                  <xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote"/>
                </td>
              </tr>
            </xsl:if>

            <!-- #Notlar/@Hesap_Açıklaması -->

            <!-- #Notlar/@Ödeme_Koşulu -->

            <xsl:if test = "//n1:Invoice/cac:PaymentTerms/cbc:Note">
              <tr>
                <td>
                  <strong>Ödeme Koşulu: </strong>
                  <xsl:value-of select = "//n1:Invoice/cac:PaymentTerms/cbc:Note"/>
                </td>
              </tr>
            </xsl:if>

            <!-- #Notlar/@Ödeme_Koşulu -->

            <!-- #Notlar/@Metro -->

            <xsl:for-each select="//n1:Invoice/cac:AdditionalDocumentReference">

              <!-- #Notlar/@Metro/@Yalnız -->

              <xsl:if test = "./cbc:DocumentType = 'YALNIZ_TL'">
                <tr>
                  <td>
                    <strong>Yalnız: </strong>
                    <xsl:value-of select = "./cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>

              <!-- #Notlar/@Metro/@Yalnız -->

              <!-- #Notlar/@Metro/@Fatura_Kod_Listesi -->

              <xsl:if test = "./cbc:DocumentType = 'FATURAKODLIST'">
                <tr>
                  <td>
                    <strong>Fatura Kod Listesi: </strong>
                    <xsl:value-of select = "./cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>

              <!-- #Notlar/@Metro/@Fatura_Kod_Listesi -->

              <!-- #Notlar/@Metro/@Künye -->

              <xsl:if test = "./cbc:DocumentType = 'KUNYE'">
                <tr>
                  <td>
                    <strong>Künye: </strong>
                    <xsl:value-of select = "./cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>

              <!-- #Notlar/@Metro/@Künye -->

              <!-- #Notlar/@Metro/@Borsa_Tescil -->

              <xsl:if test = "./cbc:DocumentType = 'BORSATESCIL'">
                <tr>
                  <td>
                    <strong>Borsa Tescil: </strong>
                    <xsl:value-of select = "./cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>

              <!-- #Notlar/@Metro/@Borsa_Tescil -->

            </xsl:for-each>

            <!-- #Notlar/@Metro -->

            <!-- #Notlar/@Sabit_Notlar -->

            <!--
            <tr><td>Sabit not satırı 1...</td></tr>
            <tr><td>Sabit not satırı 2...</td></tr>
            <tr><td>Sabit not satırı 3...</td></tr>
            <tr><td>Sabit not satırı 4...</td></tr>
            -->

            <!-- #Notlar/@Sabit_Notlar -->

          </tbody>
        </table>

        <!-- #Notlar -->

        <!-- @İrsaliyeler ~ #Stiller/@İrsaliyeler -->

        <xsl:if test = "count(//n1:Invoice/cac:DespatchDocumentReference) > 2">
          <table class = "irsaliyeler_tablosu">
            <tbody>
              <tr><th><strong>İrsaliyeler</strong></th></tr>
              <tr>
                <td>
                  <xsl:for-each select = "//n1:Invoice/cac:DespatchDocumentReference">
                    <xsl:text>[</xsl:text>
                    <xsl:value-of select = "cbc:ID"/>
                    <xsl:text>, </xsl:text>
                    <xsl:for-each select = "cbc:IssueDate">
                      <xsl:call-template name = "tarih_bicimlendirici"/>
                    </xsl:for-each>
                    <xsl:text>] </xsl:text>
                  </xsl:for-each>
                </td>
              </tr>
            </tbody>
          </table>
        </xsl:if>

        <!-- @İrsaliyeler ~ #Stiller/@İrsaliyeler -->

        <!-- @Sabit_Bankalar -->
        
        <table class = "bankalar_tablosu">
          <tbody>
            <tr>
              <th>Banka Adı</th>
              <th>Şube Adı</th>
              <th>Şube Kodu</th>
              <th>Hesap No</th>
              <th>IBAN</th>
            </tr>
            <tr>
              <td>Ingbank</td>
              <td>Kartal</td>
              <td>177</td>
              <td>11357535</td>
              <td>TR42 0009 9011 3575 3500 1000 05</td>
            </tr>
            <tr>
              <td>Garanti</td>
              <td>E5 Maltepe</td>
              <td>589</td>
              <td>6299997</td>
              <td>TR52 0006 2000 5890 0006 2999 97</td>
            </tr>
          </tbody>
        </table>

        <!-- @Sabit_Bankalar -->

        <!-- @Bankalar ~ #Stiller/@Bankalar -->

        <xsl:if test = "count(//n1:Invoice/cac:AdditionalDocumentReference[cbc:ID = 'BANKA']) > 0">
          <table class = "bankalar_tablosu">
            <tbody>

              <tr>

                <!-- @Bankalar/@Banka_Adı ~ &Banka_Adı -->

                <th>Banka Adı</th>

                <!-- @Bankalar/@Banka_Adı ~ &Banka_Adı -->

                <!-- @Bankalar/@Banka_Kodu ~ &Banka_Kodu -->

                <th>Banka Kodu</th>

                <!-- @Bankalar/@Banka_Kodu ~ &Banka_Kodu -->

                <!-- @Bankalar/@Şube_Adı ~ &Şube_Adı -->

                <th>Şube Adı</th>

                <!-- @Bankalar/@Şube_Adı ~ &Şube_Adı -->

                <!-- @Bankalar/@Şube_Kodu ~ &Şube_Kodu -->

                <th>Şube Kodu</th>

                <!-- @Bankalar/@Şube_Kodu ~ &Şube_Kodu -->

                <!-- @Bankalar/@Hesap_No ~ &Hesap_No -->

                <th>Hesap No</th>

                <!-- @Bankalar/@Hesap_No ~ &Hesap_No -->

                <!-- @Bankalar/@Hesap_Türü ~ &Hesap_Türü -->

                <th>Hesap Türü</th>

                <!-- @Bankalar/@Hesap_Türü ~ &Hesap_Türü -->

                <!-- @Bankalar/@IBAN ~ &IBAN -->

                <th>IBAN</th>

                <!-- @Bankalar/@IBAN ~ &IBAN -->

              </tr>
              
              <xsl:for-each select = "//n1:Invoice/cac:AdditionalDocumentReference">
                <xsl:if test = "./cbc:ID = 'BANKA'">

                  <tr>

                    <!-- &Banka_Adı-->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#BANKAADI'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Banka_Adı-->

                    <!-- &Banka_Kodu -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#BANKAKODU'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Banka_Kodu -->

                    <!-- &Şube_Adı -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#SUBEADI'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Şube_Adı -->

                    <!-- &Şube_Kodu -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#SUBEKODU'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Şube_Kodu -->

                    <!-- &Hesap_No -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#HESAPNO'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Hesap_No -->

                    <!-- &Hesap_Türü -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#HESAPTURU'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &Hesap_Türü -->

                    <!-- &IBAN -->

                    <xsl:for-each select = "cbc:DocumentType">
                      <xsl:if test = ". != ''">
                        <td>
                          <xsl:call-template name = "deger_bul">
                            <xsl:with-param name = "deger" select = "substring-after(., substring-before(., '#'))"/>
                            <xsl:with-param name = "deger_ayiraci" select = "':'"/>
                            <xsl:with-param name = "oge_ayiraci" select = "'|'"/>
                            <xsl:with-param name = "anahtar_kelime" select = "'#IBAN'"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:for-each>

                    <!-- &IBAN -->

                  </tr>

                </xsl:if>
              </xsl:for-each>

            </tbody>
          </table>
        </xsl:if>

        <!-- @Bankalar ~ #Stiller/@Bankalar -->

      </body>
    </html>
  </xsl:template>

  <xsl:template match = "//n1:Invoice/cac:InvoiceLine">
    <tr>

      <!-- &Sıra_No -->

      <td class = "kelime_kaydirma" align = "right"><xsl:value-of select = "./cbc:ID"/></td>

      <!-- &Sıra_No -->

      <!-- &Satıcı_Ürün_Kodu -->

      <xsl:if test = "count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification/cbc:ID[text() != '']) > 0">
        <td class = "kelime_kaydirma"><xsl:value-of select = "./cac:Item/cac:SellersItemIdentification/cbc:ID"/></td>
      </xsl:if>

      <!-- &Satıcı_Ürün_Kodu -->

      <!-- &Alıcı_Ürün_Kodu -->

      <xsl:if test = "count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:BuyersItemIdentification/cbc:ID[text() != '']) > 0">
        <td class = "kelime_kaydirma"><xsl:value-of select = "./cac:Item/cac:BuyersItemIdentification/cbc:ID"/></td>
      </xsl:if>

      <!-- &Alıcı_Ürün_Kodu -->

      <!-- &Künye -->

      <!--
      <td class = "kelime_kaydirma"><xsl:value-of select = "./cac:Item/cac:BuyersItemIdentification/cbc:ID"/></td>
      -->

      <!-- &Künye -->

      <!-- &Mal_Hizmet -->

      <td style = "max-width: 10%">
        <xsl:value-of select = "./cac:Item/cbc:Name"/>

        <!--
        <xsl:text>&#160;</xsl:text><xsl:value-of select = "./cac:Item/cbc:BrandName"/>   Kart.stokekkod
        <xsl:text>&#160;</xsl:text><xsl:value-of select = "./cac:Item/cbc:ModelName"/>   Kart.stokekadi
        <xsl:text>&#160;</xsl:text><xsl:value-of select = "./cac:Item/cbc:Description"/> Kart.stokadi
        -->

      </td>

      <!-- &Mal_Hizmet -->

      <!-- &Miktar -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:value-of select = "format-number(./cbc:InvoicedQuantity, '###.##0,00###', 'european')"/>
        <xsl:if test = "./cbc:InvoicedQuantity/@unitCode">
          <xsl:for-each select = "./cbc:InvoicedQuantity">
            <xsl:text>&#160;</xsl:text>
            <xsl:choose>
              <xsl:when test = "@unitCode = '26'">Ton</xsl:when>
              <xsl:when test = "@unitCode = 'TNE'">Ton</xsl:when>
              <xsl:when test = "@unitCode = 'BX'">Kutu</xsl:when>
              <xsl:when test = "@unitCode = 'LTR'">Lt</xsl:when>
              <xsl:when test = "@unitCode = 'NIU'">Adet</xsl:when>
              <xsl:when test = "@unitCode = 'C62'">Adet</xsl:when>
              <xsl:when test = "@unitCode = 'KGM'">KG</xsl:when>
              <xsl:when test = "@unitCode = 'KJO'">kJ</xsl:when>
              <xsl:when test = "@unitCode = 'GRM'">G</xsl:when>
              <xsl:when test = "@unitCode = 'MGM'">MG</xsl:when>
              <xsl:when test = "@unitCode = 'NT'">Net Ton</xsl:when>
              <xsl:when test = "@unitCode = 'GT'">GT</xsl:when>
              <xsl:when test = "@unitCode = 'MTR'">M</xsl:when>
              <xsl:when test = "@unitCode = 'MMT'">MM</xsl:when>
              <xsl:when test = "@unitCode = 'KTM'">KM</xsl:when>
              <xsl:when test = "@unitCode = 'MLT'">ML</xsl:when>
              <xsl:when test = "@unitCode = 'MMQ'">MM3</xsl:when>
              <xsl:when test = "@unitCode = 'CLT'">CL</xsl:when>
              <xsl:when test = "@unitCode = 'CMK'">CM2</xsl:when>
              <xsl:when test = "@unitCode = 'CMQ'">CM3</xsl:when>
              <xsl:when test = "@unitCode = 'CMT'">CM</xsl:when>
              <xsl:when test = "@unitCode = 'MTK'">M2</xsl:when>
              <xsl:when test = "@unitCode = 'MTQ'">M3</xsl:when>
              <xsl:when test = "@unitCode = 'DAY'">Gün</xsl:when>
              <xsl:when test = "@unitCode = 'MON'">Ay</xsl:when>
              <xsl:when test = "@unitCode = 'PA'">Paket</xsl:when>
              <xsl:when test = "@unitCode = 'KWH'">KWH</xsl:when>
              <xsl:when test = "@unitCode = 'ANN'">Yıl</xsl:when>
              <xsl:when test = "@unitCode = 'HUR'">Saat</xsl:when>
              <xsl:when test = "@unitCode = 'D61'">Dakika</xsl:when>
              <xsl:when test = "@unitCode = 'D62'">Saniye</xsl:when>
              <xsl:when test = "@unitCode = 'TN'">Teneke</xsl:when>
              <xsl:when test = "@unitCode = 'PR'">Çift</xsl:when>
              <xsl:when test = "@unitCode = 'RO'">Rulo</xsl:when>
              <xsl:when test = "@unitCode = 'PA'">Takım</xsl:when>
              <xsl:when test = "@unitCode = 'LN'">Boy</xsl:when>
              <xsl:when test = "@unitCode = 'BDN'">Bidon</xsl:when>
              <xsl:when test = "@unitCode = 'G/M'">Galon/Mil</xsl:when>
              <xsl:when test = "@unitCode = 'KL'">Koli</xsl:when>
              <xsl:when test = "@unitCode = 'KSY'">Kişi Sayısı</xsl:when>
              <xsl:when test = "@unitCode = 'PŞT'">Poşet</xsl:when>
              <xsl:when test = "@unitCode = 'TR'">Tambur</xsl:when>
            </xsl:choose>
          </xsl:for-each>
        </xsl:if>
      </td>

      <!-- &Miktar -->

      <!-- &Birim_Fiyat -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:value-of select = "format-number(./cac:Price/cbc:PriceAmount, '###.##0,00####', 'european')"/>
        <xsl:call-template name = "para_birimi">
          <xsl:with-param name = "pb_id" select = "./cac:Price/cbc:PriceAmount/@currencyID"/>
        </xsl:call-template>
      </td>

      <!-- &Birim_Fiyat -->

      <!-- &Brüt_Fiyat -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:value-of select = "format-number(./cac:Price/cbc:PriceAmount * ./cbc:InvoicedQuantity, '###.##0,00####', 'european')"/>
        <xsl:call-template name = "para_birimi">
          <xsl:with-param name = "pb_id" select = "./cac:Price/cbc:PriceAmount/@currencyID"/>
        </xsl:call-template>
      </td>

      <!-- &Brüt_Fiyat -->

      <!-- &İndirim_Oranı -->

      <xsl:if test = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount > 0">
        <td class = "kelime_kaydirma" align = "right">
          <xsl:text>%</xsl:text>
          <xsl:value-of select = "format-number(./cac:AllowanceCharge/cbc:MultiplierFactorNumeric * 100, '##0,00######' , 'european')"/>
        </td>
      </xsl:if>

      <!-- &İndirim_Oranı -->

      <!-- &İndirim_Tutarı -->

      <xsl:if test = "//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount > 0">
        <td class = "kelime_kaydirma" align = "right">
          <xsl:if test = "./cac:AllowanceCharge">
            <!--
            <xsl:if test = "./cac:AllowanceCharge/cbc:ChargeIndicator = true()">+</xsl:if>
            <xsl:if test = "./cac:AllowanceCharge/cbc:ChargeIndicator = false()">-</xsl:if>
            -->
            <xsl:value-of select = "format-number(./cac:AllowanceCharge/cbc:Amount, '###.##0,00', 'european')"/>
          </xsl:if>
          <xsl:call-template name = "para_birimi">
            <xsl:with-param name = "pb_id" select = "./cac:AllowanceCharge/cbc:Amount/@currencyID"/>
          </xsl:call-template>
        </td>
      </xsl:if>

      <!-- &İndirim_Tutarı -->

      <!-- &KDV_Oranı -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:for-each select = "./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test = "cbc:TaxTypeCode = '0015'">
            <xsl:text>&#160;</xsl:text>
            <xsl:if test = "../../cbc:Percent">
              <xsl:text>%</xsl:text>
              <xsl:value-of select = "format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
            </xsl:if>
          </xsl:if>
        </xsl:for-each>
      </td>

      <!-- &KDV_Oranı -->

      <!-- &KDV_Tutarı -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:for-each select = "./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test = "cbc:TaxTypeCode = '0015'">
            <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
            <xsl:call-template name = "para_birimi">
              <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:for-each>
      </td>

      <!-- &KDV_Tutarı -->

      <!-- &Diğer -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:for-each select = "./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test = "cbc:TaxTypeCode != '0015'">
            <xsl:value-of select = "cbc:Name"/>
            <xsl:if test = "../../cbc:Percent">
              <xsl:text> (%</xsl:text>
              <xsl:value-of select = "format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
              <xsl:text>) = </xsl:text>
            </xsl:if>
            <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
            <xsl:call-template name = "para_birimi">
              <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
            </xsl:call-template>
            <br/>
          </xsl:if>
        </xsl:for-each>
        <xsl:for-each select = "./cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test = "../../cbc:Percent">
            <xsl:text> (%</xsl:text>
            <xsl:value-of select = "format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
            <xsl:text>) = </xsl:text>
          </xsl:if>
          <xsl:value-of select = "format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
          <xsl:call-template name = "para_birimi">
            <xsl:with-param name = "pb_id" select = "../../cbc:TaxAmount/@currencyID"/>
          </xsl:call-template>
        </xsl:for-each>
      </td>

      <!-- &Diğer -->

      <!-- &Mal_Hizmet_Tutarı -->

      <td class = "kelime_kaydirma" align = "right">
        <xsl:value-of select = "format-number(./cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
        <xsl:call-template name = "para_birimi">
          <xsl:with-param name = "pb_id" select = "./cbc:LineExtensionAmount/@currencyID"/>
        </xsl:call-template>
      </td>

      <!-- &Mal_Hizmet_Tutarı -->

    </tr>

  </xsl:template>

  <xsl:template name = "tarih_bicimlendirici">
    <xsl:value-of select = "substring(., 9, 2)"/>-<xsl:value-of select = "substring(., 6, 2)"/>-<xsl:value-of select = "substring(., 1, 4)"/>
  </xsl:template>

  <xsl:template name = "saat_bicimlendirici">
    <xsl:value-of select = "substring(., 1, 8)"/>
  </xsl:template>

  <xsl:template name = "para_birimi">
    <xsl:param name = "pb_id"/>
    <xsl:text>&#160;</xsl:text>
    <xsl:if test = "$pb_id">
      <xsl:choose>
        <xsl:when test = "$pb_id = 'TRL'">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:when test = "$pb_id = 'TRY'">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select = "$pb_id"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "deger_bul">
    <xsl:param name = "deger"/>
    <xsl:param name = "deger_ayiraci"/>
    <xsl:param name = "oge_ayiraci"/>
    <xsl:param name = "anahtar_kelime"/>
    <xsl:variable name = "ilk_oge" select = " normalize-space(substring-before($deger, $oge_ayiraci))"/>
    <xsl:choose>
      <xsl:when test = "$ilk_oge != ''">
        <xsl:choose>
          <xsl:when test = "normalize-space(substring-before($ilk_oge, $deger_ayiraci)) = $anahtar_kelime">
            <xsl:value-of select = "normalize-space(substring-after($ilk_oge, $deger_ayiraci))"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name = "deger_bul">
              <xsl:with-param name = "deger" select = "normalize-space(substring-after($deger, $oge_ayiraci))"/>
              <xsl:with-param name = "deger_ayiraci" select = "$deger_ayiraci"/>
              <xsl:with-param name = "oge_ayiraci" select = "$oge_ayiraci"/>
              <xsl:with-param name = "anahtar_kelime" select = "$anahtar_kelime"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test = "contains($deger, $anahtar_kelime) and contains($deger, $deger_ayiraci) and not(contains($deger, $oge_ayiraci)) and normalize-space(substring-after($deger, $deger_ayiraci)) != ''">
        <xsl:value-of select = "normalize-space(substring-after($deger, $deger_ayiraci))"/>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>