<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988" xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi">
  <xsl:decimal-format NaN="" decimal-separator="," grouping-separator="." name="european"/>
  <xsl:output doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" encoding="UTF-8" indent="no" method="html" omit-xml-declaration="yes" version="4.0"/>
  <xsl:template name="idAsDate">
    <xsl:value-of select="substring(cbc:ID,9,2)"/>.<xsl:value-of select="substring(cbc:ID,6,2)"/>.<xsl:value-of select="substring(cbc:ID,1,4)"/>
  </xsl:template>
  <xsl:template name="internetSaleIdField">
    <xsl:choose>
      <!-- INTERNET SALE -->
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRWEBURI']">
        <td>
          <label>Web Adresi</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRPAY']">
        <td>
          <label>Ödeme Şekli</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EREPODARAC']">
        <td>
          <label>Ödeme Aracısı Adı</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRPAYDATE']">
        <td>
          <label>Ödeme Tarihi</label>
        </td>
        <td>
          <xsl:call-template name="idAsDate"/>
        </td>
      </xsl:when>
      <!-- SHIPMENT -->
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRPAYDELIV']">
        <td>
          <label>Gönderim Tarihi</label>
        </td>
        <td>
          <xsl:call-template name="idAsDate"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRCARR2NAME2']">
        <td>
          <label>Taşıyanın Ünvanı</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRCARR2']">
        <td>
          <label>Taşıyanın VKN</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRCARR1NAME']">
        <td>
          <label>Taşıyanın Ad Soyadı</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
      <xsl:when test="cbc:DocumentTypeCode[text()='EUPRCARR1']">
        <td>
          <label>Taşıyanın TCKN</label>
        </td>
        <td>
          <xsl:value-of select="cbc:ID"/>
        </td>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="quantity">
    <xsl:value-of select="format-number(., '###.###,####', 'european')"/>
  </xsl:template>
  <xsl:template name="currencyText">
    <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
    <xsl:if test="@currencyID">
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="@currencyID = 'TRY'">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@currencyID"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
  <xsl:variable name="priceAmountDecimalLength">
    <xsl:call-template name="calculateLongestPriceAmountDecimal"/>
  </xsl:variable>
  <xsl:template name="calculateLongestPriceAmountDecimal">
    <xsl:for-each select="n1:Invoice/cac:InvoiceLine/cac:Price/cbc:PriceAmount">
      <xsl:sort select="string-length(substring-after(., '.'))" data-type="number"/>
      <xsl:if test="position() = last()">
        <xsl:value-of select="string-length(substring-after(., '.'))"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="priceAmount">
    <xsl:choose>
      <xsl:when test="$priceAmountDecimalLength = 0">
        <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
      </xsl:when>
      <xsl:when test="$priceAmountDecimalLength = 1">
        <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
      </xsl:when>
      <xsl:when test="$priceAmountDecimalLength = 2">
        <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
      </xsl:when>
      <xsl:when test="$priceAmountDecimalLength = 3">
        <xsl:value-of select="format-number(., '###.##0,000', 'european')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="format-number(., '###.##0,0000', 'european')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@currencyID">
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="@currencyID = 'TRY'">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@currencyID"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
  <xsl:template name="lineItemsRow">
    <tr style="border:1px solid transparent;">
      <td class="lineTableTd" align="center">
        <xsl:value-of select="cbc:ID"/>
      </td>
      <td class="lineTableTd">
        <xsl:value-of select="cac:Item/cbc:Name"/>
      </td>
      <!-- <td style="border:1px solid gray;"><xsl:value-of select="cac:Item/cbc:Description"/></td> -->
      <xsl:if test="//n1:Invoice/cbc:ProfileID = 'IHRACAT'">
        <td class="lineTableTd">
          <xsl:value-of select="cac:Delivery/cac:Shipment/cac:GoodsItem/cbc:RequiredCustomsID"/>
        </td>
        <td class="lineTableTd">
          <xsl:choose>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '1'">
              <xsl:text>Denizyolu</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '2'">
              <xsl:text>Demiryolu</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '3'">
              <xsl:text>Karayolu</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '4'">
              <xsl:text>Havayolu</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '5'">
              <xsl:text>Posta</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '6'">
              <xsl:text>Çok araçlı</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '7'">
              <xsl:text>Sabit taşıma tesisleri</xsl:text>
            </xsl:when>
            <xsl:when test="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '8'">
              <xsl:text>İç su taşımacılığı</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>-</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="lineTableTd">
          <xsl:value-of select="cac:Delivery/cac:DeliveryTerms/cbc:ID"/>
        </td>
      </xsl:if>
      <td class="lineTableTd" align="right">
        <xsl:for-each select="cbc:InvoicedQuantity">
          <xsl:call-template name="quantity"/>
        </xsl:for-each>
        <xsl:if test="./cbc:InvoicedQuantity/@unitCode">
          <xsl:for-each select="./cbc:InvoicedQuantity">
            <xsl:text> </xsl:text>
            <xsl:choose>
              <xsl:when test="@unitCode  = 'TNE'">
                <xsl:text>ton</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'BX'">
                <xsl:text>Kutu</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'LTR'">
                <xsl:text>lt</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'C62'">
                <xsl:text>Adet</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'NIU'">
                <xsl:text>Adet</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'KGM'">
                <xsl:text>kg</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'KJO'">
                <xsl:text>kJ</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'GRM'">
                <xsl:text>g</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MGM'">
                <xsl:text>mg</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'NT'">
                <xsl:text>Net Ton</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'GT'">
                <xsl:text>Gross Ton</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MTR'">
                <xsl:text>m</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MMT'">
                <xsl:text>mm</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'KTM'">
                <xsl:text>km</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MLT'">
                <xsl:text>ml</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MMQ'">
                <xsl:text>mm3</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'CLT'">
                <xsl:text>cl</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'CMK'">
                <xsl:text>cm2</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'CMQ'">
                <xsl:text>cm3</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'CMT'">
                <xsl:text>cm</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MTK'">
                <xsl:text>m2</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MTQ'">
                <xsl:text>m3</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'DAY'">
                <xsl:text> Gün</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'MON'">
                <xsl:text> Ay</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'PA'">
                <xsl:text> Paket</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'PK'">
                <xsl:text> Paket</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'NPL'">
                <xsl:text> Koli</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'KWH'">
                <xsl:text> KWH</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'ANN'">
                <xsl:text> Yıl</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'HUR'">
                <xsl:text> Saat</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'D61'">
                <xsl:text> Dakika</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'D62'">
                <xsl:text> Saniye</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'CCT'">
                <xsl:text> Ton baş.taşıma kap.</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'D30'">
                <xsl:text> Brüt kalori</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'D40'">
                <xsl:text> 1000 lt</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'LPA'">
                <xsl:text> saf alkol lt</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'B32'">
                <xsl:text> kg.m2</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'NCL'">
                <xsl:text> hücre adet</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'PR'">
                <xsl:text> Çift</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'R9'">
                <xsl:text> 1000 m3</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'SET'">
                <xsl:text> Set</xsl:text>
              </xsl:when>
              <xsl:when test="@unitCode  = 'T3'">
                <xsl:text> 1000 adet</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:for-each>
        </xsl:if>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:for-each select="cac:Price/cbc:PriceAmount">
          <xsl:call-template name="priceAmount"/>
        </xsl:for-each>
      </td>
      <!--
      <td class="lineTableTd"  data-role="col-discount-percentage" align="right" >
        <xsl:if test="cac:AllowanceCharge/cbc:MultiplierFactorNumeric != ''">
          <xsl:text> %</xsl:text>
          <xsl:value-of select="format-number(./cac:AllowanceCharge/cbc:MultiplierFactorNumeric * 100, '###.##0,##', 'european')"/>
        </xsl:if>
      </td>
      <td class="lineTableTd"  data-role="col-discount-total" align="right" >
        <xsl:for-each select="cac:AllowanceCharge/cbc:Amount">
          <xsl:call-template name="currencyText"/>
        </xsl:for-each>
      </td>
      -->
      <td class="lineTableTd" data-role="col-tax-percentage" align="right">
        <xsl:for-each select="cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test="cbc:TaxTypeCode='0015'">
            <xsl:if test="../../cbc:Percent">
              <xsl:text> %</xsl:text>
              <xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
            </xsl:if>
          </xsl:if>
        </xsl:for-each>
      </td>
      <td class="lineTableTd" data-role="col-tax-percentage" align="right">
        <xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
          <xsl:if test="cbc:TaxTypeCode='0015' ">
            <xsl:text/>
            <xsl:for-each select="../../cbc:TaxAmount">
              <xsl:call-template name="Curr_Type"/>
            </xsl:for-each>
          </xsl:if>
        </xsl:for-each>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:for-each select="cbc:LineExtensionAmount">
          <xsl:call-template name="currencyText"/>
        </xsl:for-each>
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="partyBlockName">
    <xsl:if test="cac:PartyName">
      <div data-role="company-name">
        <b>
          <xsl:value-of select="cac:PartyName/cbc:Name"/>
        </b>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlockPostalAddress">
    <xsl:for-each select="cac:PostalAddress">
      <div data-role="company-address">
        <xsl:value-of select="cbc:StreetName"/>&#160;<xsl:value-of select="cbc:BuildingNumber"/>
      </div>
      <div data-role="company-district-city">
        <!-- District, City -->
        <xsl:if test="cbc:CitySubdivisionName != ''">
          <xsl:value-of select="cbc:CitySubdivisionName"/>,
        </xsl:if>
        <xsl:if test="cbc:CityName != ''">
          <xsl:value-of select="cbc:CityName"/>
        </xsl:if>
        <xsl:if test="cac:Country != ''">
          &#8211; <xsl:value-of select="cac:Country/cbc:Name"/>
        </xsl:if>
      </div>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="partyBlockTelephone">
    <xsl:if test="cac:Contact/cbc:Telephone != ''">
      <div data-role="company-phone">
        <!--
        <span style="font-weight:bold;">
          <xsl:text>Telefon :</xsl:text>
        </span>
        -->
        <xsl:value-of select="cac:Contact/cbc:Telephone"/>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlockTelefax">
    <xsl:if test="cac:Contact/cbc:Telefax != ''">
      <div data-role="company-phone">
        <!--
        <span style="font-weight:bold;">
          <xsl:text>Faks :</xsl:text>
        </span>
        -->
        <xsl:value-of select="cac:Contact/cbc:Telefax"/>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlockElectronicMail">
    <xsl:if test="cac:Contact/cbc:ElectronicMail != ''">
      <div data-role="company-email">
        <!-- Email -->
        <!--
        <span style="font-weight:bold;">
          <xsl:text>E-posta :</xsl:text>
        </span>
        -->
        <xsl:value-of select="cac:Contact/cbc:ElectronicMail"/>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlockOtherCommunication">
    <xsl:for-each select="cac:Contact/cac:OtherCommunication">
      <xsl:if test="cbc:ChannelCode = 'AH'">
        <div data-role="company-website">
          <label>Web Sitesi</label>
          <span style="font-weight:bold;">
            <xsl:text>Web Sitesi :</xsl:text>
          </span>
          <xsl:value-of select="cbc:Value"/>
        </div>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="partyBlockTaxInfo">
    <div data-role="company-tax-info">
      <!-- Tax number -->
      <span style="font-weight:bold;">
        <xsl:text>Vergi No :</xsl:text>
      </span>
      <xsl:choose>
        <xsl:when test="cac:PartyIdentification/cbc:ID[@schemeID='VKN'] != ''">
          <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='VKN']"/>
        </xsl:when>
        <xsl:when test="cac:PartyIdentification/cbc:ID[@schemeID='TCKN'] != ''">
          <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='TCKN']"/>
        </xsl:when>
      </xsl:choose>&#160;
      <xsl:if test="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name != ''">
        <xsl:value-of select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
      </xsl:if>
    </div>
  </xsl:template>
  <xsl:template name="partyBlockTradeRegistryInfo">
    <xsl:if test="cac:PartyIdentification/cbc:ID[@schemeID='TICARETSICILNO'] != ''">
      <div data-role="company-ticaret">
        <!--
        <span style="font-weight:bold;">
          <xsl:text>Ticaret Sicil No :</xsl:text>
        </span>
        -->
        <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='TICARETSICILNO']"/>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlockMersisNo">
    <xsl:if test="cac:PartyIdentification/cbc:ID[@schemeID='MERSISNO'] != ''">
      <div data-role="company-mersis">
        <!--
        <span style="font-weight:bold;">
          <xsl:text>Mersis No :</xsl:text>
        </span>
        -->
        <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='MERSISNO']"/>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="partyBlock">
    <xsl:call-template name="partyBlockName"/>
    <xsl:call-template name="partyBlockPostalAddress"/>
    <xsl:call-template name="partyBlockTelephone"/>
    <xsl:call-template name="partyBlockTelefax"/>
    <xsl:call-template name="partyBlockElectronicMail"/>
    <xsl:call-template name="partyBlockOtherCommunication"/>
    <xsl:call-template name="partyBlockTaxInfo"/>
    <xsl:call-template name="partyBlockTradeRegistryInfo"/>
    <xsl:call-template name="partyBlockMersisNo"/>
  </xsl:template>
  <xsl:template match="/">
    <html lang="en">
      <head>
        <meta charset="UTF-8"/>
        <title>Document</title>
        <style>
          body {
            margin: 0;
            padding: 0;
            font-family: 'Tahoma', "Times New Roman", Times, serif;
            font-size: 11px;
            line-height: 1.5em;
            font-kerning: normal;
            letter-spacing: 0.02em;
            color: black;
          }
          table {
            border: 0;
            border-collapse: collapse;
            width: 100%;
          }
          table {
            page-break-inside: auto
          }
          table tr td,
          table tr th,
          table tr {
            -webkit-column-break-inside: avoid;
            page-break-inside: avoid;
            break-inside: avoid;
            page-break-after: auto;
          }
          thead {
            display: table-header-group;
          }
          tfoot {
            display: table-footer-group;
          }
          label {
            display: block;
            color: #999;
            font-weight: bold;
            font-size: smaller;
            line-height: 1em;
            margin-top: 0.5em;
          }
          td.lineTableTdx {
            border-width: 1px;
            padding: 1px;
            border-style: inset;
            border-color: transparent;
            background-color: #002e61;
            color: white;
					}
          td.lineTableTd {
            border-width: 1px;
            padding: 1px;
            border-style: inset;
            border-color: transparent;
            border-color: transparent;
            background-color:transparent;
            border-radius: 7px;
            height:24px;
					}		
          .invoice-ui {
            display: none;
          }
          .invoice {
            display: block;
            min-height: 1100px;
            padding: 8px;
            background-color: #fff;
            width: 100%;
            <!--
            width: 800px;
            -->
            margin: 0 auto;
          }
          .invoice-ui {
            position: absolute;
            right: 0;
            top: 0;
            display: block;
            padding: 40px;
            <!--
            width: calc(100vw - 1050px);
            -->
            min-height: 400px;
          }
          .invoice-ui #switcher a {
            display: inline-block;
            padding: 10px;
            background-color: #fff;
            border-radius: 5px;
            text-decoration: none;
          }
          .invoice-ui #switcher a + a {
            margin-left: 10px;
          }
          .invoice-ui #switcher a input {
            pointer-events: none;
          }
          .header {
            vertical-align: top;
          }
          .header thead td {
            padding-bottom: 1em;
          }
          hr {
            margin: 0.5em 0;
            border: 0;
            border-top: 1px solid #ccc;
          }
          .header td {
            vertical-align: top;
          }
          .header h1 {
            color: black;
            <!--
            letter-spacing: 0.1em;
            -->
          }
          .header .header__stamp {
            text-align: center;
          }
          .lineitems {
            margin: 0.5em 0;
          }
          .lineitems thead {
            font-weight: bold;
            <!--
            font-size: smaller;
            -->
          }
          .lineitems thead td {
            white-space: nowrap;
            border-style: solid;
            border-width: 0.1px;
            border-color: #4581c2;
            height: 31px;
            background-color: #4581c2;
          }
          .lineitems tbody td {
            padding-top: 0.5em;
            
          }
          .notes {
            vertical-align: top;
          }
          .field-border {
            margin-top: 20px;
            margin-right: 40px;
            border-bottom: 1px solid currentColor;
          }
          .totals {
            text-align: right;
            width: auto;
          }
          .totals td {
            padding-top: 0.1em;
            white-space: nowrap;
          }
          .totals td:first-child {
            padding-right: 2em;
          }
          .hideable {
            <!--
            display: none;
            -->
          }
          .hideable.isHidden {
            display: none !important;
          }
          .return-section {
            -webkit-column-break-inside: avoid;
            page-break-inside: avoid;
            break-inside: avoid;
            page-break-after: auto;
          }
          .u-mb1 {
            margin-bottom: 10px;
          }
          .frame {
    				position:relative;
   					padding:5px;
					}
					.frame:before {
   					height:50px;
            position:absolute;
            top:0px;
            left:0px;
            right:0px;
            border-left:4px solid #222c59;
            border-right:4px solid #222c59;
            content: " ";
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
          }
          .frame:after {
            height:50px;
            position:absolute;
            bottom:0px;
            left:0px;
            right:0px;
            border-left:4px solid #222c59;
            border-right:4px solid #222c59;
            content: " ";
            border-bottom-right-radius: 10px;
            border-bottom-left-radius: 10px;
          }
          .frame > p {
            text-align:justify;
            margin:0;
            padding:0;
          }
          .frame :first-child:before {
            position:absolute;
            top:0px;
            bottom:0px;
            left:0px;
            width:50px;
            border-top:4px solid #222c59;
            border-bottom:4px solid #222c59;
            content: " ";
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
          }
          .frame :first-child:after {
            position:absolute;
            top:0px;
            bottom:0px;
            right:0px;
            width:50px;
            border-top:4px solid #222c59;
            border-bottom:4px solid #222c59;
            content: " ";
            border-top-right-radius: 10px;
            border-bottom-right-radius: 10px;
          }
          div.cerceve{
            padding:8px; border: 4px solid #4581c2;margin-bottom:10px;
          }
          div.cerceve {
            border-radius:6px;
          }
        </style>
        <script type="text/javascript">
                   <![CDATA[var QRCode;!function(){function a(a){this.mode=c.MODE_8BIT_BYTE,this.data=a,this.parsedData=[];
				   for(var b=[],d=0,e=this.data.length;e>d;d++){var f=this.data.charCodeAt(d);f>65536?(b[0]=240|(1835008&f)>>>18,
				   b[1]=128|(258048&f)>>>12,b[2]=128|(4032&f)>>>6,b[3]=128|63&f):f>2048?(b[0]=224|(61440&f)>>>12,b[1]=128|(4032&f)>>>6,
				   b[2]=128|63&f):f>128?(b[0]=192|(1984&f)>>>6,
				   b[1]=128|63&f):b[0]=f,this.parsedData=this.parsedData.concat(b)}
				   this.parsedData.length!=this.data.length&&(this.parsedData.unshift(191),this.parsedData.unshift(187),
				   this.parsedData.unshift(239))}function b(a,b){this.typeNumber=a,this.errorCorrectLevel=b,this.modules=null,this.moduleCount=0,this.dataCache=null,
				   this.dataList=[]}function i(a,b){if(void 0==a.length)throw new Error(a.length+"/"+b);for(var c=0;c<a.length&&0==a[c];)c++;
				   this.num=new Array(a.length-c+b);for(var d=0;d<a.length-c;d++)this.num[d]=a[d+c]}function j(a,b){this.totalCount=a,this.dataCount=b}
				   function k(){this.buffer=[],this.length=0}function m(){return"undefined"!=typeof CanvasRenderingContext2D}function n(){var a=!1,b=navigator.userAgent;return/android/i.test(b)&&(a=!0,aMat=b.toString().match(/android ([0-9]\.[0-9])/i),aMat&&aMat[1]&&(a=parseFloat(aMat[1]))),a}function r(a,b){for(var c=1,e=s(a),f=0,g=l.length;g>=f;f++){var h=0;switch(b){case d.L:h=l[f][0];break;case d.M:h=l[f][1];break;case d.Q:h=l[f][2];break;case d.H:h=l[f][3]}if(h>=e)break;c++}if(c>l.length)throw new Error("Too long data");return c}function s(a){var b=encodeURI(a).toString().replace(/\%[0-9a-fA-F]{2}/g,"a");return b.length+(b.length!=a?3:0)}a.prototype={getLength:function(){return this.parsedData.length},write:function(a){for(var b=0,c=this.parsedData.length;c>b;b++)a.put(this.parsedData[b],8)}},b.prototype={addData:function(b){var c=new a(b);this.dataList.push(c),this.dataCache=null},isDark:function(a,b){if(0>a||this.moduleCount<=a||0>b||this.moduleCount<=b)throw new Error(a+","+b);return this.modules[a][b]},getModuleCount:function(){return this.moduleCount},make:function(){this.makeImpl(!1,this.getBestMaskPattern())},makeImpl:function(a,c){this.moduleCount=4*this.typeNumber+17,this.modules=new Array(this.moduleCount);for(var d=0;d<this.moduleCount;d++){this.modules[d]=new Array(this.moduleCount);for(var e=0;e<this.moduleCount;e++)this.modules[d][e]=null}this.setupPositionProbePattern(0,0),this.setupPositionProbePattern(this.moduleCount-7,0),this.setupPositionProbePattern(0,this.moduleCount-7),this.setupPositionAdjustPattern(),this.setupTimingPattern(),this.setupTypeInfo(a,c),this.typeNumber>=7&&this.setupTypeNumber(a),null==this.dataCache&&(this.dataCache=b.createData(this.typeNumber,this.errorCorrectLevel,this.dataList)),this.mapData(this.dataCache,c)},setupPositionProbePattern:function(a,b){for(var c=-1;7>=c;c++)if(!(-1>=a+c||this.moduleCount<=a+c))for(var d=-1;7>=d;d++)-1>=b+d||this.moduleCount<=b+d||(this.modules[a+c][b+d]=c>=0&&6>=c&&(0==d||6==d)||d>=0&&6>=d&&(0==c||6==c)||c>=2&&4>=c&&d>=2&&4>=d?!0:!1)},getBestMaskPattern:function(){for(var a=0,b=0,c=0;8>c;c++){this.makeImpl(!0,c);var d=f.getLostPoint(this);(0==c||a>d)&&(a=d,b=c)}return b},createMovieClip:function(a,b,c){var d=a.createEmptyMovieClip(b,c),e=1;this.make();for(var f=0;f<this.modules.length;f++)for(var g=f*e,h=0;h<this.modules[f].length;h++){var i=h*e,j=this.modules[f][h];j&&(d.beginFill(0,100),d.moveTo(i,g),d.lineTo(i+e,g),d.lineTo(i+e,g+e),d.lineTo(i,g+e),d.endFill())}return d},setupTimingPattern:function(){for(var a=8;a<this.moduleCount-8;a++)null==this.modules[a][6]&&(this.modules[a][6]=0==a%2);for(var b=8;b<this.moduleCount-8;b++)null==this.modules[6][b]&&(this.modules[6][b]=0==b%2)},setupPositionAdjustPattern:function(){for(var a=f.getPatternPosition(this.typeNumber),b=0;b<a.length;b++)for(var c=0;c<a.length;c++){var d=a[b],e=a[c];if(null==this.modules[d][e])for(var g=-2;2>=g;g++)for(var h=-2;2>=h;h++)this.modules[d+g][e+h]=-2==g||2==g||-2==h||2==h||0==g&&0==h?!0:!1}},setupTypeNumber:function(a){for(var b=f.getBCHTypeNumber(this.typeNumber),c=0;18>c;c++){var d=!a&&1==(1&b>>c);this.modules[Math.floor(c/3)][c%3+this.moduleCount-8-3]=d}for(var c=0;18>c;c++){var d=!a&&1==(1&b>>c);this.modules[c%3+this.moduleCount-8-3][Math.floor(c/3)]=d}},setupTypeInfo:function(a,b){for(var c=this.errorCorrectLevel<<3|b,d=f.getBCHTypeInfo(c),e=0;15>e;e++){var g=!a&&1==(1&d>>e);6>e?this.modules[e][8]=g:8>e?this.modules[e+1][8]=g:this.modules[this.moduleCount-15+e][8]=g}for(var e=0;15>e;e++){var g=!a&&1==(1&d>>e);8>e?this.modules[8][this.moduleCount-e-1]=g:9>e?this.modules[8][15-e-1+1]=g:this.modules[8][15-e-1]=g}this.modules[this.moduleCount-8][8]=!a},mapData:function(a,b){for(var c=-1,d=this.moduleCount-1,e=7,g=0,h=this.moduleCount-1;h>0;h-=2)for(6==h&&h--;;){for(var i=0;2>i;i++)if(null==this.modules[d][h-i]){var j=!1;g<a.length&&(j=1==(1&a[g]>>>e));var k=f.getMask(b,d,h-i);k&&(j=!j),this.modules[d][h-i]=j,e--,-1==e&&(g++,e=7)}if(d+=c,0>d||this.moduleCount<=d){d-=c,c=-c;break}}}},b.PAD0=236,b.PAD1=17,b.createData=function(a,c,d){for(var e=j.getRSBlocks(a,c),g=new k,h=0;h<d.length;h++){var i=d[h];g.put(i.mode,4),g.put(i.getLength(),f.getLengthInBits(i.mode,a)),i.write(g)}for(var l=0,h=0;h<e.length;h++)l+=e[h].dataCount;if(g.getLengthInBits()>8*l)throw new Error("code length overflow. ("+g.getLengthInBits()+">"+8*l+")");for(g.getLengthInBits()+4<=8*l&&g.put(0,4);0!=g.getLengthInBits()%8;)g.putBit(!1);for(;;){if(g.getLengthInBits()>=8*l)break;if(g.put(b.PAD0,8),g.getLengthInBits()>=8*l)break;g.put(b.PAD1,8)}return b.createBytes(g,e)},b.createBytes=function(a,b){for(var c=0,d=0,e=0,g=new Array(b.length),h=new Array(b.length),j=0;j<b.length;j++){var k=b[j].dataCount,l=b[j].totalCount-k;d=Math.max(d,k),e=Math.max(e,l),g[j]=new Array(k);for(var m=0;m<g[j].length;m++)g[j][m]=255&a.buffer[m+c];c+=k;var n=f.getErrorCorrectPolynomial(l),o=new i(g[j],n.getLength()-1),p=o.mod(n);h[j]=new Array(n.getLength()-1);for(var m=0;m<h[j].length;m++){var q=m+p.getLength()-h[j].length;h[j][m]=q>=0?p.get(q):0}}for(var r=0,m=0;m<b.length;m++)r+=b[m].totalCount;for(var s=new Array(r),t=0,m=0;d>m;m++)for(var j=0;j<b.length;j++)m<g[j].length&&(s[t++]=g[j][m]);for(var m=0;e>m;m++)for(var j=0;j<b.length;j++)m<h[j].length&&(s[t++]=h[j][m]);return s};for(var c={MODE_NUMBER:1,MODE_ALPHA_NUM:2,MODE_8BIT_BYTE:4,MODE_KANJI:8},d={L:1,M:0,Q:3,H:2},e={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7},f={PATTERN_POSITION_TABLE:[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54],[6,32,58],[6,34,62],[6,26,46,66],[6,26,48,70],[6,26,50,74],[6,30,54,78],[6,30,56,82],[6,30,58,86],[6,34,62,90],[6,28,50,72,94],[6,26,50,74,98],[6,30,54,78,102],[6,28,54,80,106],[6,32,58,84,110],[6,30,58,86,114],[6,34,62,90,118],[6,26,50,74,98,122],[6,30,54,78,102,126],[6,26,52,78,104,130],[6,30,56,82,108,134],[6,34,60,86,112,138],[6,30,58,86,114,142],[6,34,62,90,118,146],[6,30,54,78,102,126,150],[6,24,50,76,102,128,154],[6,28,54,80,106,132,158],[6,32,58,84,110,136,162],[6,26,54,82,110,138,166],[6,30,58,86,114,142,170]],G15:1335,G18:7973,G15_MASK:21522,getBCHTypeInfo:function(a){for(var b=a<<10;f.getBCHDigit(b)-f.getBCHDigit(f.G15)>=0;)b^=f.G15<<f.getBCHDigit(b)-f.getBCHDigit(f.G15);return(a<<10|b)^f.G15_MASK},getBCHTypeNumber:function(a){for(var b=a<<12;f.getBCHDigit(b)-f.getBCHDigit(f.G18)>=0;)b^=f.G18<<f.getBCHDigit(b)-f.getBCHDigit(f.G18);return a<<12|b},getBCHDigit:function(a){for(var b=0;0!=a;)b++,a>>>=1;return b},getPatternPosition:function(a){return f.PATTERN_POSITION_TABLE[a-1]},getMask:function(a,b,c){switch(a){case e.PATTERN000:return 0==(b+c)%2;case e.PATTERN001:return 0==b%2;case e.PATTERN010:return 0==c%3;case e.PATTERN011:return 0==(b+c)%3;case e.PATTERN100:return 0==(Math.floor(b/2)+Math.floor(c/3))%2;case e.PATTERN101:return 0==b*c%2+b*c%3;case e.PATTERN110:return 0==(b*c%2+b*c%3)%2;case e.PATTERN111:return 0==(b*c%3+(b+c)%2)%2;default:throw new Error("bad maskPattern:"+a)}},getErrorCorrectPolynomial:function(a){for(var b=new i([1],0),c=0;a>c;c++)b=b.multiply(new i([1,g.gexp(c)],0));return b},getLengthInBits:function(a,b){if(b>=1&&10>b)switch(a){case c.MODE_NUMBER:return 10;case c.MODE_ALPHA_NUM:return 9;case c.MODE_8BIT_BYTE:return 8;case c.MODE_KANJI:return 8;default:throw new Error("mode:"+a)}else if(27>b)switch(a){case c.MODE_NUMBER:return 12;case c.MODE_ALPHA_NUM:return 11;case c.MODE_8BIT_BYTE:return 16;case c.MODE_KANJI:return 10;default:throw new Error("mode:"+a)}else{if(!(41>b))throw new Error("type:"+b);switch(a){case c.MODE_NUMBER:return 14;case c.MODE_ALPHA_NUM:return 13;case c.MODE_8BIT_BYTE:return 16;case c.MODE_KANJI:return 12;default:throw new Error("mode:"+a)}}},getLostPoint:function(a){for(var b=a.getModuleCount(),c=0,d=0;b>d;d++)for(var e=0;b>e;e++){for(var f=0,g=a.isDark(d,e),h=-1;1>=h;h++)if(!(0>d+h||d+h>=b))for(var i=-1;1>=i;i++)0>e+i||e+i>=b||(0!=h||0!=i)&&g==a.isDark(d+h,e+i)&&f++;f>5&&(c+=3+f-5)}for(var d=0;b-1>d;d++)for(var e=0;b-1>e;e++){var j=0;a.isDark(d,e)&&j++,a.isDark(d+1,e)&&j++,a.isDark(d,e+1)&&j++,a.isDark(d+1,e+1)&&j++,(0==j||4==j)&&(c+=3)}for(var d=0;b>d;d++)for(var e=0;b-6>e;e++)a.isDark(d,e)&&!a.isDark(d,e+1)&&a.isDark(d,e+2)&&a.isDark(d,e+3)&&a.isDark(d,e+4)&&!a.isDark(d,e+5)&&a.isDark(d,e+6)&&(c+=40);for(var e=0;b>e;e++)for(var d=0;b-6>d;d++)a.isDark(d,e)&&!a.isDark(d+1,e)&&a.isDark(d+2,e)&&a.isDark(d+3,e)&&a.isDark(d+4,e)&&!a.isDark(d+5,e)&&a.isDark(d+6,e)&&(c+=40);for(var k=0,e=0;b>e;e++)for(var d=0;b>d;d++)a.isDark(d,e)&&k++;var l=Math.abs(100*k/b/b-50)/5;return c+=10*l}},g={glog:function(a){if(1>a)throw new Error("glog("+a+")");return g.LOG_TABLE[a]},gexp:function(a){for(;0>a;)a+=255;for(;a>=256;)a-=255;return g.EXP_TABLE[a]},EXP_TABLE:new Array(256),LOG_TABLE:new Array(256)},h=0;8>h;h++)g.EXP_TABLE[h]=1<<h;for(var h=8;256>h;h++)g.EXP_TABLE[h]=g.EXP_TABLE[h-4]^g.EXP_TABLE[h-5]^g.EXP_TABLE[h-6]^g.EXP_TABLE[h-8];for(var h=0;255>h;h++)g.LOG_TABLE[g.EXP_TABLE[h]]=h;i.prototype={get:function(a){return this.num[a]},getLength:function(){return this.num.length},multiply:function(a){for(var b=new Array(this.getLength()+a.getLength()-1),c=0;c<this.getLength();c++)for(var d=0;d<a.getLength();d++)b[c+d]^=g.gexp(g.glog(this.get(c))+g.glog(a.get(d)));return new i(b,0)},mod:function(a){if(this.getLength()-a.getLength()<0)return this;for(var b=g.glog(this.get(0))-g.glog(a.get(0)),c=new Array(this.getLength()),d=0;d<this.getLength();d++)c[d]=this.get(d);for(var d=0;d<a.getLength();d++)c[d]^=g.gexp(g.glog(a.get(d))+b);return new i(c,0).mod(a)}},j.RS_BLOCK_TABLE=[[1,26,19],[1,26,16],[1,26,13],[1,26,9],[1,44,34],[1,44,28],[1,44,22],[1,44,16],[1,70,55],[1,70,44],[2,35,17],[2,35,13],[1,100,80],[2,50,32],[2,50,24],[4,25,9],[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],[2,86,68],[4,43,27],[4,43,19],[4,43,15],[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16],[4,101,81],[1,80,50,4,81,51],[4,50,22,4,51,23],[3,36,12,8,37,13],[2,116,92,2,117,93],[6,58,36,2,59,37],[4,46,20,6,47,21],[7,42,14,4,43,15],[4,133,107],[8,59,37,1,60,38],[8,44,20,4,45,21],[12,33,11,4,34,12],[3,145,115,1,146,116],[4,64,40,5,65,41],[11,36,16,5,37,17],[11,36,12,5,37,13],[5,109,87,1,110,88],[5,65,41,5,66,42],[5,54,24,7,55,25],[11,36,12],[5,122,98,1,123,99],[7,73,45,3,74,46],[15,43,19,2,44,20],[3,45,15,13,46,16],[1,135,107,5,136,108],[10,74,46,1,75,47],[1,50,22,15,51,23],[2,42,14,17,43,15],[5,150,120,1,151,121],[9,69,43,4,70,44],[17,50,22,1,51,23],[2,42,14,19,43,15],[3,141,113,4,142,114],[3,70,44,11,71,45],[17,47,21,4,48,22],[9,39,13,16,40,14],[3,135,107,5,136,108],[3,67,41,13,68,42],[15,54,24,5,55,25],[15,43,15,10,44,16],[4,144,116,4,145,117],[17,68,42],[17,50,22,6,51,23],[19,46,16,6,47,17],[2,139,111,7,140,112],[17,74,46],[7,54,24,16,55,25],[34,37,13],[4,151,121,5,152,122],[4,75,47,14,76,48],[11,54,24,14,55,25],[16,45,15,14,46,16],[6,147,117,4,148,118],[6,73,45,14,74,46],[11,54,24,16,55,25],[30,46,16,2,47,17],[8,132,106,4,133,107],[8,75,47,13,76,48],[7,54,24,22,55,25],[22,45,15,13,46,16],[10,142,114,2,143,115],[19,74,46,4,75,47],[28,50,22,6,51,23],[33,46,16,4,47,17],[8,152,122,4,153,123],[22,73,45,3,74,46],[8,53,23,26,54,24],[12,45,15,28,46,16],[3,147,117,10,148,118],[3,73,45,23,74,46],[4,54,24,31,55,25],[11,45,15,31,46,16],[7,146,116,7,147,117],[21,73,45,7,74,46],[1,53,23,37,54,24],[19,45,15,26,46,16],[5,145,115,10,146,116],[19,75,47,10,76,48],[15,54,24,25,55,25],[23,45,15,25,46,16],[13,145,115,3,146,116],[2,74,46,29,75,47],[42,54,24,1,55,25],[23,45,15,28,46,16],[17,145,115],[10,74,46,23,75,47],[10,54,24,35,55,25],[19,45,15,35,46,16],[17,145,115,1,146,116],[14,74,46,21,75,47],[29,54,24,19,55,25],[11,45,15,46,46,16],[13,145,115,6,146,116],[14,74,46,23,75,47],[44,54,24,7,55,25],[59,46,16,1,47,17],[12,151,121,7,152,122],[12,75,47,26,76,48],[39,54,24,14,55,25],[22,45,15,41,46,16],[6,151,121,14,152,122],[6,75,47,34,76,48],[46,54,24,10,55,25],[2,45,15,64,46,16],[17,152,122,4,153,123],[29,74,46,14,75,47],[49,54,24,10,55,25],[24,45,15,46,46,16],[4,152,122,18,153,123],[13,74,46,32,75,47],[48,54,24,14,55,25],[42,45,15,32,46,16],[20,147,117,4,148,118],[40,75,47,7,76,48],[43,54,24,22,55,25],[10,45,15,67,46,16],[19,148,118,6,149,119],[18,75,47,31,76,48],[34,54,24,34,55,25],[20,45,15,61,46,16]],j.getRSBlocks=function(a,b){var c=j.getRsBlockTable(a,b);if(void 0==c)throw new Error("bad rs block @ typeNumber:"+a+"/errorCorrectLevel:"+b);for(var d=c.length/3,e=[],f=0;d>f;f++)for(var g=c[3*f+0],h=c[3*f+1],i=c[3*f+2],k=0;g>k;k++)e.push(new j(h,i));return e},j.getRsBlockTable=function(a,b){switch(b){case d.L:return j.RS_BLOCK_TABLE[4*(a-1)+0];case d.M:return j.RS_BLOCK_TABLE[4*(a-1)+1];case d.Q:return j.RS_BLOCK_TABLE[4*(a-1)+2];case d.H:return j.RS_BLOCK_TABLE[4*(a-1)+3];default:return void 0}},k.prototype={get:function(a){var b=Math.floor(a/8);return 1==(1&this.buffer[b]>>>7-a%8)},put:function(a,b){for(var c=0;b>c;c++)this.putBit(1==(1&a>>>b-c-1))},getLengthInBits:function(){return this.length},putBit:function(a){var b=Math.floor(this.length/8);this.buffer.length<=b&&this.buffer.push(0),a&&(this.buffer[b]|=128>>>this.length%8),this.length++}};var l=[[17,14,11,7],[32,26,20,14],[53,42,32,24],[78,62,46,34],[106,84,60,44],[134,106,74,58],[154,122,86,64],[192,152,108,84],[230,180,130,98],[271,213,151,119],[321,251,177,137],[367,287,203,155],[425,331,241,177],[458,362,258,194],[520,412,292,220],[586,450,322,250],[644,504,364,280],[718,560,394,310],[792,624,442,338],[858,666,482,382],[929,711,509,403],[1003,779,565,439],[1091,857,611,461],[1171,911,661,511],[1273,997,715,535],[1367,1059,751,593],[1465,1125,805,625],[1528,1190,868,658],[1628,1264,908,698],[1732,1370,982,742],[1840,1452,1030,790],[1952,1538,1112,842],[2068,1628,1168,898],[2188,1722,1228,958],[2303,1809,1283,983],[2431,1911,1351,1051],[2563,1989,1423,1093],[2699,2099,1499,1139],[2809,2213,1579,1219],[2953,2331,1663,1273]],o=function(){var a=function(a,b){this._el=a,this._htOption=b};return a.prototype.draw=function(a){function g(a,b){var c=document.createElementNS("http://www.w3.org/2000/svg",a);for(var d in b)b.hasOwnProperty(d)&&c.setAttribute(d,b[d]);return c}var b=this._htOption,c=this._el,d=a.getModuleCount();Math.floor(b.width/d),Math.floor(b.height/d),this.clear();var h=g("svg",{viewBox:"0 0 "+String(d)+" "+String(d),width:"100%",height:"100%",fill:b.colorLight});h.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),c.appendChild(h),h.appendChild(g("rect",{fill:b.colorDark,width:"1",height:"1",id:"template"}));for(var i=0;d>i;i++)for(var j=0;d>j;j++)if(a.isDark(i,j)){var k=g("use",{x:String(i),y:String(j)});k.setAttributeNS("http://www.w3.org/1999/xlink","href","#template"),h.appendChild(k)}},a.prototype.clear=function(){for(;this._el.hasChildNodes();)this._el.removeChild(this._el.lastChild)},a}(),p="svg"===document.documentElement.tagName.toLowerCase(),q=p?o:m()?function(){function a(){this._elImage.src=this._elCanvas.toDataURL("image/png"),this._elImage.style.display="block",this._elImage.style.width="120px",this._elCanvas.style.display="none"}function d(a,b){var c=this;if(c._fFail=b,c._fSuccess=a,null===c._bSupportDataURI){var d=document.createElement("img"),e=function(){c._bSupportDataURI=!1,c._fFail&&_fFail.call(c)},f=function(){c._bSupportDataURI=!0,c._fSuccess&&c._fSuccess.call(c)};return d.onabort=e,d.onerror=e,d.onload=f,d.src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg==",void 0}c._bSupportDataURI===!0&&c._fSuccess?c._fSuccess.call(c):c._bSupportDataURI===!1&&c._fFail&&c._fFail.call(c)}if(this._android&&this._android<=2.1){var b=1/window.devicePixelRatio,c=CanvasRenderingContext2D.prototype.drawImage;CanvasRenderingContext2D.prototype.drawImage=function(a,d,e,f,g,h,i,j){if("nodeName"in a&&/img/i.test(a.nodeName))for(var l=arguments.length-1;l>=1;l--)arguments[l]=arguments[l]*b;else"undefined"==typeof j&&(arguments[1]*=b,arguments[2]*=b,arguments[3]*=b,arguments[4]*=b);c.apply(this,arguments)}}var e=function(a,b){this._bIsPainted=!1,this._android=n(),this._htOption=b,this._elCanvas=document.createElement("canvas"),this._elCanvas.width=b.width,this._elCanvas.height=b.height,a.appendChild(this._elCanvas),this._el=a,this._oContext=this._elCanvas.getContext("2d"),this._bIsPainted=!1,this._elImage=document.createElement("img"),this._elImage.style.display="none",this._el.appendChild(this._elImage),this._bSupportDataURI=null};return e.prototype.draw=function(a){var b=this._elImage,c=this._oContext,d=this._htOption,e=a.getModuleCount(),f=d.width/e,g=d.height/e,h=Math.round(f),i=Math.round(g);b.style.display="none",this.clear();for(var j=0;e>j;j++)for(var k=0;e>k;k++){var l=a.isDark(j,k),m=k*f,n=j*g;c.strokeStyle=l?d.colorDark:d.colorLight,c.lineWidth=1,c.fillStyle=l?d.colorDark:d.colorLight,c.fillRect(m,n,f,g),c.strokeRect(Math.floor(m)+.5,Math.floor(n)+.5,h,i),c.strokeRect(Math.ceil(m)-.5,Math.ceil(n)-.5,h,i)}this._bIsPainted=!0},e.prototype.makeImage=function(){this._bIsPainted&&d.call(this,a)},e.prototype.isPainted=function(){return this._bIsPainted},e.prototype.clear=function(){this._oContext.clearRect(0,0,this._elCanvas.width,this._elCanvas.height),this._bIsPainted=!1},e.prototype.round=function(a){return a?Math.floor(1e3*a)/1e3:a},e}():function(){var a=function(a,b){this._el=a,this._htOption=b};return a.prototype.draw=function(a){for(var b=this._htOption,c=this._el,d=a.getModuleCount(),e=Math.floor(b.width/d),f=Math.floor(b.height/d),g=['<table style="border:0;border-collapse:collapse;">'],h=0;d>h;h++){g.push("<tr>");for(var i=0;d>i;i++)g.push('<td style="border:0;border-collapse:collapse;padding:0;margin:0;width:'+e+"px;height:"+f+"px;background-color:"+(a.isDark(h,i)?b.colorDark:b.colorLight)+';"></td>');g.push("</tr>")}g.push("</table>"),c.innerHTML=g.join("");var j=c.childNodes[0],k=(b.width-j.offsetWidth)/2,l=(b.height-j.offsetHeight)/2;k>0&&l>0&&(j.style.margin=l+"px "+k+"px")},a.prototype.clear=function(){this._el.innerHTML=""},a}();QRCode=function(a,b){if(this._htOption={width:256,height:256,typeNumber:4,colorDark:"#000000",colorLight:"#ffffff",correctLevel:d.H},"string"==typeof b&&(b={text:b}),b)for(var c in b)
				   this._htOption[c]=b[c];"string"==typeof a&&(a=document.getElementById(a)),
				   this._android=n(),this._el=a,
				   this._oQRCode=null,this._oDrawing=new q(this._el,this._htOption),this._htOption.text&&this.makeCode(this._htOption.text)},
				   QRCode.prototype.makeCode=function(a){this._oQRCode=new b(r(a,this._htOption.correctLevel),this._htOption.correctLevel),
				   this._oQRCode.addData(a),this._oQRCode.make(),this._el.title=a,this._oDrawing.draw(this._oQRCode),this.makeImage()},
				   QRCode.prototype.makeImage=function(){"function"==typeof this._oDrawing.makeImage&&(!this._android||this._android>=3)&&this._oDrawing.makeImage()},
				   QRCode.prototype.clear=function(){this._oDrawing.clear()},QRCode.CorrectLevel=d}();]]></script>
      </head>
      <body>
        <div align="center" class="invoice" style="background-size: 98px; background-position-y:415px; background-position-x: right; width: 1024px; margin: auto;padding: 5px;background-repeat: no-repeat; background-image:url('data:image/jpeg;base64,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')">
          <div align="center" style="min-height:1041px;">
            <img alt="" style="width: 100%; margin-bottom: 13px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA+cAAAAhAgMAAADGyTIbAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAMUExURUWBwkOAwkaBwr3DymeJY7EAAAAJcEhZcwAAEnQAABJ0Ad5mH3gAAAAfSURBVGje7cGBAAAAAMOg+VOf4AZVAAAAAAAAAABPDSBbAAFM+YSvAAAAAElFTkSuQmCC"/>
            <table class="header" border="0" width="100%" style="width: 100%;">
              <tbody>
                <tr>
                  <td width="40%">
                    <div style="padding-top: 22px;padding-bottom: 22px;">
                      <img alt="" style="max-width: 320px; " src="data:image/png;base64,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"/>
                    </div>
                    <!--
                    <hr style="background-color:black;border:none;height:2px"/>
                    <hr style="background-color:black;border:none;height:2px"/>
                    -->
                    <div align="left" class="frame">
                      <xsl:if test="((//n1:Invoice/cbc:ProfileID != 'IHRACAT') and (//n1:Invoice/cbc:ProfileID != 'YOLCUBERABERFATURA'))">
                        <table align="center" border="0">
                          <tbody>
                            <tr>
                              <td/>
                            </tr>
                            <tr>
                              <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:AccountingCustomerParty">
                                  <xsl:for-each select="cac:Party">
                                    <td style="width:469px; " align="left">
                                      <span style="font-weight:bold; ">
                                        <xsl:text>SAYIN</xsl:text>
                                      </span>
                                    </td>
                                  </xsl:for-each>
                                </xsl:for-each>
                              </xsl:for-each>
                            </tr>
                            <tr>
                              <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:AccountingCustomerParty">
                                  <xsl:for-each select="cac:Party">
                                    <td style="font-weight:bold; " align="left">
                                      <xsl:if test="cac:PartyName">
                                        <xsl:value-of select="cac:PartyName/cbc:Name"/>
                                        <br/>
                                      </xsl:if>
                                      <xsl:for-each select="cac:Person">
                                        <xsl:for-each select="cbc:Title">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:FirstName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:MiddleName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160; </xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:FamilyName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:NameSuffix">
                                          <xsl:apply-templates/>
                                        </xsl:for-each>
                                      </xsl:for-each>
                                    </td>
                                  </xsl:for-each>
                                </xsl:for-each>
                              </xsl:for-each>
                            </tr>
                            <tr>
                              <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:AccountingCustomerParty">
                                  <xsl:for-each select="cac:Party">
                                    <td style="width:469px; " align="left">
                                      <xsl:for-each select="cac:PostalAddress">
                                        <xsl:for-each select="cbc:StreetName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:BuildingName">
                                          <xsl:apply-templates/>
                                        </xsl:for-each>
                                        <xsl:if test="cbc:BuildingNumber!=''">
                                          <xsl:for-each select="cbc:BuildingNumber">
                                            <span>
                                              <xsl:text> </xsl:text>
                                            </span>
                                            <xsl:apply-templates/>
                                            <span>
                                              <xsl:text>&#160;</xsl:text>
                                            </span>
                                          </xsl:for-each>
                                          <br/>
                                        </xsl:if>
                                        <xsl:for-each select="cbc:Room">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:PostalZone">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:CitySubdivisionName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>/ </xsl:text>
                                          </span>
                                        </xsl:for-each>
                                        <xsl:for-each select="cbc:CityName">
                                          <xsl:apply-templates/>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </xsl:for-each>
                                      </xsl:for-each>
                                    </td>
                                  </xsl:for-each>
                                </xsl:for-each>
                              </xsl:for-each>
                            </tr>
                            <!--
                            <xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cbc:WebsiteURI">
                              <tr align="left">
                                <td>
                                  <xsl:text>Web Sitesi: </xsl:text>
                                  <xsl:value-of select="."/>
                                </td>
                              </tr>
                            </xsl:for-each>
                            -->
                            <xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail">
                              <tr align="left">
                                <td>
                                  <xsl:text>E-Posta: </xsl:text>
                                  <xsl:value-of select="."/>
                                </td>
                              </tr>
                            </xsl:for-each>
                            <xsl:for-each select="n1:Invoice">
                              <xsl:for-each select="cac:AccountingCustomerParty">
                                <xsl:for-each select="cac:Party">
                                  <xsl:for-each select="cac:Contact">
                                    <xsl:if test="cbc:Telephone or cbc:Telefax">
                                      <tr align="left">
                                        <td style="width:469px; " align="left">
                                          <xsl:for-each select="cbc:Telephone">
                                            <span>
                                              <xsl:text>Tel: </xsl:text>
                                            </span>
                                            <xsl:apply-templates/>
                                          </xsl:for-each>
                                          <xsl:for-each select="cbc:Telefax">
                                            <span>
                                              <xsl:text> Fax: </xsl:text>
                                            </span>
                                            <xsl:apply-templates/>
                                          </xsl:for-each>
                                          <span>
                                            <xsl:text>&#160;</xsl:text>
                                          </span>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
                                      <tr align="left">
                                        <td>
                                          <span>
                                            <xsl:text>Vergi Dairesi: </xsl:text>
                                            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
                                          </span>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                  </xsl:for-each>
                                </xsl:for-each>
                              </xsl:for-each>
                            </xsl:for-each>
                            <xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification[1]">
                              <tr align="left">
                                <td>
                                  <xsl:value-of select="cbc:ID/@schemeID"/>
                                  <xsl:text>: </xsl:text>
                                  <xsl:value-of select="cbc:ID"/>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </tbody>
                        </table>
                        <!--
                        <hr/>
                        -->
                      </xsl:if>
                      <xsl:if test="((//n1:Invoice/cbc:ProfileID = 'IHRACAT') or (//n1:Invoice/cbc:ProfileID = 'YOLCUBERABERFATURA'))">
                        <table>
                          <tr>
                            <td>
                              <table align="center" border="0">
                                <tbody>
                                  <tr>
                                    <xsl:for-each select="n1:Invoice">
                                      <xsl:for-each select="cac:BuyerCustomerParty">
                                        <xsl:for-each select="cac:Party">
                                          <td style="width:469px; " align="left">
                                            <span style="font-weight:bold; ">
                                              <xsl:text>SAYIN</xsl:text>
                                            </span>
                                          </td>
                                        </xsl:for-each>
                                      </xsl:for-each>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <xsl:for-each select="n1:Invoice">
                                      <xsl:for-each select="cac:BuyerCustomerParty">
                                        <xsl:for-each select="cac:Party">
                                          <td style="font-weight:bold; " align="left">
                                            <xsl:if test="cac:PartyName">
                                              <xsl:value-of select="cac:PartyName/cbc:Name"/>
                                              <br/>
                                            </xsl:if>
                                            <xsl:for-each select="cac:Person">
                                              <xsl:for-each select="cbc:Title">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                              <xsl:if test="//n1:Invoice/cbc:ProfileID = 'YOLCUBERABERFATURA'">
                                                <!--
                                                <xsl:for-each select="cbc:FirstName">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                                <xsl:for-each select="cbc:MiddleName">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160; </xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                                <xsl:for-each select="cbc:FamilyName">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                                -->
                                                <xsl:text>Uyruğu: </xsl:text>
                                                <xsl:for-each select="cbc:NationalityID">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                                <br/>
                                                <xsl:text>Pasaport Numarası: </xsl:text>
                                                <xsl:for-each select="cac:IdentityDocumentReference/cbc:ID">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                                <br/>
                                                <xsl:text>Pasaport Tarihi: </xsl:text>
                                                <xsl:for-each select="cac:IdentityDocumentReference/cbc:IssueDate">
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                              </xsl:if>
                                              <xsl:for-each select="cbc:NameSuffix">
                                                <xsl:apply-templates/>
                                              </xsl:for-each>
                                            </xsl:for-each>
                                          </td>
                                        </xsl:for-each>
                                      </xsl:for-each>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <xsl:for-each select="n1:Invoice">
                                      <xsl:for-each select="cac:BuyerCustomerParty">
                                        <xsl:for-each select="cac:Party">
                                          <td style="width:469px; " align="left">
                                            <xsl:for-each select="cac:PostalAddress">
                                              <xsl:for-each select="cbc:StreetName">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                              <xsl:for-each select="cbc:BuildingName">
                                                <xsl:apply-templates/>
                                              </xsl:for-each>
                                              <xsl:if test="cbc:BuildingNumber!=''">
                                                <xsl:for-each select="cbc:BuildingNumber">
                                                  <span>
                                                    <xsl:text> No:</xsl:text>
                                                  </span>
                                                  <xsl:apply-templates/>
                                                  <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                  </span>
                                                </xsl:for-each>
                                              </xsl:if>
                                              <xsl:for-each select="cbc:Room">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                              <br/>
                                              <xsl:for-each select="cbc:PostalZone">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                              <xsl:for-each select="cbc:CitySubdivisionName">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>/</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                              <xsl:for-each select="cbc:CityName">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                            </xsl:for-each>
                                            <br/>
                                            <xsl:for-each select="cac:PartyLegalEntity">
                                              <xsl:for-each select="cbc:RegistrationName">
                                                <xsl:apply-templates/>
                                                <span>
                                                  <xsl:text>&#160;</xsl:text>
                                                </span>
                                              </xsl:for-each>
                                            </xsl:for-each>
                                          </td>
                                        </xsl:for-each>
                                      </xsl:for-each>
                                    </xsl:for-each>
                                  </tr>
                                </tbody>
                              </table>
                              <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:BuyerCustomerParty"></xsl:for-each>
                              </xsl:for-each>
                            </td>
                          </tr>
                        </table>
                      </xsl:if>
                      <!--
                      <span style="font-weight:bold;">
                        <xsl:text>SAYIN</xsl:text>
         		          </span>
                      <xsl:choose>
                        <xsl:when test="//n1:Invoice/cbc:ProfileID = 'IHRACAT'">
                          <xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
                            <xsl:call-template name="partyBlockName"/>
                            <xsl:call-template name="partyBlockPostalAddress"/>
                          </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                            <xsl:call-template name="partyBlockName"/>
                            <xsl:call-template name="partyBlockPostalAddress"/>
                            <xsl:call-template name="partyBlockTaxInfo"/>
                            <xsl:call-template name="partyBlockTradeRegistryInfo"/>
                            <xsl:call-template name="partyBlockMersisNo"/>
                          </xsl:for-each>
                        </xsl:otherwise>
                      </xsl:choose>
                      -->
                    </div>
                    <br/>
                    <xsl:for-each select="n1:Invoice/cbc:UUID">
                      <div data-role="ettn-number">
                        <spam style="font-weight:bold">ETTN :</spam>
                        <xsl:value-of select="."/>
                      </div>
                    </xsl:for-each>
                    <br/>
                    <table style="margin-top:0px;">
                      <tr>
                        <td>
                          <a href="https://wa.me/+905338946607" target="_blank">
                            <img style="height:25px" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAzCAYAAADVY1sUAAAACXBIWXMAAAsSAAALEgHS3X78AAADxUlEQVRogcVa23XbMAy90ALxBvEG0QbRCB5BI6gT1CO4GygbOBswGzgbqBuoE6AfpFyZAkFSotx7Dj/MF3AJEAJJEzOjJIioAXB0RcII4AbgxsxjMcHMvKk4hTunHGeWG4ALgHqzHhsItADMCuU1Uu3TiABoAAwFCfhlWEMoh8ABwHWFUsaVXPIGwLEoEWeFMSJ4BNADOGkKuD11cnsjRm4EcCpCxO2F2MolCVMWqY/IOG8iEiFhADRrCQQsZRR5/SoiERJdKQIBuSE3vmQRcT4c8tnNMT+BTI3wd6lNIuJMLK3ITdvEO5A5KGQWiylNIPnpCODwLBIJZG4qkcC+eIo7RchIHnIWiSgDRJ+cjWlc2c1ibn7VS+adz0LnqzJ55xFfmLswmYsWxeYdB6HjMTCp5IKMgt+VRBe7W2XqJIXbPtNnVQsWIiN5TTsn0hewhjquoFV8eYaZUcHihEd8M/MAGXWgfkIbaV8NtifKD6/6nYgOFRHVAF68xl6ZL0aky9QvF1ehrqlgQ5sPo0xU7py9DkaoqyssLwn+MPNNmUhrA2yY3A3Ovb696qbC0lViikqmnfDJzOdM3dZg4RWV1EuDs5a/IhN2tcYMxvv9LhHxO0k4B+qbdF3KItsiAMDMVwCfQtNPFwWfDonIIXFsC+CPUG+IKHWOYpCIJK2oix6t0PSC/ckcvd+/KywjQLICzsV+CU1vsGR8gXcQUU1EFyI6a/0C8PsPgJCIrciBQhd3I4TzDKzV/cSzR2KeFhgrZr5Z91TQz9eM2dVRQt8eyiHNLYI/ppvMFDywFCTDCe0PGW1ATif0r6dGX8CwIc3uE5VdS2Tw3Xeexhs84pWIWmSCmUdmbgH8yB3rwdcHwP0R6dWrvk7CAdm9gquSaJ0j1r+fiJs+MJ/de5FOi4izglCDvOcIUSbkm5T7hUesY7GLOdj90yqkDAL3Z27soJH2B0hRRTRzIUtNRZUBOYA8uH6MyK53VYmE24AFG5EICn1PnkRioVds0OqXqB1JiF6i+uF/JCFdj6rBZz7YT8RMQEgDm2g2OxDQHnjUV4H5BP7AbtbWQQ6bfYmo5vanFJmSSMyJSInYTbBSqFydT2d9c2Az79jHMumljJgZRGQAvKMMvpzwAcurpRr/3lRS5H3Aekb8UtCtTMqqP7MMyD8TBV9wJT/tYV2oxT7/RxmR8OeAEBEt1F1h908oB2qR//8UqRhsTFAJ1o/fnKd9uUkNMxskwt2YnODyJsT9/9vJnWQNqbKCOsBaxLC9ESkKdxC6I2dxcvEXB/trpjgS0FwAAAAASUVORK5CYII="/>
                          </a>
                        </td>
                        <td>
                          <a href="https://www.instagram.com/fqcstandard/" target="_blank">
                            <img style="height:25px" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADMAAAAzCAYAAAA6oTAqAAAACXBIWXMAAAsSAAALEgHS3X78AAAEOklEQVRoge2a0XHjNhCGP4uLZ6sDKxWYqeDYwamDkys4pYL4KohTQeQKoqsgdAWRKjipgpOfiRnmgSsfDS4kErJsJ5N/hqMZAqD2BxbLf5e4qOuavhBxYyAHJnqdCytg531VDhl0cYyMiJsAc6AArtNsOwkPwBJYeF/tDnWMklESC+DDCxuXikfgDriLkTLJiLiZDrw8p3WJ2AJT76tV2NAho0T+eB27kvEIFCGhZ2R6ENkCJbDR33NgoldOs09j3tElVNc1dV2TZZJnmdSRq8wyKfZ9X/PKMpllmWwidm2yTMb7vu1BZWTA/C1IBITGWSaLiH23z8hkmRSRjrO3JhKQWho27varM1Jvmxk++dX7avEy26A/RFwu4koRV4u4jYibt5pnNPu2jUtgCjytzM5gPHkjd7JsmbX6zIz2ZV3XjERcTjdirL2vNmea/EOYGrbAc89ZGu0FgNCEwBDWgEHQSZoEzy+BzYGJGh97rvfVTsQ98FyZXIq4sWALxs7btQ9aOm4KXBldftV+axqpFOqtJfCbMW5j2BfKrHyEjYOCLoSIG4u4W+Ab8BmbSBvXNEZvRNx0f1NX7Cbo+0AzQUfti61MbzK6GkvSFPUl8KeIu/e+mgF4Xy1EXKl27SwNFrUFg0zfByiRFacL0k8iLve+yvX/N3Rdqw3LvkJS/10TtSVxIlttL2lWOtcrFrGuRdxiv0JHEHWzVNxiu9YWmHtfhRGxhKdJmKPBIMAnEbc0xvZCLAAchLrXZ6NpDeSHjPG+2nlf3QI/0yjfEHcpNkEiGZpVCbGlkeS9gofuy8JoutJUZDBSyUyNe7O+RPZQQl96Pv8oBpMRcQXdDfwwtJLSguVWH1MelLIyhXEvWf7oan4N7+ukDUKqm4VIkj8vOB54OTLvAv+TMWClEa85HkgjUxr3kkIpPCmCTvRKiY6DyUT+5ENK9FGE8h6M6NYHqW52b9xb6Cz3hmajlkZ7PW2GLWeugLIvISVSGk3b1KpQEhnNN343mq6B1TGX06y0xE4FLLfrhVNTgIJuGnAF/CXiwnxmov1j+QzAfar8hxPIaJVkRnyGr2jSBCtVsLDumZhBpIozwsja1J+PQlVvTpPHnIJ7bM0Xg2XfaoSti3pHJd0/BfYeOoZH4Mb7anD6YGAXCwCDQqxmj3PgJxpSVgbZxhr4BZgkRi7TPsGuguQkxHpdpTkwT6xo9oXpZhdZJjnwd9Cw3pd93hv0PfY9uP3ofTUe6SYO3eJaixbvEZYOLOHHS9NyqeQqybmgq2LZtYQfZBZGh4+pVZIzYkH3nfbIfjH+c980dcC/8Wvzqt33nOcAzBDcOkwUw7598DkA64TGLXaO8Z5gntDoKACtA99w/C3+VtiXgTsyzJQzKjFymq9W7wlfaArzZp1tyHmz2HfKcyP2/bODo2TaGHASsOjxuPJAW9JJwH8AN0VPlScTGngAAAAASUVORK5CYII="/>
                          </a>
                        </td>
                        <td>
                          <a href="https://maps.app.goo.gl/gkPkuiuuX6g7o86K9" target="_blank">
                            <img style="height:25px" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACYAAAAzCAYAAAD7JnqGAAAACXBIWXMAAAsSAAALEgHS3X78AAADAUlEQVRYhc2ZP2/TQBiHn8bnBYZ2oCCxpF1YifgEXigSIDVAVYmJABIr/QjhjyhdEIUNCeSOSCCFFdHW/QIoFYgBGNoNOkAyIIF80jHEbh3XduxzbeeRLMXxxX3qO9+9/nlCKYUOQpgzQMPbwvSArpSuo3VyYCKLmCfT8rZ6ip/0gQ5gZ5ZUSo3cDENMGYawDUOoHJtjGMJK8/eUUqOvmBBmE7CByUz/cTyrQFtKt5fUKFFMCNMGbhyRUJBtoCWl241rECtWoJRPH7Di5GpRX5YgBYOh4QhhRt3Vh8WEMNslSPlMAh0hzKnwgaGuFMK0gM2SpIK8k9JtBr/YF/Osu6Sbn4rgipRux98JduUS1UkBPA3u1GD/ai1VonNAXQiz5e/4V6zF0U2geWj7H4Ji40DduwGpeQvz2Up1hmnB4Io1k9uVjgUgiK6nUnN1foHFxYX9/W9fv/Pk+TN+/9rTPWVdCHMGwxBdnTLm2PFJtfHBUXHMnb+Yp0Sy0P3xo/uPY6WUUurnjz11Yvq0rlg7chFPw+07txKPnzw1zbmG/ijRFisabbGXL16NbPOxG1sHjkRb7OHKMpvrW7HHL8xdynNn6ov9+/uHy/PzLF67zpvXbwH4/OkLyw9WmJ09w/rGe20pgAnDED3GY50McrPGoAYbN3bGUkxK16kBTtUiIbYAal45269YJkgHDu7KTkLDshkSs6vzGGJNSncHPDEviYmfLcvD9j8EJ9h26RrDrAWjqvAD71PgbgVSfWAmmACFl6Q2sFumkUcrHEsNiXkHm5Q7fawGn8B9ImMoL4FxKH4N3ZLStaIOJOVjRcvtAo24ZDG27PECNYtiurUPNJPizsR6rEC5paSYE1IUigXIrUrp2qMapc75j2jMHQro4sj6AiKP3DaDMDgxRvfJVPPn6NY+EZNoEpkfRjTlEjP9KLSekjLK3Yua2UeRaYyFSTHmUg/2MLnEIFEu02APkzu7iOnWzIP9EGlf06V4ddgwDNHz862858vdlUG8bm2kmdlH8R+SWk0CXZ04/QAAAABJRU5ErkJggg=="/>
                          </a>
                        </td>
                        <td>
                          <a href="https://www.fqcstandard.com.tr/" target="_blank">
                            <img style="height:25px" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADMAAAAzCAYAAAA6oTAqAAAACXBIWXMAAAsSAAALEgHS3X78AAAFiElEQVRogdVa0ZHjNgx9u6S/1x2sUsH5Koi2gnUqiK4DXwVxKoivgtN14Ksg2grireDkDuRvcUb5EChDEChRlpNMMMOxRIEgHgiCIOmHpmlwT7J2tQGwBpAGWEoApXN1cdeOATwsBWPtag1gSyUF8DSj+TuAAkDuXH1apAgWgLF2lQLIAPy6VAmiM4ADWmDVTRKapplVjLEbY2xhjG2UUon3E3s+BtpoMnZz9WqaBo+xoK1dra1dHQD8BeBnYdEvAD6idRlen7L3E4BPQuxnqntjdU8A/rB2daL5F08zRuMkLFgaYzPGsxfW3VC9r9vTeybkeL7EGJsrIxU9SjFAtsJ9Kq8Y40mFAin71gNDdVzp0hi7njBcvhiMYsWTtyTjWZNCA6VDYKieK3xQ+t4rfa9vAqMAyTVhotNC+R4Ck4gRT5W20isG8ifB0FBzIeowk0IccBILhr7tuLst0UUFQ24TZQ3TD9EDZafAKDKyAI+ck2pQ0Bpq68FRWl100JvEM8FwOVXA3eX6VWleoPno2GKWeyGmH5FUi8aACckiXWRU42XgMVIoj0rbgFUa0bnq6zPBbMQol0qfR5qj/FumgjH96FWw+rUx9jBioZNRItEMN0tGjNbQnEoZf8+9uawu0bR2VQJ4psTgRabo1q4StInlDuHM+I3Slor9/knfvgHIAfgtwobK80DKVdZe2ypYuypwTal+ca4+dumMQBuMXoHI8k+UQSAY0eHo632imTHgh4ClPPHkzyeKX9DuTebSBcB3kvMR7egBwNNYkkmjdabXV9pTdSNTxVhECd2D8EiTOaV50MsO6D2lomUTfN4GAwbxctlZ0zSQkSSPAOOBj0axOdFMBIOB+0REwNy7WcpGsBjzCQoCfvIv3uZKcq4ucXWf0b0MbbMv9JoCwKNoNKVgMoP3VirpNxTlOHkdnoEWTOK/RBwqJOy5DPAspU6HiJ1mwXhTvm0+D3kHlLDnMoL/FuKHGes5DR+MsRXaeXBBnJv54X8XHYfIL25nxBlgTh+c9+XBGHvfU8D/jl6iT2f+F2SuafbkuiEWqmByees6M7cPyfuIq0/OCYXAzMn5b9Aj2KSMCIV8Ms47oIun1D9EHK731shH9K2dTDQuA4LuSV6HyxiT0OHsXF1JMNuxlpRu+E7uDoayX+/uo8sEpVY93kcayl6OM0FdCkEC70m8/2KClxu+AADLXl7RKphO+GqB60KYot09AlAvmniQ2Fq78s8llZO4vhgoOEIZe+7tNLcynY5Mvf0eJXTFEVNK0x6Q8HOAOTvNbmccOgP4iebHgMi1fkxYbSm9O1cH56Q4A/jkXJ0D6IHZA/iNGL47V2+FgBTAHv27mZ4CaOdTCXIR5+rC2pVPl35H6w5rtBErQeuOG+gHJGe0Lnzgrkh6+EOSs3N10rVgQyePZVO2+xtzo0rbAs/JAMz04WPGePnBYMbldLkZod8xy+R0U/YDw5uyz7jedj1hIqRHEG//DdeDDS//K92k5QA+UP27d6+OFCuFRqEUFgoexs0ZGbHv70bZhG/SfNlIWSHh8nQxpMg9bgGOYzxkNHnmrMoabAEoimWR7sHdcjd3EaXJ/EqvF+hndhX6adabc/VeFTjiHpmwhrr+mP45dBE7MmZ4fZgpbeVF0+hV4NTeQgIqpDBFqV0kmOOEEXai79vvNEcAVcbYreLX6uTUwAhFexdHNGflhdckkCgwTFkZFORVw0FTUIJRgG/ZCO+VfgY30YvAsM60K8ITjd5aRLcT1XVglDlwoLpcATHwgLuBEaOk3Wx5AKH3Y0BhTc4+xq1kWfKvpgxtaP4wwRpLF1xzsfIWAff4v9kG7bqUYj6wC9rksxikJjfQYjCcaNu7wXVzlgoWfkVY3uMPc5z+BpA3YOXUhpO0AAAAAElFTkSuQmCC"/>
                          </a>
                        </td>
                        <td style="font-weight: bold;font-size: 11px;vertical-align:middle;">
									Daha Fazla Bilgi İçin Logolara Tıklayınız...
									</td>
                      </tr>
                    </table>
                  </td>
                  <td width="20%" class="header__stamp">
                    <!-- GIB LOGO -->
                    <br/>
                    <br/>
                    <br/>
                    <img style="width:91px;" align="middle" alt="E-Fatura Logo" src="data:image/jpeg;base64,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"/>
                    <h3 align="center">e-FATURA</h3>
                    <!-- SIGNATURE -->
                    <br/>
                    <hr style="width:160px; height:1px; border:none; background-color:transparent;"/>
                  </td>
                  <td width="40%" align="right">
                    <div align="right" style=";margin-bottom: 5px;">
                      <div align="right" class="qr-code-container">
                        <div id="qrcode"/>
                        <!--qrvalue bloğu tek satır olarak korunması gerekiyor-->
                        <div id="qrvalue" style="vissibility: hidden; height: 30px; width: 30px; display:none">{"vkntckn":"<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'TCKN' or @schemeID = 'VKN']"/>","avkntckn":"<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'TCKN' or @schemeID = 'VKN']"/>","senaryo":"<xsl:value-of select="n1:Invoice/cbc:ProfileID"/>","tip":"<xsl:value-of select="n1:Invoice/cbc:InvoiceTypeCode"/>","tarih":"<xsl:value-of select="n1:Invoice/cbc:IssueDate"/>","no":"<xsl:value-of select="n1:Invoice/cbc:ID"/>","ettn":"<xsl:value-of select="n1:Invoice/cbc:UUID"/>","parabirimi":"<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>","malhizmettoplam":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount"/>",<xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015']"><xsl:text>"kdvmatrah</xsl:text>(<xsl:value-of select="cbc:Percent"/>)":"<xsl:value-of select="cbc:TaxableAmount"/>",</xsl:for-each><xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015']"><xsl:text>"hesaplanankdv</xsl:text>(<xsl:value-of select="cbc:Percent"/>)":"<xsl:value-of select="cbc:TaxAmount"/>",</xsl:for-each>"vergidahil":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount"/>","odenecek":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount"/>"}</div>
                        <script type="text/javascript">
										var qrcode = new QRCode(document.getElementById("qrcode"), {
										width : 120,
										height : 120,
										correctLevel: QRCode.CorrectLevel.L,
										});
										qrcode.makeCode(document.getElementById("qrvalue").innerHTML)
									</script>
                      </div>
                    </div>
                    <!-- Company logo -->
                    <!--
                    <hr style="background-color:black;border:none;height:2px"/>
                    -->
                    <div class="cerceve" align="left">
                      <xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">
                        <span style="font-weight:bold;">FQC STANDARD UYGUNLUK DEĞERLENDİRME A.Ş.</span>
                        <!--
                        <xsl:call-template name="partyBlockName"/>
                        <xsl:call-template name="partyBlockPostalAddress"/>
                        -->
                      </xsl:for-each>
                      <div style="">
                        <xsl:for-each select="n1:Invoice/cac:AccountingSupplierParty/cac:Party">
                          <table>
                            <tr>
                              <td colspan="3">İçerenköy Mah. Bahçelerarası Sk.No: 43 Kat: 14/A</td>
                            </tr>
                            <tr>
                              <td colspan="3">Ataşehir / İSTANBUL</td>
                            </tr>
                            <!--
                            <tr>
                              <td style="font-weight:bold; width: 100px;">
                                Telefon No
                              </td>
                              <td style="font-weight:bold">:</td>
                              <td>
                                <xsl:call-template name="partyBlockTelephone"/>
                              </td>
                            </tr>
                            <tr>
                              <td style="font-weight:bold">E-Posta</td>
                              <td style="font-weight:bold">:</td>
                              <td>
                                <xsl:call-template name="partyBlockElectronicMail"/>
                              </td>
                            </tr>
                            -->
                            <tr>
                              <td style="font-weight:bold">Vergi No</td>
                              <td style="font-weight:bold">:</td>
                              <td>
                                <xsl:choose>
                                  <xsl:when test="cac:PartyIdentification/cbc:ID[@schemeID='VKN'] != ''">
                                    <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='VKN']"/>
                                  </xsl:when>
                                  <xsl:when test="cac:PartyIdentification/cbc:ID[@schemeID='TCKN'] != ''">
                                    <xsl:value-of select="cac:PartyIdentification/cbc:ID[@schemeID='TCKN']"/>
                                  </xsl:when>
                                </xsl:choose>
                              </td>
                            </tr>
                            <tr>
                              <td style="font-weight:bold">Vergi Dairesi</td>
                              <td style="font-weight:bold">:</td>
                              <td>
                                <xsl:if test="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name != ''">
                                  <xsl:value-of select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
                                </xsl:if>
                              </td>
                            </tr>
                            <!--
                            <tr>
                              <td style="font-weight:bold">Ticaret Sic. No</td>
                              <td style="font-weight:bold">:</td>
                    		      <td>
                                <xsl:call-template name="partyBlockTradeRegistryInfo"/>
                              </td>
                            </tr>
                            <tr>
                              <td style="font-weight:bold">Mersis No</td>
                              <td style="font-weight:bold">:</td>
                              <td>
                                <xsl:call-template name="partyBlockMersisNo"/>
                              </td>
                            </tr>
                            -->
                          </table>
                        </xsl:for-each>
                      </div>
                    </div>
                    <!--
                    <hr style="background-color:black;border:none;height:2px" />
                    -->
                    <div class="cerceve">
                      <table border="0">
                        <tr>
                          <td style="font-weight:bold;width: 120px;">Özelleştirme No</td>
                          <td style="font-weight:bold">:</td>
                          <td style=" ">
                            <xsl:for-each select="n1:Invoice/cbc:CustomizationID">
                              <div data-role="invoice-ubl-version-number">
                                <xsl:value-of select="."/>
                              </div>
                            </xsl:for-each>
                          </td>
                        </tr>
                        <tr>
                          <td style="font-weight:bold;">Senaryo</td>
                          <td style="font-weight:bold">:</td>
                          <td style="">
                            <xsl:for-each select="n1:Invoice/cbc:ProfileID">
                              <div data-role="invoice-scenario">
                                <xsl:value-of select="."/>
                              </div>
                            </xsl:for-each>
                          </td>
                        </tr>
                        <tr>
                          <td style="font-weight:bold;">Fatura Tipi</td>
                          <td style="font-weight:bold">:</td>
                          <td style=" ">
                            <xsl:for-each select="n1:Invoice/cbc:InvoiceTypeCode">
                              <div data-role="invoice-type">
                                <xsl:value-of select="."/>
                              </div>
                            </xsl:for-each>
                          </td>
                        </tr>
                        <tr>
                          <td style="font-weight:bold;">Fatura Numarası</td>
                          <td style="font-weight:bold">:</td>
                          <td style="">
                            <xsl:for-each select="n1:Invoice/cbc:ID">
                              <div data-role="invoice-number">
                                <xsl:value-of select="."/>
                              </div>
                            </xsl:for-each>
                          </td>
                        </tr>
                        <tr>
                          <td style="font-weight:bold;">Fatura Tarihi</td>
                          <td style="font-weight:bold">:</td>
                          <td style="">
                            <div data-role="invoice-date">
                              <xsl:for-each select="n1:Invoice/cbc:IssueDate">
                                <xsl:value-of select="substring(string(.),9,2)"/>.<xsl:value-of select="substring(string(.),6,2)"/>.<xsl:value-of select="substring(string(.),1,4)"/>
                              </xsl:for-each>
                                <xsl:for-each select="n1:Invoice/cbc:IssueTime">&#8211; <xsl:value-of select="."/>
                              </xsl:for-each>
                            </div>
                          </td>
                        </tr>
                        <xsl:if test="n1:Invoice/cac:DespatchDocumentReference">
                          <xsl:for-each select="n1:Invoice/cac:DespatchDocumentReference">
                            <tr>
                              <td style="font-weight:bold;">İrsaliye Numarası</td>
                              <td style="font-weight:bold">:</td>
                              <td style="">
                                <div>
                                  <xsl:value-of select="cbc:ID"/>
                                </div>
                              </td>
                            </tr>
                            <tr>
                              <td style="font-weight:bold; width: 110px;border-style: solid;border-width: 1px;padding: 3px;border-color:black;border-top-style:none;border-right-style:none;border-left-style:none">İrsaliye Tarihi</td>
                              <td style="font-weight:bold">:</td>
                              <td style=" ">
                                <div>
                                  <xsl:for-each select="cbc:IssueDate">
                                    <xsl:value-of select="substring(string(.),9,2)"/>.<xsl:value-of select="substring(string(.),6,2)"/>.<xsl:value-of select="substring(string(.),1,4)"/>
                                  </xsl:for-each>
                                </div>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cac:OrderReference">
                          <tr style="height:13px">
                            <td style="font-weight:bold;">
                              <span style="font-weight:bold; ">
                                <xsl:text>Sipariş No</xsl:text>
                              </span>
                            </td>
                            <td style="font-weight:bold">:</td>
                            <td>
                              <xsl:for-each select="n1:Invoice/cac:OrderReference/cbc:ID">
                                <xsl:apply-templates/>
                              </xsl:for-each>
                            </td>
                          </tr>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cac:OrderReference/cbc:IssueDate">
                          <tr>
                            <td style="font-weight:bold;">
                              <span style="font-weight:bold; ">
                                <xsl:text>Sipariş Tarihi</xsl:text>
                              </span>
                            </td>
                            <td style="font-weight:bold">:</td>
                            <td>
                              <xsl:for-each select="n1:Invoice/cac:OrderReference/cbc:IssueDate">
                                <xsl:apply-templates select="."/>
                              </xsl:for-each>
                            </td>
                          </tr>
                        </xsl:if>
                        <!--
                        <tr>
                          <td style="font-weight:bold">Ödeme Tarihi</td>
                          <td style="font-weight:bold">:</td> 
                            <td style="border-style: solid;border-width: 1px;padding: 3px;border-color:black;border-top-style:none;border-right-style:none;border-bottom-style:none;">Invoice due date
                              <xsl:for-each select="n1:Invoice/cac:PaymentMeans">
                                <xsl:if test="./cbc:PaymentDueDate != ''">
                                  <div data-role="invoice-due-date">
                                    <xsl:value-of select="substring(string(./cbc:PaymentDueDate),9,2)"/>.<xsl:value-of select="substring(string(./cbc:PaymentDueDate),6,2)"/>.<xsl:value-of select="substring(string(./cbc:PaymentDueDate),1,4)"/>
                                  </div>
                                </xsl:if>
                              </xsl:for-each>
                            </td>
                        </tr>
                        -->
                        <tr>
                        </tr>
                      </table>
                    </div>
                  </td>
                </tr>
              </tbody>
            </table>
            <table class="lineitems" style="border-color: transparent; width: 100%;">
              <thead>
                <tr style="border:2px solid ;height: 18px;font-size:12px; border-color: transparent;">
                  <td class="lineTableTdx" width="3%">No</td>
                  <td class="lineTableTdx" width="28%">Hizmet / Ürün Adı</td>
                  <xsl:if test="n1:Invoice/cbc:ProfileID = 'IHRACAT'">
                    <td class="lineTableTdx" width="10%">GTIP Kodu</td>
                    <td class="lineTableTdx" width="11%">Gönderim Şekli</td>
                    <td class="lineTableTdx" width="9%">Teslim Şartı</td>
                  </xsl:if>
                  <td class="lineTableTdx" width="5%" align="right">Miktar</td>
                  <td class="lineTableTdx" width="8%" align="right">Birim Fiyat</td>
                  <td class="lineTableTdx" width="5%" data-role="col-tax-percentage" align="center">
                    <span>KDV Oranı</span>
                  </td>
                  <td class="lineTableTdx" width="7%" data-role="col-tax-percentage" align="right">KDV Tutarı</td>
                  <td class="lineTableTdx" width="11%" align="right">Toplam</td>
                </tr>
              </thead>
              <tbody id="lineItemsBody">
                <xsl:for-each select="n1:Invoice/cac:InvoiceLine">
                  <xsl:call-template name="lineItemsRow"/>
                </xsl:for-each>
              </tbody>
            </table>
            <hr style="width: 100%;border:none;height:4px;background-color:#4581c2;margin-bottom:10px;"/>
            <!--<img alt="" style="width: 800px;height:5px;    margin-bottom: 13px; " src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA+cAAAAhAgMAAADGyTIbAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAMUExURUWBwkOAwkaBwr3DymeJY7EAAAAJcEhZcwAAEnQAABJ0Ad5mH3gAAAAfSURBVGje7cGBAAAAAMOg+VOf4AZVAAAAAAAAAABPDSBbAAFM+YSvAAAAAElFTkSuQmCC"  />-->
            <table style="width: 100%;">
              <tr>
                <td class="notes">
                  <fieldset style="border:4px solid #4581c2;border-radius: 10px;">
                    <legend align="center" style="background-color:#4581c2; border-width:1px;border-color:transparent;color:white;border-radius: 10px; width: 200px;height: 18px;">
                      <b>AÇIKLAMALAR</b>
                    </legend>
                    <!-- <spam style="font-weight:bold;">Fatura Notu</spam>-->
                    <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' and cac:TaxCategory/cbc:TaxExemptionReason]">
                      <xsl:if test="position() = 1">
                        <div>Vergi İstisna Muafiyet Sebebi: <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/> - <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/></div>
                      </xsl:if>
                    </xsl:for-each>
                    <xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
                      <div>Tevkifat Sebebi: <xsl:value-of select="cbc:TaxTypeCode"/> - <xsl:value-of select="cbc:Name"/></div>
                    </xsl:for-each>
                    <div class="u-mb1">
                      <xsl:for-each select="n1:Invoice/cbc:Note">
                        <div>
                          <xsl:value-of select="."/>
                        </div>
                      </xsl:for-each>
                    </div>
                    <!-- <span>e-Arşiv izni kapsamında elektronik ortamda iletilmiştir</span>-->
                  </fieldset>
                </td>
                <td align="right" style="vertical-align: top;">
                  <table class="totals">
                    <tr style="border: 1px solid #002e61;;">
                      <td style="border: 1px solid #002e61;;width:200px">
                      Mal Hizmet Toplam Tutarı
                    </td>
                      <td style="border: 1px solid #002e61;;width: 98px;">
                        <xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount">
                          <xsl:call-template name="currencyText"/>
                        </xsl:for-each>
                      </td>
                    </tr>
                    <xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                      <tr style="border: 1px solid #002e61;;">
                        <td style="border: 1px solid #002e61;;">Mal Hizmet Toplam Tutarı (TL)</td>
                        <td style="border: 1px solid #002e61;">
                        <xsl:value-of select="format-number(n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/> TL
                      </td>
                      </tr>
                    </xsl:if>
                    <!-- <tr style="border: 1px solid #002e61;">
                    <td style="border: 1px solid #002e61;">
                      Toplam İndirim
                    </td>
                    <td>
                      <xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount">
                        <xsl:call-template name="currencyText"/>
                      </xsl:for-each>
                    </td>
                  </tr>-->
                    <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
                      <tr style="border: 1px solid #002e61;">
                        <td style="border: 1px solid #002e61;">
                        Hesaplanan <xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                        <xsl:if test="cbc:Percent != ''"> (%<xsl:value-of select="cbc:Percent"/>)</xsl:if>
                      </td>
                        <td style="border: 1px solid #002e61;">
                          <xsl:for-each select="cbc:TaxAmount">
                            <xsl:call-template name="currencyText"/>
                          </xsl:for-each>
                        </td>
                      </tr>
                    </xsl:for-each>
                    <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
                      <xsl:if test="//n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                        <tr style="border: 1px solid #002e61;">
                          <td style="border: 1px solid #002e61;">
                          Hesaplanan <xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
                          <xsl:if test="cbc:Percent != ''"> (<xsl:value-of select="cbc:Percent"/>) (TL)</xsl:if>
                        </td>
                          <td style="border: 1px solid #002e61;">
                          <xsl:value-of select="format-number(cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/> TL
                        </td>
                        </tr>
                      </xsl:if>
                    </xsl:for-each>
                    <xsl:for-each select="n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
                      <tr style="border: 1px solid #002e61;">
                        <td style="border: 1px solid #002e61;">Hesaplanan KDV Tevkifat <xsl:if test="cbc:Percent != ''">(%<xsl:value-of select="cbc:Percent"/>)</xsl:if></td>
                        <td style="border: 1px solid #002e61;">
                          <xsl:for-each select="cbc:TaxAmount">
                            <xsl:call-template name="currencyText"/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                        <tr style="border: 1px solid #002e61;">
                          <td style="border: 1px solid #002e61;">Hesaplanan KDV Tevkifat <xsl:if test="cbc:Percent != ''">(%<xsl:value-of select="cbc:Percent"/>) TL</xsl:if></td>
                          <td>
                          <xsl:value-of select="format-number(cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/> TL
                        </td>
                        </tr>
                      </xsl:if>
                    </xsl:for-each>
                    <xsl:if test="n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                      <tr style="border: 1px solid #002e61;">
                        <td style="border: 1px solid #002e61;">Tevkifata Tabi İşlem Tutarı</td>
                        <td style="border: 1px solid #002e61;">
                          <xsl:if test="n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                            <xsl:value-of select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                          </xsl:if>
                          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
                            <xsl:text>TL</xsl:text>
                          </xsl:if>
                          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                            <xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
                          </xsl:if>
                        </td>
                      </tr>
                      <tr style="border: 1px solid #002e61;">
                        <td style="border: 1px solid #002e61;">Tevkifata Tabi İşlem Üzerinden Hes. KDV</td>
                        <td style="border: 1px solid #002e61;">
                          <xsl:if test="n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                            <xsl:value-of select="format-number(sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
                          </xsl:if>
                          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
                            <xsl:text>TL</xsl:text>
                          </xsl:if>
                          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                            <xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
                          </xsl:if>
                        </td>
                      </tr>
                    </xsl:if>
                    <tr style="border: 1px solid #002e61;">
                      <td style="border: 1px solid #002e61;">Vergiler Dahil Toplam Tutar</td>
                      <td style="border: 1px solid #002e61;">
                        <xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount">
                          <xsl:call-template name="currencyText"/>
                        </xsl:for-each>
                      </td>
                    </tr>
                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                      <tr style="border: 1px solid #002e61;">
                        <td style="border: 1px solid #002e61;">Vergiler Dahil Toplam Tutar(TL)</td>
                        <td style="border: 1px solid #002e61;">
                        <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/> TL
                      </td>
                      </tr>
                    </xsl:if>
                    <tr style="border: 1px solid #002e61;">
                      <td style="border: 1px solid #002e61;">
                        <b>Ödenecek Tutar</b>
                      </td>
                      <td style="border: 1px solid #002e61;">
                        <b>
                          <xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
                            <xsl:call-template name="currencyText"/>
                          </xsl:for-each>
                        </b>
                      </td>
                    </tr>
                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                      <tr>
                        <td>
                          <b>Ödenecek Tutar (TL)</b>
                        </td>
                        <td>
                          <b>
                          <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/> TL
                        </b>
                        </td>
                      </tr>
                    </xsl:if>
                  </table>
                </td>
              </tr>
            </table>
          </div>
          <br/>
          <div align="left" style="width: 100%; margin-bottom: 6px;">
            <table id="hesapBilgileri" width="100%" style="width: 100%;">
              <tbody style="color: black">
                <tr>
                  <td>
                    <fieldset style="border:4px solid #4581c2;border-radius: 10px;">
                      <legend align="center" style="background-color:#4581c2; border-width:1px;border-color:transparent;color:white;border-radius: 10px;width: 200px;height: 18px;">
                        <b>BANKA HESAP BİLGİLERİ</b>
                      </legend>
                      <table width="100%">
                        <tr style="color:#4581c2;">
                          <td align="left" style="font-weight:bold;">BANKA </td>
                          <td align="center" style="font-weight:bold;">HESAP TÜRÜ</td>
                          <td align="center" style="font-weight:bold;">IBAN NUMARASI</td>
                          <td align="center" style="font-weight:bold;">SWIFT KODU</td>
                        </tr>
                        <tr>
                          <td class="lineTableTd">TÜRK EKONOMİ BANKASI</td>
                          <td class="lineTableTd" align="center">TL</td>
                          <td class="lineTableTd" align="center">TR43 0003 2000 0000 0107 8391 88</td>
                          <td class="lineTableTd" align="center"/>
                        </tr>
                        <tr>
                          <td class="lineTableTd">TÜRK EKONOMİ BANKASI</td>
                          <td class="lineTableTd" align="center">USD</td>
                          <td class="lineTableTd" align="center">TR50 0003 2000 0000 0107 8392 56</td>
                          <td class="lineTableTd" align="center">TEBUTRIS</td>
                        </tr>
                        <tr>
                          <td class="lineTableTd">TÜRK EKONOMİ BANKASI</td>
                          <td class="lineTableTd" align="center">USD</td>
                          <td class="lineTableTd" align="center">TR66 0003 2000 0000 0107 8392 59</td>
                          <td class="lineTableTd" align="center">TEBUTRIS</td>
                        </tr>
                      </table>
                    </fieldset>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <table style="width: 100%;" border="0">
            <tr style="font-weight: bold;">
              <td align="right" style="vertical-align: middle; padding-left: 53px;">
                <img alt="" style="width:30px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IB2cksfwAAAAlwSFlzAAALEwAACxMBAJqcGAAABXJJREFUeJztmY9vFFUQx/lXjCbGxIiKv0USJAhECRA0jVEaGhBaG5taKQppNVARrKIFsUSqEEEbLIJWLaRIa0v4WUKLaSqEhhqUQxTRxqJN05pnP6Ozvlve3u3dLeU0N8nkbndu79533sx3Zt6Nu278k+dH1fzXdVwOSJZpDki2aQ5ItmkOSCK9feJiM/fxF01+wSpPZ8x+wdx0Z0H2A1lUvNbs/fKYicUumkRy6uRZs72h1cx8dHl2AVld/aE59/2/ix8aGvbeDwz8Ia+23ZYTXb1m/uJXry0QPNp7+py3+K3bmiWc2r7qkntNew6bnY375f2cxyrMsY6T8p7dKCiqNu3tJzxAbe1dZsIDhWMPZOUrW83g4JC3sLsmP+3dRzo7T0s+1H/cKtfkx813LzDf9v0g18WlNfL5WXmVpru7T+79eOEXM2fUEWMGZMPGT7ywWVD4mnd/6sxyAcf9+6eWyD0bCNfTZz/vfebeKc/IvRtuy5fwRLA9Vfz61Qeyas0H8oOXLv1mpjy8JM7WcfSbOG+7gGhOIc3NHXHPA2B4eEQ0nZ0JDWTewtVmZORPWYS9EyiMhRw62G2uv3VeQiDsgIbTXN+C393c5IWZhmukQIj387GfveQkBPhR4h67LsxecBAQNC+/Su6zi1wTii0tx+MYDbKIHIh6qvadRgmd/l8H5JrXPc1HnaGSCAiqLHbkSI+309AxYaWOAXBkQNgNkhO95Z6Fco+dWPHy+x4ghEII3ZaWv22mPVJubpwwPw4I1R4afqlqixTO/v7L3rN9Z2KmqKRGwo7vh80UWGRAqt/8SL60as02J0jCjDpCkqYiOIZneQ7Q/u9W8oDpIgFCTUCULm3Fw8jmLbsFFGFRXrnJbKr73OxuOmy+O3vh7/A51CPX6zfslB17aNZS8b6GpatdKSl7S2xraxoyB8Li8HbQFq+v3SU/VmhRbtgcQZdV1on9uWUbr7CxS+wY+ZIxkLwnViT0CsyC+GtKWCDkku6oy44DEWXHtIGQ0Ik8rnGsJJAqEMILoT9z2Ru/OCh2uoaMgOhCAGTPFqpnemNid9nQ1rZOsVdU1AV+5vfLg9IdJ3o+DA2HAnKthW45EiCw0PKV712hykouG9px/JTYIYWgz1CLaEkSPU97lBEQkhwJyhGl5qARNlmOoMiB/V87bZ9+diDp86GA0BwidKwuu9aByTOeTQvIpGmlYmcoc9lpX5AgMgkNBNpL5DF6LyRohkgGpGxprdhdXQOMBhEwjCUDkRQI2vNPA+caRbXOkEOuZ5U+YSCXfceuNrH723mUvEBwViRAdCKkCru8Rs/EoIV3WTiV2G4Ibbn4U7/UnvqGFgHHaMDzrl6LOT4IZFpA2AlaBZjF/4N0rCzOL9QXu9ciNCl6rs9SQ/yNIQWQ1p6u2B7UMgIisT7qQYTDBa6ZSfQgQYUTFZo/m8FcOULiUuAUpAqnKgpIkxxHhQERGsj4+xYJ39NyK+Ui0COL1wrvbyWCkp0Fq8cpdtpT8f2MywiDV9jdCA1Ed0GFH6MVVxvdK+KfEoOAaPzbHof59JSSjhtqDgsiJSCojryEkZ/FdDy1Tw5dQFg8wi7YHmcqVJJI5/QxJSCwlLbuxLidpCyE0IDBFKQfCOOuJry9owxb1AyEUThVECkDUTDMDwhsxtSnbEY9Qeha+ZwfiOaXdgoA0+6AcCoOaIWuChBVzrL08AFqfmPdDlmYMg5gbSBa/Dj2eXB6manfvs/bBU7ow87mkQNBCSEWrAcPvNq0qjGvB9uI/bcDYUihdRXEMQWiesekIoltTfhkQrEkjKL84yfyf6wILwoelGzPFowC/oIZpeb+Q8w2zQHJNs0ByTb93wD5C2clbxqcnmsuAAAAAElFTkSuQmCC"/>
              </td>
              <td style="width: 230px;padding-left: 10px;">fqcstandard.com.tr</td>
              <td align="right" style="width:30px;">
                <img alt="" style="width:30px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IB2cksfwAAAAlwSFlzAAALEwAACxMBAJqcGAAABGhJREFUeJztmPtPzXEYx/0rbMbM3HPbNOY2l2H4xWiUXKLFRMQMw3LLfZFsbmEhJE0hEWItxTBUY6QijUYWlR7n9ZnvWfH9nu+l881pO8/2dM75nG/n83l/Ps/zft7Pp0vXvnNOeDyzk/vSLp4/VR6XTu7JQSAB5kEggeZBIIHmQSDKew+ZL1NmrpMFUbtk45bjkrg3Tc5cuKU869pDyble2MbTM/LVd6fP58rWHakSvz5FwiO3yZiJsdJ9wNyOA9Jj0DyZGbZJUo5lydNnr6WxsUn8ZV+/fpd795+qDQkdv1y69QtzB8jwsTGSlJwhdXX1flu8kb16+U5i4w9J76GR/gUCiAcPn7sOoLU1NPyUw0evWA05cyDsSkHBsw4FoVlz8y9J2HXGP0COHM38LyA042Smz97QPiDDRkdLfX2Dz4n4vrqqVt6+/SDl5e/lzetqqaqsVWN6Xln5ST2H8/7jx8+mpAEJtAvI3oPpPicoeVwmi2J2y4RpaxTTDAqNkiGjlsr4aavVmJ6PnbxSPYfzHvomfGo/1RnOA1B+1zGQ/PwnPoEk7jvXHu5vQ+tFRa98zrUiLsk5kOLiUp8/XlxS5t0pwnDeou2WfeKMeG+tWBidaErrMJhjIGa71NTULAeSLqoFsTBi3qodO5mt/q//iMWWqJ0wdwwEmWFmX758k7DIBLUods2qzY7YquZgI6BZM0PKOAYSvWK/tLS0+JyARIxbm2yJHFqbRqnpF++YPltTUyc9Q8KdA2GX8/JKDCeA40+m5kivwREqRMzIobUhGvl9GI5cNNowxrWNcgwEJ5nh+r8BkOioXiQErAOFWgkRzfhNBChgBoYulp170qSiouYfQIS3BQFpTWtFxeyR0rIKpXg5ARbAKfAd9QA1DDi7Vl39WZatOugNm5CRS9RcLJ75IBtAWqBw6+qXyTQBp+0iCpUKbZZHvuznj0bJzilsszld/9QWGz2K/cYKmoU6oVo7oWRmnCgnTohxynbW5AhI6tkbuguBhgmJS5fveusJr3y+mvVAaTJOjsXCVIWFL1Qd0jMKputAaFX1LO92iepbiHMaMAxm4jPjLJwwIgcYo478TSKaod9cBUKeGBVJwgy+J4G1nWbhKF7GtTzS1DKtrZFZoNv2ASEZuUTQM0IGzRTuCQvtGcKQMGGHkffkweaEU2qMVyN9Rd/uKhCYihDRM2oAcgNFDCiMzpKbFcaR6ZxU2vlbagyQRr2OA1VtDwixbaSIvaHlCRsttJAvqsnyhJvGcIQUY5CDkZFjrgKheSJE9AyAyI1Rk2K9+gntxedxU+NUE0ZokeyMEYZGzRT3Xq4CYQHspp4R7zDXzdxH6gQwQJMvjGv0i7RhDGBG9MtFns0LO3tAKIZmPbw/jErfusr7HciUWetdB4FxqjYu5+wDoYh1hCEWbcoU+yfiROXaNXKqz7AF7gHhuGlnqRkkvRvOvS8F1LVL7AD3IJBA8yCQQPMgkEDzIJBAcwUk2+NFndzX/QakE84yo03K8gAAAABJRU5ErkJggg=="/>
              </td>
              <td style="width: 230px;padding-left: 10px;">0216 255 55 99</td>
              <td style="width:30px;">
                <img alt="" style="width:30px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAzCAYAAADVY1sUAAAAAXNSR0IB2cksfwAAAAlwSFlzAAALEwAACxMBAJqcGAAAApFJREFUeJztmN9Lk1EYx/1XCiIoQqmwRKJiEEjdFEUgWpmRlSVZN0sJ++WFmYaBNAopm/QDyUKINtxFEgSxyqwLW5SQNxpChJYxFnvqc+AMoR+be9+9O47zhe82tvOe83zOOe/znHdFS4qrYgXgcNHvFykAxyyIYbYgptmCmGYLYpotiGnODKTMd0xqDl3Mi0s21LkHUlx+UAYePJWZme+eOnBtUFaur3UHxLf1pHpnZm7fjYhX6g48TEGs2XjYOUgk8kL8p6+rzytK96tZSiR+5gyAvlvb+mT52n2ybPUe6ejql8ZTV52DjLyMybfZOWm/fE+WllSrzts67siPubjrEIzDpDEGk9YbDEk8npCmcz3ugCA6vNH7ODVTDMg+dktTU1+krqFTTRZbavDRs9TKuwqCksmk9N8fllVlB9SADDw9/dUxxPj4pOzee16NV7q5Xp4Mv1ZjabkOohUKPVcD8vuu6rMyMfE5a4g3bz9KxXa/6mtTRaO8Gnn/R5ucgSCSgM4m23Y2qa2xULESBE8f5VsaZGzs01/b5RQEjY5+UMVSzyaBZSqu1avKivxvVXMOgghA15p1vqMSjb5LC8FqUmS5pqqmNe195gkIIpAdlS2qPYVzaCj6z7bBvnCq0NUf71IpN508A0Gk4toj7SqbUQPIbvMzD58pbqRv2jS39GRcizwFQQRGfdGFk2MGtYAadObCTfUdvtI9sKDTgecgiKA5BRAwQACwhfRKcV6bv1LGgiAC5XjBNtL9cHNTf7JR3kC0CJxTAGk2k2xmLAiitmRTLI0DcUMWxIJYEAtiQRYvCM/P+daJ5oBzEJ4zbgXDeTP/3OgnSUcgi8QWxDRbENNsQUyzBTHNhQVyqQDs/wVyHa0g4SIkKgAAAABJRU5ErkJggg=="/>
              </td>
              <td style="width: 230px;padding-left: 10px;">info@fqcstandard.com.tr</td>
            </tr>
          </table>
          <img alt="" style="width: 100%; margin-top:5px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA+cAAAAhCAIAAAA0xU3fAAAAAXNSR0IB2cksfwAAAAlwSFlzAAASdAAAEnQB3mYfeAAAAMNJREFUeJzt1kEBACAMACFXxAhrZP8a1rgHpGDuvgMAAISNtQMAQJy1AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBAnbUDAECdtQMAQJ21AwBA3QcWpBXruOIR+AAAAABJRU5ErkJggg=="/>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="Curr_Type">
    <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
    <xsl:if test="@currencyID">
      <xsl:text/>
      <xsl:choose>
        <xsl:when test="@currencyID = 'TRL' or @currencyID = 'TRY'">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@currencyID"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>