<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988" xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt" version="1.0" exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi">
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN=""/>
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="linePerPage" select="15"/>
	<xsl:variable name="legalMonetary" select="n1:Invoice=/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount"/>
	<xsl:variable name="linediscount" select="sum(n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:Amount)"/>
	<xsl:variable name="footerNote" select="//n1:Invoice/cbc:Note[not(contains(.,'[SEVK]') or contains(.,'[Fiyat Farkı]'))]"/>
	<xsl:variable name="control">
		<xsl:choose>
			<xsl:when test="n1:Invoice/cbc:ProfileID='IHRACAT'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
          body {background-color: #FFFFFF;font-family: Calibri !important;font-size: 14pt;color: #666666;margin:0px}
          #container{width:1280px;height:1040px;border-spacing: 0px;}
          .containerTr{float:left;border-spacing: 0px;}
          .invoiceLineMainTr{margin-top: 3px;float:left;border-spacing: 0px;}
          #invoiceTop{width:1280px;}
          .capital{text-transform:capitalize;}
          .lower{text-transform:lowercase;}
          .invoiceCompany{width:1280px;}
          .companyLogo{}
          .companyInfo{width:520px;}
          #companyInfoUl{list-style-type:none;padding: 0px;}
          #companyInfoUl li{float:left;padding-top: 5px;padding-left: 25px;}
          .companyAdres{width:100% !important;text-transform:capitalize;}
          .companyNameLineTbl{height:40px;width:1280px;background:#BB0000;border: none;border-spacing: 0px;}
          .companyNameColor{width:10px;background:#5C6582;height: 40px;}
          .companyNameP{color: #FFF;font-weight: bold;font-size: 20pt;padding-left: 10px;}
          .invoiceInfo{width:1280px;}
          .invoiceCustomer{float:left;width:35%;}
          .invoiceLogo{float:left;width:35%;}
          .invoiceLogo img{}
          .invoiceDetails{float:left;}
          .customerTitle{    font-weight:bold;color:#5C6582;	font-size: 17pt;text-transform:capitalize;}
          #companyInfoTbl{width:100%;}
          .lbl{font-weight:bold;color:#5C6582;text-transform:none !important;}
          #eInvoiceTitle{color: #5C6582 !important;text-transform: none !important;margin: 0px;font-size: 15pt;}
          #invoiceDetailTbl {padding-left: 10px;border-left: 15px solid #BB0000;}
          .invoiceID{padding-left: 55px;color:#BB0000;font-weight:bold;font-size: 18pt;}
          .invoiceDetailColor{color:#5C6582;font-weight:bold;}
          #ettn{border-top: 1px dashed #5C6582;border-bottom: 1px dashed #5C6582;height: 30px;width: 1280px;}
          #ettn p{margin:0px;padding-top: 9px;padding-left: 6px;}
          #invoiceLines{margin-top:10px;}
          #lineTable{font-size: 16pt;border: 1px solid #DCDCDB;text-align: left;border-collapse:collapse; color:#414141;}
          #lineTable th{background-color: #BB0000;color:white;height: 30px;text-align:center;padding: 3px;border: none;font-weight: bold;}
          #lineTable td{padding: 1px;border: 1px solid #DCDCDB;font-size: 13pt;}
          #lineTable tr{padding: 0px;border: none;background-color: #fff;height: 25px;}
          .coloredTr{	background-color: #f6f6f6 !important;}
          #invoiceTotal{width: 1280px;}
          #budgetContainerTable{margin-top:5px;float:right;font-size: 16pt;border: 1px solid #DCDCDB;text-align: left;border-collapse: collapse;color:#414141;}
          #budgetContainerTable tr{padding: 0px;border: none;background-color: #fff;}
          #budgetContainerTable td{border: 1px solid #DCDCDB;font-size: 14pt;width:100px;text-align:right;height: 17px;}
          #budgetContainerTable th{background-color: #BB0000;color:white;text-align:left;border-bottom: 1px solid #FFCB45;font-weight: bold;height: 19px;padding-left: 4px;padding-right: 4px;}
          .notesMainTr{border-spacing: 0px;height: 80px;position: static;bottom: 20px;}
          #notes{width:1280px;}
          #notesTable{border-left: 15px solid #BB0000;width: 100%;padding-left: 8px;}
          .noteLbl{width: 16%;font-weight: bold;color: #5C6582;}
          .pageInfo{height: 20px;position: static;bottom: 0px;}
        </style>
				<title>
          <xsl:choose>
            <xsl:when test = "//n1:Invoice/cbc:ProfileID = 'EARSIVFATURA'">e-Arşiv Fatura</xsl:when>
            <xsl:otherwise>e-Fatura</xsl:otherwise>
          </xsl:choose>
        </title>
				<link rel="Stylesheet" type="text/css" href="ubl.css">  </link>
			</head>
			<body>
				<xsl:variable name="totalInvoiceLine" select="count(n1:Invoice/cac:InvoiceLine)"/>
				<xsl:variable name="invoicePageCount" select="ceiling($totalInvoiceLine div $linePerPage)"/>
				<xsl:call-template name="Paging">
					<xsl:with-param name="count" select="$invoicePageCount"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="dateFormatter">
		<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
	</xsl:template>
	<xsl:template name="Paging">
		<xsl:param name="index" select="1"/>
		<xsl:param name="count" select="1"/>
		<xsl:if test="$index &lt;= $count">
			<xsl:for-each select="$XML">
				<table id="container">
					<tr class="containerTr">
						<td>
							<table id="invoiceTop">
								<tr class="invoiceCompany">
									<td align="center" class="companyLogo">
										<img alt="ariston logo" src="data:image/jpeg;base64,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"/>
									</td>
									<td class="companyInfo">
										<ul id="companyInfoUl">
											<li class="companyAdres">
												<span class="lbl">Merkez: </span>
												<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:StreetName">
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:StreetName"/>
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingName">
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingName"/>
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber">
													<xsl:text>No:</xsl:text>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber"/>
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:PostalZone">
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:PostalZone"/>
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName"/>
												<xsl:text>/</xsl:text>
												<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CityName"/>
											</li>
											<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone">
												<li>
													<span class="lbl">Tel: </span>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone"/>
												</li>
											</xsl:if>
											<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax">
												<li>
													<span class="lbl">Fax: </span>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax"/>
												</li>
											</xsl:if>
											<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI">
												<li class="lower">
													<span class="lbl">Web: </span>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI"/>
												</li>
											</xsl:if>
											<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail">
												<li class="lower">
													<span class="lbl">E-mail: </span>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail"/>
												</li>
											</xsl:if>
											<xsl:if test="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
												<li class="capital">
													<span class="lbl">Vergi Dairesi: </span>
													<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
												</li>
											</xsl:if>
											<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification">
												<xsl:choose>
													<xsl:when test="cbc:ID/@schemeID='TICARETSICILNO'">
														<li>
															<span class="lbl">Ticaret Sicil No: </span>
															<xsl:value-of select="cbc:ID"/>
														</li>
													</xsl:when>
													<xsl:when test="cbc:ID/@schemeID!='DISTRIBUTORNO'">
														<li>
															<span class="lbl">
																<xsl:value-of select="cbc:ID/@schemeID"/>:
                              </span>
															<xsl:value-of select="cbc:ID"/>
														</li>
													</xsl:when>
												</xsl:choose>
											</xsl:for-each>
										</ul>
									</td>
									<td align="center" class="companyLogo">
										<img alt="ik koçoğlu logo" src="data:image/jpeg;base64,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"/>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr class="containerTr">
						<td colspan="3">
							<table class="companyNameLineTbl">
								<tr>
									<td class="companyNameColor"/>
									<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name">
										<td class="companyNameP">
										  <span><font color="black">İK</font></span>
										  <span><font color="white">KOÇOĞLU</font></span>
										  <!--
											<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name"/>
                      -->
										</td>
									</xsl:if>
									<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person">
										<td class="companyNameP">
											<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/Title">
												<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:Title"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:FirstName"/>
											<xsl:text> </xsl:text>
											<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/MiddleName">
												<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:MiddleName"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:FamilyName"/>
											<xsl:text> </xsl:text>
											<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/NameSuffix">
												<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:NameSuffix"/>
											</xsl:if>
										</td>
									</xsl:if>
									<td class="companyNameColor"/>
								</tr>
							</table>
						</td>
					</tr>
					<tr class="containerTr">
						<td>
							<table class="invoiceInfo">
								<tr>
									<td class="invoiceCustomer">
										<table>
											<tr>
												<xsl:choose>
													<xsl:when test="$control=1">
														<td class="customerTitle">
															<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyName/cbc:Name"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="customerTitle">
															<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</tr>
											<tr>
												<td>
													<table id="customerInfoTbl">
														<xsl:choose>
															<xsl:when test="$control=1">
																<tr>
																	<td class="capital">
																		<span class="lbl">Adres: </span>
																		<xsl:if test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:StreetName">
																			<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:StreetName"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingName">
																			<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingName"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber">
																			<xsl:text> No:</xsl:text>
																			<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:PostalZone">
																			<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:PostalZone"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cbc:CityName"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PostalAddress/cac:Country/cbc:Name"/>
																	</td>
																</tr>
																<tr>
																	<td class="capital">
																		<span class="lbl">Müşteri Vergi No: </span>
																		<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID"/>
																	</td>
																</tr>
																<tr>
																	<td class="capital">
																		<span class="lbl">Teslimat Adresi: </span>
																		<xsl:value-of select="concat(n1:Invoice/cac:InvoiceLine/cac:Delivery/cac:DeliveryAddress/cbc:StreetName,' ',n1:Invoice/cac:InvoiceLine/cac:Delivery/cac:DeliveryAddress/cbc:CitySubdivisionName,' ',n1:Invoice/cac:InvoiceLine/cac:Delivery/cac:DeliveryAddress/cbc:CityName,' ',n1:Invoice/cac:InvoiceLine/cac:Delivery/cac:DeliveryAddress/cac:Country/cbc:Name)"/>
																	</td>
																</tr>
															</xsl:when>
															<xsl:otherwise>
																<tr>
																	<td class="capital">
																		<span class="lbl">Adres: </span>
																		<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:StreetName">
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:StreetName"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingName">
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingName"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber">
																			<xsl:text> No:</xsl:text>
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:PostalZone">
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:PostalZone"/>
																			<xsl:text> </xsl:text>
																		</xsl:if>
																		<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:CityName"/>
																	</td>
																</tr>
																<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telephone">
																	<tr>
																		<td>
																			<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telephone">
																				<span class="lbl">Tel: </span>
																				<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telephone"/>
																			</xsl:if>
																			<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telefax">
																				<xsl:text> </xsl:text>
																				<span class="lbl">Fax: </span>
																				<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:Telefax"/>
																			</xsl:if>
																		</td>
																	</tr>
																</xsl:if>
																<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail">
																	<tr>
																		<td class="lower">
																			<span class="lbl">E-mail: </span>
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail"/>
																		</td>
																	</tr>
																</xsl:if>
																<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cbc:WebsiteURI">
																	<tr>
																		<td class="lower">
																			<span class="lbl">Web: </span>
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cbc:WebsiteURI"/>
																		</td>
																	</tr>
																</xsl:if>
																<xsl:if test="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
																	<tr>
																		<td class="capital">
																			<span class="lbl">Vergi Dairesi: </span>
																			<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
																		</td>
																	</tr>
																</xsl:if>
																<xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification">
																	<tr>
																		<td>
																			<span class="lbl">
																				<xsl:value-of select="cbc:ID/@schemeID"/>:
                                      </span>
																			<xsl:value-of select="cbc:ID"/>
																		</td>
																	</tr>
																</xsl:for-each>
																<!--<xsl:if test="count(n1:Invoice/cbc:Note[contains(.,'[DA]')]) > 0"> <tr> <td class="capital"> <span class="lbl">Teslimat Adresi: </span> <xsl:value-of select="substring-after(n1:Invoice/cbc:
								[contains(.,'[DA]')],'[DA]')" /> </td> </tr> </xsl:if>-->
																<xsl:if test="count(n1:Invoice/cbc:Note[contains(.,'ShipTo address')]) &gt; 0">
																	<tr>
																		<td class="capital">
																			<span class="lbl">Teslimat Adresi: </span>
																			<xsl:value-of select="substring-after(n1:Invoice/cbc:Note[contains(.,'ShipTo address')],'ShipTo address')"/>
																		</td>
																	</tr>
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td class="invoiceLogo" align="center">
										<img align="middle" alt="E-Fatura Logo" src="data:image/jpeg;base64,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"/>
										<h2 id="eInvoiceTitle" align="center">
                      <xsl:choose>
                        <xsl:when test = "//n1:Invoice/cbc:ProfileID = 'EARSIVFATURA'">e-Arşiv Fatura</xsl:when>
                        <xsl:otherwise>e-Fatura</xsl:otherwise>
                      </xsl:choose>
										</h2>
										<img align="middle" alt="imza" src="data:image/jpeg;base64,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"/>
									</td>
									<td class="invoiceDetails">
										<table>
										  <tr>
                        <td style="float: right;">
                        <img id = "simge_kare_kod_2" src = "data:image/png;base64,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"/>
                        </td>
                      </tr>
											<tr>
												<td class="invoiceID">
													<span class="invoiceDetailColor">Fatura No: </span>
													<xsl:value-of select="n1:Invoice/cbc:ID"/>
												</td>
											</tr>
											<tr>
												<td>
													<table id="invoiceDetailTbl">
														<tr>
															<td class="invoiceDetailColor">Özelleştirme No</td>
															<td class="doubleDot">:</td>
															<td>
																<xsl:value-of select="n1:Invoice/cbc:CustomizationID"/>
															</td>
														</tr>
														<tr>
															<td class="invoiceDetailColor">Senaryo</td>
															<td class="doubleDot">:</td>
															<td class="capital">
																<xsl:value-of select="n1:Invoice/cbc:ProfileID"/>
															</td>
														</tr>
														<tr>
															<td class="invoiceDetailColor">Fatura Tipi</td>
															<td class="doubleDot">:</td>
															<td class="capital">
																<xsl:value-of select="n1:Invoice/cbc:InvoiceTypeCode"/>
															</td>
														</tr>
														<tr>
															<td class="invoiceDetailColor">Fatura Tarihi</td>
															<td class="doubleDot">:</td>
															<td>
																<xsl:for-each select="n1:Invoice/cbc:IssueDate">
																	<xsl:value-of select="substring(.,9,2)"/>.<xsl:value-of select="substring(.,6,2)"/>.<xsl:value-of select="substring(.,1,4)"/>
																</xsl:for-each>
															</td>
														</tr>
														<xsl:for-each select="n1:Invoice/cac:DespatchDocumentReference">
															<tr>
																<td class="invoiceDetailColor">İrsaliye No</td>
																<td class="doubleDot">:</td>
																<td>
																	<xsl:value-of select="cbc:ID"/>
																</td>
															</tr>
															<tr>
																<td class="invoiceDetailColor">İrsaliye Tarihi</td>
																<td class="doubleDot">:</td>
																<td align="left">
																	<xsl:for-each select="cbc:IssueDate">
																		<xsl:value-of select="substring(.,9,2)"/>.<xsl:value-of select="substring(.,6,2)"/>.<xsl:value-of select="substring(.,1,4)"/>
																	</xsl:for-each>
																</td>
															</tr>
														</xsl:for-each>
														<xsl:for-each select="n1:Invoice/cac:OrderReference">
															<tr>
																<td class="invoiceDetailColor">Sipariş No</td>
																<td class="doubleDot">:</td>
																<td>
																	<xsl:value-of select="cbc:ID"/>
																</td>
															</tr>
															<tr>
																<td class="invoiceDetailColor">Sipariş Tarihi</td>
																<td class="doubleDot">:</td>
																<td align="left">
																	<xsl:for-each select="cbc:IssueDate">
																		<xsl:value-of select="substring(.,9,2)"/>.<xsl:value-of select="substring(.,6,2)"/>.<xsl:value-of select="substring(.,1,4)"/>
																	</xsl:for-each>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr class="containerTr">
						<td>
							<div id="ettn">
								<p>
									<span class="lbl">ETTN: </span>
									<xsl:value-of select="n1:Invoice/cbc:UUID"/>
								</p>
							</div>
						</td>
					</tr>
					<tr class="invoiceLineMainTr">
						<td id="invoiceLines">
							<table id="lineTable" width="1280">
								<tr>
									<th style="width:15px;">S. No</th>
									<th style="width:50px;">Ürün Kodu</th>
									<th style="width:140px;">Mal Hizmet</th>
									<th style="width:15px;">Mktr</th>
									<th style="width:30px;">Birim</th>
									<th style="width:58px;">Birim Fiyat</th>
									<th style="width:30px;">İsknt %</th>
									<th style="width:58px;">İskonto Tutarı</th>
									<th style="width:30px;">KDV %</th>
									<th style="width:58px;">KDV Tutarı</th>
									<th style="width:80px;">Mal Hizmet Tutarı</th>
								</tr>
								<xsl:for-each select="n1:Invoice/cac:InvoiceLine">
									<xsl:variable name="linePosition" select="position()"/>
									<xsl:variable name="tempPosition" select="($index - 1) * $linePerPage"/>
									<xsl:variable name="tempPosition2" select="$index * $linePerPage"/>
									<xsl:if test="$linePosition &gt; $tempPosition">
										<xsl:if test="$linePosition &lt;= $tempPosition2">
											<tr>
												<td align="center">
													<xsl:value-of select="./cbc:ID"/>
												</td>
												<td align="center">
													<xsl:value-of select="./cac:Item/cac:SellersItemIdentification/cbc:ID"/>
												</td>
												<td>
													<xsl:value-of select="./cac:Item/cbc:Name"/>
												</td>
												<td align="center">
													<xsl:value-of select="format-number(./cbc:InvoicedQuantity, '###.###,00', 'european')"/>
												</td>
												<td align="center">
													<xsl:if test="./cbc:InvoicedQuantity/@unitCode">
														<xsl:for-each select="./cbc:InvoicedQuantity">
															<xsl:text/>
															<xsl:choose>
																<xsl:when test="@unitCode  = '26'">
																	<xsl:text>Ton</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'BX'">
																	<xsl:text>Kutu</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'NIU' or @unitCode  = 'C62'">
																	<xsl:text>Adet</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'EA'">
																	<xsl:text>Adet</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'KGM'">
																	<xsl:text>KG</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'KJO'">
																	<xsl:text>kJ</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'GRM'">
																	<xsl:text>G</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MGM'">
																	<xsl:text>MG</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'NT'">
																	<xsl:text>Net Ton</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'GT'">
																	<xsl:text>GT</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MTR'">
																	<xsl:text>M</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MMT'">
																	<xsl:text>MM</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'KTM'">
																	<xsl:text>KM</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MLT'">
																	<xsl:text>ML</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MIL'">
																	<xsl:text>MIL</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MMQ'">
																	<xsl:text>MM3</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CLT'">
																	<xsl:text>CL</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CMK'">
																	<xsl:text>CM2</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CMQ'">
																	<xsl:text>CM3</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CMT'">
																	<xsl:text>CM</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MTK'">
																	<xsl:text>M2</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MTQ'">
																	<xsl:text>M3</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'DAY'">
																	<xsl:text>Gün</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'MON'">
																	<xsl:text>Ay</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'PA'">
																	<xsl:text>Paket</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'KWH'">
																	<xsl:text>KWH</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CT'">
																	<xsl:text>Karton</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'TNE'">
																	<xsl:text>Ton</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'CS'">
																	<xsl:text>CS</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'PK'">
																	<xsl:text>Paket</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = '15'">
																	<xsl:text>Paket</xsl:text>
																</xsl:when>
																<xsl:when test="@unitCode  = 'PK'">
																	<xsl:text>Stick</xsl:text>
																</xsl:when>
															</xsl:choose>
														</xsl:for-each>
													</xsl:if>
												</td>
												<td align="right">
													<xsl:value-of select="format-number(./cac:Price/cbc:PriceAmount, '###.##0,00', 'european')"/>
													<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID">
														<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID = &quot;TRY&quot; ">
															<xsl:text> TL</xsl:text>
														</xsl:if>
														<xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID != &quot;TRY&quot;">
															<xsl:value-of select="./cac:Price/cbc:PriceAmount/@currencyID"/>
														</xsl:if>
													</xsl:if>
												</td>
												<td align="center">
													<xsl:if test="./cac:AllowanceCharge/cbc:MultiplierFactorNumeric">
														<xsl:value-of select="format-number(./cac:AllowanceCharge/cbc:MultiplierFactorNumeric * 100, '###.##0,00', 'european')"/>
													</xsl:if>
												</td>
												<td align="right">
													<xsl:if test="./cac:AllowanceCharge">
														<xsl:value-of select="format-number(./cac:AllowanceCharge/cbc:Amount, '###.##0,00', 'european')"/>
													</xsl:if>
													<xsl:if test="./cac:AllowanceCharge/cbc:Amount/@currencyID">
														<xsl:if test="./cac:AllowanceCharge/cbc:Amount/@currencyID = 'TRY'">
															<xsl:text> TL</xsl:text>
														</xsl:if>
														<xsl:if test="./cac:AllowanceCharge/cbc:Amount/@currencyID != 'TRY'">
															<xsl:value-of select="./cac:AllowanceCharge/cbc:Amount/@currencyID"/>
														</xsl:if>
													</xsl:if>
												</td>
												<td align="center">
													<xsl:for-each select="./cac:TaxTotal">
														<xsl:for-each select="cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
															<xsl:if test="cbc:TaxTypeCode='0015' ">
																<xsl:if test="../../cbc:Percent">
																	<xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
																</xsl:if>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
												</td>
												<td align="right">
													<xsl:for-each select="./cac:TaxTotal">
														<xsl:for-each select="cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
															<xsl:if test="cbc:TaxTypeCode='0015' ">
																<xsl:value-of select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
																<xsl:if test="../../cbc:TaxAmount/@currencyID">
																	<xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRY'">
																		<xsl:text> TL</xsl:text>
																	</xsl:if>
																	<xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRY'">
																		<xsl:value-of select="../../cbc:TaxAmount/@currencyID"/>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
												</td>
												<td align="right">
													<xsl:value-of select="format-number(./cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
													<xsl:if test="./cbc:LineExtensionAmount/@currencyID">
														<xsl:if test="./cbc:LineExtensionAmount/@currencyID = 'TRY' ">
															<xsl:text> TL</xsl:text>
														</xsl:if>
														<xsl:if test="./cbc:LineExtensionAmount/@currencyID != 'TRY' ">
															<xsl:value-of select="./cbc:LineExtensionAmount/@currencyID"/>
														</xsl:if>
													</xsl:if>
												</td>
											</tr>
											<xsl:if test="./cbc:Note!='' and substring(./cbc:Note, 1, 1) != '#'">
												<xsl:value-of disable-output-escaping="yes" select="./cbc:Note"/>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</table>
						</td>
					</tr>
					<xsl:if test="$index = $count">
						<tr class="containerTr">
							<td id="invoiceTotal">
								<table align="right" id="budgetContainerTable">
									<tr>
										<th>Mal Hizmet Toplam Tutarı</th>
										<td>
											<xsl:value-of select="format-number(n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
											<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID">
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRY'">
													<xsl:text> TL</xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
													<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID"/>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
									<xsl:if test="$legalMonetary &gt;0 or $linediscount &gt;0 ">
										<tr>
											<th>Toplam İskonto</th>
											<td>
												<xsl:value-of select="format-number(($legalMonetary + $linediscount), '###.##0,00', 'european')"/>
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID">
													<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID = 'TRY'">
														<xsl:text> TL</xsl:text>
													</xsl:if>
													<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID != 'TRY'">
														<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID"/>
													</xsl:if>
												</xsl:if>
											</td>
										</tr>
									</xsl:if>
									<xsl:for-each select="//n1:Invoice/cbc:Note[contains(.,'[SEVK]')]">
										<tr>
											<th>Net Sevk Sürşarjı</th>
											<td>
												<xsl:value-of select="format-number(substring-after(.,'[SEVK]'), '###.##0,00', 'european')"/>
												<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID">
													<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID = 'TRY'">
														<xsl:text> TL</xsl:text>
													</xsl:if>
													<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID != 'TRY'">
														<xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID"/>
													</xsl:if>
												</xsl:if>
											</td>
										</tr>
									</xsl:for-each>
									<xsl:for-each select="//n1:Invoice/*/cac:TaxSubtotal">
										<xsl:sort select="cbc:Percent" data-type="number"/>
										<tr>
											<th>
												<xsl:choose>
													<xsl:when test="./cac:TaxCategory/cac:TaxScheme/cbc:Name=//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:Name">
														<xsl:text>Hesaplanan KDV Tevkifatı % </xsl:text>
														<xsl:value-of select="cbc:Percent"/> (Matrah: <xsl:value-of select="format-number(cbc:TaxableAmount, '###.##0,00', 'european')"/>)
                          </xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/> %<xsl:value-of select="cbc:Percent"/> (Matrah: <xsl:value-of select="format-number(cbc:TaxableAmount, '###.##0,00', 'european')"/>)
                          </xsl:otherwise>
												</xsl:choose>
											</th>
											<td>
												<xsl:value-of select="format-number(cbc:TaxAmount, '###.##0,00', 'european')"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<th>
											<xsl:choose>
												<xsl:when test="count(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme[TaxTypeCode='9015'])&gt;0">
													<xsl:text>Tevkifat </xsl:text>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>Vergiler </xsl:text>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:text>Dahil Toplam Tutar</xsl:text>
										</th>
										<td>
											<xsl:value-of select="format-number(n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount, '###.##0,00', 'european')"/>
											<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID">
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID = 'TRY'">
													<xsl:text> TL</xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID != 'TRY'">
													<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID"/>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
									<tr>
										<th>Ödenecek Tutar</th>
										<td>
											<xsl:value-of select="format-number(n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount, '###.##0,00', 'european')"/>
											<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID">
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID = 'TRY'">
													<xsl:text> TL</xsl:text>
												</xsl:if>
												<xsl:if test="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID != 'TRY'">
													<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID"/>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr class="notesMainTr">
							<td id="notes">
								<table id="notesTable">
									<xsl:for-each select="//n1:Invoice/cbc:Note[contains(.,'[Fiyat Farkı]')]">
										<tr>
											<td class="noteLbl">
												<xsl:value-of select="substring-after(substring-before(.,']'),'[')"/>
											</td>
											<td>:</td>
											<td class="capital">
												<xsl:value-of select="substring-after(.,']')"/>
											</td>
										</tr>
									</xsl:for-each>
									<xsl:for-each select="$footerNote">
										<tr>
											<td class="noteLbl">
                        Not <xsl:value-of select="position()"/>
											</td>
											<td>:</td>
											<td class="capital">
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<xsl:if test="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote">
										<tr>
											<td class="noteLbl">Ödeme Açıklaması</td>
											<td>:</td>
											<td>
												<xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote"/>
												<xsl:text>IBAN: </xsl:text>
												<xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:ID"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="//n1:Invoice/cac:PaymentTerms/cbc:Note">
										<tr>
											<td class="noteLbl">Ödeme Koşulu</td>
											<td>:</td>
											<td class="capital">
												<xsl:value-of select="//n1:Invoice/cac:PaymentTerms/cbc:Note"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="//n1:Invoice/cac:PaymentMeans">
										<tr>
											<td class="noteLbl">Ödeme Şekli</td>
											<td>:</td>
											<td>
												<xsl:for-each select="//n1:Invoice/cac:PaymentMeans">
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=49]">
															<span>DIREKT BORCLANMA SISTEMI</span>
														</xsl:when>
													</xsl:choose>
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=10]">
															<span>NAKIT</span>
														</xsl:when>
													</xsl:choose>
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=42]">
															<span>BANKA TRANSFER</span>
														</xsl:when>
													</xsl:choose>
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=48]">
															<span>KREDI KART</span>
														</xsl:when>
													</xsl:choose>
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=66]">
															<span>CIROLU SENET</span>
														</xsl:when>
													</xsl:choose>
													<xsl:choose>
														<xsl:when test="./cbc:PaymentMeansCode[.=44]">
															<span>ÇEK</span>
														</xsl:when>
													</xsl:choose>
													<br/>
												</xsl:for-each>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="//n1:Invoice/cac:PaymentMeans/cbc:PaymentDueDate">
										<tr>
											<td class="noteLbl">Ödeme Vadesi</td>
											<td>:</td>
											<td>
												<xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cbc:PaymentDueDate"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
						<tr class="BankaTr">
							<td id="notes">
								<table id="banka">
									<tr>
										<th>BANKA</th>
										<th>PARA BİRİMİ</th>
										<th>IBAN NO</th>
									</tr>
									<tr>
										<td>ZİRAAT KATILIM</td>
										<td>TL</td>
										<td>TR86 0020 9000 0149 6785 0000 01</td>
									</tr>
									<tr>
										<td>AKBANK</td>
										<td>TL</td>
										<td>TR87 0004 6006 5888 8000 1736 42</td>
									</tr>
									<tr>
										<td>KUVEYT TÜRK</td>
										<td>TL</td>
										<td>TR61 0020 5000 0972 5315 5000 01</td>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:if>
					<tr class="pageInfo">
						<td style="font-size: 15pt;" align="center">
              Sayfa: <xsl:value-of select="$index"/> / <xsl:value-of select="$count"/>
						</td>
					</tr>
				</table>
			</xsl:for-each>
			<xsl:call-template name="Paging">
				<xsl:with-param name="index" select="$index + 1"/>
				<xsl:with-param name="count" select="$count"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>