<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988" xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:DespatchAdvice-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi">
  <xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN=""/>
  <xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
  <xsl:param name="SV_OutputFormat" select="'HTML'"/>
  <xsl:variable name="XML" select="/"/>
  <xsl:variable name="varStockCode" select="count(//cac:SellersItemIdentification[cbc:ID !=''])"/>
  <xsl:variable name="varInnerItemCount" select="count(//cac:GoodsItem[cbc:Description !=''])"/>
  <xsl:variable name="varManufacturerItemId" select="count(//cac:ManufacturersItemIdentification[cbc:ID !=''])"/>
  <xsl:variable name="varBuyersItemId" select="count(//cac:BuyersItemIdentification[cbc:ID !=''])"/>
  <xsl:variable name="varLineDescription" select="count(//cac:DespatchLine/cac:Item[cbc:Description !=''])"/>
  <xsl:variable name="varKunyeNo" select="//n1:DespatchAdvice/cbc:ProfileID='HALTIPI' and count(//cbc:ID[@schemeID='KUNYENO'])&gt;0"/>
  <xsl:template match="/">
    <html>
      <head>
        <style type="text/css">
          body {
            background-color: #FFFFFF;
            font-family: 'Tahoma', "Times New Roman", Times, serif;
            font-size: 14pt;
            color: #000000;
          }
          h1, h2 {
            padding-bottom: 3px;
            padding-top: 3px;
            margin-bottom: 5px;
            text-transform: uppercase;
            font-family: Arial, Helvetica, sans-serif;
          }
          h1 {
            font-size: 1.4em;
            text-transform:none;
          }
          h2 {
            font-size: 1em;
            color: brown;
          }
          h3 {
            font-size: 1em;
            color: #000000;
            text-align: justify;
            margin: 0;
            padding: 0;
          }
          h4 {
            font-size: 1.1em;
            font-style: bold;
            font-family: Arial, Helvetica, sans-serif;
            color: #000000;
            margin: 0;
            padding: 0;
          }
          hr {
            height:2px;
            color: #000000;
            background-color: #000000;
            border-bottom: 1px solid #000000;
          }
          p, ul, ol {
            margin-top: 1.5em;
          }
          ul, ol {
            margin-left: 3em;
          }
          blockquote {
            margin-left: 3em;
            margin-right: 3em;
            font-style: italic;
          }
          a {
            text-decoration: none;
            color: #70A300;
          }
          a:hover {
            border: none;
            color: #70A300;
          }
          #despatchTable {
            border-collapse:collapse;
            font-size: 14pt;
            float:right;
            border-color:gray;
          }
          #ettnTable {
            border-collapse:collapse;
            font-size: 14pt;
            border-color:gray;
          }
          #customerPartyTable {
            border-width: 0px;
            border-spacing:;
            border-style: inset;
            border-color: gray;
            border-collapse: collapse;
            background-color:
          }
          #customerIDTable {
            border-width: 2px;
            border-spacing:;
            border-style: inset;
            border-color: gray;
            border-collapse: collapse;
            background-color:
          }
          #customerIDTableTd {
            border-width: 2px;
            border-spacing:;
            border-style: inset;
            border-color: gray;
            border-collapse: collapse;
            background-color:
          }
          #lineTable {
            border-width:2px;
            border-spacing:;
            border-style: inset;
            border-color: black;
            border-collapse: collapse;
            background-color:;
          }
          td.lineTableTd {
            border-width: 1px;
            padding: 1px;
            border-style: solid;
            border-color: gray;
            background-color: white;
          }
          tr.lineTableTr {
            border-width: 1px;
            padding: 0px;
            border-style: inset;
            border-color: black;
            background-color: white;
            -moz-border-radius:;
          }
          #lineTableDummyTd {
            border-width: 1px;
            border-color:white;
            padding: 1px;
            border-style: inset;
            border-color: black;
            background-color: white;
          }
          td.lineTableBudgetTd {
            border-width: 2px;
            border-spacing:0px;
            padding: 1px;
            border-style: inset;
            border-color: black;
            background-color: white;
            -moz-border-radius:;
          }
          #notesTable {
            border-width: 2px;
            border-spacing:;
            border-style: inset;
            border-color: black;
            border-collapse: collapse;
            background-color:
          }
          #notesTableTd {
            border-width: 0px;
            border-spacing:;
            border-style: inset;
            border-color: black;
            border-collapse: collapse;
            background-color: ;
            vertical-align: top;
          }
          table {
          border-spacing:0px;
          }
          #budgetContainerTable {
            border-width: 0px;
            border-spacing: 0px;
            border-style: inset;
            border-color: black;
            border-collapse: collapse;
            background-color:;
          }
          td {
            border-color:gray;
          }

          #invoice-info-td {
            border-style: solid;
            border-width: 1px;
            border-color:gray
            width: 50%;
          }
          #invoice-line-td {
            border-style: solid;
            border-width: 0px;
            color:white;
          }
          .budget-td {
            border-style: solid;
            border-width: 1px;
            border-color: black;
            border-spacing: 0;
            line-height: 18px;
            text-align: right;
          }
        </style>
        <title>e-İrsaliye</title>
      </head>
      <body style="width:1280px">
        <xsl:for-each select="$XML">
          <!-- GONDERICI - BELGE LOGO - FIRMA LOGO TABLOSU -->
          <table style="width: 100%;">
            <tbody>
              <tr>
                <td colspan="3">
                  <table width="100%">
                    <tr>
                      <td width="20%">
                        <img src="data:image/jpeg;base64,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"/>
                      </td>
                      <td>
                        <span style="color:#5B6581;font-weight:bold">Adres : </span>
                        <xsl:for-each select="n1:DespatchAdvice/cac:DespatchSupplierParty/cac:Party">
                          <xsl:for-each select="cac:PostalAddress">
                            <xsl:for-each select="cbc:StreetName">
                              <xsl:apply-templates/>
                              <xsl:text>&#160;</xsl:text>
                            </xsl:for-each>
                            <xsl:for-each select="cbc:BuildingName">
                              <xsl:apply-templates/>
                            </xsl:for-each>
                            <xsl:if test="cbc:BuildingNumber">
                              <xsl:text> No:</xsl:text>
                              <xsl:for-each select="cbc:BuildingNumber">
                                <xsl:apply-templates/>
                              </xsl:for-each>
                              <xsl:text>&#160;</xsl:text>
                            </xsl:if>
                            <br/>
                            <xsl:for-each select="cbc:PostalZone">
                              <xsl:apply-templates/>
                              <xsl:text>&#160;</xsl:text>
                            </xsl:for-each>
                            <xsl:for-each select="cbc:CitySubdivisionName">
                              <xsl:apply-templates/>
                            </xsl:for-each>
                            <xsl:text>/ </xsl:text>
                            <xsl:for-each select="cbc:CityName">
                              <xsl:apply-templates/>
                              <xsl:text>&#160;</xsl:text>
                            </xsl:for-each>
                          </xsl:for-each>
                        </xsl:for-each>
                        <br/>
                        <xsl:for-each select="//n1:DespatchAdvice/cac:DespatchSupplierParty/cac:Party/cbc:WebsiteURI">
                          <span style="color:#5B6581;font-weight:bold">
                            <xsl:text>Web: </xsl:text>
                          </span>
                          <xsl:value-of select="."/>
                        </xsl:for-each>
                        <br/>
                        <xsl:for-each select="n1:DespatchAdvice/cac:DespatchSupplierParty/cac:Party">
                          <span style="color:#5B6581;font-weight:bold">
                            <xsl:text>Vergi Dairesi: </xsl:text>
                          </span>
                          <xsl:for-each select="cac:PartyTaxScheme">
                            <xsl:for-each select="cac:TaxScheme">
                              <xsl:for-each select="cbc:Name">
                                <xsl:apply-templates/>
                              </xsl:for-each>
                            </xsl:for-each>
                            <xsl:text>&#160;</xsl:text>
                          </xsl:for-each>
                        </xsl:for-each>
                        <br/>
                        <xsl:for-each select="//n1:DespatchAdvice/cac:DespatchSupplierParty/cac:Party/cac:PartyIdentification">
                          <span style="color:#5B6581;font-weight:bold">
                            <xsl:value-of select="cbc:ID/@schemeID"/>
                          </span>
                          <xsl:text>: </xsl:text>
                          <xsl:value-of select="cbc:ID"/>
                          <br/>
                        </xsl:for-each>
                      </td>
                      <td width="20%">
                        <img src="data:image/jpeg;base64,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"/>
                      </td>
                    </tr>
                    <tr align="left">
                      <td align="center" colspan="3">
                        <table width="100%" style="border-collapse:collapse">
                          <tr>
                            <td style="background-color:#E38E14;width:1%"/>
                            <td align="center" style="font-weight:bold;font-size:15pt;background-color:#5B6581;padding:10px;color:white">
                              <xsl:for-each select="n1:DespatchAdvice/cac:DespatchSupplierParty/cac:Party">
                                <xsl:if test="cac:PartyName">
                                  <xsl:value-of select="cac:PartyName/cbc:Name"/>
                                  <br/>
                                </xsl:if>
                                <xsl:for-each select="cac:Person">
                                  <xsl:for-each select="cbc:Title">
                                    <xsl:apply-templates/>
                                    <xsl:text>&#160;</xsl:text>
                                  </xsl:for-each>
                                  <xsl:for-each select="cbc:FirstName">
                                    <xsl:apply-templates/>
                                    <xsl:text>&#160;</xsl:text>
                                  </xsl:for-each>
                                  <xsl:for-each select="cbc:MiddleName">
                                    <xsl:apply-templates/>
                                    <xsl:text>&#160;</xsl:text>
                                  </xsl:for-each>
                                  <xsl:for-each select="cbc:FamilyName">
                                    <xsl:apply-templates/>
                                    <xsl:text>&#160;</xsl:text>
                                  </xsl:for-each>
                                  <xsl:for-each select="cbc:NameSuffix">
                                    <xsl:apply-templates/>
                                  </xsl:for-each>
                                </xsl:for-each>
                              </xsl:for-each>
                            </td>
                            <td style="background-color:#E38E14;width:1%"/>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
            </tbody>
          </table>
          <!-- ALICI - IMZA - FATURA BILGILERI TABLOSU -->
          <table style="width: 100%">
            <tbody>
              <tr>
                <td style="width: 40%;" valign="top">
                  <table style="width: 100%;">
                    <tbody>
                      <tr>
                        <xsl:choose>
                          <xsl:when test="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
                            <xsl:for-each select="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party">
                              <xsl:call-template name="Party_Title">
                                <xsl:with-param name="PartyType">
                                  TAXFREE
                                </xsl:with-param>
                              </xsl:call-template>
                            </xsl:for-each>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:for-each select="n1:DespatchAdvice/cac:DeliveryCustomerParty/cac:Party">
                              <xsl:call-template name="Party_Title">
                                <xsl:with-param name="PartyType">
                                  OTHER
                                </xsl:with-param>
                              </xsl:call-template>
                            </xsl:for-each>
                          </xsl:otherwise>
                        </xsl:choose>
                      </tr>
                      <xsl:choose>
                        <xsl:when test="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
                          <xsl:for-each select="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party">
                            <tr>
                              <xsl:call-template name="Party_Adress">
                                <xsl:with-param name="PartyType">
                                  TAXFREE
                                </xsl:with-param>
                              </xsl:call-template>
                            </tr>
                            <xsl:call-template name="Party_Other">
                              <xsl:with-param name="PartyType">
                                TAXFREE
                              </xsl:with-param>
                            </xsl:call-template>
                          </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:for-each select="n1:DespatchAdvice/cac:DeliveryCustomerParty/cac:Party">
                            <tr>
                              <xsl:call-template name="Party_Adress">
                                <xsl:with-param name="PartyType">
                                  OTHER
                                </xsl:with-param>
                              </xsl:call-template>
                            </tr>
                            <xsl:call-template name="Party_Other">
                              <xsl:with-param name="PartyType">
                                OTHER
                              </xsl:with-param>
                            </xsl:call-template>
                          </xsl:for-each>
                        </xsl:otherwise>
                      </xsl:choose>
                      <tr>
                        <td style="padding-top:10px">
                          <span style="color:#5B6581;font-weight:bold">Sevk Adresi</span>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <span style="color:#5B6581;font-weight:bold">
                            <xsl:value-of select="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party/cac:PartyName/cbc:Name"/>
                          </span>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <span style="color:#5B6581;font-weight:bold">Adres: </span>
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:StreetName"/> 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:BuildingName"/> 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:BuildingNumber"/> 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:CitySubdivisionName"/> / 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:CityName"/> 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cbc:PostalZone"/> 
                          <xsl:value-of select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:DeliveryAddress/cac:Country/cbc:Name"/>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <span style="color:#5B6581;font-weight:bold">VKN: </span>
                          <xsl:value-of select="n1:DespatchAdvice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID"/>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </td>
                <td style="width: 20%; text-align: center;">
                  <img style="width:auto;" align="middle" alt="E-Fatura Logo" src="data:image/jpeg;base64,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"/>
                  <h1 style="text-align: center;">
                    <span style="font-weight:bold; ">
                      <xsl:text>e-İRSALİYE</xsl:text>
                    </span>
                  </h1>
                  <br/>
                  <div id="qrcode" style="display: flex; flex-direction: column; align-items: center;">
                  <!--
                  NOTLAR KAREKOD GELECEK
                  -->
                  <img alt='' src='data:image/png;base64,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'/>
                  </div>
                </td>
                <td style="width: 30%;" valign="top">
                  <table style="width:100%; border-collapse: collapse;">
                    <tbody>
                      <tr>
                        <td style="width: 50%;padding-bottom:10px;" colspan="3">
                          <span style="font-weight:bold; color:#5B6581">
                            <xsl:text>İrsaliye No :</xsl:text>
                          </span>
                          <xsl:for-each select="n1:DespatchAdvice/cbc:ID">
                            <xsl:apply-templates/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td rowspan="20" style="background-color:#E38E14">    </td>
                      </tr>
                      <tr>
                        <td rowspan="20">    </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold; color:#5B6581">
                            <xsl:text>Özelleştirme No</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cbc:CustomizationID">
                            <xsl:apply-templates/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581 ">
                            <xsl:text>Senaryo</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cbc:ProfileID">
                            <xsl:apply-templates/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581 ">
                            <xsl:text>İrsaliye Tipi</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cbc:DespatchAdviceTypeCode">
                            <xsl:apply-templates/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581 ">
                            <xsl:text>İrsaliye Tarihi</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cbc:IssueDate">
                            <xsl:apply-templates select="."/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581 ">
                            <xsl:text>İrsaliye Zamanı</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cbc:IssueTime">
                              <xsl:call-template name = "saat_bicimlendir">
                                <xsl:with-param name = "saat" select = "."/>
                              </xsl:call-template>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold; color:#5B6581">
                            <xsl:text>Sevk Tarihi</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:Despatch/cbc:ActualDespatchDate">
                            <xsl:apply-templates select="."/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581">
                            <xsl:text>Sevk Zamanı</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cac:Shipment/cac:Delivery/cac:Despatch/cbc:ActualDespatchTime">
                              <xsl:call-template name = "saat_bicimlendir">
                                <xsl:with-param name = "saat" select = "."/>
                              </xsl:call-template>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold; color:#5B6581">
                            <xsl:text>Sipariş No</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cac:OrderReference/cbc:ID">
                            <xsl:apply-templates/>
                          </xsl:for-each>
                        </td>
                      </tr>
                      <tr>
                        <td style="width: 50%;">
                          <span style="font-weight:bold;color:#5B6581 ">
                            <xsl:text>Sipariş Tarihi</xsl:text>
                          </span>
                        </td>
                        <td style="width: 50%;">
                          :
                          <xsl:for-each select="n1:DespatchAdvice/cac:OrderReference/cbc:IssueDate">
                            <xsl:apply-templates select="."/>
                          </xsl:for-each>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </td>
              </tr>
            </tbody>
          </table>
          <!-- ETTN SATIRI -->
          <table style="width: 100%; margin-bottom: 5px;">
            <tbody>
              <tr>
                <td style="border-top:1px dotted black;border-bottom:1px dotted black;padding:10px">
                  <span style="color:#5B6581;font-weight:bold">
                    <xsl:text>ETTN: </xsl:text>
                  </span>
                  <xsl:for-each select="n1:DespatchAdvice/cbc:UUID">
                    <xsl:apply-templates/>
                  </xsl:for-each>
                </td>
              </tr>
            </tbody>
          </table>
          <!-- URUNLER SATIRI (TABLOSU) -->
          <table style="width: 100%; border-collapse: collapse; border-style: solid; border-width: 1px;border-color:gray">
            <tbody>
              <tr>
                <td id="invoice-line-td" style="width:5%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Sıra No</xsl:text>
                  </span>
                </td>
                <td id="invoice-line-td" style="width:30%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Mal</xsl:text>
                  </span>
                </td>
                <xsl:choose>
                  <xsl:when test="$varStockCode &gt; 0">
                    <td id="invoice-line-td" style="width:10%; text-align: center; background-color: #E38E14;">
                      <span style="font-weight:bold;">
                        <xsl:text>Stok Kodu</xsl:text>
                      </span>
                    </td>
                  </xsl:when>
                  <xsl:otherwise/>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="$varManufacturerItemId &gt; 0">
                    <td id="invoice-line-td" style="width:10%; text-align: center; background-color: #E38E14;">
                      <span style="font-weight:bold;">
                        <xsl:text>Barkod</xsl:text>
                      </span>
                    </td>
                  </xsl:when>
                  <xsl:otherwise/>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="$varBuyersItemId &gt; 0">
                    <td id="invoice-line-td" style="width:10%; text-align: center; background-color: #E38E14;">
                      <span style="font-weight:bold;">
                        <xsl:text>Müşteri Ürün Kodu</xsl:text>
                      </span>
                    </td>
                  </xsl:when>
                  <xsl:otherwise/>
                </xsl:choose>
                <td id="invoice-line-td" style="width:10%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Miktar</xsl:text>
                  </span>
                </td>
				<!--
                <td id="invoice-line-td" style="width:10%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Birim Fiyat</xsl:text>
                  </span>
                </td>
				-->
                <td id="invoice-line-td" style="width:15%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Sonradan Gönd. Miktar</xsl:text>
                  </span>
                </td>
                <xsl:choose>
                  <xsl:when test="$varKunyeNo">
                    <td id="invoice-line-td" style="width:15%; text-align: center; background-color: #E38E14;">
                      <span style="font-weight:bold;">
                        <xsl:text>Künye No</xsl:text>
                      </span>
                    </td>
                  </xsl:when>
                  <xsl:otherwise/>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="$varLineDescription &gt; 0">
                    <td id="invoice-line-td" style="width:15%; text-align: center; background-color: #E38E14;">
                      <span style="font-weight:bold;">
                        <xsl:text>Satır Açıklaması</xsl:text>
                      </span>
                    </td>
                  </xsl:when>
                  <xsl:otherwise/>
                </xsl:choose>
				<!--
                <td id="invoice-line-td" style="width:15%; text-align: center; background-color: #E38E14;">
                  <span style="font-weight:bold;">
                    <xsl:text>Tutar</xsl:text>
                  </span>
                </td>
				-->
              </tr>
              <xsl:if test="count(//n1:DespatchAdvice/cac:DespatchLine) &gt;= 1">
                <xsl:for-each select="//n1:DespatchAdvice/cac:DespatchLine">
                  <xsl:apply-templates select="."/>
                </xsl:for-each>
              </xsl:if>
              <xsl:if test="count(//n1:DespatchAdvice/cac:DespatchLine) &lt; 1">
                <xsl:choose>
                  <xsl:when test="//n1:DespatchAdvice/cac:DespatchLine[1]">
                    <xsl:apply-templates select="//n1:DespatchAdvice/cac:DespatchLine[1]"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:apply-templates select="//n1:DespatchAdvice"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </tbody>
          </table>
        </xsl:for-each>
        <table style="margin-bottom: 10px; width: 100%; margin-top: 20px;" cellspacing="0" cellpadding="0">
          <tr>
            <td style="width: 60%;"/>
            <td style="width: 40%;">
              <table style="width: 100%; border-collapse: collapse;" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="budget-td" style="width: 50%;">
                    <span style="font-weight:bold; ">
                      <xsl:text>Toplam Tutar</xsl:text>
                    </span>
                  </td>
                  <td class="budget-td" style="width: 50%;">
                    <xsl:if test="n1:DespatchAdvice/cac:Shipment/cac:GoodsItem/cbc:ValueAmount != 0">
                      <xsl:for-each select="n1:DespatchAdvice/cac:Shipment/cac:GoodsItem/cbc:ValueAmount">
                        <xsl:call-template name="Curr_Type"/>
                      </xsl:for-each>
                    </xsl:if>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
		<!--
        <xsl:if test="//n1:DespatchAdvice/cac:AdditionalDocumentReference">
          <table style="margin-bottom: 10px; width: 100%; margin-top: 20px; border-collapse: collapse;" cellspacing="0" cellpadding="0">
            <thead>
              <tr>
                <td align="left">
                  <span style="font-weight:bold; " align="center">
                    İlgili
                    Dokümanlar
                  </span>
                </td>
                <td align="left">
                  <span style="font-weight:bold; " align="center">
                  </span>
                </td>
                <td align="left">
                  <span style="font-weight:bold; " align="center">
                  </span>
                </td>
                <td align="left">
                  <span style="font-weight:bold; " align="center">
                  </span>
                </td>
              </tr>
            </thead>
            <tbody>
              <tr align="left" class="lineTableTr">
                <td class="lineTableTd">
                  <span style="font-weight:bold; " align="center">Doküman No</span>
                </td>
                <td class="lineTableTd">
                  <span style="font-weight:bold; " align="center">Tarih</span>
                </td>
                <td class="lineTableTd">
                  <span style="font-weight:bold; " align="center">Doküman Tipi</span>
                </td>
                <td class="lineTableTd">
                  <span style="font-weight:bold; " align="center">Açıklama</span>
                </td>
              </tr>
              <xsl:for-each select="//n1:DespatchAdvice/cac:AdditionalDocumentReference">
                <tr align="left" class="lineTableTr">
                  <td class="lineTableTd">
                    <xsl:value-of select="./cbc:ID"/>
                  </td>
                  <td class="lineTableTd">
                    <xsl:for-each select="./cbc:IssueDate">
                      <xsl:apply-templates select="."/>
                    </xsl:for-each>
                  </td>
                  <td class="lineTableTd">
                    <xsl:value-of select="./cbc:DocumentType"/>
                  </td>
                  <td class="lineTableTd">
                    <xsl:value-of select="./cbc:DocumentDescription"/>
                  </td>
                </tr>
              </xsl:for-each>
            </tbody>
          </table>
        </xsl:if>
		-->
        <br/>
        <table style="width: 100%;" cellspacing="0" cellpadding="6">
          <tr>
            <td rowspan="3" style="background-color:#E38E14;"> </td>
          </tr>
          <tr>
            <td style="width: 15%" valign="top">
              <span style="font-weight:bold;color:#5B6581">
                Not :
              </span>
            </td>
            <td style="width: 85%">
              <xsl:for-each select="//n1:DespatchAdvice/cbc:Note">
                <xsl:value-of select="."/>
                <br/>
              </xsl:for-each>
            </td>
          </tr>
          <tr>
            <td>
              <span style="font-weight:bold;color:#5B6581">Taşıyıcı Firma : </span>
            </td>
            <td>
              VKN: <xsl:value-of select="//cac:CarrierParty/cac:PartyIdentification/cbc:ID"/>,
              <xsl:value-of select="//cac:CarrierParty/cac:PartyName/cbc:Name"/>
            </td>
          </tr>
        </table>
        <br/>
        <table style="width:1280px;border-collapse:collapse;border:1px solid black" cellpadding="10">
          <tr style="font-weight:bold">
            <td style="border-right:1px solid black">Teslim Eden</td>
            <td>Teslim Alan</td>
          </tr>
          <tr style="font-weight:bold">
            <td style="border-right:1px solid black">Ad-Soyad : </td>
            <td>Ad-Soyad : </td>
          </tr>
          <tr style="font-weight:bold">
            <td style="border-right:1px solid black">Tarih : </td>
            <td>Tarih : </td>
          </tr>
          <tr style="font-weight:bold">
            <td style="border-right:1px solid black">İmza : </td>
            <td>İmza : </td>
          </tr>
        </table>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="//n1:DespatchAdvice/cac:DespatchLine">
    <tr class="lineTableTr">
      <td class="lineTableTd">
        <xsl:value-of select="./cbc:ID"/>
      </td>
      <td class="lineTableTd">
        <xsl:value-of select="./cac:Item/cbc:Name"/>
      </td>
      <xsl:choose>
        <xsl:when test="$varStockCode &gt; 0">
          <td class="lineTableTd">
            <xsl:value-of select="./cac:Item/cac:SellersItemIdentification/cbc:ID"/>
          </td>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$varManufacturerItemId &gt; 0">
          <td class="lineTableTd">
            <xsl:value-of select="./cac:Item/cac:ManufacturersItemIdentification/cbc:ID"/>
          </td>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$varBuyersItemId &gt; 0">
          <td class="lineTableTd">
            <xsl:value-of select="./cac:Item/cac:BuyersItemIdentification/cbc:ID"/>
          </td>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
      <td class="lineTableTd" align="right">
        <xsl:choose>
          <xsl:when test="$varInnerItemCount &gt; 0">
            <xsl:value-of select="format-number(./cbc:DeliveredQuantity, '###.###,####', 'european')"/>
            <xsl:text>(*</xsl:text>
            <xsl:value-of select="./cac:Shipment/cac:GoodsItem/cbc:Description"/>
            <xsl:text>)</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="format-number(./cbc:DeliveredQuantity, '###.###,####', 'european')"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#160;</xsl:text>
        <xsl:if test="./cbc:DeliveredQuantity/@unitCode">
          <xsl:for-each select="./cbc:DeliveredQuantity">
            <xsl:choose>
              <xsl:when test="@unitCode  = '26'"><xsl:text>ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'BX'"><xsl:text>Kutu</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'LTR'"><xsl:text>lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'C62'"><xsl:text>Adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NIU'"><xsl:text>Adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KGM'"><xsl:text>kg</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KJO'"><xsl:text>kJ</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'GRM'"><xsl:text>g</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MGM'"><xsl:text>mg</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NT'"><xsl:text>Net Ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'GT'"><xsl:text>Gross Ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTR'"><xsl:text>m</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MMT'"><xsl:text>mm</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KTM'"><xsl:text>km</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MLT'"><xsl:text>ml</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MMQ'"><xsl:text>mm3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CLT'"><xsl:text>cl</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMK'"><xsl:text>cm2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMQ'"><xsl:text>cm3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMT'"><xsl:text>cm</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTK'"><xsl:text>m2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTQ'"><xsl:text>m3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'DAY'"><xsl:text> Gün</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MON'"><xsl:text> Ay</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'PA'"><xsl:text> Paket</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KWH'"><xsl:text> KWH</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'ANN'"><xsl:text> Yıl</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'HUR'"><xsl:text> Saat</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D61'"><xsl:text> Dakika</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D62'"><xsl:text> Saniye</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CCT'"><xsl:text> Ton baş.taşıma kap.</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D30'"><xsl:text> Brüt kalori</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D40'"><xsl:text> 1000 lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'LPA'"><xsl:text> saf alkol lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'B32'"><xsl:text> kg.m2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NCL'"><xsl:text> hücre adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'PR'"><xsl:text> Çift</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'R9'"><xsl:text> 1000 m3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'SET'"><xsl:text> Set</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'T3'"><xsl:text> 1000 adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'PK'"><xsl:text> Koli</xsl:text></xsl:when>
            </xsl:choose>
          </xsl:for-each>
        </xsl:if>
      </td>
	  <!--
      <td class="lineTableTd" align="right">
        <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount != 0">
          <xsl:value-of select="format-number(./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount, '###.##0,########', 'european')"/>
          <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID">
            <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID = &quot;TRL&quot; or ./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID = &quot;TRY&quot;">
              <xsl:text>&#160;TL</xsl:text>
            </xsl:if>
            <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID != &quot;TRL&quot; and ./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID != &quot;TRY&quot;">
              <xsl:value-of select="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount/@currencyID"/>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </td>
	  -->
      <td class="lineTableTd" align="right">
        <xsl:value-of select="format-number(./cbc:OutstandingQuantity, '###.###,####', 'european')"/>
        <xsl:text>&#160;</xsl:text>
        <xsl:if test="./cbc:OutstandingQuantity/@unitCode">
          <xsl:for-each select="./cbc:OutstandingQuantity">
            <xsl:choose>
              <xsl:when test="@unitCode  = '26'"><xsl:text>ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'BX'"><xsl:text>Kutu</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'LTR'"><xsl:text>lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'C62'"><xsl:text>Adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NIU'"><xsl:text>Adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KGM'"><xsl:text>kg</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KJO'"><xsl:text>kJ</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'GRM'"><xsl:text>g</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MGM'"><xsl:text>mg</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NT'"><xsl:text>Net Ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'GT'"><xsl:text>Gross Ton</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTR'"><xsl:text>m</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MMT'"><xsl:text>mm</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KTM'"><xsl:text>km</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MLT'"><xsl:text>ml</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MMQ'"><xsl:text>mm3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CLT'"><xsl:text>cl</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMK'"><xsl:text>cm2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMQ'"><xsl:text>cm3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CMT'"><xsl:text>cm</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTK'"><xsl:text>m2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MTQ'"><xsl:text>m3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'DAY'"><xsl:text> Gün</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'MON'"><xsl:text> Ay</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'PA'"><xsl:text> Paket</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'KWH'"><xsl:text> KWH</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'ANN'"><xsl:text> Yıl</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'HUR'"><xsl:text> Saat</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D61'"><xsl:text> Dakika</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D62'"><xsl:text> Saniye</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'CCT'"><xsl:text> Ton baş.taşıma kap.</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D30'"><xsl:text> Brüt kalori</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'D40'"><xsl:text> 1000 lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'LPA'"><xsl:text> saf alkol lt</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'B32'"><xsl:text> kg.m2</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'NCL'"><xsl:text> hücre adet</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'PR'"><xsl:text> Çift</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'R9'"><xsl:text> 1000 m3</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'SET'"><xsl:text> Set</xsl:text></xsl:when>
              <xsl:when test="@unitCode  = 'T3'"><xsl:text> 1000 adet</xsl:text></xsl:when>
            </xsl:choose>
          </xsl:for-each>
        </xsl:if>
      </td>
      <xsl:choose>
        <xsl:when test="$varLineDescription &gt; 0">
          <td class="lineTableTd">
            <xsl:value-of select="./cac:Item/cbc:Description"/>
          </td>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$varKunyeNo">
          <td class="lineTableTd">
            <xsl:value-of select="./cac:Item/cac:AdditionalItemIdentification/cbc:ID[@schemeID='KUNYENO']"/>
          </td>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
	  <!--
      <td class="lineTableTd" align="right">
        <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cac:Price/cbc:PriceAmount != 0">
          <xsl:value-of select="format-number(./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount, '###.##0,########', 'european')"/>
          <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID">
            <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID = &quot;TRL&quot; or ./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID = &quot;TRY&quot;">
              <xsl:text>&#160;TL</xsl:text>
            </xsl:if>
            <xsl:if test="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID != &quot;TRL&quot; and ./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID != &quot;TRY&quot;">
              <xsl:value-of select="./cac:Shipment/cac:GoodsItem/cac:InvoiceLine/cbc:LineExtensionAmount/@currencyID"/>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </td>
	  -->
    </tr>
  </xsl:template>
  <xsl:template match="//cbc:IssueDate">
    <xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
  </xsl:template>
  <xsl:template match="//cbc:ActualDespatchDate">
    <xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
  </xsl:template>
  <xsl:template match="//n1:DespatchAdvice">
    <tr class="lineTableTr">
      <td class="lineTableTd">
        <xsl:text>&#160;</xsl:text>
      </td>
      <td class="lineTableTd">
        <xsl:text>&#160;</xsl:text>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:text>&#160;</xsl:text>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:text>&#160;</xsl:text>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:text>&#160;</xsl:text>
      </td>
      <td class="lineTableTd" align="right">
        <xsl:text>&#160;</xsl:text>
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="Party_Title">
    <xsl:param name="PartyType"/>
    <td style="width:469px;color:#5B6581" align="left">
      <xsl:if test="cac:PartyName">
        <b>
          <xsl:value-of select="cac:PartyName/cbc:Name"/>
        </b>
        <br/>
      </xsl:if>
      <xsl:for-each select="cac:Person">
        <xsl:for-each select="cbc:Title">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:FirstName">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:MiddleName">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:FamilyName">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:NameSuffix">
          <xsl:apply-templates/>
        </xsl:for-each>
        <xsl:if test="$PartyType='TAXFREE'">
          <br/>
          <xsl:text>Pasaport No: </xsl:text>
          <xsl:value-of select="cac:IdentityDocumentReference/cbc:ID"/>
          <br/>
          <xsl:text>Ülkesi: </xsl:text>
          <xsl:value-of select="cbc:NationalityID"/>
        </xsl:if>
      </xsl:for-each>
    </td>
  </xsl:template>
  <xsl:template name="Party_Adress">
    <xsl:param name="PartyType"/>
    <td style="width:469px; " align="left">
      <span style="color:#5B6581;font-weight:bold">Adres: </span>
      <xsl:for-each select="cac:PostalAddress">
        <xsl:for-each select="cbc:StreetName">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:BuildingName">
          <xsl:apply-templates/>
        </xsl:for-each>
        <xsl:for-each select="cbc:BuildingNumber">
          <xsl:text>No:</xsl:text>
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <br/>
        <xsl:for-each select="cbc:Room">
          <xsl:text>Kapı No:</xsl:text>
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:PostalZone">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:CitySubdivisionName">
          <xsl:apply-templates/>
          <xsl:text>/</xsl:text>
        </xsl:for-each>
        <xsl:for-each select="cbc:CityName">
          <xsl:apply-templates/>
          <xsl:text>&#160;</xsl:text>
        </xsl:for-each>
        <xsl:if test="$PartyType='TAXFREE'">
          <br/>
          <xsl:value-of select="cac:Country/cbc:Name"/>
          <br/>
        </xsl:if>
      </xsl:for-each>
    </td>
  </xsl:template>
  <xsl:template name="Party_Other">
    <xsl:param name="PartyType"/>
    <xsl:for-each select="cbc:WebsiteURI">
      <tr align="left">
        <td>
          <span style="color:#5B6581;font-weight:bold">
            <xsl:text>Web Sitesi: </xsl:text>
          </span>
          <xsl:value-of select="."/>
        </td>
      </tr>
    </xsl:for-each>
    <xsl:for-each select="cac:Contact/cbc:ElectronicMail">
      <tr align="left">
        <td>
          <span style="color:#5B6581;font-weight:bold">
            <xsl:text>E-Posta: </xsl:text>
          </span>
          <xsl:value-of select="."/>
        </td>
      </tr>
    </xsl:for-each>
    <xsl:for-each select="cac:Contact">
      <xsl:if test="cbc:Telephone or cbc:Telefax">
        <tr align="left">
          <td style="width:469px; " align="left">
            <xsl:for-each select="cbc:Telephone">
              <span style="color:#5B6581;font-weight:bold">
                <xsl:text>Tel: </xsl:text>
              </span>
              <xsl:apply-templates/>
            </xsl:for-each>
            <xsl:for-each select="cbc:Telefax">
              <span style="color:#5B6581;font-weight:bold">
                <xsl:text>Fax: </xsl:text>
              </span>
              <xsl:apply-templates/>
            </xsl:for-each>
            <xsl:text>&#160;</xsl:text>
          </td>
        </tr>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="$PartyType!='TAXFREE'">
      <xsl:for-each select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
        <tr align="left">
          <td>
            <span style="color:#5B6581;font-weight:bold">
              <xsl:text>Vergi Dairesi: </xsl:text>
            </span>
            <xsl:apply-templates/>
          </td>
        </tr>
      </xsl:for-each>
      <xsl:for-each select="cac:PartyIdentification">
        <tr align="left">
          <td>
            <span style="color:#5B6581;font-weight:bold">
              <xsl:value-of select="cbc:ID/@schemeID"/>
            </span>
            <xsl:text>: </xsl:text>
            <xsl:value-of select="cbc:ID"/>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  <xsl:template name="Curr_Type">
    <xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
    <xsl:if test="@currencyID">
      <xsl:choose>
        <xsl:when test="@currencyID = 'TRL' or @currencyID = 'TRY'">
          <xsl:text>&#160;TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@currencyID"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
  <xsl:template name = "saat_bicimlendir">
    <xsl:param name = "saat"/>
    <xsl:variable name = "saat_dize" select = "string($saat)"/>
    <xsl:if test = "$saat_dize != ''">
      <xsl:value-of select = "substring($saat_dize, 1, 2)"/>
      <xsl:text>:</xsl:text>
      <xsl:value-of select = "substring($saat_dize, 4, 2)"/>
      <xsl:text>:</xsl:text>
      <xsl:value-of select = "substring($saat_dize, 7, 2)"/>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>