<?xml version = "1.0" encoding = "utf-8"?>

<xsl:stylesheet
  version = "1.0"
  xmlns:cac = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
  xmlns:cbc = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
  xmlns:ccts = "urn:un:unece:uncefact:documentation:2"
  xmlns:clm5639 = "urn:un:unece:uncefact:codelist:specification:5639:1988"
  xmlns:clm54217 = "urn:un:unece:uncefact:codelist:specification:54217:2001"
  xmlns:clm66411 = "urn:un:unece:uncefact:codelist:specification:66411:2001"
  xmlns:clmIANAMIMEMediaType = "urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003"
  xmlns:ds = "http://www.w3.org/2000/09/xmldsig#"
  xmlns:ext = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
  xmlns:fn = "http://www.w3.org/2005/xpath-functions"
  xmlns:lcl = "http://www.efatura.gov.tr/local"
  xmlns:link = "http://www.xbrl.org/2003/linkbase"
  xmlns:n1 = "urn:oasis:names:specification:ubl:schema:xsd:DespatchAdvice-2"
  xmlns:qdt = "urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
  xmlns:udt = "urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
  xmlns:xades = "http://uri.etsi.org/01903/v1.3.2#"
  xmlns:xbrldi = "http://xbrl.org/2006/xbrldi"
  xmlns:xbrli = "http://www.xbrl.org/2003/instance"
  xmlns:xdt = "http://www.w3.org/2005/xpath-datatypes"
  xmlns:xlink = "http://www.w3.org/1999/xlink"
  xmlns:xs = "http://www.w3.org/2001/XMLSchema"
  xmlns:xsd = "http://www.w3.org/2001/XMLSchema"
  xmlns:xsi = "http://www.w3.org/2001/XMLSchema-instance"
  xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes = "cac cbc ccts clm5639 clm54217 clm66411 clmIANAMIMEMediaType ds ext fn lcl link n1 qdt udt xades xbrldi xbrli xdt xlink xs xsd xsi xsl">

  <xsl:output
    version = "4.0"
    method = "html"
    indent = "yes"
    encoding = "utf-8"
    doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system = "http://www.w3.org/TR/html4/loose.dtd"/>

  <xsl:param
    name = "SV_OutputFormat"
    select = "'HTML'"/>

  <xsl:decimal-format
    name = "european"
    decimal-separator = ","
    grouping-separator = "."
    NaN = ""/>

  <xsl:variable
    name = "xml"
    select = "/"/>

  <xsl:variable
    name = "xml_belge"
    select = "//n1:DespatchAdvice"/>

  <xsl:variable
    name = "xml_satici_merkez"
    select = "$xml_belge/cac:DespatchSupplierParty/cac:Party"/>

  <xsl:variable
    name = "xml_satici_sube"
    select = "$xml_belge/cac:SellerSupplierParty/cac:Party"/>

  <xsl:variable
    name = "xml_alici_merkez"
    select = "$xml_belge/cac:DeliveryCustomerParty/cac:Party"/>

  <xsl:variable
    name = "xml_alici_sube"
    select = "$xml_belge/cac:BuyerCustomerParty/cac:Party"/>

  <xsl:variable
    name = "xml_belge_ozellestirme_no"
    select = "$xml_belge/cbc:CustomizationID"/>

  <xsl:variable
    name = "xml_belge_senaryo"
    select = "$xml_belge/cbc:ProfileID"/>

  <xsl:variable
    name = "xml_belge_fatura_tipi"
    select = "$xml_belge/cbc:DespatchAdviceTypeCode"/>

  <xsl:variable
    name = "xml_belge_fatura_no"
    select = "$xml_belge/cbc:ID"/>

  <xsl:variable name = "kucuk_harf" select = "'abcdefghijklmnopqrstuvwxyz'"/>
  <xsl:variable name = "buyuk_harf" select = "'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

  <xsl:variable
    name = "xml_belge_uuid"
    select = "translate($xml_belge/cbc:UUID, $kucuk_harf, $buyuk_harf)"/>

  <xsl:variable
    name = "xml_belge_fatura_tarihi"
    select = "$xml_belge/cbc:IssueDate"/>

  <xsl:variable
    name = "xml_belge_fatura_saati"
    select = "$xml_belge/cbc:IssueTime"/>

  <xsl:variable
    name = "xml_belge_sevk_tarihi"
    select = "$xml_belge/cac:Shipment/cac:Delivery/cac:Despatch/cbc:ActualDespatchDate"/>

  <xsl:variable
    name = "xml_belge_sevk_saati"
    select = "$xml_belge/cac:Shipment/cac:Delivery/cac:Despatch/cbc:ActualDespatchTime"/>

  <xsl:variable
    name = "xml_belge_fatura_son_odeme_tarihi"
    select = "$xml_belge/cac:PaymentMeans/cbc:PaymentDueDate"/>

  <xsl:variable
    name = "xml_belge_ek_belge_basvurulari"
    select = "$xml_belge/cac:AdditionalDocumentReference"/>

  <xsl:variable
    name = "xml_belge_siparis_no_1"
    select = "$xml_belge/cac:OrderReference/cbc:ID"/>

  <xsl:variable
    name = "xml_belge_siparis_tarihi_1"
    select = "$xml_belge/cac:OrderReference/cbc:IssueDate"/>

  <xsl:variable
    name = "xml_fatura_satiri"
    select = "$xml_belge/cac:DespatchLine"/>

  <xsl:variable
    name = "xml_fatura_satiri_urun_hizmet"
    select = "$xml_fatura_satiri/cac:Item"/>

  <xsl:variable
    name = "xml_fatura_satiri_urun_hizmet_adi"
    select = "$xml_fatura_satiri_urun_hizmet/cbc:Name"/>

  <xsl:variable
    name = "xml_fatura_satiri_notu"
    select = "$xml_fatura_satiri/cbc:Note"/>

  <xsl:variable
    name = "deger_ayiraci"
    select = "':'"/>

  <xsl:variable
    name = "oge_ayiraci"
    select = "'|'"/>

  <xsl:variable
    name = "satir_ayiraci"
    select = "'//'"/>

  <xsl:variable
    name = "dil_tur"
    select = "'tur'"/>

  <xsl:variable
    name = "dil_ing"
    select = "'ing'"/>

  <xsl:variable
    name = "try"
    select = "'TRY'"/>

  <xsl:variable
    name = "trl"
    select = "'TRL'"/>

  <xsl:variable
    name = "degisken_ulke_kodu"
    select = "'#ULKE_KODU:'"/>

  <xsl:variable
    name = "degisken_seri_no"
    select = "'#SERI_NO:'"/>

  <xsl:variable
    name = "degisken_son_kullanma_tarihi"
    select = "'#SON_KULLANMA_TARIHI:'"/>

  <xsl:variable
    name = "degisken_vade_tarihi"
    select = "'#VADE_TARIHI:'"/>

  <xsl:variable
    name = "degisken_marka"
    select = "'#MARKA:'"/>

  <xsl:variable
    name = "degisken_model"
    select = "'#MODEL:'"/>

  <xsl:variable
    name = "degisken_renk"
    select = "'#RENK:'"/>

  <xsl:variable
    name = "degisken_boyut"
    select = "'#BOYUT:'"/>

  <xsl:variable
    name = "degisken_nitelik"
    select = "'#NITELIK:'"/>

  <xsl:variable
    name = "degisken_boyut_1"
    select = "'#BOYUT1:'"/>

  <xsl:variable
    name = "degisken_boyut_2"
    select = "'#BOYUT2:'"/>

  <xsl:variable
    name = "degisken_boyut_3"
    select = "'#BOYUT3:'"/>

  <xsl:variable
    name = "degisken_hacim"
    select = "'#HACIM:'"/>

  <xsl:variable
    name = "degisken_alan"
    select = "'#ALAN:'"/>

  <xsl:variable
    name = "degisken_ilk_birim"
    select = "'#ILK_BIRIM:'"/>

  <xsl:variable
    name = "degisken_on_birim"
    select = "'#ON_BIRIM:'"/>

  <xsl:variable
    name = "degisken_brut"
    select = "'#BRUT:'"/>

  <xsl:variable
    name = "degisken_brut_kg"
    select = "'#BRUT_KG:'"/>

  <xsl:variable
    name = "degisken_net"
    select = "'#NET:'"/>

  <xsl:variable
    name = "degisken_net_kg"
    select = "'#NET_KG:'"/>

  <xsl:variable
    name = "degisken_siparis_satir_no"
    select = "'#SS_Satir_NO'"/>

  <xsl:variable
    name = "degisken_ihracat_mensei"
    select = "'IHRACAT_MENSEI'"/>

  <xsl:variable
    name = "degisken_tasima_web_adresi"
    select = "'TASIMA_WEB_ADRESI'"/>

  <xsl:variable
    name = "degisken_tasima_odeme_aracisi"
    select = "'TASIMA_ODEME_ARACISI'"/>

  <xsl:variable
    name = "degisken_tasima_odeme_tipi"
    select = "'TASIMA_ODEME_TIPI'"/>

  <xsl:variable
    name = "degisken_tasima_odeme_tarihi"
    select = "'TASIMA_ODEME_TARIHI'"/>

  <xsl:variable
    name = "degisken_tasima_gonderim_tarihi"
    select = "'TASIMA_GONDERIM_TARIHI'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_vkn"
    select = "'TASIMA_KARGO_VKN'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_unvani"
    select = "'TASIMA_KARGO_UNVANI'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_subesi"
    select = "'TASIMA_KARGO_SUBESI'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_ilcesi"
    select = "'TASIMA_KARGO_ILCESI'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_ili"
    select = "'TASIMA_KARGO_ILI'"/>

  <xsl:variable
    name = "degisken_tasima_kargo_ulkesi"
    select = "'TASIMA_KARGO_ULKESI'"/>

  <xsl:variable
    name = "degisken_tasima_arac_plakasi"
    select = "'TASIMA_ARAC_PLAKASI'"/>

  <xsl:variable
    name = "degisken_tasima_dorse_plakasi"
    select = "'TASIMA_DORSE_PLAKASI'"/>

  <xsl:variable
    name = "degisken_tasima_surucu_1_tckn"
    select = "'TASIMA_SURUCU_1_TCKN'"/>

  <xsl:variable
    name = "degisken_tasima_surucu_1_adi_soyadi"
    select = "'TASIMA_SURUCU_1_ADI_SOYADI'"/>

  <xsl:variable
    name = "degisken_tasima_surucu_2_tckn"
    select = "'TASIMA_SURUCU_2_TCKN'"/>

  <xsl:variable
    name = "degisken_tasima_surucu_2_adi_soyadi"
    select = "'TASIMA_SURUCU_2_ADI_SOYADI'"/>

  <xsl:variable
    name = "bicim_yuzde"
    select = "'###.##0,####'"/>

  <xsl:variable
    name = "bicim_miktar_birim"
    select = "'###.##0,####'"/>

  <xsl:variable
    name = "bolge"
    select = "'european'"/>

  <xsl:variable
    name = "ys"
    select = "'&lt;br/&gt;'"/>

  <xsl:variable
    name = "renk_cizgi"
    select = "'#e8e8e8'"/>

  <xsl:variable
    name = "renk_odak"
    select = "'#c0c0c0'"/>

  <xsl:variable
    name = "renk_baslik_arka"
    select = "'#f5f5f5'"/>

  <xsl:variable name = "cizgi_satici_merkez" select = "0"/>
  <xsl:variable name = "cizgi_satici_sube" select = "0"/>
  <xsl:variable name = "cizgi_alici_merkez" select = "0"/>
  <xsl:variable name = "cizgi_alici_sube" select = "0"/>
  <xsl:variable name = "cizgi_belge" select = "1"/>
  <xsl:variable name = "cizgi_benzersiz" select = "1"/>
  <xsl:variable name = "cizgi_satirlar" select = "1"/>
  <xsl:variable name = "cizgi_ihracat" select = "1"/>
  <xsl:variable name = "cizgi_tasima" select = "1"/>
  <xsl:variable name = "cizgi_siparisler" select = "1"/>
  <xsl:variable name = "cizgi_notlar" select = "1"/>
  <xsl:variable name = "cizgi_iadeler" select = "1"/>
  <xsl:variable name = "cizgi_teslimat" select = "1"/>

  <xsl:variable name = "basliklar_sagda" select = "0"/>
  <xsl:variable name = "belge_bilgileri_solda" select = "0"/>
  <xsl:variable name = "kap_bilgileri_satirda" select = "1"/>
  <xsl:variable name = "kucult" select = "1"/>
  <xsl:variable name = "kucult_font" select = "1"/>
  <xsl:variable name = "sutun_sirasi_satirlar" select = "'stn_sira_no|stn_gtip_no|stn_parti_no|stn_satici_urun_hizmet_kodu|stn_alici_urun_hizmet_kodu|stn_urun_hizmet_adi|stn_urun_hizmet_markasi|stn_urun_hizmet_modeli|stn_miktar_birim|stn_ulke_kodu|stn_seri_no|stn_son_kullanma_tarihi|stn_vade_tarihi|stn_marka|stn_model|stn_renk|stn_boyut|stn_nitelik|stn_boyut_1|stn_boyut_2|stn_boyut_3|stn_hacim|stn_alan|stn_ilk_birim|stn_on_birim|stn_brut|stn_brut_kg|stn_net|stn_net_kg|stn_siparis_satir_no|'"/>

  <xsl:variable name = "tur" select = "1"/>
  <xsl:variable name = "ing">
    <xsl:choose>
      <xsl:when test = "$tur = 1">
        <xsl:value-of select = "0"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name = "satici_merkez">
    <xsl:choose>
      <xsl:when test = "$xml_satici_merkez">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "satici_merkez_unvan" select = "0"/>
  <xsl:variable name = "satici_merkez_kisi" select = "0"/>
  <xsl:variable name = "satici_merkez_adres" select = "0"/>
  <xsl:variable name = "satici_merkez_telefon" select = "0"/>
  <xsl:variable name = "satici_merkez_faks" select = "0"/>
  <xsl:variable name = "satici_merkez_eposta" select = "0"/>
  <xsl:variable name = "satici_merkez_web" select = "0"/>
  <xsl:variable name = "satici_merkez_vergi_dairesi" select = "0"/>
  <xsl:variable name = "satici_merkez_vkn" select = "0"/>
  <xsl:variable name = "satici_merkez_tckn" select = "0"/>
  <xsl:variable name = "satici_merkez_ticaret_sicil_no" select = "0"/>
  <xsl:variable name = "satici_merkez_mersis_no" select = "0"/>
  <xsl:variable name = "satici_merkez_mal_veren_no" select = "1"/>

  <xsl:variable name = "satici_sube">
    <xsl:choose>
      <xsl:when test = "$xml_satici_sube">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "satici_sube_unvan" select = "1"/>
  <xsl:variable name = "satici_sube_kisi" select = "1"/>
  <xsl:variable name = "satici_sube_adres" select = "1"/>
  <xsl:variable name = "satici_sube_telefon" select = "1"/>
  <xsl:variable name = "satici_sube_faks" select = "1"/>
  <xsl:variable name = "satici_sube_eposta" select = "1"/>
  <xsl:variable name = "satici_sube_web" select = "1"/>
  <xsl:variable name = "satici_sube_vergi_dairesi" select = "1"/>
  <xsl:variable name = "satici_sube_vkn" select = "1"/>
  <xsl:variable name = "satici_sube_tckn" select = "1"/>
  <xsl:variable name = "satici_sube_ticaret_sicil_no" select = "1"/>
  <xsl:variable name = "satici_sube_mersis_no" select = "1"/>
  <xsl:variable name = "satici_sube_mal_veren_no" select = "1"/>

  <xsl:variable name = "alici_merkez" select = "0"/>
  <xsl:variable name = "alici_merkez_unvan" select = "1"/>
  <xsl:variable name = "alici_merkez_kisi" select = "1"/>
  <xsl:variable name = "alici_merkez_adres" select = "1"/>
  <xsl:variable name = "alici_merkez_telefon" select = "1"/>
  <xsl:variable name = "alici_merkez_faks" select = "1"/>
  <xsl:variable name = "alici_merkez_eposta" select = "1"/>
  <xsl:variable name = "alici_merkez_web" select = "1"/>
  <xsl:variable name = "alici_merkez_vergi_dairesi" select = "1"/>
  <xsl:variable name = "alici_merkez_vkn" select = "1"/>
  <xsl:variable name = "alici_merkez_tckn" select = "1"/>
  <xsl:variable name = "alici_merkez_ticaret_sicil_no" select = "1"/>
  <xsl:variable name = "alici_merkez_mersis_no" select = "1"/>
  <xsl:variable name = "alici_merkez_bayi_no" select = "1"/>
  <xsl:variable name = "alici_merkez_sube_no" select = "1"/>
  <xsl:variable name = "alici_merkez_musteri_no" select = "1"/>

  <xsl:variable name = "alici_sube">
    <xsl:choose>
      <xsl:when test = "$xml_alici_sube">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "alici_sube_unvan" select = "0"/>
  <xsl:variable name = "alici_sube_kisi" select = "0"/>
  <xsl:variable name = "alici_sube_adres" select = "0"/>
  <xsl:variable name = "alici_sube_telefon" select = "0"/>
  <xsl:variable name = "alici_sube_faks" select = "0"/>
  <xsl:variable name = "alici_sube_eposta" select = "0"/>
  <xsl:variable name = "alici_sube_web" select = "0"/>
  <xsl:variable name = "alici_sube_vergi_dairesi" select = "0"/>
  <xsl:variable name = "alici_sube_vkn" select = "0"/>
  <xsl:variable name = "alici_sube_tckn" select = "0"/>
  <xsl:variable name = "alici_sube_ticaret_sicil_no" select = "0"/>
  <xsl:variable name = "alici_sube_mersis_no" select = "0"/>
  <xsl:variable name = "alici_sube_bayi_no" select = "0"/>
  <xsl:variable name = "alici_sube_sube_no" select = "0"/>
  <xsl:variable name = "alici_sube_musteri_no" select = "0"/>

  <xsl:variable name = "araci_kurum_unvani" select = "0"/>
  <xsl:variable name = "araci_kurum_vkn" select = "0"/>

  <xsl:variable name = "simge_gib" select = "1"/>
  <xsl:variable name = "simge_sirket" select = "1"/>
  <xsl:variable name = "simge_logo" select = "0"/>

  <xsl:variable name = "fatura_tipi" select = "1"/>

  <xsl:variable name = "belge" select = "1"/>
  <xsl:variable name = "belge_kare_kod_1" select = "1"/>
  <xsl:variable name = "belge_kare_kod_2" select = "1"/>
  <xsl:variable name = "belge_ozellestirme_no" select = "1"/>
  <xsl:variable name = "belge_senaryo" select = "1"/>
  <xsl:variable name = "belge_fatura_tipi" select = "1"/>
  <xsl:variable name = "belge_fatura_no" select = "1"/>
  <xsl:variable name = "belge_fatura_tarihi" select = "1"/>
  <xsl:variable name = "belge_fatura_saati" select = "1"/>
  <xsl:variable name = "belge_fatura_son_odeme_tarihi" select = "1"/>
  <xsl:variable name = "belge_sevk_tarihi" select = "1"/>
  <xsl:variable name = "belge_sevk_saati" select = "1"/>
  <xsl:variable name = "belge_siparis_1" select = "1"/>
  <xsl:variable name = "belge_siparis_no_1" select = "1"/>
  <xsl:variable name = "belge_siparis_tarihi_1" select = "1"/>
  <xsl:variable name = "belge_barkodu" select = "0"/>
  <xsl:variable name = "belge_barkodu_yazisi" select = "0"/>
  <xsl:variable name = "belge_siparis_sorumlusu" select = "0"/>

  <xsl:variable name = "benzersiz_no" select = "1"/>

  <xsl:variable name = "satirlar" select = "1"/>
  <xsl:variable name = "stn_sira_no" select = "1"/>
  <xsl:variable name = "stn_gtip_no" select = "0"/>
  <xsl:variable name = "stn_parti_no" select = "0"/>
  <xsl:variable name = "stn_satici_urun_hizmet_kodu" select = "0"/>
  <xsl:variable name = "stn_alici_urun_hizmet_kodu" select = "0"/>
  <xsl:variable name = "stn_urun_hizmet_adi">
    <xsl:choose>
      <xsl:when test = "count($xml_fatura_satiri_urun_hizmet_adi[text() != '']) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "stn_urun_hizmet_markasi" select = "0"/>
  <xsl:variable name = "stn_urun_hizmet_modeli" select = "0"/>
  <xsl:variable name = "stn_miktar_birim" select = "1"/>
  <xsl:variable name = "stn_ulke_kodu" select = "0"/>
  <xsl:variable name = "stn_seri_no" select = "0"/>
  <xsl:variable name = "stn_son_kullanma_tarihi" select = "0"/>
  <xsl:variable name = "stn_vade_tarihi" select = "0"/>
  <xsl:variable name = "stn_marka" select = "0"/>
  <xsl:variable name = "stn_model" select = "0"/>
  <xsl:variable name = "stn_renk" select = "0"/>
  <xsl:variable name = "stn_boyut" select = "0"/>
  <xsl:variable name = "stn_nitelik" select = "0"/>
  <xsl:variable name = "stn_boyut_1" select  ="0"/>
  <xsl:variable name = "stn_boyut_2" select = "0"/>
  <xsl:variable name = "stn_boyut_3" select = "0"/>
  <xsl:variable name = "stn_hacim" select = "0"/>
  <xsl:variable name = "stn_alan" select = "0"/>
  <xsl:variable name = "stn_ilk_birim" select = "0"/>
  <xsl:variable name = "stn_on_birim" select = "0"/>
  <xsl:variable name = "stn_brut" select = "0"/>
  <xsl:variable name = "stn_brut_kg" select = "0"/>
  <xsl:variable name = "stn_net" select = "0"/>
  <xsl:variable name = "stn_net_kg" select = "0"/>
  <xsl:variable name = "stn_siparis_satir_no" select = "0"/>

  <xsl:variable name = "stn_tne" select = "1"/>
  <xsl:variable name = "stn_nt" select = "1"/>
  <xsl:variable name = "stn_gt" select = "1"/>
  <xsl:variable name = "stn_kgm" select = "1"/>
  <xsl:variable name = "stn_grm" select = "1"/>
  <xsl:variable name = "stn_mgm" select = "1"/>
  <xsl:variable name = "stn_ktm" select = "1"/>
  <xsl:variable name = "stn_mtr" select = "1"/>
  <xsl:variable name = "stn_dmt" select = "1"/>
  <xsl:variable name = "stn_cmt" select = "1"/>
  <xsl:variable name = "stn_mmt" select = "1"/>
  <xsl:variable name = "stn_mtk" select = "1"/>
  <xsl:variable name = "stn_dmk" select = "1"/>
  <xsl:variable name = "stn_cmk" select = "1"/>
  <xsl:variable name = "stn_mmk" select = "1"/>
  <xsl:variable name = "stn_mtq" select = "1"/>
  <xsl:variable name = "stn_dmq" select = "1"/>
  <xsl:variable name = "stn_cmq" select = "1"/>
  <xsl:variable name = "stn_mmq" select = "1"/>
  <xsl:variable name = "stn_r9" select = "1"/>
  <xsl:variable name = "stn_ltr" select = "1"/>
  <xsl:variable name = "stn_dlt" select = "1"/>
  <xsl:variable name = "stn_clt" select = "1"/>
  <xsl:variable name = "stn_mlt" select = "1"/>
  <xsl:variable name = "stn_d40" select = "1"/>
  <xsl:variable name = "stn_lpa" select = "1"/>
  <xsl:variable name = "stn_niu" select = "1"/>
  <xsl:variable name = "stn_c62" select = "1"/>
  <xsl:variable name = "stn_pr" select = "1"/>
  <xsl:variable name = "stn_bx" select = "1"/>
  <xsl:variable name = "stn_pa" select = "1"/>
  <xsl:variable name = "stn_pg" select = "1"/>
  <xsl:variable name = "stn_set" select = "1"/>
  <xsl:variable name = "stn_bo" select = "1"/>
  <xsl:variable name = "stn_jr" select = "1"/>
  <xsl:variable name = "stn_ch" select = "1"/>
  <xsl:variable name = "stn_tp" select = "1"/>
  <xsl:variable name = "stn_t3" select = "1"/>
  <xsl:variable name = "stn_ncl" select = "1"/>
  <xsl:variable name = "stn_ctm" select = "1"/>
  <xsl:variable name = "stn_wtt" select = "1"/>
  <xsl:variable name = "stn_kwt" select = "1"/>
  <xsl:variable name = "stn_kwh" select = "1"/>
  <xsl:variable name = "stn_kjo" select = "1"/>
  <xsl:variable name = "stn_b32" select = "1"/>
  <xsl:variable name = "stn_d70" select = "1"/>
  <xsl:variable name = "stn_d30" select = "1"/>
  <xsl:variable name = "stn_ann" select = "1"/>
  <xsl:variable name = "stn_mon" select = "1"/>
  <xsl:variable name = "stn_wee" select = "1"/>
  <xsl:variable name = "stn_day" select = "1"/>
  <xsl:variable name = "stn_hur" select = "1"/>
  <xsl:variable name = "stn_d61" select = "1"/>
  <xsl:variable name = "stn_d62" select = "1"/>

  <xsl:variable name = "ihracat" select = "0"/>
  <xsl:variable name = "ihracat_mensei" select = "1"/>
  <xsl:variable name = "ihracat_teslim_sarti" select = "1"/>
  <xsl:variable name = "ihracat_gonderim_sekli" select = "1"/>
  <xsl:variable name = "ihracat_teslim_odeme_yeri" select = "1"/>
  <xsl:variable name = "ihracat_kap_markasi" select = "1"/>
  <xsl:variable name = "ihracat_kap_cinsi" select = "1"/>
  <xsl:variable name = "ihracat_kap_no" select = "1"/>
  <xsl:variable name = "ihracat_kap_sayisi" select = "1"/>

  <xsl:variable name = "tasima_web_adresi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_web_adresi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_odeme_aracisi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_odeme_aracisi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_odeme_tipi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_odeme_tipi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_odeme_tarihi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_odeme_tarihi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_gonderim_tarihi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_gonderim_tarihi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_vkn">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_vkn]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_unvani">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_unvani]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_subesi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_subesi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_ilcesi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_ilcesi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_ili">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_ili]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_kargo_ulkesi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_kargo_ulkesi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_arac_plakasi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_arac_plakasi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_dorse_plakasi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_dorse_plakasi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_surucu_1_tckn">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_surucu_1_tckn]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_surucu_1_adi_soyadi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_surucu_1_adi_soyadi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_surucu_2_tckn">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_surucu_2_tckn]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima_surucu_2_adi_soyadi">
    <xsl:choose>
      <xsl:when test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_tasima_surucu_2_adi_soyadi]) &gt; 0">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name = "tasima">
    <xsl:choose>
      <xsl:when test = "($tasima_web_adresi = 1) or ($tasima_odeme_aracisi = 1) or ($tasima_odeme_tipi = 1) or ($tasima_odeme_tarihi = 1) or ($tasima_gonderim_tarihi = 1) or ($tasima_kargo_vkn = 1) or ($tasima_kargo_unvani = 1) or ($tasima_kargo_ilcesi = 1) or ($tasima_kargo_ili = 1) or ($tasima_kargo_ulkesi = 1) or ($tasima_kargo_subesi = 1) or ($tasima_arac_plakasi = 1) or ($tasima_dorse_plakasi = 1) or ($tasima_surucu_1_tckn = 1) or ($tasima_surucu_1_adi_soyadi = 1) or ($tasima_surucu_2_tckn = 1) or ($tasima_surucu_2_adi_soyadi = 1)">
        <xsl:value-of select = "1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select = "0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name = "siparisler" select = "0"/>

  <xsl:variable name = "notlar" select = "1"/>
  <xsl:variable name = "yonerge_notu" select = "1"/>
  <xsl:variable name = "odeme_notu" select = "1"/>
  <xsl:variable name = "odeme_sarti" select = "1"/>
  <xsl:variable name = "metro_yalniz" select = "1"/>
  <xsl:variable name = "metro_fatura_kod_listesi" select = "1"/>
  <xsl:variable name = "metro_gumruk_kunyesi" select = "1"/>
  <xsl:variable name = "metro_borsa_tescili" select = "1"/>

  <xsl:variable name = "iadeler" select = "0"/>
  <xsl:variable name = "stn_iade_sira_no" select = "0"/>
  <xsl:variable name = "stn_iade_urun_adi" select = "0"/>
  <xsl:variable name = "stn_iade_miktar_birim" select = "0"/>
  <xsl:variable name = "stn_iade_nedeni" select = "0"/>

  <xsl:variable name = "teslimat" select = "0"/>
  <xsl:variable name = "stn_teslim_alan" select = "0"/>
  <xsl:variable name = "stn_teslim_eden" select = "0"/>

  <xsl:variable name = "orka" select = "1"/>

  <!--[ SATICI MERKEZ ]-->

  <xsl:variable name = "bas_satici_merkez"><![CDATA[Satıcı (Merkez)|Seller (HQ)]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_adres"><![CDATA[Adres|Address]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_telefon"><![CDATA[Telefon / Faks|Telephone / Fax]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_eposta"><![CDATA[E-Posta / Web|E-Mail / Web]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_vkn"><![CDATA[Vergi No / Dairesi|Tax No / Office]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_ticaret_sicil_no"><![CDATA[Tic. Sic. No|Trade Reg. No]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_mersis_no"><![CDATA[Mersis No|Central Registry No]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_bayi_no"><![CDATA[Bayi No|ReSeller No]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_mal_veren_no"><![CDATA[MalVeren Kodu|Merchant Code]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_sube_no"><![CDATA[Şube No|Branch No]]></xsl:variable>
  <xsl:variable name = "bas_satici_merkez_musteri_no"><![CDATA[Müşteri No|Customer No]]></xsl:variable>

  <!--[ SATICI ŞUBE ]-->

  <xsl:variable name = "bas_satici_sube"><![CDATA[Satıcı (Şube)|Seller (Branch)]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_adres"><![CDATA[Adres|Address]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_telefon"><![CDATA[Telefon / Faks|Telephone / Fax]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_eposta"><![CDATA[E-Posta / Web|E-Mail / Web]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_vkn"><![CDATA[Vergi No / Dairesi|Tax No / Office]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_ticaret_sicil_no"><![CDATA[Tic. Sic. No|Trade Reg. No]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_mersis_no"><![CDATA[Mersis No|Central Registry No]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_bayi_no"><![CDATA[Bayi No|ReSeller No]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_mal_veren_no"><![CDATA[MalVeren Kodu|Merchant Code]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_sube_no"><![CDATA[Şube No|Branch No]]></xsl:variable>
  <xsl:variable name = "bas_satici_sube_musteri_no"><![CDATA[Müşteri No|Customer No]]></xsl:variable>

  <!--[ ALICI MERKEZ ]-->

  <xsl:variable name = "bas_alici_merkez"><![CDATA[Alıcı (Merkez)|Buyer (HQ)]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_adres"><![CDATA[Adres|Address]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_telefon"><![CDATA[Telefon / Faks|Telephone / Fax]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_eposta"><![CDATA[E-Posta / Web|E-Mail / Web]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_vkn"><![CDATA[Vergi No / Dairesi|Tax No / Office]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_ticaret_sicil_no"><![CDATA[Tic. Sic. No|Trade Reg. No]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_mersis_no"><![CDATA[Mersis No|Central Registry No]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_bayi_no"><![CDATA[Bayi No|ReSeller No]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_mal_veren_no"><![CDATA[MalVeren Kodu|Merchant Code]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_sube_no"><![CDATA[Şube No|Branch No]]></xsl:variable>
  <xsl:variable name = "bas_alici_merkez_musteri_no"><![CDATA[Müşteri No|Customer No]]></xsl:variable>

  <!--[ ALICI ŞUBE ]-->

  <xsl:variable name = "bas_alici_sube"><![CDATA[Alıcı (Şube)|Buyer (HQ)]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_adres"><![CDATA[Adres|Address]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_telefon"><![CDATA[Telefon / Faks|Telephone / Fax]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_eposta"><![CDATA[E-Posta / Web|E-Mail / Web]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_vkn"><![CDATA[Vergi No / Dairesi|Tax No / Office]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_ticaret_sicil_no"><![CDATA[Tic. Sic. No|Trade Reg. No]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_mersis_no"><![CDATA[Mersis No|Central Registry No]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_bayi_no"><![CDATA[Bayi No|ReSeller No]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_mal_veren_no"><![CDATA[MalVeren Kodu|Merchant Code]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_sube_no"><![CDATA[Şube No|Branch No]]></xsl:variable>
  <xsl:variable name = "bas_alici_sube_musteri_no"><![CDATA[Müşteri No|Customer No]]></xsl:variable>

  <!--[ ARACI KURUM ]-->

  <xsl:variable name = "bas_araci_kurum_unvani"><![CDATA[Aracı Kurum|Intermediary Institution]]></xsl:variable>
  <xsl:variable name = "bas_araci_kurum_vkn"><![CDATA[Aracı Kurum Vergi No|Intermediary Institution Tax No]]></xsl:variable>

  <!--[ BELGE ]-->

  <xsl:variable name = "bas_ozellestirme_no"><![CDATA[Özelleştirme No|Customization No]]></xsl:variable>
  <xsl:variable name = "bas_belge_senaryo"><![CDATA[Senaryo|Profile]]></xsl:variable>
  <xsl:variable name = "bas_fatura_tipi"><![CDATA[İrsaliye Tipi|Despatch Advice Type]]></xsl:variable>
  <xsl:variable name = "bas_fatura_no"><![CDATA[İrsaliye No|Despatch Advice No]]></xsl:variable>
  <xsl:variable name = "bas_fatura_tarihi"><![CDATA[İrsaliye Tarihi|Issue Date]]></xsl:variable>
  <xsl:variable name = "bas_fatura_saati"><![CDATA[İrsaliye Saati|Issue Time]]></xsl:variable>
  <xsl:variable name = "bas_fatura_son_odeme_tarihi"><![CDATA[Son Ödeme Tarihi|Payment Due Date]]></xsl:variable>
  <xsl:variable name = "bas_belge_sevk_tarihi"><![CDATA[Fiili Sevk Tarihi|Actual Despatch Date]]></xsl:variable>
  <xsl:variable name = "bas_belge_sevk_saati"><![CDATA[Fiili Sevk Saati|Actual Despatch Time]]></xsl:variable>
  <xsl:variable name = "bas_siparis_no_1"><![CDATA[Sipariş No (1)|Order No (1)]]></xsl:variable>
  <xsl:variable name = "bas_siparis_tarihi_1"><![CDATA[Sipariş Tarihi (1)|Order Date (1)]]></xsl:variable>
  <xsl:variable name = "bas_siparis_sorumlusu"><![CDATA[Sipariş Sorumlusu|Order Staff]]></xsl:variable>

  <xsl:variable name = "bas_benzersiz_no"><![CDATA[ETTN|ETTN]]></xsl:variable>

  <xsl:variable name = "bas_sira_no"><![CDATA[Sıra//No|Seq.//No]]></xsl:variable>
  <xsl:variable name = "bas_gtip_no"><![CDATA[GTIP//No|GTIP//No]]></xsl:variable>
  <xsl:variable name = "bas_parti_no"><![CDATA[Parti//No|Party//No]]></xsl:variable>
  <xsl:variable name = "bas_satici_urun_hizmet_kodu"><![CDATA[Ürün / Hizmet//Satıcı Kodu|Item / Service//Seller's Code]]></xsl:variable>
  <xsl:variable name = "bas_alici_urun_hizmet_kodu"><![CDATA[Ürün / Hizmet//Alıcı Kodu|Item / Service//Buyer's Code]]></xsl:variable>
  <xsl:variable name = "bas_urun_hizmet_adi"><![CDATA[Ürün / Hizmet//Adı|Item / Service//Name]]></xsl:variable>
  <xsl:variable name = "bas_miktar_birim"><![CDATA[Miktar//Birim|Quantity//Unit]]></xsl:variable>
  <xsl:variable name = "bas_ulke_kodu"><![CDATA[Ülke//Kodu|Country//Code]]></xsl:variable>
  <xsl:variable name = "bas_seri_no"><![CDATA[Seri//No|Serial//No]]></xsl:variable>
  <xsl:variable name = "bas_son_kullanma_tarihi"><![CDATA[Son Kullanma//Tarihi|Expiry//Date]]></xsl:variable>
  <xsl:variable name = "bas_vade_tarihi"><![CDATA[Vâde//Tarihi|Due//Date]]></xsl:variable>
  <xsl:variable name = "bas_marka"><![CDATA[Marka|Brand]]></xsl:variable>
  <xsl:variable name = "bas_model"><![CDATA[Model|Model]]></xsl:variable>
  <xsl:variable name = "bas_renk"><![CDATA[Renk|Color]]></xsl:variable>
  <xsl:variable name = "bas_boyut"><![CDATA[Boyut|Size]]></xsl:variable>
  <xsl:variable name = "bas_nitelik"><![CDATA[Nitelik|Quality]]></xsl:variable>
  <xsl:variable name = "bas_boyut_1"><![CDATA[Boyut-1|Size-1]]></xsl:variable>
  <xsl:variable name = "bas_boyut_2"><![CDATA[Boyut-2|Size-2]]></xsl:variable>
  <xsl:variable name = "bas_boyut_3"><![CDATA[Boyut-3|Size-3]]></xsl:variable>
  <xsl:variable name = "bas_hacim"><![CDATA[Hacim|Volume]]></xsl:variable>
  <xsl:variable name = "bas_alan"><![CDATA[Alan|Field]]></xsl:variable>
  <xsl:variable name = "bas_ilk_birim"><![CDATA[İlk//Birim|First//Unit]]></xsl:variable>
  <xsl:variable name = "bas_on_birim"><![CDATA[Ön//Birim|Front//Unit]]></xsl:variable>
  <xsl:variable name = "bas_brut"><![CDATA[Brüt|Gross]]></xsl:variable>
  <xsl:variable name = "bas_brut_kg"><![CDATA[Brüt//KG|Gross//KG]]></xsl:variable>
  <xsl:variable name = "bas_net"><![CDATA[Net|Net]]></xsl:variable>
  <xsl:variable name = "bas_net_kg"><![CDATA[Net//KG|Net//KG]]></xsl:variable>
  <xsl:variable name = "bas_siparis_satir_no"><![CDATA[Sipariş//Satır No|Order//Row No]]></xsl:variable>

  <xsl:variable name = "bas_tne"><![CDATA[Ton|Tonne]]></xsl:variable>
  <xsl:variable name = "bas_nt"><![CDATA[Net Ton|Net Tonne]]></xsl:variable>
  <xsl:variable name = "bas_gt"><![CDATA[Brüt Ton|Gross Tonne]]></xsl:variable>
  <xsl:variable name = "bas_kgm"><![CDATA[KG|KG]]></xsl:variable>
  <xsl:variable name = "bas_grm"><![CDATA[G|G]]></xsl:variable>
  <xsl:variable name = "bas_mgm"><![CDATA[MG|MG]]></xsl:variable>
  <xsl:variable name = "bas_ktm"><![CDATA[KM|KM]]></xsl:variable>
  <xsl:variable name = "bas_mtr"><![CDATA[M|M]]></xsl:variable>
  <xsl:variable name = "bas_dmt"><![CDATA[DM|DM]]></xsl:variable>
  <xsl:variable name = "bas_cmt"><![CDATA[CM|CM]]></xsl:variable>
  <xsl:variable name = "bas_mmt"><![CDATA[MM|MM]]></xsl:variable>
  <xsl:variable name = "bas_mtk"><![CDATA[M2|M2]]></xsl:variable>
  <xsl:variable name = "bas_dmk"><![CDATA[DM2|DM2]]></xsl:variable>
  <xsl:variable name = "bas_cmk"><![CDATA[CM2|CM2]]></xsl:variable>
  <xsl:variable name = "bas_mmk"><![CDATA[MM2|MM2]]></xsl:variable>
  <xsl:variable name = "bas_mtq"><![CDATA[M3|M3]]></xsl:variable>
  <xsl:variable name = "bas_dmq"><![CDATA[DM3|DM3]]></xsl:variable>
  <xsl:variable name = "bas_cmq"><![CDATA[CM3|CM3]]></xsl:variable>
  <xsl:variable name = "bas_mmq"><![CDATA[MM3|MM3]]></xsl:variable>
  <xsl:variable name = "bas_r9"><![CDATA[1000 M3|1000 M3]]></xsl:variable>
  <xsl:variable name = "bas_ltr"><![CDATA[Lt|Lt]]></xsl:variable>
  <xsl:variable name = "bas_dlt"><![CDATA[DL|DL]]></xsl:variable>
  <xsl:variable name = "bas_clt"><![CDATA[CL|CL]]></xsl:variable>
  <xsl:variable name = "bas_mlt"><![CDATA[ML|ML]]></xsl:variable>
  <xsl:variable name = "bas_d40"><![CDATA[1000 Lt|1000 Lt]]></xsl:variable>
  <xsl:variable name = "bas_lpa"><![CDATA[Saf Alkol Lt|Pure Alcohol Lt]]></xsl:variable>
  <xsl:variable name = "bas_niu"><![CDATA[Adet|Piece(s)]]></xsl:variable>
  <xsl:variable name = "bas_c62"><![CDATA[Adet|Piece(s)]]></xsl:variable>
  <xsl:variable name = "bas_pr"><![CDATA[Çift|Pair(s)]]></xsl:variable>
  <xsl:variable name = "bas_bx"><![CDATA[Kutu|Box(es)]]></xsl:variable>
  <xsl:variable name = "bas_pa"><![CDATA[Paket|Pack(s)]]></xsl:variable>
  <xsl:variable name = "bas_pg"><![CDATA[Plaka|Plate(s)]]></xsl:variable>
  <xsl:variable name = "bas_set"><![CDATA[Set|Set(s)]]></xsl:variable>
  <xsl:variable name = "bas_bo"><![CDATA[Şişe|Bottle(s)]]></xsl:variable>
  <xsl:variable name = "bas_jr"><![CDATA[Kavanoz|Jar(s)]]></xsl:variable>
  <xsl:variable name = "bas_ch"><![CDATA[Konteyner|Container(s)]]></xsl:variable>
  <xsl:variable name = "bas_tp"><![CDATA[Deste|Deck(s)]]></xsl:variable>
  <xsl:variable name = "bas_t3"><![CDATA[1000 Adet|1000 Pieces]]></xsl:variable>
  <xsl:variable name = "bas_ncl"><![CDATA[Hücre Adet|Cell Piece(s)]]></xsl:variable>
  <xsl:variable name = "bas_ctm"><![CDATA[Karat|Carat(s)]]></xsl:variable>
  <xsl:variable name = "bas_wtt"><![CDATA[Watt|Watt(s)]]></xsl:variable>
  <xsl:variable name = "bas_kwt"><![CDATA[KW|KW]]></xsl:variable>
  <xsl:variable name = "bas_kwh"><![CDATA[KWH|KWH]]></xsl:variable>
  <xsl:variable name = "bas_kjo"><![CDATA[KJ|KJ]]></xsl:variable>
  <xsl:variable name = "bas_b32"><![CDATA[KG M2|KG M2]]></xsl:variable>
  <xsl:variable name = "bas_d70"><![CDATA[Kalori|Calorie(s)]]></xsl:variable>
  <xsl:variable name = "bas_d30"><![CDATA[Brüt Kalori|Gross Calorie(s)]]></xsl:variable>
  <xsl:variable name = "bas_ann"><![CDATA[Yıl|Year(s)]]></xsl:variable>
  <xsl:variable name = "bas_mon"><![CDATA[Ay|Month(s)]]></xsl:variable>
  <xsl:variable name = "bas_wee"><![CDATA[Hafta|Week(s)]]></xsl:variable>
  <xsl:variable name = "bas_day"><![CDATA[Gün|Day(s)]]></xsl:variable>
  <xsl:variable name = "bas_hur"><![CDATA[Saat|Hour(s)]]></xsl:variable>
  <xsl:variable name = "bas_d61"><![CDATA[Dakika|Minute(s)]]></xsl:variable>
  <xsl:variable name = "bas_d62"><![CDATA[Saniye|Second(s)]]></xsl:variable>
  <xsl:variable name = "bas_lm"><![CDATA[MetreTül|Linear Meter(s)]]></xsl:variable>
  
  <xsl:variable name = "bas_ihracat_mensei"><![CDATA[Menşei|Origin Country]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_teslim_sarti"><![CDATA[Teslim Şartı|Delivery Terms]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_gonderim_sekli"><![CDATA[Gönderim Şekli|Transport Mode]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_teslim_odeme_yeri"><![CDATA[Teslim / Ödeme Yeri|Delivery / Payment Address]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_kap_markasi"><![CDATA[Kap Markası|Package Brand]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_kap_cinsi"><![CDATA[Kap Cinsi|Package Type]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_kap_no"><![CDATA[Kap No|Package No]]></xsl:variable>
  <xsl:variable name = "bas_ihracat_kap_sayisi"><![CDATA[Kap Sayısı|Package Count]]></xsl:variable>

  <xsl:variable name = "bas_tasima_web_adresi"><![CDATA[Web Adresi|Web Address]]></xsl:variable>
  <xsl:variable name = "bas_tasima_odeme_aracisi"><![CDATA[Ödeme Aracısı|Payment GateWay]]></xsl:variable>
  <xsl:variable name = "bas_tasima_odeme_tipi"><![CDATA[Ödeme Tipi|Payment Type]]></xsl:variable>
  <xsl:variable name = "bas_tasima_odeme_tarihi"><![CDATA[Ödeme Tarihi|Payment Date]]></xsl:variable>
  <xsl:variable name = "bas_tasima_gonderim_tarihi"><![CDATA[Gönderim Tarihi|Sending Date]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_vkn"><![CDATA[Kargo V.K.N.|Cargo Tax No]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_unvani"><![CDATA[Kargo Unvanı|Cargo Title]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_subesi"><![CDATA[Kargo Şubesi|Cargo Branch]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_ilcesi"><![CDATA[Kargo İlçesi|Cargo District]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_ili"><![CDATA[Kargo İli|Cargo City]]></xsl:variable>
  <xsl:variable name = "bas_tasima_kargo_ulkesi"><![CDATA[Kargo İli|Cargo Country]]></xsl:variable>
  <xsl:variable name = "bas_tasima_arac_plakasi"><![CDATA[Araç Plakası|License Plate]]></xsl:variable>
  <xsl:variable name = "bas_tasima_dorse_plakasi"><![CDATA[Dorse Plakası|Trailer Plate]]></xsl:variable>
  <xsl:variable name = "bas_tasima_surucu_1_tckn"><![CDATA[Sürücü T.C.K.N. (1)|Driver Identification No (1)]]></xsl:variable>
  <xsl:variable name = "bas_tasima_surucu_1_adi_soyadi"><![CDATA[Sürücü Adı, SoyAdı (1)|Driver Name, LastName (1)]]></xsl:variable>
  <xsl:variable name = "bas_tasima_surucu_2_tckn"><![CDATA[Sürücü T.C.K.N. (2)|Driver Identification No (2)]]></xsl:variable>
  <xsl:variable name = "bas_tasima_surucu_2_adi_soyadi"><![CDATA[Sürücü Adı, SoyAdı (2)|Driver Name, LastName (2)]]></xsl:variable>

  <xsl:variable name = "bas_siparisler"><![CDATA[Siparişler|Orders]]></xsl:variable>

  <xsl:variable name = "bas_notlar"><![CDATA[Notlar|Notes]]></xsl:variable>
  <xsl:variable name = "bas_yonerge_notu"><![CDATA[Yönerge Notu|Instruction Note]]></xsl:variable>
  <xsl:variable name = "bas_odeme_notu"><![CDATA[Ödeme Notu|Payment Note]]></xsl:variable>
  <xsl:variable name = "bas_odeme_sarti"><![CDATA[Ödeme Şartı|Payment Term]]></xsl:variable>
  <xsl:variable name = "bas_metro_yalniz"><![CDATA[Yalnız|Only]]></xsl:variable>
  <xsl:variable name = "bas_metro_fatura_kod_listesi"><![CDATA[Fatura Kod Listesi|Invoice Code Liste]]></xsl:variable>
  <xsl:variable name = "bas_metro_gumruk_kunyesi"><![CDATA[Gümrük Künyesi|Customs Tag]]></xsl:variable>
  <xsl:variable name = "bas_metro_borsa_tescili"><![CDATA[Borsa Tescili|Stock Exchange Registry]]></xsl:variable>

  <xsl:variable name = "bas_iadeler"><![CDATA[İadeler|ReTurns]]></xsl:variable>
  <xsl:variable name = "bas_iade_sira_no"><![CDATA[Sıra//No|Seq.//No]]></xsl:variable>
  <xsl:variable name = "bas_iade_urun_adi"><![CDATA[Ürün//Adı|Item//Name]]></xsl:variable>
  <xsl:variable name = "bas_iade_miktar_birim"><![CDATA[Miktar//Birim|Quantity//Unit]]></xsl:variable>
  <xsl:variable name = "bas_iade_nedeni"><![CDATA[İade//Nedeni|ReTurn//Reason]]></xsl:variable>
  
  <xsl:variable name = "bas_teslim_alan"><![CDATA[Teslim Alan Kişi|Receiving Person]]></xsl:variable>
  <xsl:variable name = "bas_teslim_eden"><![CDATA[Teslim Eden Kişi|Delivery Person]]></xsl:variable>

  <xsl:template match = "/">
    <html>
      <head>
        <title>Orka</title>
        <style type = "text/css">
          @page {
            size: auto;
            margin: 40px;
            <xsl:choose>
              <xsl:when test = "$kucult_font = 0">
                font-size: 11pt;
              </xsl:when>
              <xsl:otherwise>
                font-size: 10pt;
              </xsl:otherwise>
            </xsl:choose>
            font-family: Calibri, 'Segoe UI', Tahoma, Arial, Sans-Serif;
          }
          @media print {
            @page {
              size: auto;
              margin: 40px;
              <xsl:choose>
                <xsl:when test = "$kucult_font = 0">
                  font-size: 11pt;
                </xsl:when>
                <xsl:otherwise>
                  font-size: 10pt;
                </xsl:otherwise>
              </xsl:choose>
              font-family: Calibri, 'Segoe UI', Tahoma, Arial, Sans-Serif;
            }
            html,
            body {
              size: auto;
              margin: 40px;
              <xsl:choose>
                <xsl:when test = "$kucult_font = 0">
                  font-size: 11pt;
                </xsl:when>
                <xsl:otherwise>
                  font-size: 10pt;
                </xsl:otherwise>
              </xsl:choose>
              font-family: Calibri, 'Segoe UI', Tahoma, Arial, Sans-Serif;
            }
            .yazdirma {
              display: none;
              visibility: hidden;
            }
            footer {
              page-break-after: avoid;
            }
          }
          * {
            margin: 0px;
            border: 0px;
            padding: 0px;
            white-space: nowrap;
          }
          html,
          body {
            size: auto;
            margin: 0px;
            <xsl:choose>
              <xsl:when test = "$kucult_font = 0">
                font-size: 11pt;
              </xsl:when>
              <xsl:otherwise>
                font-size: 10pt;
              </xsl:otherwise>
            </xsl:choose>
            font-family: Calibri, 'Segoe UI', Tahoma, Arial, Sans-Serif;
          }
          table {
            border-collapse: collapse;
          }
          th {
            text-align: right;
            font-weight: bold;
            vertical-align: top;
          }
          td {
            text-align: left;
            vertical-align: top;
          }
          a:link {
            color: #000000;
            text-decoration: none;
          }
          a:visited {
            color: #000000;
          }
          a:hover {
            color: #0000ff;
          }
          a:active {
            color: #800000;
          }
          #tbl_dis {
            width: 98%;
            margin-top: 10px;
            margin-left: 10px;
            margin-right: 10px;
            margin-bottom: 10px;
          }
          #tbl_ust_orta td {
            text-align: center;
          }
          #stn_ust_sol {
            width: 45%;
            min-width: 45%;
            max-width: 45%;
          }
          #stn_ust_sag {
            width: 40%;
            min-width: 40%;
            max-width: 40%;
          }
          #stn_ust_orta {
            width: 20%;
            min-width: 20%;
            max-width: 20%;
          }
          #tbl_satici_merkez,
          #tbl_satici_sube,
          #tbl_alici_merkez,
          #tbl_alici_sube {
            width: 100%;
            min-width: 100%;
            max-width: 100%;
          }
          <xsl:if test = "$satici_merkez = 1">
            <xsl:if test = "$satici_sube = 1">
              #hr_satici_sube {
                margin-top: 10px;
                margin-bottom: 10px;
                border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
              }
            </xsl:if>
          </xsl:if>
          <xsl:if test = "($satici_merkez = 1) or ($satici_sube = 1)">
            <xsl:if test = "$alici_merkez = 1">
              #hr_alici_merkez {
                margin-top: 10px;
                margin-bottom: 10px;
                border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
              }
            </xsl:if>
          </xsl:if>
          <xsl:if test = "($satici_merkez = 1) or ($satici_sube = 1) or ($alici_merkez = 1)">
            <xsl:if test = "$alici_sube = 1">
              #hr_alici_sube {
                margin-top: 10px;
                margin-bottom: 10px;
                border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
              }
            </xsl:if>
          </xsl:if>
          #tbl_belge {
            float: right;
          }
          #tbl_ihracat,
          #tbl_tasima,
          #tbl_tasima_2 {
            float: left;
          }
          <xsl:if test = "$cizgi_satici_merkez = 1">
            #tbl_satici_merkez {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_satici_sube = 1">
            #tbl_satici_sube {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_alici_merkez = 1">
            #tbl_alici_merkez {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_alici_sube = 1">
            #tbl_alici_sube {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_belge = 1">
            #tbl_belge {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_benzersiz = 1">
            #tbl_benzersiz {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_satirlar = 1">
            #tbl_satirlar {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_ihracat = 1">
            #tbl_ihracat {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_tasima = 1">
            #tbl_tasima,
            #tbl_tasima_2 {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_siparisler = 1">
            #tbl_siparisler {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          #tbl_notlar {
            <xsl:if test = "$kucult = 1">
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          <xsl:if test = "$cizgi_iadeler = 1">
            #tbl_iadeler {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          <xsl:if test = "$cizgi_teslimat = 1">
            #tbl_teslimat {
              border: 2px solid <xsl:value-of select = "$renk_cizgi"/>;
            }
          </xsl:if>
          #tbl_satirlar,
          #tbl_benzersiz {
            width: 100%;
            min-width: 100%;
            max-width: 100%;
            margin-top: 20px;
          }
          #tbl_siparisler,
          #tbl_notlar,
          #tbl_iadeler,
          #tbl_teslimat {
            width: 100%;
            min-width: 100%;
            max-width: 100%;
            margin-top: 10px;
          }
          #tbl_ihracat,
          #tbl_tasima,
          #tbl_tasima_2 {
            margin-top: 10px;
            margin-right: 10px;
            margin-bottom: 10px;
          }
          #tbl_satici_merkez th,
          #tbl_satici_merkez td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_satici_merkez = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_satici_sube th,
          #tbl_satici_sube td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_satici_sube = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_alici_merkez th,
          #tbl_alici_merkez td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_alici_merkez = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_alici_sube th,
          #tbl_alici_sube td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_alici_sube = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_belge th,
          #tbl_belge td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_belge = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_benzersiz th,
          #tbl_benzersiz td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_benzersiz = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_satirlar th,
          #tbl_satirlar td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_satirlar = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_ihracat th,
          #tbl_ihracat td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_ihracat = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }          
          #tbl_tasima th,
          #tbl_tasima td,
          #tbl_tasima_2 th,
          #tbl_tasima_2 td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_tasima = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_siparisler th,
          #tbl_siparisler td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_siparisler = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_siparisler span {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            margin-left: 2px;
            margin-bottom: 2px;
            <xsl:if test = "$cizgi_siparisler = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_notlar th,
          #tbl_notlar td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_notlar = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_iadeler th,
          #tbl_iadeler td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_iadeler = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          #tbl_teslimat th,
          #tbl_teslimat td {
            <xsl:choose>
              <xsl:when test = "$kucult = 0">
                padding: 4px 8px 4px 8px;
              </xsl:when>
              <xsl:otherwise>
                padding: 2px 4px 2px 4px;
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test = "$cizgi_teslimat = 1">
              border: 1px solid <xsl:value-of select = "$renk_cizgi"/>;
            </xsl:if>
          }
          <xsl:if test = "$belge_bilgileri_solda = 0">
            #tbl_belge td {
              text-align: right;
            }
          </xsl:if>
          #tbl_belge .barkod,
          #tbl_belge .barkod_yazisi {
            text-align: center;
            font-size: 12pt;
          }
          #tbl_satici_merkez:hover,
          #tbl_satici_merkez:hover th,
          #tbl_satici_merkez:hover td,
          #tbl_satici_sube:hover,
          #tbl_satici_sube:hover th,
          #tbl_satici_sube:hover td,
          #tbl_alici_merkez:hover,
          #tbl_alici_merkez:hover th,
          #tbl_alici_merkez:hover td,
          #tbl_alici_sube:hover,
          #tbl_alici_sube:hover th,
          #tbl_alici_sube:hover td,
          #tbl_belge:hover,
          #tbl_belge:hover th,
          #tbl_belge:hover td,
          #tbl_benzersiz:hover,
          #tbl_benzersiz:hover th,
          #tbl_benzersiz:hover td,
          #tbl_satirlar:hover,
          #tbl_satirlar:hover th,
          #tbl_satirlar:hover td,
          #tbl_ihracat:hover,
          #tbl_ihracat:hover th,
          #tbl_ihracat:hover td,
          #tbl_tasima:hover,
          #tbl_tasima:hover th,
          #tbl_tasima:hover td,
          #tbl_tasima_2:hover,
          #tbl_tasima_2:hover th,
          #tbl_tasima_2:hover td,
          #tbl_siparisler:hover,
          #tbl_siparisler:hover th,
          #tbl_siparisler:hover td,
          #tbl_siparisler:hover span,
          #tbl_notlar:hover,
          #tbl_notlar:hover th,
          #tbl_notlar:hover td,
          #tbl_iadeler:hover,
          #tbl_iadeler:hover th,
          #tbl_iadeler:hover td,
          #tbl_teslimat:hover,
          #tbl_teslimat:hover th,
          #tbl_teslimat:hover td {
            border-color: <xsl:value-of select = "$renk_odak"/>;
          }
          #tbl_satici_merkez:hover,
          #tbl_satici_merkez tr:hover,
          #tbl_satici_merkez tr:hover th,
          #tbl_satici_merkez tr:hover td,
          #tbl_satici_sube:hover,
          #tbl_satici_sube tr:hover,
          #tbl_satici_sube tr:hover th,
          #tbl_satici_sube tr:hover td,
          #tbl_alici_merkez tr:hover,
          #tbl_alici_merkez tr:hover th,
          #tbl_alici_merkez tr:hover td,
          #tbl_alici_sube tr:hover,
          #tbl_alici_sube tr:hover th,
          #tbl_alici_sube tr:hover td,
          #tbl_belge tr:hover,
          #tbl_belge tr:hover th,
          #tbl_belge tr:hover td,
          #tbl_benzersiz tr:hover,
          #tbl_benzersiz tr:hover th,
          #tbl_benzersiz tr:hover td,
          #tbl_satirlar tr:hover,
          #tbl_satirlar tr:hover th,
          #tbl_satirlar tr:hover td,
          #tbl_ihracat tr:hover,
          #tbl_ihracat tr:hover th,
          #tbl_ihracat tr:hover td,
          #tbl_tasima tr:hover,
          #tbl_tasima tr:hover th,
          #tbl_tasima tr:hover td,
          #tbl_tasima_2 tr:hover,
          #tbl_tasima_2 tr:hover th,
          #tbl_tasima_2 tr:hover td,
          #tbl_siparisler tr:hover,
          #tbl_siparisler tr:hover th,
          #tbl_siparisler tr:hover td,
          #tbl_siparisler tr:hover span,
          #tbl_notlar tr:hover,
          #tbl_notlar tr:hover th,
          #tbl_notlar tr:hover td,
          #tbl_iadeler tr:hover,
          #tbl_iadeler tr:hover th,
          #tbl_iadeler tr:hover td,
          #tbl_teslimat tr:hover,
          #tbl_teslimat tr:hover th,
          #tbl_teslimat tr:hover td {
            background-color: #fff8dc;
          }
          #tbl_satici_merkez tr:hover th:hover,
          #tbl_satici_merkez tr:hover td:hover,
          #tbl_satici_sube tr:hover th:hover,
          #tbl_satici_sube tr:hover td:hover,
          #tbl_alici_merkez tr:hover th:hover,
          #tbl_alici_merkez tr:hover td:hover,
          #tbl_alici_sube tr:hover th:hover,
          #tbl_alici_sube tr:hover td:hover,
          #tbl_belge tr:hover th:hover,
          #tbl_belge tr:hover td:hover,
          #tbl_benzersiz tr:hover th:hover,
          #tbl_benzersiz tr:hover td:hover,
          #tbl_satirlar tr:hover th:hover,
          #tbl_satirlar tr:hover td:hover,
          #tbl_ihracat tr:hover th:hover,
          #tbl_ihracat tr:hover td:hover,
          #tbl_tasima tr:hover th:hover,
          #tbl_tasima tr:hover td:hover,
          #tbl_tasima_2 tr:hover th:hover,
          #tbl_tasima_2 tr:hover td:hover,
          #tbl_siparisler tr:hover th:hover,
          #tbl_siparisler tr:hover span:hover,
          #tbl_notlar tr:hover th:hover,
          #tbl_notlar tr:hover td:hover,
          #tbl_iadeler tr:hover th:hover,
          #tbl_iadeler tr:hover td:hover,
          #tbl_teslimat tr:hover th:hover,
          #tbl_teslimat tr:hover td:hover {
            background-color: #f0e68c;
          }
          #simge_gib {
            max-width: 102px;
            max-height: 100px;
            margin-left: 10px;
            margin-right: 10px;
          }
          #simge_sirket {
            max-width: 320px;
            max-height: 320px;
            margin-bottom: 20px;
          }
          #simge_logo {
            /*
            max-width: 920px;
            max-height: 320px;
            */
            margin-bottom: 10px;
          }
          #simge_kare_kod_1,
          #simge_kare_kod_2 {
            min-width: 136px;
            max-width: 136px;
            min-height: 136px;
            max-height: 136px;
          }
          #fatura_tipi {
            font-size: 14pt;
            font-weight: bold;
            margin-left: 10px;
            margin-right: 10px;
            text-align: center;
          }
          .secilemez {
            user-select: none;
            -ms-user-select: none;
            -moz-user-select: none;
            -webkit-user-select: none;
          }
          .bas_satici_merkez,
          #tbl_satici_merkez .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_satici_merkez = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_satici_merkez = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          .bas_satici_sube,
          #tbl_satici_sube .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_satici_sube = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_satici_sube = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          .bas_alici_merkez,
          #tbl_alici_merkez .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_alici_merkez = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_alici_merkez = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          .bas_alici_sube,
          #tbl_alici_sube .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_alici_sube = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_alici_sube = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_satirlar .bas_yatay {
            <xsl:choose>
              <xsl:when test = "($cizgi_satirlar = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_satirlar = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_ihracat .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_ihracat = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_ihracat = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_tasima .bas_yatay,
          #tbl_tasima_2 .bas_yatay {
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
            <xsl:choose>
              <xsl:when test = "($cizgi_tasima = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_tasima = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_siparisler .bas_yatay {
            <xsl:choose>
              <xsl:when test = "($cizgi_siparisler = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_siparisler = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_notlar .bas_yatay {
            text-align: left;
            <xsl:choose>
              <xsl:when test = "($cizgi_notlar = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_notlar = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_iadeler .bas_yatay {
            <xsl:choose>
              <xsl:when test = "($cizgi_iadeler = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_iadeler = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          #tbl_teslimat .bas_yatay {
            <xsl:choose>
              <xsl:when test = "($cizgi_teslimat = 0) and ($kucult = 0)">
                border-bottom: 1px solid <xsl:value-of select = "$renk_odak"/>;
              </xsl:when>
              <xsl:when test = "$cizgi_teslimat = 1">
                background-color: <xsl:value-of select = "$renk_baslik_arka"/>;
              </xsl:when>
            </xsl:choose>
          }
          .bas_dikey {
            width: 100px;
            min-width: 100px;
            white-space: nowrap;
            <xsl:if test = "$basliklar_sagda = 0">
              text-align: left;
            </xsl:if>
          }
          .stn_urun_hizmet_adi,
          .stn_iade_urun_adi,
          .stn_iade_nedeni,
          .stn_urun_hizmet_markasi,
          .stn_urun_hizmet_modeli,
          .stn_aciklama {
            white-space: normal;
          }
          .stn_gtip_no,
          .stn_parti_no,
          .stn_satici_urun_hizmet_kodu,
          .stn_alici_urun_hizmet_kodu,
          .stn_urun_hizmet_adi,
          .stn_urun_hizmet_markasi,
          .stn_urun_hizmet_modeli,
          .stn_ulke_kodu,
          .stn_seri_no,
          .stn_son_kullanma_tarihi,
          .stn_vade_tarihi,
          .stn_marka,
          .stn_model,
          .stn_renk,
          .stn_boyut,
          .stn_nitelik,
          .stn_boyut_1,
          .stn_boyut_2,
          .stn_boyut_3,
          .stn_hacim,
          .stn_alan,
          .stn_ilk_birim,
          .stn_on_birim,
          .stn_brut,
          .stn_brut_kg,
          .stn_net,
          .stn_net_kg,
          .stn_iade_miktar_birim,
          .stn_iade_urun_adi,
          .stn_iade_nedeni {
            text-align: left;
          }
          .stn_sira_no,
          .stn_siparis_satir_no,
          .stn_iade_sira_no,
          .stn_miktar_birim {
            text-align: right;
          }
          .stn_sira_no,
          .stn_iade_sira_no,
          .stn_gtip_no,
          .stn_parti_no,
          .stn_satici_urun_hizmet_kodu,
          .stn_alici_urun_hizmet_kodu,
          .stn_miktar_birim,
          .stn_ulke_kodu,
          .stn_seri_no,
          .stn_son_kullanma_tarihi,
          .stn_vade_tarihi,
          .stn_marka,
          .stn_model,
          .stn_renk,
          .stn_boyut,
          .stn_nitelik,
          .stn_boyut_1,
          .stn_boyut_2,
          .stn_boyut_3,
          .stn_hacim,
          .stn_alan,
          .stn_ilk_birim,
          .stn_on_birim,
          .stn_brut,
          .stn_brut_kg,
          .stn_net,
          .stn_net_kg,
          .stn_siparis_satir_no,
          .stn_iade_miktar_birim {
            width: 20px;
            min-width: 20px;
          }
        </style>
      </head>
      <body class = "secilemez" unselectable = "on">
        <table id = "tbl_dis">
          <tbody>
            <tr>
              <xsl:if test = "($simge_sirket = 1) or ($satici_merkez = 1) or ($satici_sube = 1) or ($alici_merkez = 1) or ($alici_sube = 1)">
                <td id = "stn_ust_sol">
                  <xsl:if test = "$simge_sirket = 1">
                    <img id = "simge_sirket" src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAANEAAAA8CAIAAAB3gsjkAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAABh0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMS41ZEdYUgAAAKZJREFUeF7t0jEBAAAMw6D5N925yAUauEHLOWrOUXOOmnPUnKPmHDXnqDlHzTlqzlFzjppz1Jyj5hw156g5R805as5Rc46ac9Sco+YcNeeoOUfNOWrOUXOOmnPUnKPmHDXnqDlHzTlqzlFzjppz1Jyj5hw156g5R805as5Rc46ac9Sco+YcNeeoOUfNOWrOUXOOmnPUnKPmHDXnqDlHzTlqzlFzjtb2+BNpm2xGnz4AAAAASUVORK5CYII="/>
                  </xsl:if>
                  <xsl:if test = "$satici_merkez = 1">
                    <xsl:call-template name = "taraf_goruntule">
                      <xsl:with-param name = "taraf" select = "$xml_satici_merkez"/>
                      <xsl:with-param name = "tablo" select = "'satici_merkez'"/>
                      <xsl:with-param name = "unvan" select = "$satici_merkez_unvan"/>
                      <xsl:with-param name = "adres" select = "$satici_merkez_adres"/>
                      <xsl:with-param name = "telefon" select = "$satici_merkez_telefon"/>
                      <xsl:with-param name = "faks" select = "$satici_merkez_faks"/>
                      <xsl:with-param name = "eposta" select = "$satici_merkez_eposta"/>
                      <xsl:with-param name = "web" select = "$satici_merkez_web"/>
                      <xsl:with-param name = "vergi_dairesi" select = "$satici_merkez_vergi_dairesi"/>
                      <xsl:with-param name = "vkn" select = "$satici_merkez_vkn"/>
                      <xsl:with-param name = "tckn" select = "$satici_merkez_tckn"/>
                      <xsl:with-param name = "ticaret_sicil_no" select = "$satici_merkez_ticaret_sicil_no"/>
                      <xsl:with-param name = "mersis_no" select = "$satici_merkez_mersis_no"/>
                      <xsl:with-param name = "bayi_no" select = "0"/>
                      <xsl:with-param name = "sube_no" select = "0"/>
                      <xsl:with-param name = "musteri_no" select = "0"/>
                      <xsl:with-param name = "mal_veren_no" select = "$satici_merkez_mal_veren_no"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test = "$satici_sube = 1">
                    <xsl:call-template name = "taraf_goruntule">
                      <xsl:with-param name = "taraf" select = "$xml_satici_sube"/>
                      <xsl:with-param name = "tablo" select = "'satici_sube'"/>
                      <xsl:with-param name = "unvan" select = "$satici_sube_unvan"/>
                      <xsl:with-param name = "adres" select = "$satici_sube_adres"/>
                      <xsl:with-param name = "telefon" select = "$satici_sube_telefon"/>
                      <xsl:with-param name = "faks" select = "$satici_sube_faks"/>
                      <xsl:with-param name = "eposta" select = "$satici_sube_eposta"/>
                      <xsl:with-param name = "web" select = "$satici_sube_web"/>
                      <xsl:with-param name = "vergi_dairesi" select = "$satici_sube_vergi_dairesi"/>
                      <xsl:with-param name = "vkn" select = "$satici_sube_vkn"/>
                      <xsl:with-param name = "tckn" select = "$satici_sube_tckn"/>
                      <xsl:with-param name = "ticaret_sicil_no" select = "$satici_sube_ticaret_sicil_no"/>
                      <xsl:with-param name = "mersis_no" select = "$satici_sube_mersis_no"/>
                      <xsl:with-param name = "bayi_no" select = "0"/>
                      <xsl:with-param name = "sube_no" select = "0"/>
                      <xsl:with-param name = "musteri_no" select = "0"/>
                      <xsl:with-param name = "mal_veren_no" select = "$satici_sube_mal_veren_no"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test = "$alici_merkez = 1">
                    <xsl:call-template name = "taraf_goruntule">
                      <xsl:with-param name = "taraf" select = "$xml_alici_merkez"/>
                      <xsl:with-param name = "tablo" select = "'alici_merkez'"/>
                      <xsl:with-param name = "unvan" select = "$alici_merkez_unvan"/>
                      <xsl:with-param name = "adres" select = "$alici_merkez_adres"/>
                      <xsl:with-param name = "telefon" select = "$alici_merkez_telefon"/>
                      <xsl:with-param name = "faks" select = "$alici_merkez_faks"/>
                      <xsl:with-param name = "eposta" select = "$alici_merkez_eposta"/>
                      <xsl:with-param name = "web" select = "$alici_merkez_web"/>
                      <xsl:with-param name = "vergi_dairesi" select = "$alici_merkez_vergi_dairesi"/>
                      <xsl:with-param name = "vkn" select = "$alici_merkez_vkn"/>
                      <xsl:with-param name = "tckn" select = "$alici_merkez_tckn"/>
                      <xsl:with-param name = "ticaret_sicil_no" select = "$alici_merkez_ticaret_sicil_no"/>
                      <xsl:with-param name = "mersis_no" select = "$alici_merkez_mersis_no"/>
                      <xsl:with-param name = "bayi_no" select = "$alici_merkez_bayi_no"/>
                      <xsl:with-param name = "sube_no" select = "$alici_merkez_sube_no"/>
                      <xsl:with-param name = "musteri_no" select = "$alici_merkez_musteri_no"/>
                      <xsl:with-param name = "mal_veren_no" select = "0"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test = "$alici_sube = 1">
                    <xsl:call-template name = "taraf_goruntule">
                      <xsl:with-param name = "taraf" select = "$xml_alici_sube"/>
                      <xsl:with-param name = "tablo" select = "'alici_sube'"/>
                      <xsl:with-param name = "unvan" select = "$alici_sube_unvan"/>
                      <xsl:with-param name = "adres" select = "$alici_sube_adres"/>
                      <xsl:with-param name = "telefon" select = "$alici_sube_telefon"/>
                      <xsl:with-param name = "faks" select = "$alici_sube_faks"/>
                      <xsl:with-param name = "eposta" select = "$alici_sube_eposta"/>
                      <xsl:with-param name = "web" select = "$alici_sube_web"/>
                      <xsl:with-param name = "vergi_dairesi" select = "$alici_sube_vergi_dairesi"/>
                      <xsl:with-param name = "vkn" select = "$alici_sube_vkn"/>
                      <xsl:with-param name = "tckn" select = "$alici_sube_tckn"/>
                      <xsl:with-param name = "ticaret_sicil_no" select = "$alici_sube_ticaret_sicil_no"/>
                      <xsl:with-param name = "mersis_no" select = "$alici_sube_mersis_no"/>
                      <xsl:with-param name = "bayi_no" select = "0"/>
                      <xsl:with-param name = "sube_no" select = "0"/>
                      <xsl:with-param name = "musteri_no" select = "0"/>
                      <xsl:with-param name = "mal_veren_no" select = "0"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
              </xsl:if>
              <td id = "stn_ust_orta">
                <table id = "tbl_ust_orta" align = "center">
                  <tbody>
                    <xsl:if test = "$simge_gib = 1">
                      <tr>
                        <td>
                          <a href = "http://www.gib.gov.tr" target = "_blank">
                            <img id = "simge_gib" src = "data:image/jpeg;base64,/9j/4QAYRXhpZgAASUkqAAgAAAAAAAAAAAAAAP/sABFEdWNreQABAAQAAABkAAD/4QMZaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLwA8P3hwYWNrZXQgYmVnaW49Iu+7vyIgaWQ9Ilc1TTBNcENlaGlIenJlU3pOVGN6a2M5ZCI/PiA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJBZG9iZSBYTVAgQ29yZSA1LjYtYzEzMiA3OS4xNTkyODQsIDIwMTYvMDQvMTktMTM6MTM6NDAgICAgICAgICI+IDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+IDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdFJlZj0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlUmVmIyIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjZDNDJBNEI2QjVCRDExRThCQjM0REIwQkZGMEQxODY0IiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjZDNDJBNEI1QjVCRDExRThCQjM0REIwQkZGMEQxODY0IiB4bXA6Q3JlYXRvclRvb2w9IkFkb2JlIFBob3Rvc2hvcCBDUzQgV2luZG93cyI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSIzREVENkU1N0FDREVDNEJBNzkxNUM2M0NCN0RENzM0NyIgc3RSZWY6ZG9jdW1lbnRJRD0iM0RFRDZFNTdBQ0RFQzRCQTc5MTVDNjNDQjdERDczNDciLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7/7gAOQWRvYmUAZMAAAAAB/9sAhAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAgICAgICAgICAgIDAwMDAwMDAwMDAQEBAQEBAQIBAQICAgECAgMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwP/wAARCABmAGkDAREAAhEBAxEB/8QAtwAAAgMAAQUBAAAAAAAAAAAACAkABwoGAQIEBQsDAQABBAIDAQAAAAAAAAAAAAAGAAQFBwgJAQIDChAAAAYBAwMCAwUHAwQDAAAAAQIDBAUGBwARCCESExQJMSIVQVEyIxbwYXGBoRcKkbHB0VIzJEI0JxEAAgECBAIHBAcGBAQHAAAAAQIDEQQAIRIFMQZBUWEiMhMHcYEUCJGhscFCIxXw0VJiMwlyU3Mk4YKiFtJDg9NUJRf/2gAMAwEAAhEDEQA/AN/GlhYmlhYmlhYprMnILDXH6BJYsvZDrlKZOD+CLZyb0hpywPTbAlGVqutgXnLFKLGMAEbsm66xhH8O3XUjtu1bhu0/kWMZdqVJqAB7SSAPpz6MNbi8t7ZdUzU9x+4HA4o8kORGWa9LT+DePCmO6yyKdRtkLl3KymIGT1gkQyzmaj8bRUJZMgpxaDb80DzKUEYwFEDFKUO/Up+k7VY0ivrlpL6tDDFHqoa+EyaqV7AD1YbC4u7gFoUCRUyYkfTpp9uB4XuHJG15XisNWf3DMc48v1hWZNoiAwjxNeSVZdyEtT5HIUbVm+XMqSF7obu5vaBEOJpCMI7byq0UT1hGfpzEOM2YNtG1ncYtnY28dSztcnXQOIy5irrCCRhHr0aNZ0atWWGzC4acQPcjWeHcyrStK8K0FaVrTOlMAhycznyH475S5B48ccs+TFun8Y4wr9uxikwDAMAXLN/ev8TtLLTE45fBsjFViNrTHM8PKKujLuVPpyL9UUCpMjrGK9i2PZd6sbO9+GjiinuCkpLFhDHSUrJ0FyxgkULQd7QNRLgCPupJ7aSSLWWZUquXiPdqOoU1Ka55VNKDBeROQOVddttBx7Ec9q/KZCvdLirdCVjkdxCVSo8uuvQ3eSJesQOZsXp4qrMpLRFSinr9fsO4XQZtV1ToGMgskmNGz2trWa9/SxJaxSFWZLo60GsRqzQhtSguVUErp1MBU1FX2q4jdUE5EjCoBTI5EkBiKEgAmnGg7McrxB7hXJFxUavdMr8RZ/ItFtGPqXlJnkPig7l7+6aUTISEm6p07N4juUPUrwU8ywiFXXpIVaedpIGIfxGTUTOdpuPKu3W7vbx3ax7kk0kRhZSQJI2AdPNqF7tfERQnu1qDjm33G7Kh5Iy0BUNqqB3TmDQD9uOGB4L5RYF5KRTqSw3kmvW5zFH8FirJF1Iu71F6XYqkdcKRLpMbVVn6Rx7RSetEDCPw3DqItuWz7ltThL2Mx1FQahgfeCRXs48MsxiTt723uFDRNU+/7wMX/qNw6xNLCxNLCxNLCxNLCx0H/YP266WFhdeU+WVtyLklbjjxHcVBe7lmVqneM73h0iOMcXT6UU9mpGp1eHFyye5nzJHV5gvIfpyMWIixaoHWkXTVMuxjOy5fgsbH9Y34P5QXUkKhiZFqFJaRCfKAZ08YFSQtQTiHnvJLiQW1kQGJzbLLp8LDPgeHtwAY3zGuPWrm54PreUs88nJeWjJcnKnLVLYZDtmUMVQl2PRM2XHjTBsnFkNCRuGbOo2aT9dY16OexUWqeRTiZYiBBWKfgbu90W27yQwbLGrBbcPp8iVo/MhjnkKJQTqC0beYUZqIXjOas0MUA1QBnuSRV6eJQaMyrU+AnvClQMwG6T6s+Icoc0OH9HcWyfmsF8h1KraWjO0hVLDXooXVgjLBjm1Gs+JJqZZTDjHeVqY6Uepwc2ZrMRZHjNydKPlmJU24rBuNhyzzHKIES72bzFqmtWailZF0TBSolicBfMjBR9LKC8TnVJNDLe2S6iY7mhzoQMwVNVr4WGek5ioOTDK4obhjhyFzND55YJ2COv7CEpsVLhBygQkBaHlCqTukViWnWrRuM24COrT0W304JEIhyVBso5auFmrdVOMk5k3KXbG2lyjWZZyuoamQSOHYKT3RVhXVp1irBWAZgXAsoVmFwKiSg4ZA0FBXp4dFacMshjzsm8LuN+Xrn/cK+Y+JMXAz6wSSk0E5YW6yj6zYlfYQklwboygM2/8A+dPzNkiIppJpOk0ngF9WkRcvFjzNvW3Wxs7SbTbFVXTpU5LMJwMxX+qAanMiq+EkYUtlbTOJJFq4JNaniVKH/pNPr44q+1+3dhGXkbnYqhK3jG9st1TyBWUp+vSzKRWr7zI2J4TDExaYn9RxsrIFsDClVxmRiY7oUGiyZjppgCyxVHtvzhukSRQ3KxT28UkbaWBAYRytMEbSVGkuzaqCpB45Cnk+3wsWZCyOwIqOiqhaitc6AUwM0zTc14bzfW8Z8dyPrFk3IGUrxkG6P31fyPCYMxlg+HwvH4OwUxus8oRlWrfCY1gGMa9SrUW99fPWtqsdII9I7t8zm4bnbNy2t73eSsdjBbpGgDRm4lnaYzzlFzZGkYuDK66Y4SAdZCI7VkmhnEVuCZXck1B0KoXSteg0FO6DVmqchUjjlKjcXc+8hT673FVywVl+jQknJYo5hY0lH9NzFLtavYGdTcy91QjaPCU+PaWyUclkWdTcy9yYLMCroyKce/arM0u94t1yrZosVwk9lMwE9vRdI1KW0JIWaRgo7rvoiGqhQSIwc+axx7g7dwpKtdD51yNKlaBRXoFWy46SCBdOL+Y17wjkNvx25oy1QmXQ2tpjuicrqAdmjji7297GsZmIoOZaswcP1MA5kkYWWZroMX6oRU0Dkh2C/cYEdRN9y/DuNou6bCrpqTW1uVbuKCU1JJIR5oZkbwVoarxAGO8F7LayC1vaNnQPUZmgNCqjKlRx48cNIAQMACA7gPUBDfYQ+z+ICH+ugsmhNeIxNY7tc4WJpYWOm/XbSp04WAa5EXG9ZVsT/jlh+0KUGOaRqcvyLzo2cN2quIaEugZ6EBVJB2PoEcm29i2UBFVYDJQ0cKj5UO4G5Dlmz29ttcUe9X6+ZMx/28IrWQhtLMStdOg5qGXvHgOnEVdNLdObWE6UHjbq6RkaVr2HLC+5q3wsvIYzwXxQM1uHGWbZ3TGuPYDjO8MllWlZ2gkcf3qIz7l/JttgUT4yewzhxKO0zOyvGc5FeoduTTakszikyqG1eKObc9+URb2nlyyNcgCKSA+ZEYIooyPOL0QMRR1koB5XlvKWpapWC1Oq3NVGjxBsm1Mx8NM6DgR/FqC4a/gjj/D4nhVX88SAsOSrHZH+RbrYYmIcxdYJlCz12JgshWjHFVk5KcLjdrf3UYeRlWkeumk9lH7x0oHe5UDQFu27ybhKFi1pZRoI41JBfylYtGsjgL5pjBCqzCqoqqMlGJa3t1hWrUMhOokcNRFCVBJ014kDiSTxJwRJjFIUxzCBSlARMY3QAAOoiI/YABqGHbhyATkMzjOh7nfuPPTOZfBeC7Q8g0IZx47zkKDknMa+I8bggv8ARq9KMFW7psdsoBiuVSH+ICQPt2qDnnnRrQ/p21OVkU95x0cMgGUgjtB/47QPlE+U223iKLnv1EtxLaTLWC2Y5FalTIzw3IYN/I6ZDt8OeWZ5f52TeLgnygzaBUznD8vKt2AoABhD8JZrp8Nvu1VLc47+h7t24PsX/wAONldp8sXo0YVL8u21SP8ANn6P/XxU07zr5IKPm0JWuQ2fpiYfrps2LZrlK9rLuXK5wTSSSbpzYnUOY5gAOn26UPNfNFy6xQ3T6iacE6faowx3b0G+Xzlyyk3HdtitUtolJbv3bUp/gkY/QDh9vtmYG5Vz9ormVORPIbkQ9FJRGUhsdI5Xui0IQiyCgpFtiDuVWI/MIKFHwB8hRD5u7VzcpbXvwVLzd7lmPEIQvt4o33Y1R/Mj6l+kUpn5c9M9igt4xVGnWW4JND/l3NuCOB4P78aMMg46ta2JcutuOi9HxDm/IUDJuYnIbinRrhBS9LNFEmNjtabJqkrNSZPIcib12m/FqqcFzt3ZCGbLXHt9/b/H2rbyJbna4nAaPWQfLBzVSfCOwFa8Ayk6hr4niYxyfC6UmYGhp09Z/Y+w8MJlwfx0xbS7dkeD5QMnWO8QytUk8ZSOLs0RFZtmcc0ucszUJb7Vk3OeTcZ3iwsbfjLGuYSS5anfJqtwbxm8lVzKS6SBUklrM3jeLu9tIW2fTcX+sSeZEWW3hEStGsUEMsSlJZIdBlhjlkUhFpHqBKwUFrGjsLmqw0pRs3YsQxZmVjVQ1dLFQcznTicfHa/5G4r5fh+EvIKxS91ptoZyL7h3n+xLCvKXOswjcF3mC8oy6opldZlo0ckZZm9EpAsEOQFdvVIOAMI7pa229WDcwbaAs8dPiYxWiFm0q4LEatfEhQafizqS9tXktJlsZjVGroPXQVIy6u0+zDPdtvhoNz92JboxOv36WOKHrxTGfssJYaxhPXBJr9Usaws65RK8Uf8A2LTkCyuk4am1tonsYyisrOu0SD2gJgT7jbDttqT2jb/1K9WBiBAAWcnhpXM9IOfDI9PVhtdz/Dwlx4zkPbUDtwoPM7fK+LpzFGI5CauOB5q62mwM8n8lsnMofIHC/PqeV6n3Wen5RpERLCZja7FlB9H1SutZd9TZFvClVWYTC+/0x3Ym1Dbr6K53MJFdhEVktoS0d7A0TZSQyFf6axB5XKJOoOlXiWgkSIlE0Hl24JiqSC7UMTBhwYA8SxCipQ8SGPhLJ+K/FtlghCzXSzOWM/mLJKqr25zLVpV146rMX1hn7qpjCiWKJx/QLNM4yrlxt8s5ijWBN7MESdgks5OmiiRMK37fW3Ux2sAKbbAKItXq5CqnnSK0kirK6Igfy9KVWoUEkmVtLQW+qRzWd+JyyFSdIIVSVBJpqqc+OC80O4eDCmvdM5knwFjlPGNJkSoZMyKycJeoRUTFeuVg3e3eyxiGIYSOHQgZFubpsfcwD8ugLnnmP9HsPhrc0vJRQdgyqc1I6eGMzvk79CT6o85DmDeIw3LG3SKWBP8AUlz0r3ZopAAQDqAZa5EHOmK3LuRVnay8OxcnOUVFDO1xP3KLrKj3HUOcdzHOcwiIiI9RHWM13cM0lK59P1dmPoE5U2CGyt0OmiKoCipNAAOnUa8OnAf2KZdeVGMjE13krILJtWrRukZdy5dLn8aaSSae51FFDjsAAHx14W1u08qQJ4mNB+1cSHNW/wBrsG3SXly2m3jQljQnICvQrHgOgHGlT2sPa+j6dHlzrnVi1/UyccacVCUKb0NJh0SerV3Kr+T9S8CfcooIfl/hAQ66yB5P5Sg2iAX17/XpU8e7w/hcg/RjRh8zXzIbx6ncxHk7lZv/AKsyGNRRD5rE0p+baxOmf89O3BjWz3ocH8ecpwNLh8RvZbF4yhoeVv6Ms3bvfGgqLUZiPizs1PUR5TmA4gKyZhT3EAEdgHtJ6l2druS2SRarQtQvqYdnh8sn68Se0fIJzXvnIEnNF5f+Tvwh1rbiGFw1aMAZhfKgyPHRl1VxozpVur96rEHbKu9RkIOwRbKWjHaBgOmuyfoEcNlSmD/uTUD/AF1a0MyTxLNHmjCo9hxrq3XbrvaNxm2y+Gm6gkKMKg0Ycc1JB9xI7cL/AOeXEaiZMjZbPB6vWrLZabXI1xc6lfLlM0rFt/q1FSt54dxlKXgKndbWWoY6hsg2V7IRcC3YubbHulYiRWcsDg0Mdcpcx3dhIu1CSSOCRzoeNFeWN5NFfKDPGmuQxRKryFhCwEsYWQasDe4WUcymegLACoJIVgK01UBNAGaoFNQOlqjLFNUnFeW+YnFS0Uzk1c/0pyztMLSOQGPm7C1UdwGBrxGM/LjiyY9pEBFRF4oMNVbxFLx8q1nDSjpy4I9aqSTryLopP76823YN/S42CPXsUUjw6yrgy0JqZJCWR20srKYwq6aflqDn4JDLe2ZS9IF0wDUqO77AKECoIzqa9JwbnCbkQ+5L8f6zebTFp1rKcBITuN82UvYCL0zL+PpVzWbvCrIB8yDVxIsfXsBH/wAsa8bqhuU4aFuY9qj2jdpLeA6rQ6WQ9YKg04k5EkZmpAB6cPNuuvirZWbKQZH3ZdQ40wWmoPD7CtOVOa6rHcs8R1m3hKvaRx4qsdnOwwtejFZ6ftWWsq3aOwFxxokLApmIaSsVjtlnkFI0m5Sg5bgc5kyl8pDnZdrnk2KURIPiL2oR2OlUjgDSTOx6ECK5b/DlU8Ia5nX45S3gh4gcSZAAoHaWIA49tMHKhlSMsGVk8RxrCMcykNTY293+LsTuTh7JXIiwrqpUCTgYVetPYG7R0jNwUm0kHDWWS+jPGSRTFVOsAEFzYvFYfqDlhG0hSMqAVYqPzAzagyEKyFQUOsMeFM5PzQ0vkilQtTXiK8KClDmDXPKmLm1HY9sehs9hjanXZqzTK5WsVAxjyVkHB9+1FoyQOuuce0pjfKmQR+A68ppY4I2nk8CAk+zEhtW23O77lBtdmNV1cSqijIVZjQZkgD2kgdZxgz5t8lZjM2UMgZUk3ah/rko6jaw3Oc4kYVdk4XRh2qJDAUUwFtsocAAA8ihh1ipzZvcu7bk92fATRR1AUHHSCfeK4+kb5cfSq09O+Q9v5atV0yrGHmNT3pGIdmI82QA50oracqgCtMKYnpYyaTp+5OInMBj9xuoiOw/fvoJHeI7cZVTOtlbgdAH2fThm/tEcNls65IVzZcoVSQgK9IGjaWzdpFO0eS4ABnUodM+4KFj0z7JdNgOO/wBmrk9O+XTLJ+pTr3QRpz+ng32jGpf55PXN7RP+wdnlo7qTOdPAVGkd+3NaiuaSZVzxqL9xtw548e31kN1XyKM3EqWErUo6bE2WTjZx+kzf7mT+YpVEFBKI/Zvqy+d7h9v5alkg40C17CR119mMHPk+2S05x+YDbLPcQHiBllUZjvJE7Ke6ycDQ5mlejGEzPmQFbi/iYyLFRycSJs2iCZDCos6dLJlApSiACJjG2ANYxRNJeXSBRVy33+7H0C75Jb8sbBM9wdKrCSeJ8K8ctfUeGPoVe2OWyxvFnFNctSi6ktB0mEZugXEfIRQjRIfCbcR6oFMBB+4Q1lxy+kkO2QxSZHR2fdj5l/WG8s9x5+3G+s/6UtwxB73RRfxAHOnUMMXEpTFEpgAxTAJTFMACBgENhAQHoICGpwZcMVbhLdLxZTeE3JpS3HpecpynSFrHHEbekIvEOMeN2K4zP1vpxWS7lL9Rt8t5xyROSqUBEy80VlKEVXjwcuytjoLuwsq43C45o2L4cS2iXKp5hQmeW5mNuj1AOkwwRIvmOiakIDFV1AquIVIksbrXpkMZOmvcVF1kcc9TMTQE0PCppmcXFj4n9gvc9y9j5EAZUPmniCJzzXGRNko9tmjDBozH+TisG5Pywd22lScLJOxApRM4ZKKmEx1h1FXbfqfJ1tIo/M293VyTxErilB2dwdJ4nLpUNbbdpEHgmAPvVa/v6sND0FYmsIDs2RsNPuTnNH+/0Ra31Gy1yOwpxnjrRTf1YSfxa54+cdJ/kTBX2GdUSOk7izmYHJ8K0PHuY8qa7CSfouxOVNBQDW3a2e6nYdvm2p41ubS2uJQr6NMqzTxQvERIQhVknbWrEhkDLTPAyskJupfiFYrKyCorVSqswbLMEFBQjgaHDHuIFbwvIK3LKeOuQGSeTllk2cFQ5fI2VJmIk5+v1yAVk7HCUWNZV+i46iIuPbObSu6WUNHHkXqqpBeOVzIpAkF8xT7ioisLuzgsYFLOI4lYKzNRWkJeSRiToAA1aFodCrU1mLNIe9LHI0rGgqxFQBUgZBR09VT0k0wb2hjD7CwPdvy6ti3iFa42Pc+nl8jv2FKZ9pxIqLR84TWlzJG3ASmJHInDcPh3aCufdyNhsEgXxy0X3VFeg9H24yz+TLklOcfWuxkuFraWKvMf8XluEGToeIJqK8OB6MLuXpoziSQjCHHxNkw7vtDuETb/AB/ntrFm6l1vkch99MfRhyxaCG2Eh8RA+wduB9Tr8nfLdWKDCpmWkrNNx0K2TTL3GFZ+5SQ7gAA3MCYKdw9PgGvXa7R729jt08TEftxHR24G/U7mmDljlm73iY0jt4S3AnOlAMkc5mg8JxsjwfyA4ve3DVKRh65Qlxf2SvUqvvpAavCNZBo2cSTBJc53Sp3iC4vnCvcqYBJ0KYvXWSS8wbJytGm13RYOi9Ac1qAa8GpXjxONEMnoX6s/MVc3HP8AsUcb2d1O1NclslCraSBWSFjpIpUxrXiK8cWFmn3XuB/JLE10xBeK5lBStW+GcxbwFq03RcNBUTN4HzU5pAQTdslRKomb7DF/lprf88cp7pYSWc7PokWnhk9vQB0jrwTcjfKB8x/pzzbZc17JBbJuVrLqU+fZN2EUeZ1zB4lTTjTCJuIeDOEWROYELSaJL5RyFZirS8pV21trMPH1uLbwzdd4s4kFmko5XcOG6JfyzeHtE4B0D46C+Utv5dk3cJZsZJeIykWgFTXM0OMmvmk5r9c7P03+L5pjWzsnYLKA1hMGJ0gKDGmsAE8QBWufDG3fDdFRo1WZx6JSlEECAPaGxR6BsABsGwB2/dq+7eNUjBHGn7v3Y03bnctdXTO3iqf24DFwa98R+FIc96rjNHM+Mckz87doG7xsMwr9RnsZ4MwRkq7VqdbTj2WauK1kHkHH2Sh4wt0uzfGK1OWPRk3SDYfTODqFSTLYHKV1ejbp7KJYntGYs6Sz3EUbrpA78dsySSopFT3iqk94UqcRG4RxGZJGLCQDIqqMwPYXBCk+yp6MftyugnGL8re1ZkBaw3C1S1W5Iu8OzNqvx4Y93moLPeLbPAPAs6tdiIKEJKL26LhjrJs2bZqUyHaRIpSlAPPZrmK62jfIgscYlSJlWPVoXy2diF1FmI4ULMT0kk48r1Cl5aMxZiC2ZpU5DjSgr7BhtG4fsA6A8TeoYVpwKga/I5k5/KzkUyf2mlc9L5Y6++et0l30Cjb8K4ziEn0YsYBO0UkoMXTYTF2MLdQ5N9jCAmfMDzx7Pt3lsRDLbsrAHxaXVsx0gEqR2jsxCbYEM82rNlK0y4VBH14aZoMxOY6Dv9n7f76WF0duM4Pv73QyCHHujlWMUqzy5WZZDu2KcGreJjUjmL/8thdG2+7rqm/Vm6IjtbToOth7tGXDtHTjaj/bQ2KK43XmHemH5kS2sYNTlr8+opqAzp/CfaMZHLm7M6n5FUR/Cqcob7CIAXcNugiHTb+Q6x/clmJHHG67bYxFZov7ccEZ7Y1D/uTzgoBXDUrplUzurQsVQonTIrHp9rUTBv07lDhtv032/dqwfTyz+I3lZWGahvrU9o4YwP8Ano5rfZPS+S0RqPdTxgmlaqk0bEU0N2Z1B9uHJ8q/bC5l5YzbdcnxeS6a3iLlLgvBQxU5UxouCIRNtGMVe5sZIDoNiABgKO2++jXfOQtx3XcHvjNpDUoNCmgAA/zB1dWMWPRz50+RPTfkiz5T/TNc0Wss3xFwKs8jOTp+BlAqWOQcgdFOGEWXz9ZUCRt9ZlZNhIuavKyEA4k2SQkQdOWK6rRdRDcpDdvlTMAbgA9NUxfQyWdy9oWqUNK0A6jwz+3G1/k7dbPm7l+y5iij8r4uLWF1M1MyBmQleFfCPZg0/Y3h39g5iWO2FKYxqzVlkU3AlEdlppwZmokU4dwAY7cTCP7g1ZvpZbh9wkmI8I/eOvtxrw/uJ8wNHylY7NXKWV6j/DoINdPSRw1DG+2DIYkWzA/4/CTu/jsAf021kMnhGNJLmrk9Zx7bXbHXCQ+cPGyNh85TOWn94lk6/myGvsfZohr7cWRuaY1JpN42wfiu2PyW/GLtZpj8V67iiKXizzMQ/dmcLSZUzuWe7RvaXKu9PPtS7ckS+faNGVY7nFY6iss8qApNnJRpnDeW6AAR1Cv3mgdwtwlwZix0SBqjyGlpVUU5r4clFNQPTxGQ57zKpMLRsccA6jXH8nJpSHuE8WbEwcTDd20knPrcjkuM4ANZNMsywatGHqBRavVFXTJomVsZQQSKAQW2yz3v6lcSBVK21DShGVQOGRJpmVyJq1M8d75Ar26irDUTnl1H9vow3/QVibwrnjssGOvcw564tcm9O1y1ROPXJaqIGH5XSKNef4ivKjYdxARZWCrs1HAbbgL5LfoIaNt6CS8n7VdA1kRrhX7PzO7/ANK9A9vbDWf5e5TxdiU+j/jhjtfu1RtjycYVizQc+7rEkaHsbaIlGkgvBy5Cd54uWSbKqHYP0yDuZFUCnKA9Q0DJIj10EGmCa626+so0lu4njjlBKE/iApWnsqPpGOUfw6fv/n+8NdtQpXDLGV7/ACDActsrcdHZu4Gq9NurUphEOwF0pWFUMX/t7jJqgP8AANUf6uEieyY/wy/bHjcF/bBKvtHNMP4/iLE/VdYy2WDcZOTEQ+Ky/wDpubbVGv3WoMbgrbK2WnVhm/sUxCUpy+uiypQE7KmNRSKbqOy8ukicd9h6CX4/Dpq3PSkK19IeJCj9vrONVf8AcXuJF5YsIwe6Z5K8P5ezG6e2Giaxjmcsr5NBNKv1eQkzLKFLsmVnHnWAw7lHt6k1fc7LDaPKclVSTjTdy/aTbrzDabfCNUs1wiKMh4iBStR9JI9ox84/PkyEg0np9UpE3dmn5SZXKUfwqSLpy9OXfoIgB1R1hzuMjXE5l6WJ+2vZj6nOSbJNs2G226LuxW8KIOnIKKcST0dJPtw3X/HdohnsvlS5rIAJX1kiItssJQMPhZMnSyxCiO+xfIcN9h1dnpXZlLOS4YcSPt9v3Y1E/wBw3mA3PNFptde7DHJX2kIf4R19ZxtJak8bZAgB0KmUP4dP+NXNjV0ak1x5OuOnCxXOSMt4zw/GRkzk+8VuhxEzMtq9GSlolGsQwdzTtBw5bRqbt4dJD1KzdmqcpRMG5UzD9mvGa4t7UB520gmnT92JfaNj3TfZng2qEzSohYgFRkOrURU9QFSegHAE8sHaOSea/ty4kjVUX7OBumVuTViKgcFE04fHOOHtVqL1QxREh2rmzZBIdI24h5m5dvs1YPL3l2/KG8XjLVpFgRDX+chuvodePu7A7cEeTdbaEZGNn1dmQ/dhne4/cP8AT/roFxNYVBz6UPx75A8Quc7dM6FUplwe8buQsikA+GMwpnh3GMYu3zB9wKlCUHJsbFvHZx6Jt1zqdRTApjrlZV3XaNw5ZC6ru4jVoc6UZCWbPIZ0XiQBn7DCbkTa3cF9/wCUrd/6qdZ6+AxxHjpjyJ4s8uJesW23YXoqOWnFzNixhEybgck5+hpmac3H6zdUAj2seErTJKQM0j3C7t66dA4dJoikkYiQ0zY267TuRs5GCliQgpm4FSSaVAp/MangMZVc7b3ceo3Iq7/YQNObUq104YKtuzlURVVtDSaxn+UjKgNWNSxw4z+nX/fcf36LBwxjfXrxnF/yIaS7cYuwRkpoj3I1i6TcHKLAUfymk/HMhbCYdhAAM8YgHUQ6jqn/AFctC+2295Sojdgf+bQB09nVjaJ/bI5jitOed55alOd3bRSKO2ETsTkp4A9LAZ8CcZDrITeQWULsX1BO8vUDfjDf/nWPRpWvHG8C1JMAXq/fhj3sd2tlVucbiEegHfcKi8YsxEwFAHEe5Rfh8TAAicpR+8eurT9LJ0h3RofxEfvxrM/uHbFNd8gW+5x+CCdieH4mjHSw7eAPDGx73C72FB4S5jmU1gRcvqf9CYnMYCiLqccNo9IC7iXc4g4HbYd/u1dfNd18Jy7PKDmUAHvI7DjVb8svL45i9b9j2+QVjFyzt7Eidv4l6R0GvVj59Gf34IsmbMDCAJoKKiUBEdvlECgI9R3ER+/WJ87apVIGYP7sfSvt6eTtrt06B9mNRv8Aj14/CI49sLAZM3ks1imJg5zAPVPv9MgIGH4lEiYgGsj/AE8t/K2SJz+KpJ9/t93140D/ADub8dz9XLuAHKAKn0qK/hH3+3GnoA2AAD7P3f8AGrIyrXGEWOgjsAjv9giH8g1xkw7Mc4RzyyyNyQtvKOpYMLjKnZawdY7lTl5Gt3DETy/4xkafLyo1yzHLldCGbRlQyLRCV5xJBHugXVEZY4CYWzYq2g7cbjc33dLSNQ9mzAU7tDUD8R7wIPUcZUchbFyBaenc2/XM7W3NixMwlAuC0dHIX8oMYZFdaCrLpFRUVrggOHnZnzljyp5eokIvQID6RxJwA8KIHau6xi96rI5jssSqQfTrsLJlFQjEFCbhtAATcDFOGrw5oij2bYdv5bHd3GJXe4GfFiGjB4qaKxHdY+EagDQDDuwd72+n3JzqSRu59Ybt6uI9mGj7D9/9NAWWJzLFbZixTTs54ryDh7IManL0rJVSnKbZGBw2MpGTrBZiss2U6Gbvmgqgs3WKJTorpkOQQMUBB3t17Pt15HewEiaNq5ZV6COB4gkHI5HhjwngS4iaKTwH9vtwjHGNcsVkRleNeZa3L5A5u8BY+NQxW3C2sqC45T4CRtEHK4jyF+rXxPGSOZOayzRsKaaoqpvmSyS3/wBzrIeoGwQXqw84bTDqtLipCaiCjLk9SzZ1cMa041AyKknnpPz3ebBLLyjfXYstsuP6kvlCbTRW0jQEZjqqEqGGnVqNQCMNJ4dZ+msy1mbibVYa9e7nSJaRh7vdsfQzuKxgnaTP1nTqiVV9KO1HtocUlg6bs3kkimVs4XIYRBFXuRKHbTePdQ6ZW1yrxalBx4AAUyGVRWvHtw/9QuWINhv1msoDbWEwGiMuXYBVUFmLMXGs1ajBaV00BBA4b7neBj8huGWYaUyag7n4+CNaqymAdx/rdbUJKNgT+Yo96hW5ybB1EB2+3bUZzjtn6tsM1sB3wNQ9oIPWOivTTFgfK56g/wD5v60bRv0jabRpjFJlXuyKy0/pyHMkCqrXPI4+eFJyiJSg2diZB6yUUauElQEpyKIHMRQhwNsJTkMUQEB+AhrEWRGjbQ/jGPp2s7+1ubeO7ib8mRQwyPAjtAP0gYsPidlxDCXLLCmTCPASjoy7xDaXMU+xRipJwRi8BQR32TKkt3D+4uiPlK//AE7fIJm/ip7a9HA9OMb/AJn+TYee/S7dNrhFZ/I1xmpyZSGJzeMHKuRNOzGxD3nMxQ7DhvjmJLIJla5ItVfeJOCKD41Y+JZFnCqfL+NNU/jH4h1H4Dq7/Uq+ROXUiU5yMOjoUqerqxqe+QLky6vvWue+ZavY2rAioGciSCvjHDT2/fjEpm+0x8xIrCxcEWRAhEExDuDcfw9Nw32MI/cG+2sdF/OnB/DUfdjePfk2G0NE+TCM1+j343e+zdj8KbxWxMzM29Ot+jop0uXsEgmVfInemOYPh3GIuXffqOssuUrX4baIUHAJ9uY6T0Y+aT5gt7be/Urc74NqRrgjhTwgD+FekHow5jfpv8P2/ftopNffiieGAb5n8i6tjKuR+Mo3NCeHcvZFcxsfRrWWlrZAjqq/cTMaziX94hkm67eMqNimHKEQd04MgXve/lnKcvcWG3XcIbdVtxL5V1J4G0lqUIrlSmYNM/aOGLT9NeT77eLmTf59s/UuXbIHzozOLepZW00bUHJQjXRQQaaSQGwDVwY3Pj/jpHj9iiBr1a5587Zd2pZ4Oh2202bHON2g+rj8k8jIyJmjphUq7GxCyj9RJEjb1Uyuk2KqooUhtHPp5y/bwLJzPu0YXbLahk7x7ztlHQK1RRmDZClaA5V0inqlzlLzDuceyWFwZ9uiqIWKBCoYL5gOpFdqU06nNSFrxNS3DBOGadx6w/j3CtCbGbVPHdaY16MFUpfVPlEAMvJzMicvRaVnpVdd67U+KrlwoceptR+7bjcbvuMu5XJ/NkIrw4ABVGQAyUAVoK0qcCFtbpbQLBH4FH2mp6+k4trUfj3xNL7MLAIc0+IcnnxtS8tYYtKOKOW+CnD2bwZlUUTqRyhnpCJz2NsiNGxfU2HGF4YlM1fs+4DIHOVwl85BIoUct78u2M9juKebsdzQTR1pWldLBlBcaSdVFIr9GI2/sWuNM8B03cZqp49XQTTo6cC/xCtWLuRGcHM5kAuQOPnMPj5CBXsg8TSWRGvUuqndyK0hZ8iUWAiW7ZrkSgZUfPkVTyx1XqRyJoFEqC+51WXMfJse03MW82rGbaJKmGXw1yGqqaiwpmKsADxFKgYMdu9Sd0uOXX5QcKok0iYEBmkKsGQltHdoQKBWGVAcq1LjHvLOvZdy1lSlRLCP/s/jtRtTHmV5CTj20DZMmvkWCr2hwqbx02dvn0Q1eHK68bdZEFg8flBQDJ6DbfcUu7p49I+FSlHr4iRUilARQ4L955BuOXNi2/cmmZ+YbkuzWwQVhVGoraw7KwZaNwFCSpqQcIh5Few1iLJF8suT8bZRuDeu3+Zf2hmwriNaka81CXeKu1koV4kgfzR/mUMKY95w2Hbfpqvb3022u5u3vA2UjV4Mew5+aPsGMyeVfnx9ROWdhteXLqEvJaxBNWq2WoGY7v6e1Mj/ABMes4HEv+PXCC5QU/ujk0gpHKYpixlf3KYpgEDFN6cAAxTBuGmy+mW3qKq2Y6aN/wC7iduP7gPOlzGY5baqkZ/mQZ/Rtww0HOvtcuOS2A8I43v2ZMmIDg2tKQEUsyZQR1bIYyLdu3lZwjhmoASLZk1KiUUhKUSfEBHroj3jk2HeLOC2uXyhBpkemnU69XWcUl6XfNPvHpTzNum/cv2lLjdTHrHmx5aNf+ZaTA18wnJUpTp6Fguv8eqAcSCapsnZKWSSdpq9ikbXwBUpFCnMU4+m3ADEDqO3TfUBF6ZbZCRKGrQ9T55/6uLlv/n8533G2eCa3prUiuu3yr7NuGNSXFXFwYixnA1dfuSQgIaNikllu1MRbRbFJmmor2lIQoiRABN9m+rSs4BawJEPCopX6us417cy7pJvW7y3x/qSuzU7WNepfsGKmyNz8xjEZmmuLNfdu4fPD1oszpg2qKUQq0vMStdZS1PcRjn1SATrGxvZAWzbsURKdVi77zpkRAx4yffrX4xtrhb/AH9KcDkSuoZ00nI9dMWBs/pBzC/K8HqFuUQ/7QJ1MweOpVZjC4KiUSr3wQSELdIHTgJ3Frs2Am1AyTysrEZm/wBwS1P7fX+MGHKUWOHJrmvWorJyepZHf06T/RkzU6jKJqPVZVwkEbENiidJUypTqiT8i8lXu+L+q7+/lWttVpJ6A+WCDp7iONZagGQOgGrdAw09U/Ubl7bp7nlT0srFyrdpEGj/ADGErIAxIa6jM0emSte8oemXd4nxxE4uWfF8jcc9Z+sLHIXK7M6LJTINoYpiNax9Wm+ziHwziwi6ZXTGg1dcxjnVU/8AZlHxjuVhAvgRRIuZeYItwEe2bYnk7FbEiNKljmalizAPRjmAxJFfcKT26yaCtzcHVdyZseHuoDT6Bg59CuJTE0sLE0sLE0qdOFgMOWPCTGXKVOuW1eTsGKs8Y3UO+xHyExw6+kZIoEgALCVqDsglbWWpPFFzethpEq7F0Uw/KRTZQpHsXMl3soe2AEu2Tf1YjQBxQimrSWXj+Hj01xHXu3RXbLL4Z08LZmnuqAffhQ/I1jlinV1jj33EMUT7mtwc5OTtb59cRsfI22nKy0/WXdMkLfyBwaELKuaVYzQDxMAkyNnzJu8SKZqsgKaYnc7nyTy9zlCrcsSiHdCtRasHYrQd6ksjqr1C6uJpXiOGDvkP1X5j9OtwM94nxO2yUEg1ImvTXRQrG7JpLdAowyYEcCLwRkbKpJJ3N8Tch4Qz9w9x/iOyR+N8d4stEFYLUs8qNMrTLHVVnIt6CVrr19krOq+PKHVdC3FumQiyCbpTvCvr3YOZuW79oLmMi0jFAn5fVQUcFq5940JHEVrliyH5m9L+deXUa+Uwc5zzFprpmuWy83UT5SqsNBF+WoABrTIDPBGOeYORsc27CmMMw8en43bJcVWHlinadKJoUauyFpsbKATg4qSs7eOJYp2tpvQdyzFFcrtBqQTN03QiUotTulxDLFBNDR3rUhuHTwpmejjxwxg9O9k3fab3e9m3Mm2tWUKrQHvlm0kljICi5agShJUioBqMdkR7hNSuCLUarj22RJmXI6k4Fn0bBGMJHyEt6ksRvYYxzB2AzFOMVSjAWK5Ms4MkkoQx2xu8ADm23uK5r5YJAdQewNWh4dnD68cbt6QblsZj+NnUrNbySIQozMWjUuUhNPzF7xAP8uPUcv8APHLDGOeMc0XA2HVb3S5itx9sm3zWl2ObCUcRl6gI6yUUtqYtlKxTpuaqD5yrGuZVZq1SWRMqqoKZOw/Xc7ndIbyNLGPWhFTmo6sswfu+nD3095b9Pt25Zu9w5rvvhdxjbShMcz0qG7wEbqp6BQhj0kUxWucWubnUtndnyzzzizCHEGx1WXhq4ynbnB1a0oSKUrX5+mT0dJVdCu2UyRTt3UfKMFZgx3gAUiaaqapgFxact8y8xXktgqs9jMUCKAmXAmrBlI7wz1sB0cMe0PPXppyPtWz7ry9aludbQ3HxE3mXFHDlkQmOZHhFInIHlKc6MxDChpjAFxyxeqpTqXwaxWa22auUlbHMr7iPISmzNNoqdKPYH0ulFYuhJlBW55caQblyQWCCPhhfI3KCqyfzdll2HJuycoxKea5vM3KJai1AYFwaFQZI3dVpXrzApqFSBUfO3qDufPG6XE21R/D7VOymlVcAhAHNWjjY6m1EigFTwPHDNeMXDSj8eH9iyJMWGw5k5DZAQbkyZnzISpHdwsZUDGOlCQDFIfpFEpTFQ+zeIi00UNilMuZdUPKLHf8Ame73tI7RFEW0QZQwih0AgA9/SrNUiverTgMCljt0NnWXxXDeJs8/dUge7BjaGgAMhiRxNLCxNLCxNLCxNLCxNLCx+K/g9Ot6rw+l8SnqPP2eDwdg+XzeT5PF49+7fpt8dLCwh7kzE+ytN5XcMJW0QtQ5GLLmB7OcLG2WneYWsl5zdhrShxXr9lWNMA4/8f1poo4327Om2rQ2B/UePbq7apfba8H8gdX8ZElPqwNXS7E0/fbTcV6pDnl1ZY5/ReMOfV49s/49+5pzTgYVQoGZQnKTjDKZAVQSETCgmc+VMeYkyJsUNwN6t6ocS7biHQdNJd42eI03XZ4JZOkx3YXPpyhFPrx2jtpSf9tckHLjH7KeL3YshvgX3MQRBuT3BsBnYFeCmMgThYw+qKPu05RcKNE8xkRLN7fMYu/d39Nea77yHkRsTaq//Mn92JE2nMHTd9//AEo8cUt3GXkYRms9zx7lnLWWiSFOZeJ4zcYTUJdYgFMKyZVKNR8v3jtMnuBfSukzgO3aO+2vVN52KVqbVs0EUnW92GFej+sKYYG2kUf7i5LL/p06v4Tir8JQns6QGVGUdZbgtd8/pPA+lz3OxpmZle3Mv8DDUG/KGtVWBJNd4CJ/ojQjrr83TbT/AHh/UiTbGN0nl7XpGSG3PdqKU0EyU4cOjjljpZrsauBG2qbrIkH25Yekz9J6Vt6H0/ofAl6P0nj9L6bxl8Hp/D+V4PHt29vy9u22qrOqve8WCMUplwx5OuMc4mlhYmlhYmlhY//Z"/>
                          </a>
                        </td>
                      </tr>
                    </xsl:if>
                    <xsl:if test = "$fatura_tipi = 1">
                      <tr>
                        <td id = "fatura_tipi">
                          <xsl:text>e-İrsaliye</xsl:text>
                          <xsl:if test = "$ing = 1">
                            <br/>
                            <xsl:text>Despatch Advice</xsl:text>
                          </xsl:if>
                        </td>
                      </tr>
                    </xsl:if>
                  </tbody>
                </table>
              </td>
              <td id = "stn_ust_sag">
                <xsl:if test = "$belge = 1">
                  <xsl:if test= "$belge_kare_kod_1 = 1 or $belge_kare_kod_2 = 1">
                    <table style = "float: right;">
                      <tbody>
                        <xsl:if test = "$belge_kare_kod_1 = 1">
                          <tr>
                            <th style = "text-align: right;" colspan = "2">
                              ETTN KAREKOD GELECEK
                            </th>
                          </tr>
                        </xsl:if>
                        <xsl:if test = "$belge_kare_kod_2 = 1">
                          <tr>
                            <th style = "text-align: right;" colspan = "2">
                              NOTLAR KAREKOD GELECEK
                            </th>
                          </tr>
                        </xsl:if>
                      </tbody>
                    </table>
                  </xsl:if>
                  <table id = "tbl_belge">
                    <tbody>
                      <xsl:if test = "$belge_ozellestirme_no = 1">
                        <xsl:if test = "$xml_belge_ozellestirme_no != ''">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_ozellestirme_no"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:value-of select = "$xml_belge_ozellestirme_no"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_senaryo = 1">
                        <xsl:if test = "$xml_belge_senaryo != ''">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_belge_senaryo"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:value-of select = "$xml_belge_senaryo"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_fatura_tipi = 1">
                        <xsl:if test = "$xml_belge_fatura_tipi != ''">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_fatura_tipi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:value-of select = "$xml_belge_fatura_tipi"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_fatura_no = 1">
                        <xsl:if test = "$xml_belge_fatura_no != ''">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_fatura_no"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:value-of select = "$xml_belge_fatura_no"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_fatura_tarihi = 1">
                        <xsl:if test = "$xml_belge_fatura_tarihi">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_fatura_tarihi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:call-template name = "tarih_bicimlendir">
                                <xsl:with-param name = "tarih" select = "$xml_belge_fatura_tarihi"/>
                              </xsl:call-template>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_fatura_saati = 1">
                        <xsl:if test = "$xml_belge_fatura_saati">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_fatura_saati"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:call-template name = "saat_bicimlendir">
                                <xsl:with-param name = "saat" select = "$xml_belge_fatura_saati"/>
                              </xsl:call-template>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_fatura_son_odeme_tarihi = 1">
                        <xsl:if test = "$xml_belge_fatura_son_odeme_tarihi">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_fatura_son_odeme_tarihi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:call-template name = "tarih_bicimlendir">
                                <xsl:with-param name = "tarih" select = "$xml_belge_fatura_son_odeme_tarihi"/>
                              </xsl:call-template>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_sevk_tarihi = 1">
                        <xsl:if test = "$xml_belge_sevk_tarihi">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_belge_sevk_tarihi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:call-template name = "tarih_bicimlendir">
                                <xsl:with-param name = "tarih" select = "$xml_belge_sevk_tarihi"/>
                              </xsl:call-template>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_sevk_saati = 1">
                        <xsl:if test = "$xml_belge_sevk_saati">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_belge_sevk_saati"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:call-template name = "saat_bicimlendir">
                                <xsl:with-param name = "saat" select = "$xml_belge_sevk_saati"/>
                              </xsl:call-template>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$belge_siparis_1 = 1">
                        <xsl:if test = "$belge_siparis_no_1 = 1">
                          <xsl:if test = "$xml_belge_siparis_no_1 != ''">
                            <tr>
                              <th class = "bas_dikey">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_siparis_no_1"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                              </th>
                              <td>
                                <xsl:value-of select = "$xml_belge_siparis_no_1"/>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test = "$belge_siparis_tarihi_1 = 1">
                          <xsl:if test = "$xml_belge_siparis_tarihi_1">
                            <tr>
                              <th class = "bas_dikey">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_siparis_tarihi_1"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                              </th>
                              <td>
                                <xsl:call-template name = "tarih_bicimlendir">
                                  <xsl:with-param name = "tarih" select = "$xml_belge_siparis_tarihi_1"/>
                                </xsl:call-template>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test = "$belge_siparis_sorumlusu = 1">
                          <tr>
                            <th class = "bas_dikey">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_siparis_sorumlusu"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                            </th>
                            <td>
                              <xsl:for-each select = "$xml_belge/cbc:Note">
                                <xsl:if test = ". != ''">
                                  <xsl:if test = "substring(., 1, 3) = 'SS:'">
                                    <xsl:value-of select = "substring(., 4, string-length(.) - 3)"/>
                                  </xsl:if>
                                </xsl:if>
                              </xsl:for-each>
                            </td>
                          </tr>
                        </xsl:if>
                        <xsl:if test = "$belge_barkodu = 1">
                          <tr>
                            <td colspan = "2" class = "barkod">
                              BARKOD GELECEK
                            </td>
                          </tr>
                        </xsl:if>
                        <xsl:if test = "$belge_barkodu_yazisi = 1">
                          <tr>
                            <td colspan = "2" class = "barkod_yazisi">
                              BARKOD YAZISI GELECEK
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                    </tbody>
                  </table>
                </xsl:if>
              </td>
            </tr>
            <xsl:if test = "$benzersiz_no = 1">
              <tr>
                <td colspan = "3">
                  <table id = "tbl_benzersiz">
                    <tbody>
                      <xsl:if test = "$xml_belge_uuid != ''">
                        <tr>
                          <th class = "bas_dikey">
                            <xsl:call-template name = "baslik_bicimlendir">
                              <xsl:with-param name = "baslik" select = "$bas_benzersiz_no"/>
                              <xsl:with-param name = "yuzde" select = "-1"/>
                            </xsl:call-template>
                          </th>
                          <td>
                            <xsl:value-of select = "$xml_belge_uuid"/>
                          </td>
                        </tr>
                      </xsl:if>
                    </tbody>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test = "$satirlar = 1">
              <tr>
                <td colspan = "3">
                  <table id = "tbl_satirlar">
                    <thead>
                      <xsl:if test = "($ing = 0) or ($tur = 1)">
                        <tr>
                          <xsl:call-template name = "sutunlari_goruntule">
                            <xsl:with-param name = "sutun_sirasi" select = "$sutun_sirasi_satirlar"/>
                            <xsl:with-param name = "dil" select = "$dil_tur"/>
                          </xsl:call-template>
                        </tr>
                      </xsl:if>
                      <xsl:if test = "$ing = 1">
                        <tr>
                          <xsl:call-template name = "sutunlari_goruntule">
                            <xsl:with-param name = "sutun_sirasi" select = "$sutun_sirasi_satirlar"/>
                            <xsl:with-param name = "dil" select = "$dil_ing"/>
                          </xsl:call-template>
                        </tr>
                      </xsl:if>
                    </thead>
                    <tbody>
                      <xsl:apply-templates select = "$xml_fatura_satiri"/>
                    </tbody>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <tr>
              <td colspan = "3">
                <table style = "width: 100%;">
                  <tbody>
                    <tr>
                      <xsl:if test = "$ihracat = 1">
                        <td style = "width: 1px;">
                          <xsl:for-each select = "$xml_belge/cac:Shipment/cac:Delivery">
                            <table id = "tbl_ihracat">
                              <tbody>
                                <xsl:if test = "$ihracat_mensei = 1">
                                  <xsl:if test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentTypeCode = $degisken_ihracat_mensei]) &gt; 0">
                                    <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                      <xsl:if test = "cbc:DocumentTypeCode = $degisken_ihracat_mensei">
                                        <tr>
                                          <th class = "bas_dikey">
                                            <xsl:call-template name = "baslik_bicimlendir">
                                              <xsl:with-param name = "baslik" select = "$bas_ihracat_mensei"/>
                                              <xsl:with-param name = "yuzde" select = "-1"/>
                                            </xsl:call-template>
                                          </th>
                                          <td>
                                            <xsl:value-of select = "cbc:DocumentType"/>
                                          </td>
                                        </tr>
                                      </xsl:if>
                                    </xsl:for-each>
                                  </xsl:if>
                                </xsl:if>
                                <xsl:if test = "$ihracat_teslim_sarti = 1">
                                  <xsl:if test = "cac:DeliveryTerms/cbc:ID[@schemeID = 'INCOTERMS'] != ''">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_ihracat_teslim_sarti"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:for-each select = "cac:DeliveryTerms/cbc:ID[@schemeID = 'INCOTERMS']">
                                          <xsl:value-of select = "."/>
                                        </xsl:for-each>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:if>
                                <xsl:if test = "$ihracat_gonderim_sekli = 1">
                                  <xsl:if test = "cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode != ''">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_ihracat_gonderim_sekli"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:for-each select = "cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode">
                                          <xsl:call-template name = "gonderim_bicimlendir">
                                            <xsl:with-param name = "g">
                                              <xsl:value-of select = "."/>
                                            </xsl:with-param>
                                          </xsl:call-template>
                                        </xsl:for-each>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:if>
                                <xsl:if test = "$ihracat_teslim_odeme_yeri = 1">
                                  <tr>
                                    <th class = "bas_dikey">
                                      <xsl:call-template name = "baslik_bicimlendir">
                                        <xsl:with-param name = "baslik" select = "$bas_ihracat_teslim_odeme_yeri"/>
                                        <xsl:with-param name = "yuzde" select = "-1"/>
                                      </xsl:call-template>
                                    </th>
                                    <td>
                                      <xsl:for-each select = "cac:DeliveryAddress">
                                        <xsl:call-template name = "adres_bicimlendir">
                                          <xsl:with-param name = "sokak" select = "cbc:StreetName"/>
                                          <xsl:with-param name = "bina_adi" select = "cbc:BuildingName"/>
                                          <xsl:with-param name = "dis_kapi_no" select = "cbc:BuildingNumber"/>
                                          <xsl:with-param name = "ic_kapi_no" select = "cbc:Room"/>
                                          <xsl:with-param name = "posta_kodu" select = "cbc:PostalZone"/>
                                          <xsl:with-param name = "ilce" select = "cbc:CitySubdivisionName"/>
                                          <xsl:with-param name = "il" select = "cbc:CityName"/>
                                          <xsl:with-param name = "ulke" select = "cbc:Country/cbc:Name"/>
                                        </xsl:call-template>
                                      </xsl:for-each>
                                    </td>
                                  </tr>
                                </xsl:if>
                                <xsl:variable
                                  name = "paketleme"
                                  select = "cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage"/>
                                <xsl:if test = "$kap_bilgileri_satirda = 0">
                                  <xsl:if test = "$ihracat_kap_markasi = 1">
                                    <xsl:variable name = "km" select = "$paketleme/cbc:PackageLevelCode"/>
                                    <xsl:if test = "$km != ''">
                                      <tr>
                                        <th class = "bas_dikey">
                                          <xsl:call-template name = "baslik_bicimlendir">
                                            <xsl:with-param name = "baslik" select = "$bas_ihracat_kap_markasi"/>
                                            <xsl:with-param name = "yuzde" select = "-1"/>
                                          </xsl:call-template>
                                        </th>
                                        <td>
                                          <xsl:value-of select = "$km"/>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                  </xsl:if>
                                  <xsl:if test = "$ihracat_kap_cinsi = 1">
                                    <xsl:variable name = "kc" select = "$paketleme/cbc:PackagingTypeCode"/>
                                    <xsl:if test = "$kc != ''">
                                      <tr>
                                        <th class = "bas_dikey">
                                          <xsl:call-template name = "baslik_bicimlendir">
                                            <xsl:with-param name = "baslik" select = "$bas_ihracat_kap_cinsi"/>
                                            <xsl:with-param name = "yuzde" select = "-1"/>
                                          </xsl:call-template>
                                        </th>
                                        <td>
                                          <xsl:value-of select = "$kc"/>
                                          <xsl:text>&#160;[</xsl:text>
                                          <xsl:call-template name = "kap_bicimlendir">
                                            <xsl:with-param name = "k" select = "$kc"/>
                                          </xsl:call-template>
                                          <xsl:text>]</xsl:text>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                  </xsl:if>
                                  <xsl:if test = "$ihracat_kap_no = 1">
                                    <xsl:variable name = "kn" select = "$paketleme/cbc:ID"/>
                                    <xsl:if test = "$kn != ''">
                                      <tr>
                                        <th class = "bas_dikey">
                                          <xsl:call-template name = "baslik_bicimlendir">
                                            <xsl:with-param name = "baslik" select = "$bas_ihracat_kap_no"/>
                                            <xsl:with-param name = "yuzde" select = "-1"/>
                                          </xsl:call-template>
                                        </th>
                                        <td>
                                          <xsl:value-of select = "$kn"/>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                  </xsl:if>
                                  <xsl:if test = "$ihracat_kap_sayisi = 1">
                                    <xsl:variable name = "ks" select = "$paketleme/cbc:Quantity"/>
                                    <xsl:if test = "$ks &gt; 0">
                                      <tr>
                                        <th class = "bas_dikey">
                                          <xsl:call-template name = "baslik_bicimlendir">
                                            <xsl:with-param name = "baslik" select = "$bas_ihracat_kap_sayisi"/>
                                            <xsl:with-param name = "yuzde" select = "-1"/>
                                          </xsl:call-template>
                                        </th>
                                        <td>
                                          <xsl:value-of select = "$ks"/>
                                        </td>
                                      </tr>
                                    </xsl:if>
                                  </xsl:if>
                                </xsl:if>
                              </tbody>
                            </table>
                          </xsl:for-each>
                        </td>
                      </xsl:if>
                      <xsl:if test = "$tasima = 1">
                        <td style = "width: 1px;">
                          <table id = "tbl_tasima">
                            <tbody>
                              <xsl:if test = "$tasima_web_adresi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_web_adresi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_web_adresi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_odeme_aracisi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_odeme_aracisi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_odeme_aracisi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_odeme_tipi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_odeme_tipi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_odeme_tipi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_odeme_tarihi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_odeme_tarihi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_odeme_tarihi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_gonderim_tarihi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_gonderim_tarihi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_gonderim_tarihi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_vkn = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_vkn">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_vkn"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_unvani = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_unvani">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_unvani"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_subesi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_subesi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_subesi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_ilcesi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_ilcesi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_ilcesi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_ili = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_ili">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_ili"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_kargo_ulkesi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_kargo_ulkesi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_kargo_ulkesi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                            </tbody>
                          </table>
                        </td>
                      </xsl:if>
                      <xsl:if test = "$tasima = 1">
                        <td style = "width: 1px;">
                          <table id = "tbl_tasima_2">
                            <tbody>
                              <xsl:if test = "$tasima_arac_plakasi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_arac_plakasi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_arac_plakasi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_dorse_plakasi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_dorse_plakasi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_dorse_plakasi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_surucu_1_tckn = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_surucu_1_tckn">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_surucu_1_tckn"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_surucu_1_adi_soyadi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_surucu_1_adi_soyadi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_surucu_1_adi_soyadi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_surucu_2_tckn = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_surucu_2_tckn">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_surucu_2_tckn"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                              <xsl:if test = "$tasima_surucu_2_adi_soyadi = 1">
                                <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                                  <xsl:if test = "cbc:DocumentTypeCode = $degisken_tasima_surucu_2_adi_soyadi">
                                    <tr>
                                      <th class = "bas_dikey">
                                        <xsl:call-template name = "baslik_bicimlendir">
                                          <xsl:with-param name = "baslik" select = "$bas_tasima_surucu_2_adi_soyadi"/>
                                          <xsl:with-param name = "yuzde" select = "-1"/>
                                        </xsl:call-template>
                                      </th>
                                      <td>
                                        <xsl:value-of select = "cbc:DocumentType"/>
                                      </td>
                                    </tr>
                                  </xsl:if>
                                </xsl:for-each>
                              </xsl:if>
                            </tbody>
                          </table>
                        </td>
                      </xsl:if>
                    </tr>
                  </tbody>
                </table>
              </td>
            </tr>
            <xsl:if test = "$siparisler = 1">
              <xsl:if test = "count($xml_belge_ek_belge_basvurulari[cbc:DocumentType = 'SIPARIS']) &gt; 0">
                <tr>
                  <td colspan = "3">
                    <table id = "tbl_siparisler">
                      <tbody>
                        <tr>
                          <th class = "bas_yatay">
                            <xsl:call-template name = "baslik_bicimlendir">
                              <xsl:with-param name = "baslik" select = "$bas_siparisler"/>
                              <xsl:with-param name = "yuzde" select = "-1"/>
                            </xsl:call-template>
                          </th>
                        </tr>
                        <tr>
                          <td style = "max-width: 210mm; white-space: normal;">
                            <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                              <xsl:if test = "cbc:DocumentType = 'SIPARIS'">
                                <span style = "display: inline-block;">
                                  <xsl:value-of select = "cbc:ID"/>
                                  <xsl:text>, </xsl:text>
                                  <xsl:call-template name = "tarih_bicimlendir">
                                    <xsl:with-param name = "tarih" select = "cbc:IssueDate"/>
                                  </xsl:call-template>
                                </span>
                              </xsl:if>
                            </xsl:for-each>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
            <xsl:if test = "$notlar = 1">
              <tr>
                <td colspan = "3">
                  <table id = "tbl_notlar">
                    <tbody>
                      <xsl:if test = "($cizgi_notlar = 1) or ($kucult = 0)">
                        <tr>
                          <th class = "bas_yatay" colspan = "2">
                            <xsl:call-template name = "baslik_bicimlendir">
                              <xsl:with-param name = "baslik" select = "$bas_notlar"/>
                              <xsl:with-param name = "yuzde" select = "-1"/>
                            </xsl:call-template>
                          </th>
                        </tr>
                      </xsl:if>
                      <xsl:for-each select = "$xml_belge/cbc:Note">
                        <xsl:if test = ". != ''">
                          <xsl:if test = "substring(., 1, 3) != 'SS:'">
                            <tr>
                              <td class = "stn_aciklama">
                                <xsl:call-template name = "satir_bicimlendir">
                                  <xsl:with-param name = "satir" select = "."/>
                                </xsl:call-template>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                      </xsl:for-each>
                      <xsl:if test = "$yonerge_notu = 1">
                        <xsl:variable
                          name = "xml_yonerge_notu"
                          select = "$xml_belge/cac:PaymentMeans/cbc:InstructionNote"/>
                        <xsl:if test = "$xml_yonerge_notu != ''">
                          <tr>
                            <td class = "stn_aciklama">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_yonerge_notu"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                              <xsl:text>&#160;</xsl:text>
                              <xsl:value-of select = "$xml_yonerge_notu"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$odeme_notu = 1">
                        <xsl:variable
                          name = "xml_odeme_notu"
                          select = "$xml_belge/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote"/>
                        <xsl:if test = "$xml_odeme_notu != ''">
                          <tr>
                            <td class = "stn_aciklama">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_odeme_notu"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                              <xsl:text>&#160;</xsl:text>
                              <xsl:value-of select = "$xml_odeme_notu"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test = "$odeme_sarti = 1">
                        <xsl:variable
                          name = "xml_odeme_sarti"
                          select = "$xml_belge/cac:PaymentTerms/cbc:Note"/>
                        <xsl:if test = "$xml_odeme_sarti != ''">
                          <tr>
                            <td class = "stn_aciklama">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_odeme_sarti"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                              </xsl:call-template>
                              <xsl:text>&#160;</xsl:text>
                              <xsl:value-of select = "$xml_odeme_sarti"/>
                            </td>
                          </tr>
                        </xsl:if>
                      </xsl:if>
                      <xsl:for-each select = "$xml_belge_ek_belge_basvurulari">
                        <xsl:if test = "$metro_yalniz = 1">
                          <xsl:if test = "cbc:DocumentType = 'YALNIZ_TL'">
                            <tr>
                              <td class = "stn_aciklama">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_metro_yalniz"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select = "cbc:ID"/>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test = "$metro_fatura_kod_listesi = 1">
                          <xsl:if test = "cbc:DocumentType = 'FATURAKODLIST'">
                            <tr>
                              <td class = "stn_aciklama">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_metro_fatura_kod_listesi"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select = "cbc:ID"/>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test = "$metro_gumruk_kunyesi = 1">
                          <xsl:if test = "cbc:DocumentType = 'KUNYE'">
                            <tr>
                              <td class = "stn_aciklama">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_metro_gumruk_kunyesi"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select = "cbc:ID"/>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test = "$metro_borsa_tescili = 1">
                          <xsl:if test = "cbc:DocumentType = 'BORSATESCIL'">
                            <tr>
                              <td class = "stn_aciklama">
                                <xsl:call-template name = "baslik_bicimlendir">
                                  <xsl:with-param name = "baslik" select = "$bas_metro_borsa_tescili"/>
                                  <xsl:with-param name = "yuzde" select = "-1"/>
                                </xsl:call-template>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select = "cbc:ID"/>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:if>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test = "$iadeler = 1">
              <tr>
                <td colspan = "3">
                  <table id = "tbl_iadeler">
                    <tbody>
                      <xsl:if test = "($ing = 0) or ($tur = 1)">
                        <tr>
                          <th class = "bas_yatay" style = "text-align: left;" colspan = "4">
                            <xsl:call-template name = "baslik_bicimlendir">
                              <xsl:with-param name = "baslik" select = "$bas_iadeler"/>
                              <xsl:with-param name = "yuzde" select = "-1"/>
                              <xsl:with-param name = "dil" select = "$dil_tur"/>
                            </xsl:call-template>
                          </th>
                        </tr>
                        <tr>
                          <xsl:if test = "$stn_iade_sira_no = 1">
                            <th class = "bas_yatay stn_iade_sira_no">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_sira_no"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_urun_adi = 1">
                            <th class = "bas_yatay stn_iade_urun_adi">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_urun_adi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_miktar_birim = 1">
                            <th class = "bas_yatay stn_iade_miktar_birim">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_miktar_birim"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_nedeni = 1">
                            <th class = "bas_yatay stn_iade_nedeni">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_nedeni"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                        </tr>
                      </xsl:if>
                      <xsl:if test = "$ing = 1">
                        <tr>
                          <xsl:if test = "$stn_iade_sira_no = 1">
                            <th class = "bas_yatay stn_iade_sira_no">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_sira_no"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_urun_adi = 1">
                            <th class = "bas_yatay stn_iade_urun_adi">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_urun_adi"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_miktar_birim = 1">
                            <th class = "bas_yatay stn_iade_miktar_birim">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_miktar_birim"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_iade_nedeni = 1">
                            <th class = "bas_yatay stn_iade_nedeni">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_iade_nedeni"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                        </tr>
                      </xsl:if>
                      <tr>
                        <td class = "stn_iade_sira_no">1</td>
                        <td class = "stn_iade_urun_adi"></td>
                        <td class = "stn_iade_miktar_birim"></td>
                        <td class = "stn_iade_nedeni"></td>
                      </tr>
                      <tr>
                        <td class = "stn_iade_sira_no">2</td>
                        <td class = "stn_iade_urun_adi"></td>
                        <td class = "stn_iade_miktar_birim"></td>
                        <td class = "stn_iade_nedeni"></td>
                      </tr>
                      <tr>
                        <td class = "stn_iade_sira_no">3</td>
                        <td class = "stn_iade_urun_adi"></td>
                        <td class = "stn_iade_miktar_birim"></td>
                        <td class = "stn_iade_nedeni"></td>
                      </tr>
                      <tr>
                        <td class = "stn_iade_sira_no">4</td>
                        <td class = "stn_iade_urun_adi"></td>
                        <td class = "stn_iade_miktar_birim"></td>
                        <td class = "stn_iade_nedeni"></td>
                      </tr>
                      <tr>
                        <td class = "stn_iade_sira_no">5</td>
                        <td class = "stn_iade_urun_adi"></td>
                        <td class = "stn_iade_miktar_birim"></td>
                        <td class = "stn_iade_nedeni"></td>
                      </tr>
                    </tbody>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test = "$teslimat = 1">
              <tr>
                <td colspan = "3">
                  <table id = "tbl_teslimat">
                    <tbody>
                      <xsl:if test = "($ing = 0) or ($tur = 1)">
                        <tr>
                          <xsl:if test = "$stn_teslim_alan = 1">
                            <th class = "bas_yatay" style = "text-align: left;">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_teslim_alan"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test  = "$stn_teslim_eden = 1">
                            <th class = "bas_yatay">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_teslim_eden"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_tur"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                        </tr>
                      </xsl:if>
                      <xsl:if test = "$ing = 1">
                        <tr>
                          <xsl:if test = "$stn_teslim_alan = 1">
                            <th class = "bas_yatay" style = "text-align: left;">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_teslim_alan"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                          <xsl:if test = "$stn_teslim_eden = 1">
                            <th class = "bas_yatay">
                              <xsl:call-template name = "baslik_bicimlendir">
                                <xsl:with-param name = "baslik" select = "$bas_teslim_eden"/>
                                <xsl:with-param name = "yuzde" select = "-1"/>
                                <xsl:with-param name = "dil" select = "$dil_ing"/>
                              </xsl:call-template>
                            </th>
                          </xsl:if>
                        </tr>
                      </xsl:if>
                      <tr>
                        <xsl:if test = "$stn_teslim_alan = 1">
                          <td>&#160;<br/>&#160;<br/>&#160;<br/>&#160;</td>
                        </xsl:if>
                        <xsl:if test = "$stn_teslim_eden = 1">
                          <td>&#160;<br/>&#160;<br/>&#160;<br/>&#160;</td>
                        </xsl:if>
                      </tr>
                    </tbody>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <tr>
              <td colspan = "3" style = "height: 10px;"/>
            </tr>
          </tbody>
          <tfoot>
            <tr>
              <th></th>
            </tr>
          </tfoot>
          <xsl:if test = "$simge_logo = 1 or $orka = 1">
            <tfoot>
              <xsl:if test = "$simge_logo = 1">
                <tr>
                  <td colspan = "3">
                    <center>
                      <img id = "simge_logo" src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA5gAAABkAQMAAADZvg0BAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAADUExURf///6fEG8gAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAhSURBVGje7cEBAQAAAIIg/69uSEAAAAAAAAAAAAAAAJdqLVAAAaFAa4gAAAAASUVORK5CYII="/>
                    </center>
                  </td>
                </tr>
              </xsl:if>
              <xsl:if test = "$orka = 1">
                <tr>
                  <td colspan = "3">
                    <center>
                      <footer class = "yazdirma">
                        <a href = "https://www.orka.com.tr" target = "_blank">Orka - WinIceberg E.R.P. Uygulaması Kullanılarak Hazırlanmıştır - www.orka.com.tr</a>
                      </footer>
                    </center>
                  </td>
                </tr>
              </xsl:if>
            </tfoot>
          </xsl:if>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template name = "baslik_bicimlendir">
    <xsl:param name = "baslik"/>
    <xsl:param name = "yuzde"/>
    <xsl:param name = "bicim"/>
    <xsl:param name = "ek"/>
    <xsl:param name = "dil"/>
    <xsl:if test = "($baslik != '') and ($baslik != ' ') and ($baslik != '$oge_ayiraci')">
      <xsl:if test = "($dil = '') or ($dil = $dil_tur)">
        <xsl:if test = "($ing = 0) or ($tur = 1)">
          <xsl:call-template name = "dizeyi_degistir">
            <xsl:with-param name = "dize" select = "substring-before($baslik, $oge_ayiraci)"/>
            <xsl:with-param name = "bul" select = "$satir_ayiraci"/>
            <xsl:with-param name = "degistir" select = "$ys"/>
          </xsl:call-template>
          <xsl:if test = "$ek != ''">
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select = "$ek"/>
          </xsl:if>
          <xsl:if test = "$yuzde &gt; -1">
            <xsl:text>&#160;(%</xsl:text>
            <xsl:if test = "$bicim = ''">
              <xsl:value-of disable-output-escaping = "yes" select = "format-number($yuzde, $bicim_yuzde, $bolge)"/>
            </xsl:if>
            <xsl:if test = "$bicim != ''">
              <xsl:value-of disable-output-escaping = "yes" select = "format-number($yuzde, $bicim, $bolge)"/>
            </xsl:if>
            <xsl:text>)</xsl:text>
          </xsl:if>
          <xsl:if test = "$dil != $dil_tur">
            <xsl:if test = "$yuzde != -2">
              <xsl:text>:</xsl:text>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "($dil = '') or ($dil = $dil_ing)">
        <xsl:if test = "$ing = 1">
          <xsl:if test = "$tur = 1">
            <xsl:if test = "$dil != $dil_ing">
              <br/>
            </xsl:if>
          </xsl:if>
          <xsl:call-template name = "dizeyi_degistir">
            <xsl:with-param name = "dize" select = "substring-after($baslik, $oge_ayiraci)"/>
            <xsl:with-param name = "bul" select = "$satir_ayiraci"/>
            <xsl:with-param name = "degistir" select = "$ys"/>
          </xsl:call-template>
          <xsl:if test = "$ek != ''">
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select = "$ek"/>
          </xsl:if>
          <xsl:if test = "$yuzde &gt; -1">
            <xsl:text>&#160;(</xsl:text>
            <xsl:if test = "$bicim = ''">
              <xsl:value-of disable-output-escaping = "yes" select = "format-number($yuzde, $bicim_yuzde, $bolge)"/>
            </xsl:if>
            <xsl:if test = "$bicim != ''">
              <xsl:value-of disable-output-escaping = "yes" select = "format-number($yuzde, $bicim, $bolge)"/>
            </xsl:if>
            <xsl:text>%)</xsl:text>
          </xsl:if>
          <xsl:if test = "$dil != $dil_ing">
            <xsl:if test = "$yuzde != -2">
              <xsl:text>:</xsl:text>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "satir_bicimlendir">
    <xsl:param name = "satir"/>
    <xsl:if test = "$satir != ''">
      <xsl:variable name = "s" select = "concat($satir, $oge_ayiraci)"/>
      <xsl:call-template name = "dizeyi_degistir">
        <xsl:with-param name = "dize" select = "substring-before($s, $oge_ayiraci)"/>
        <xsl:with-param name = "bul" select = "$satir_ayiraci"/>
        <xsl:with-param name = "degistir" select = "$ys"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "isim_bicimlendir">
    <xsl:param name = "on_ek"/>
    <xsl:param name = "ilk_isim"/>
    <xsl:param name = "ikinci_isim"/>
    <xsl:param name = "soy_isim"/>
    <xsl:param name = "son_ek"/>
    <xsl:if test = "$on_ek != ''">
      <xsl:value-of select = "$on_ek"/>
    </xsl:if>
    <xsl:if test = "$ilk_isim != ''">
      <xsl:if test = "$on_ek != ''">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:value-of select = "$ilk_isim"/>
    </xsl:if>
    <xsl:if test = "$ikinci_isim != ''">
      <xsl:if test = "($on_ek != '') or ($ilk_isim != '')">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:value-of select = "$ikinci_isim"/>
    </xsl:if>
    <xsl:if test = "$soy_isim != ''">
      <xsl:if test = "($on_ek != '') or ($ilk_isim != '') or ($ikinci_isim != '')">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:value-of select = "$soy_isim"/>
    </xsl:if>
    <xsl:if test = "$son_ek != ''">
      <xsl:if test = "($on_ek != '') or ($ilk_isim != '') or ($ikinci_isim != '') or ($soy_isim != '')">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:value-of select = "$son_ek"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "adres_bicimlendir">
    <xsl:param name = "sokak"/>
    <xsl:param name = "bina_adi"/>
    <xsl:param name = "dis_kapi_no"/>
    <xsl:param name = "ic_kapi_no"/>
    <xsl:param name = "posta_kodu"/>
    <xsl:param name = "ilce"/>
    <xsl:param name = "il"/>
    <xsl:param name = "ulke"/>
    <xsl:if test = "$sokak != ''">
      <xsl:value-of select = "$sokak"/>
    </xsl:if>
    <xsl:if test = "$bina_adi != ''">
      <xsl:if test = "$sokak != ''">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:value-of select = "$bina_adi"/>
    </xsl:if>
    <xsl:if test = "($dis_kapi_no != '') or ($ic_kapi_no != '')">
      <xsl:if test = "($sokak != '') or ($bina_adi != '')">
        <xsl:text>&#160;</xsl:text>
      </xsl:if>
      <xsl:text>No:&#160;</xsl:text>
      <xsl:if test = "$dis_kapi_no != ''">
        <xsl:value-of select = "$dis_kapi_no"/>
      </xsl:if>
      <xsl:if test = "$ic_kapi_no != ''">
        <xsl:if test = "$dis_kapi_no != ''">
          <xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select = "$ic_kapi_no"/>
      </xsl:if>
    </xsl:if>
    <xsl:if test = "($posta_kodu != '') or ($ilce != '') or ($il != '') or ($ulke != '')">
      <xsl:if test = "($sokak != '') or ($bina_adi != '') or ($dis_kapi_no != '') or ($ic_kapi_no != '')">
        <br/>
      </xsl:if>
      <xsl:if test = "$posta_kodu != ''">
        <xsl:value-of select = "$posta_kodu"/>
      </xsl:if>
      <xsl:if test = "$ilce != ''">
        <xsl:if test = "$posta_kodu != ''">
          <xsl:text>,&#160;</xsl:text>
        </xsl:if>
        <xsl:value-of select = "$ilce"/>
      </xsl:if>
      <xsl:if test = "$il != ''">
        <xsl:if test = "($posta_kodu != '') or ($ilce != '')">
          <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:value-of select = "$il"/>
      </xsl:if>
      <xsl:if test = "$ulke != ''">
        <xsl:if test = "($posta_kodu != '') or ($ilce != '') or ($il != '')">
          <xsl:text>,&#160;</xsl:text>
        </xsl:if>
        <xsl:value-of select = "$ulke"/>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "tarih_bicimlendir">
    <xsl:param name = "tarih"/>
    <xsl:variable name = "tarih_dize" select = "string($tarih)"/>
    <xsl:if test = "$tarih_dize != ''">
      <xsl:value-of select = "substring($tarih_dize, 9, 2)"/>
      <xsl:text>/</xsl:text>
      <xsl:value-of select = "substring($tarih_dize, 6, 2)"/>
      <xsl:text>/</xsl:text>
      <xsl:value-of select = "substring($tarih_dize, 1, 4)"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "saat_bicimlendir">
    <xsl:param name = "saat"/>
    <xsl:variable name = "saat_dize" select = "string($saat)"/>
    <xsl:if test = "$saat_dize != ''">
      <xsl:value-of select = "substring($saat_dize, 1, 2)"/>
      <xsl:text>:</xsl:text>
      <xsl:value-of select = "substring($saat_dize, 4, 2)"/>
      <xsl:text>:</xsl:text>
      <xsl:value-of select = "substring($saat_dize, 7, 2)"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "para_bicimlendir">
    <xsl:param name = "tutar"/>
    <xsl:param name = "birim"/>
    <xsl:param name = "bicim"/>
    <xsl:value-of select = "format-number($tutar, $bicim, $bolge)"/>
    <xsl:if test = "$birim">
      <xsl:text>&#160;</xsl:text>
      <xsl:choose>
        <xsl:when test = "$birim = $trl">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:when test = "$birim = $try">
          <xsl:text>TL</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select = "$birim"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "birim_bicimlendir">
    <xsl:param name = "b"/>
    <xsl:if test = "$b != ''">
      <xsl:text>&#160;</xsl:text>
        <xsl:choose>
          <xsl:when test = "$b = 'TNE'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_tne"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'NT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_nt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'GT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_gt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'KGM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_kgm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'GRM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_grm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MGM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mgm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'KTM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ktm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MTR'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mtr"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'DMT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_dmt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'CMT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_cmt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MMT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mmt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MTK'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mtk"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'DMK'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_dmk"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'CMK'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_cmk"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MMK'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mmk"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MTQ'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mtq"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'DMQ'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_dmq"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'CMQ'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_cmq"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MMQ'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mmq"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'R9'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_r9"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'LTR'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ltr"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'DLT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_dlt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'CLT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_clt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MLT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mlt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'D40'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_d40"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'LPA'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_lpa"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'NIU'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_niu"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'C62'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_c62"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'PR'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_pr"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'BX'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_bx"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'PA'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_pa"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test=  "$b =  'PG'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_pg"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'SET'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_set"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'BO'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_bo"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'JR'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_jr"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'CH'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ch"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'TP'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_tp"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b =  'T3'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_t3"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'NCL'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ncl"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'CTM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ctm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'WTT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_wtt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'KWT'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_kwt"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'KWH'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_kwh"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'KJO'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_kjo"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'B32'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_b32"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'D70'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_d70"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'D30'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_d30"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'ANN'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ann"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'MON'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_mon"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'WEE'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_wee"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'DAY'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_day"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'HUR'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_hur"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'D61'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_d61"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'D62'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_d62"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test = "$b = 'LM'">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_lm"/>
              <xsl:with-param name = "yuzde" select = "-2"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select = "$b"/>
          </xsl:otherwise>
        </xsl:choose>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name = "kap_bicimlendir">
    <xsl:param name = "k"/>
    <xsl:if test = "$k != ''">
      <xsl:choose>
        <xsl:when test = "$k = 'TI'">42 Galonluk Fıçı</xsl:when>
        <xsl:when test = "$k = 'NT'">Ağ</xsl:when>
        <xsl:when test = "$k = 'NV'">Ağ, Boru, Dokuma Kumaş</xsl:when>
        <xsl:when test = "$k = 'NU'">Ağ, Boru, Plastik</xsl:when>
        <xsl:when test = "$k = 'CK'">Ahşap Varil</xsl:when>
        <xsl:when test = "$k = 'PK'">Ambalaj</xsl:when>
        <xsl:when test = "$k = 'IE'">Ambalaj, Gösterişli</xsl:when>
        <xsl:when test = "$k = 'ID'">Ambalaj, Gösterişli, Metal</xsl:when>
        <xsl:when test = "$k = 'IB'">Ambalaj, Gösterişli, Mukavva</xsl:when>
        <xsl:when test = "$k = 'IC'">Ambalaj, Gösterişli, Plastik</xsl:when>
        <xsl:when test = "$k = 'IA'">Ambalaj, Gösterişli, Tahta</xsl:when>
        <xsl:when test = "$k = 'IF'">Ambalaj, Kabarık</xsl:when>
        <xsl:when test = "$k = 'IG'">Ambalaj, Kağıt Sarılı</xsl:when>
        <xsl:when test = "$k = 'IK'">Ambalaj, Mukavva, Üstten Tutmak İçin Delikli</xsl:when>
        <xsl:when test = "$k = 'AP'">Ampul, Korumalı</xsl:when>
        <xsl:when test = "$k = 'AM'">Ampul, Korumasız</xsl:when>
        <xsl:when test = "$k = 'VN'">Araç</xsl:when>
        <xsl:when test = "$k = 'LE'">Bagaj</xsl:when>
        <xsl:when test = "$k = 'CE'">Balık Sepeti</xsl:when>
        <xsl:when test = "$k = 'BP'">Balon, Korumalı</xsl:when>
        <xsl:when test = "$k = 'BF'">Balon, Korumasız</xsl:when>
        <xsl:when test = "$k = 'BN'">Balya, Sıkıştırılmamış</xsl:when>
        <xsl:when test = "$k = 'BL'">Balya, Sıkıştırılmış</xsl:when>
        <xsl:when test = "$k = 'SU'">Bavul</xsl:when>
        <xsl:when test = "$k = '3A'">Beş Galonluk Bidon, Çelik</xsl:when>
        <xsl:when test = "$k = 'QL'">Beş Galonluk Bidon, Çelik, Çıkartılabilir Kafa</xsl:when>
        <xsl:when test = "$k = 'QK'">Beş Galonluk Bidon, Çelik, Çıkartılamayan Kafa</xsl:when>
        <xsl:when test = "$k = 'JC'">Beş Galonluk Bidon, Dikdörtgen</xsl:when>
        <xsl:when test = "$k = '3H'">Beş Galonluk Bidon, Plastik</xsl:when>
        <xsl:when test = "$k = 'QN'">Beş Galonluk Bidon, Plastik, Çıkartılabilir Kafa</xsl:when>
        <xsl:when test = "$k = 'QM'">Beş Galonluk Bidon, Plastik, Çıkartılamayan Kafa</xsl:when>
        <xsl:when test = "$k = 'JY'">Beş Galonluk Bidon, Silindirik</xsl:when>
        <xsl:when test = "$k = 'YR'">Birleşik Ambalaj, Alüminyum Kasa İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YD'">Birleşik Ambalaj, Alüminyum Kasa İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YQ'">Birleşik Ambalaj, Alüminyum Tambur İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YC'">Birleşik Ambalaj, Alüminyum Tambur İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = '6P'">Birleşik Ambalaj, Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YB'">Birleşik Ambalaj, Çelik Kasa Kutu İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YP'">Birleşik Ambalaj, Çelik Sandık Kutu İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YN'">Birleşik Ambalaj, Çelik Tambur İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YA'">Birleşik Ambalaj, Çelik Tambur İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YY'">Birleşik Ambalaj, Dayanıklı Olmayan Plastik Çıkın İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YW'">Birleşik Ambalaj, Elyaf Tambur İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YJ'">Birleşik Ambalaj, Elyaf Tambur İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YV'">Birleşik Ambalaj, Hasır Kapaklı Sepet İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YH'">Birleşik Ambalaj, Kontrplak Kutu İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YT'">Birleşik Ambalaj, Kontrplak Tambur İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YG'">Birleşik Ambalaj, Kontrplak Tambur İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = '6H'">Birleşik Ambalaj, Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YL'">Birleşik Ambalaj, Plastik Tambur İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YZ'">Birleşik Ambalaj, Sağlam Plastik Denk İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YM'">Birleşik Ambalaj, Sağlam Plastik Kutu İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YX'">Birleşik Ambalaj, Sıkıştırılmış Liflerden Yapılmış Tahta Kutu İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YK'">Birleşik Ambalaj, Sıkıştırılmış Liflerden Yapılmış Tahta Kutu İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YS'">Birleşik Ambalaj, Tahta Kutu İçinde Cam Muhafaza</xsl:when>
        <xsl:when test = "$k = 'YF'">Birleşik Ambalaj, Tahtadan Kutu İçinde Plastik Muhafaza</xsl:when>
        <xsl:when test = "$k = 'OK'">Blok</xsl:when>
        <xsl:when test = "$k = 'BB'">Bobin</xsl:when>
        <xsl:when test = "$k = 'SO'">Bobin</xsl:when>
        <xsl:when test = "$k = 'BE'">Bohça</xsl:when>
        <xsl:when test = "$k = '8C'">Bohça, Tahta</xsl:when>
        <xsl:when test = "$k = 'PI'">Boru</xsl:when>
        <xsl:when test = "$k = 'PV'">Boru, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'TT'">Büyük El Çantası</xsl:when>
        <xsl:when test = "$k = 'TR'">Büyük Eşya Sandığı</xsl:when>
        <xsl:when test = "$k = 'BU'">Büyük Fıçı</xsl:when>
        <xsl:when test = "$k = 'HG'">Büyük Fıçı</xsl:when>
        <xsl:when test = "$k = 'TO'">Büyük Fıçı</xsl:when>
        <xsl:when test = "$k = 'CZ'">Çadır Bezi</xsl:when>
        <xsl:when test = "$k = 'BG'">Çanta</xsl:when>
        <xsl:when test = "$k = 'JB'">Çanta, Büyük Boy</xsl:when>
        <xsl:when test = "$k = 'MB'">Çanta, Büyüyen</xsl:when>
        <xsl:when test = "$k = '43'">Çanta, Çok Hacimli</xsl:when>
        <xsl:when test = "$k = 'GY'">Çanta, Çuval</xsl:when>
        <xsl:when test = "$k = '5L'">Çanta, Dokuma Kumaş</xsl:when>
        <xsl:when test = "$k = 'XF'">Çanta, Dokuma Kumaş, Astarsız</xsl:when>
        <xsl:when test = "$k = 'XG'">Çanta, Dokuma Kumaş, Dayanaklı</xsl:when>
        <xsl:when test = "$k = 'XH'">Çanta, Dokuma Kumaş, Su Geçirmez</xsl:when>
        <xsl:when test = "$k = 'FX'">Çanta, Esnek Hazne</xsl:when>
        <xsl:when test = "$k = 'ZB'">Çanta, Geniş</xsl:when>
        <xsl:when test = "$k = '5M'">Çanta, Kağıt</xsl:when>
        <xsl:when test = "$k = 'XJ'">Çanta, Kağıt, Katmanlı</xsl:when>
        <xsl:when test = "$k = 'XK'">Çanta, Kağıt, Katmanlı, Su Geçirmez</xsl:when>
        <xsl:when test = "$k = 'EC'">Çanta, Plastik</xsl:when>
        <xsl:when test = "$k = '5H'">Çanta, Plastik Dokuma</xsl:when>
        <xsl:when test = "$k = 'XA'">Çanta, Plastik Dokuma, Astarsız</xsl:when>
        <xsl:when test = "$k = 'XB'">Çanta, Plastik Dokuma, Dayanaklı</xsl:when>
        <xsl:when test = "$k = 'XC'">Çanta, Plastik Dokuma, Su Geçirmez</xsl:when>
        <xsl:when test = "$k = 'XD'">Çanta, Plastik Tabakalı</xsl:when>
        <xsl:when test = "$k = '44'">Çanta, Şeffaf Plastik</xsl:when>
        <xsl:when test = "$k = 'TC'">Çay Sandığı</xsl:when>
        <xsl:when test = "$k = 'SW'">Çekme-Sarma</xsl:when>
        <xsl:when test = "$k = 'FR'">Çerçeve</xsl:when>
        <xsl:when test = "$k = 'BT'">Cıvata</xsl:when>
        <xsl:when test = "$k = 'PT'">Çömlek</xsl:when>
        <xsl:when test = "$k = 'BR'">Çubuk</xsl:when>
        <xsl:when test = "$k = 'RD'">Çubuk</xsl:when>
        <xsl:when test = "$k = 'BZ'">Çubuk, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'RZ'">Çubuk, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'SA'">Çuval</xsl:when>
        <xsl:when test = "$k = 'MS'">Çuval, Çok Katmanlı</xsl:when>
        <xsl:when test = "$k = 'CP'">Damacana, Korumalı</xsl:when>
        <xsl:when test = "$k = 'DP'">Damacana, Korumalı</xsl:when>
        <xsl:when test = "$k = 'DJ'">Damacana, Korumasız</xsl:when>
        <xsl:when test = "$k = 'CO'">Damacana, Korumasız</xsl:when>
        <xsl:when test = "$k = 'FL'">Dar Küçük Şişe</xsl:when>
        <xsl:when test = "$k = 'DR'">Davul</xsl:when>
        <xsl:when test = "$k = '1B'">Davul, Alüminyum</xsl:when>
        <xsl:when test = "$k = 'QD'">Davul, Alüminyum, Çıkartılabilir Kafa</xsl:when>
        <xsl:when test = "$k = 'QC'">Davul, Alüminyum, Çıkartılamayan Kafa</xsl:when>
        <xsl:when test = "$k = '1A'">Davul, Çelik</xsl:when>
        <xsl:when test = "$k = 'QB'">Davul, Çelik, Çıkartılabilir Kafa</xsl:when>
        <xsl:when test = "$k = 'QA'">Davul, Çelik, Çıkartılamayan Kafa</xsl:when>
        <xsl:when test = "$k = 'DI'">Davul, Demir</xsl:when>
        <xsl:when test = "$k = '1G'">Davul, Elyaf</xsl:when>
        <xsl:when test = "$k = '1D'">Davul, Kontrplak</xsl:when>
        <xsl:when test = "$k = 'IH'">Davul, Plastik</xsl:when>
        <xsl:when test = "$k = 'QG'">Davul, Plastik, Çıkartılabilir Kafa</xsl:when>
        <xsl:when test = "$k = 'QF'">Davul, Plastik, Çıkartılamayan Kafa</xsl:when>
        <xsl:when test = "$k = '1W'">Davul, Tahta</xsl:when>
        <xsl:when test = "$k = 'TS'">Demet</xsl:when>
        <xsl:when test = "$k = 'BH'">Deste</xsl:when>
        <xsl:when test = "$k = 'GI'">Direk</xsl:when>
        <xsl:when test = "$k = 'GZ'">Direk, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'DN'">Dispenser</xsl:when>
        <xsl:when test = "$k = 'VG'">Dökme, Gaz (1031 mbar ve 15oC’de)</xsl:when>
        <xsl:when test = "$k = 'VS'">Dökme, Hurda Metal</xsl:when>
        <xsl:when test = "$k = 'VO'">Dökme, Katı, Büyük Parçacıklar (Yumrular)</xsl:when>
        <xsl:when test = "$k = 'VR'">Dökme, Katı, Granüllü Parçacıklar (Tahıllar)</xsl:when>
        <xsl:when test = "$k = 'VY'">Dökme, Katı, İnce Parçacıklar (Toz)</xsl:when>
        <xsl:when test = "$k = 'VL'">Dökme, Sıvı</xsl:when>
        <xsl:when test = "$k = 'VQ'">Dökme, Sıvılaştırılmış Gaz (Normal Olmayan  Isı/Basınçta)</xsl:when>
        <xsl:when test = "$k = 'NA'">Elde Mevcut Olmayan</xsl:when>
        <xsl:when test = "$k = 'FB'">Esnek Çanta</xsl:when>
        <xsl:when test = "$k = 'FE'">Esnek Tank</xsl:when>
        <xsl:when test = "$k = 'SX'">Fide</xsl:when>
        <xsl:when test = "$k = 'FP'">Film Paketi</xsl:when>
        <xsl:when test = "$k = 'CU'">Fincan</xsl:when>
        <xsl:when test = "$k = 'FT'">FoodTainer</xsl:when>
        <xsl:when test = "$k = 'VK'">Furgon Ambalajı</xsl:when>
        <xsl:when test = "$k = 'SE'">Gemici Sandığı</xsl:when>
        <xsl:when test = "$k = 'PL'">Gerdel</xsl:when>
        <xsl:when test = "$k = 'RG'">Halka</xsl:when>
        <xsl:when test = "$k = 'MT'">Hasır</xsl:when>
        <xsl:when test = "$k = 'PH'">İbrik</xsl:when>
        <xsl:when test = "$k = 'SD'">İğ</xsl:when>
        <xsl:when test = "$k = 'JT'">Jüt Çuval</xsl:when>
        <xsl:when test = "$k = 'CG'">Kafes</xsl:when>
        <xsl:when test = "$k = 'RK'">Kafes</xsl:when>
        <xsl:when test = "$k = 'RJ'">Kafes, Çengelli</xsl:when>
        <xsl:when test = "$k = 'DG'">Kafes, Milletler Topluluğu Elleçleme Ekipman Havuzu (CHEP)</xsl:when>
        <xsl:when test = "$k = 'CW'">Kafes, Rulo</xsl:when>
        <xsl:when test = "$k = 'UC'">Kafesli Olmayan</xsl:when>
        <xsl:when test = "$k = 'PN'">Kalas</xsl:when>
        <xsl:when test = "$k = 'PZ'">Kalas, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'HN'">Kanca</xsl:when>
        <xsl:when test = "$k = 'CL'">Kangal</xsl:when>
        <xsl:when test = "$k = 'BI'">Kap</xsl:when>
        <xsl:when test = "$k = 'HR'">Kapaklı Sepet</xsl:when>
        <xsl:when test = "$k = 'NE'">Kapsız veya Ambalajlanmamış</xsl:when>
        <xsl:when test = "$k = 'NG'">Kapsız veya Ambalajlanmamış, Çoklu Birim</xsl:when>
        <xsl:when test = "$k = 'NF'">Kapsız veya Ambalajlanmamış, Tek Birim</xsl:when>
        <xsl:when test = "$k = 'AV'">Kapsül</xsl:when>
        <xsl:when test = "$k = 'CT'">Karton</xsl:when>
        <xsl:when test = "$k = 'CQ'">Kartuş</xsl:when>
        <xsl:when test = "$k = 'CS'">Kasa</xsl:when>
        <xsl:when test = "$k = 'CB'">Kasa, Bira</xsl:when>
        <xsl:when test = "$k = 'SS'">Kasa, Çelik</xsl:when>
        <xsl:when test = "$k = 'FD'">Kasa, Çerçeveli</xsl:when>
        <xsl:when test = "$k = 'DC'">Kasa, Çok Katmanlı, Mukavva</xsl:when>
        <xsl:when test = "$k = 'DA'">Kasa, Çok Katmanlı, Plastik</xsl:when>
        <xsl:when test = "$k = 'DB'">Kasa, Çok Katmanlı, Tahta</xsl:when>
        <xsl:when test = "$k = 'DK'">Kasa, Hacimli, Mukavva</xsl:when>
        <xsl:when test = "$k = 'DL'">Kasa, Hacimli, Plastik</xsl:when>
        <xsl:when test = "$k = 'DM'">Kasa, Hacimli, Tahta</xsl:when>
        <xsl:when test = "$k = '7A'">Kasa, Hareketli</xsl:when>
        <xsl:when test = "$k = 'SK'">Kasa, İskeletli</xsl:when>
        <xsl:when test = "$k = 'EI'">Kasa, İzotermik</xsl:when>
        <xsl:when test = "$k = 'MA'">Kasa, Metal</xsl:when>
        <xsl:when test = "$k = 'FC'">Kasa, Meyve</xsl:when>
        <xsl:when test = "$k = 'ED'">Kasa, Palet Tabanlı</xsl:when>
        <xsl:when test = "$k = 'EH'">Kasa, Palet Tabanlı, Metal</xsl:when>
        <xsl:when test = "$k = 'EF'">Kasa, Palet Tabanlı, Mukavva</xsl:when>
        <xsl:when test = "$k = 'EG'">Kasa, Palet Tabanlı, Plastik</xsl:when>
        <xsl:when test = "$k = 'EE'">Kasa, Palet Tabanlı, Tahtadan</xsl:when>
        <xsl:when test = "$k = 'SC'">Kasa, Sığ</xsl:when>
        <xsl:when test = "$k = 'MC'">Kasa, Süt</xsl:when>
        <xsl:when test = "$k = '7B'">Kasa, Tahta</xsl:when>
        <xsl:when test = "$k = '8B'">Kasa, Tahta</xsl:when>
        <xsl:when test = "$k = 'JR'">Kavanoz</xsl:when>
        <xsl:when test = "$k = 'B4'">Kayış</xsl:when>
        <xsl:when test = "$k = 'PO'">Kese</xsl:when>
        <xsl:when test = "$k = 'MX'">Kibrit Kutusu</xsl:when>
        <xsl:when test = "$k = 'CV'">Kılıf</xsl:when>
        <xsl:when test = "$k = 'SI'">Kızak</xsl:when>
        <xsl:when test = "$k = 'SH'">Koku Torbası</xsl:when>
        <xsl:when test = "$k = 'OU'">Konteyner, Dış</xsl:when>
        <xsl:when test = "$k = '1F'">Konteyner, Esnek</xsl:when>
        <xsl:when test = "$k = 'GL'">Konteyner, Galon</xsl:when>
        <xsl:when test = "$k = 'ME'">Konteyner, Metal</xsl:when>
        <xsl:when test = "$k = 'CN'">Konteyner, Taşıma Ekipmanı Olarak Başka Şekilde Belirtilmedikçe</xsl:when>
        <xsl:when test = "$k = 'BJ'">Kova</xsl:when>
        <xsl:when test = "$k = 'KG'">Küçük Fıçı</xsl:when>
        <xsl:when test = "$k = 'FO'">Küçük Sandık</xsl:when>
        <xsl:when test = "$k = 'AJ'">Külah</xsl:when>
        <xsl:when test = "$k = 'IN'">Külçe</xsl:when>
        <xsl:when test = "$k = 'IZ'">Külçe, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'AL'">Küre</xsl:when>
        <xsl:when test = "$k = 'BX'">Kutu</xsl:when>
        <xsl:when test = "$k = '4B'">Kutu, Alüminyum</xsl:when>
        <xsl:when test = "$k = '4A'">Kutu, Çelik</xsl:when>
        <xsl:when test = "$k = '4C'">Kutu, Doğal Tahta</xsl:when>
        <xsl:when test = "$k = '4D'">Kutu, Kontrplak</xsl:when>
        <xsl:when test = "$k = 'DH'">Kutu, Milletler Topluluğu Elleçleme Ekipman Havuzu (CHEP), EuroBox</xsl:when>
        <xsl:when test = "$k = '4H'">Kutu, Plastik</xsl:when>
        <xsl:when test = "$k = 'QR'">Kutu, Plastik, Genişletilmiş</xsl:when>
        <xsl:when test = "$k = 'QS'">Kutu, Plastik, Sağlam</xsl:when>
        <xsl:when test = "$k = '4G'">Kutu, Sıkılaştırılmış Liflerden Yapılmış Tahta</xsl:when>
        <xsl:when test = "$k = 'BW'">Kutu, Sıvılar İçin</xsl:when>
        <xsl:when test = "$k = 'QP'">Kutu, Tahtadan, Doğal Tahta, Basit</xsl:when>
        <xsl:when test = "$k = 'QQ'">Kutu, Tahtadan, Doğal Tahta, Dayanıklı Dış Yüzey</xsl:when>
        <xsl:when test = "$k = '4F'">Kutu, Yeniden Düzenlenmiş Tahta</xsl:when>
        <xsl:when test = "$k = 'LG'">Kütük</xsl:when>
        <xsl:when test = "$k = 'LZ'">Kütük, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'BM'">Leğen</xsl:when>
        <xsl:when test = "$k = 'SB'">Levha</xsl:when>
        <xsl:when test = "$k = 'LV'">Liftvan</xsl:when>
        <xsl:when test = "$k = 'RL'">Makara</xsl:when>
        <xsl:when test = "$k = 'CM'">Mukavva</xsl:when>
        <xsl:when test = "$k = 'WA'">Orta Boy Büyüklükte Konteyner</xsl:when>
        <xsl:when test = "$k = 'WD'">Orta Boy Büyüklükte Konteyner, Alüminyum</xsl:when>
        <xsl:when test = "$k = 'WH'">Orta Boy Büyüklükte Konteyner, Alüminyum, Basınçlı &gt; 10 kpa</xsl:when>
        <xsl:when test = "$k = 'WL'">Orta Boy Büyüklükte Konteyner, Alüminyum, Sıvı</xsl:when>
        <xsl:when test = "$k = 'ZS'">Orta Boy Büyüklükte Konteyner, Bileşik</xsl:when>
        <xsl:when test = "$k = 'ZP'">Orta Boy Büyüklükte Konteyner, Bileşik, Esnek Plastik, Basınçlı</xsl:when>
        <xsl:when test = "$k = 'ZM'">Orta Boy Büyüklükte Konteyner, Bileşik, Esnek Plastik, Sağlam</xsl:when>
        <xsl:when test = "$k = 'ZR'">Orta Boy Büyüklükte Konteyner, Bileşik, Esnek Plastik, Sıvı</xsl:when>
        <xsl:when test = "$k = 'ZN'">Orta Boy Büyüklükte Konteyner, Bileşik, Sert Plastik, Basınçlı</xsl:when>
        <xsl:when test = "$k = 'ZL'">Orta Boy Büyüklükte Konteyner, Bileşik, Sert Plastik, Sağlam</xsl:when>
        <xsl:when test = "$k = 'ZQ'">Orta Boy Büyüklükte Konteyner, Bileşik, Sert Plastik, Sıvı</xsl:when>
        <xsl:when test = "$k = 'WC'">Orta Boy Büyüklükte Konteyner, Çelik</xsl:when>
        <xsl:when test = "$k = 'WG'">Orta Boy Büyüklükte Konteyner, Çelik, Basınçlı &gt; 10 kpa</xsl:when>
        <xsl:when test = "$k = 'WK'">Orta Boy Büyüklükte Konteyner, Çelik, Sıvı</xsl:when>
        <xsl:when test = "$k = 'WT'">Orta Boy Büyüklükte Konteyner, Dış Astarlı Dokuma Kumaş</xsl:when>
        <xsl:when test = "$k = 'ZW'">Orta Boy Büyüklükte Konteyner, Doğal Tahta</xsl:when>
        <xsl:when test = "$k = 'WU'">Orta Boy Büyüklükte Konteyner, Doğal Tahta, Astarlı</xsl:when>
        <xsl:when test = "$k = 'WW'">Orta Boy Büyüklükte Konteyner, Dokuma Kumaş, Astarlı</xsl:when>
        <xsl:when test = "$k = 'WV'">Orta Boy Büyüklükte Konteyner, Dokuma Kumaş, Kaplamalı</xsl:when>
        <xsl:when test = "$k = 'WX'">Orta Boy Büyüklükte Konteyner, Dokuma Kumaş, Kaplamalı ve Astarlı</xsl:when>
        <xsl:when test = "$k = 'ZU'">Orta Boy Büyüklükte Konteyner, Esnek</xsl:when>
        <xsl:when test = "$k = 'ZA'">Orta Boy Büyüklükte Konteyner, Kağıt, Çok Katmanlı</xsl:when>
        <xsl:when test = "$k = 'ZC'">Orta Boy Büyüklükte Konteyner, Kağıt, Çok Katmanlı, Su Geçirmez</xsl:when>
        <xsl:when test = "$k = 'WF'">Orta Boy Büyüklükte Konteyner, Metal</xsl:when>
        <xsl:when test = "$k = 'WJ'">Orta Boy Büyüklükte Konteyner, Metal, Basınç 10 kpa</xsl:when>
        <xsl:when test = "$k = 'ZV'">Orta Boy Büyüklükte Konteyner, Metal, Çelik Dışında</xsl:when>
        <xsl:when test = "$k = 'WM'">Orta Boy Büyüklükte Konteyner, Metal, Sıvı</xsl:when>
        <xsl:when test = "$k = 'WQ'">Orta Boy Büyüklükte Konteyner, Örme Plastik, Astarlı</xsl:when>
        <xsl:when test = "$k = 'WP'">Orta Boy Büyüklükte Konteyner, Örme Plastik, Kaplamalı</xsl:when>
        <xsl:when test = "$k = 'WR'">Orta Boy Büyüklükte Konteyner, Örme Plastik, Kaplamalı ve Astarlı</xsl:when>
        <xsl:when test = "$k = 'WN'">Orta Boy Büyüklükte Konteyner, Örme Plastik, Kaplamalı ve Astarlı Olmayan</xsl:when>
        <xsl:when test = "$k = 'WS'">Orta Boy Büyüklükte Konteyner, Plastik Film</xsl:when>
        <xsl:when test = "$k = 'AA'">Orta Boy Büyüklükte Konteyner, Sert Plastik</xsl:when>
        <xsl:when test = "$k = 'ZH'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Müstakil, Basınçlı</xsl:when>
        <xsl:when test = "$k = 'ZF'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Müstakil, Sağlam</xsl:when>
        <xsl:when test = "$k = 'ZK'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Müstakil, Sıvı</xsl:when>
        <xsl:when test = "$k = 'ZG'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Teçhizatlı, Basınçlı</xsl:when>
        <xsl:when test = "$k = 'ZD'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Teçhizatlı, Sağlam</xsl:when>
        <xsl:when test = "$k = 'ZJ'">Orta Boy Büyüklükte Konteyner, Sert Plastik, Teçhizatlı, Sıvı</xsl:when>
        <xsl:when test = "$k = 'ZT'">Orta Boy Büyüklükte Konteyner, Sıkıştırılmış Liflerden Yapılmış Tahta</xsl:when>
        <xsl:when test = "$k = 'ZX'">Orta Boy Büyüklükte Konteyner, Sıkıştırılmış Liflerden Yapılmış Tahta</xsl:when>
        <xsl:when test = "$k = 'WY'">Orta Boy Büyüklükte Konteyner, Sıkıştırılmış Liflerden Yapılmış Tahta, Astarlı</xsl:when>
        <xsl:when test = "$k = 'ZY'">Orta Boy Büyüklükte Konteyner, Yeniden Düzenlenmiş Tahta</xsl:when>
        <xsl:when test = "$k = 'WZ'">Orta Boy Büyüklükte Konteyner, Yeniden Düzenlenmiş Tahta, Astarlı</xsl:when>
        <xsl:when test = "$k = 'ZZ'">Ortaklaşa Tanımlanmış</xsl:when>
        <xsl:when test = "$k = 'PA'">Paket</xsl:when>
        <xsl:when test = "$k = 'PC'">Paket</xsl:when>
        <xsl:when test = "$k = 'PX'">Palet</xsl:when>
        <xsl:when test = "$k = 'AH'">Palet, 100 cm X 110 cm</xsl:when>
        <xsl:when test = "$k = 'OC'">Palet, 100 cm X 120 cm</xsl:when>
        <xsl:when test = "$k = 'OE'">Palet, 110 cm X 110 cm</xsl:when>
        <xsl:when test = "$k = 'OD'">Palet, 115.5 cm X 116.5 cm.</xsl:when>
        <xsl:when test = "$k = 'OA'">Palet, 40 cm X 60 cm</xsl:when>
        <xsl:when test = "$k = 'OB'">Palet, 80 cm X 120 cm</xsl:when>
        <xsl:when test = "$k = 'PD'">Palet, Birimsel, Yakalık 80 cm X 100 cm</xsl:when>
        <xsl:when test = "$k = 'PE'">Palet, Birimsel, Yakalık 80 cm X 120 cm</xsl:when>
        <xsl:when test = "$k = 'AF'">Palet, Birimsel, Yakalık 80 cm X 60 cm</xsl:when>
        <xsl:when test = "$k = 'AG'">Palet, Küçültülerek Sarılmış</xsl:when>
        <xsl:when test = "$k = 'PB'">Palet, Kutu</xsl:when>
        <xsl:when test = "$k = 'TW'">Palet, Mukavva</xsl:when>
        <xsl:when test = "$k = '8A'">Palet, Tahta</xsl:when>
        <xsl:when test = "$k = 'PB'">Palet, Ucu Açık Kutu ve Paletin Birleşimi Kutu</xsl:when>
        <xsl:when test = "$k = 'LT'">Parça</xsl:when>
        <xsl:when test = "$k = 'PP'">Parça</xsl:when>
        <xsl:when test = "$k = 'PF'">Pen</xsl:when>
        <xsl:when test = "$k = 'PG'">Plaka</xsl:when>
        <xsl:when test = "$k = 'PY'">Plaka, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'OF'">Platform, Belirsiz Ağırlık veya Boyut</xsl:when>
        <xsl:when test = "$k = 'PJ'">Punnet</xsl:when>
        <xsl:when test = "$k = 'AT'">Püskürgeç</xsl:when>
        <xsl:when test = "$k = 'RT'">Rednet</xsl:when>
        <xsl:when test = "$k = 'RO'">Rulo</xsl:when>
        <xsl:when test = "$k = 'CH'">Sandık</xsl:when>
        <xsl:when test = "$k = 'CF'">Sandık</xsl:when>
        <xsl:when test = "$k = 'VA'">Sarnıç</xsl:when>
        <xsl:when test = "$k = 'OT'">Sekizgen Karton Kutu</xsl:when>
        <xsl:when test = "$k = 'BK'">Sepet</xsl:when>
        <xsl:when test = "$k = 'HC'">Sepet, Kulplu, Karton</xsl:when>
        <xsl:when test = "$k = 'HA'">Sepet, Kulplu, Plastik</xsl:when>
        <xsl:when test = "$k = 'HB'">Sepet, Kulplu, Tahtadan</xsl:when>
        <xsl:when test = "$k = 'WB'">Sepetli Şişe</xsl:when>
        <xsl:when test = "$k = 'KI'">Set</xsl:when>
        <xsl:when test = "$k = 'CY'">Silindir</xsl:when>
        <xsl:when test = "$k = 'BC'">Şişe Kasası</xsl:when>
        <xsl:when test = "$k = 'GB'">Şişe, Gaz</xsl:when>
        <xsl:when test = "$k = 'BQ'">Şişe, Korumalı, Silindirik</xsl:when>
        <xsl:when test = "$k = 'BV'">Şişe, Korumalı, Soğan Şeklinde</xsl:when>
        <xsl:when test = "$k = 'BO'">Şişe, Korumasız, Silindirik</xsl:when>
        <xsl:when test = "$k = 'BS'">Şişe, Korumasız, Soğan Şeklinde</xsl:when>
        <xsl:when test = "$k = 'AE'">Sprey (Aerosol)</xsl:when>
        <xsl:when test = "$k = 'AI'">Süt Güğümü</xsl:when>
        <xsl:when test = "$k = 'T1'">Tablet</xsl:when>
        <xsl:when test = "$k = 'CJ'">Tabut</xsl:when>
        <xsl:when test = "$k = 'BD'">Tahta</xsl:when>
        <xsl:when test = "$k = 'CR'">Tahta Kasa</xsl:when>
        <xsl:when test = "$k = 'LU'">Tahta Kasa (Meyve, Sebze)</xsl:when>
        <xsl:when test = "$k = 'BY'">Tahta, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'TG'">Tank Konteyner (Sıvı ve Gaz)</xsl:when>
        <xsl:when test = "$k = 'TK'">Tank, Dikdörtgen</xsl:when>
        <xsl:when test = "$k = 'TY'">Tank, Silindirik</xsl:when>
        <xsl:when test = "$k = 'P2'">Tava</xsl:when>
        <xsl:when test = "$k = 'TE'">Tekerlek</xsl:when>
        <xsl:when test = "$k = 'SY'">Tel</xsl:when>
        <xsl:when test = "$k = 'CI'">Teneke Kutu</xsl:when>
        <xsl:when test = "$k = 'TN'">Teneke Kutu</xsl:when>
        <xsl:when test = "$k = 'CA'">Teneke Kutu, Dikdörtgen</xsl:when>
        <xsl:when test = "$k = 'CD'">Teneke Kutu, Kulplu ve Oluklu</xsl:when>
        <xsl:when test = "$k = 'CX'">Teneke Kutu, Silindirik</xsl:when>
        <xsl:when test = "$k = 'PU'">Tepsi</xsl:when>
        <xsl:when test = "$k = 'DY'">Tepsi, İki Katmanlı, Kapaksız, Mukavva</xsl:when>
        <xsl:when test = "$k = 'DW'">Tepsi, İki Katmanlı, Kapaksız, Plastik Tepsi</xsl:when>
        <xsl:when test = "$k = 'DX'">Tepsi, İki Katmanlı, Kapaksız, Yün</xsl:when>
        <xsl:when test = "$k = 'IL'">Tepsi, Sabit, Kapaklı İstiflenebilir (CEN TS 14482:2002)</xsl:when>
        <xsl:when test = "$k = 'DV'">Tepsi, Tek Katmanlı, Kapaksız, Mukavva</xsl:when>
        <xsl:when test = "$k = 'DS'">Tepsi, Tek Katmanlı, Kapaksız, Plastik</xsl:when>
        <xsl:when test = "$k = 'DU'">Tepsi, Tek Katmanlı, Kapaksız, Polisitrin</xsl:when>
        <xsl:when test = "$k = 'DT'">Tepsi, Tek Katmanlı, Kapaksız, Yün</xsl:when>
        <xsl:when test = "$k = 'GU'">Tepsi, Yatay İstiflenmiş Düz Kalemleri-Eşyayı İçeren</xsl:when>
        <xsl:when test = "$k = 'JG'">Testi, Sürahi</xsl:when>
        <xsl:when test = "$k = 'TU'">Tüp</xsl:when>
        <xsl:when test = "$k = 'TV'">Tüp, Hortumlu</xsl:when>
        <xsl:when test = "$k = 'TD'">Tüp, Portatif</xsl:when>
        <xsl:when test = "$k = 'TZ'">Tüp, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'VI'">Ufak Şişe</xsl:when>
        <xsl:when test = "$k = 'FI'">Ufak Yağ Fıçısı</xsl:when>
        <xsl:when test = "$k = 'UN'">Ünite</xsl:when>
        <xsl:when test = "$k = 'VP'">Vakumlu Paket</xsl:when>
        <xsl:when test = "$k = 'BA'">Varil</xsl:when>
        <xsl:when test = "$k = '2C'">Varil, Tahtadan</xsl:when>
        <xsl:when test = "$k = 'QJ'">Varil, Tahtadan, Sökülebilir Kafalı</xsl:when>
        <xsl:when test = "$k = 'QH'">Varil, Tahtadan, Tıpa Şeklinde</xsl:when>
        <xsl:when test = "$k = 'ST'">Yaprak</xsl:when>
        <xsl:when test = "$k = 'SM'">Yaprak, Metal</xsl:when>
        <xsl:when test = "$k = 'SP'">Yaprak, Plastik Geçirilmiş</xsl:when>
        <xsl:when test = "$k = 'SZ'">Yaprak, Tomar/Deste/Demet Halinde</xsl:when>
        <xsl:when test = "$k = 'TB'">Yarım Fıçı</xsl:when>
        <xsl:when test = "$k = 'TL'">Yarım Fıçı, Kapaklı</xsl:when>
        <xsl:when test = "$k = 'CC'">Yayık</xsl:when>
        <xsl:when test = "$k = 'SL'">Yeni Basılmış Kağıtların Arasına Konulan Boş Kağıt</xsl:when>
        <xsl:when test = "$k = 'NS'">Yuva</xsl:when>
        <xsl:when test = "$k = 'EN'">Zarf</xsl:when>
        <xsl:when test = "$k = 'GR'">Zarf, Cam</xsl:when>
        <xsl:when test = "$k = 'SV'">Zarf, Çelik</xsl:when>
        <xsl:when test = "$k = 'AB'">Zarf, Elyaf</xsl:when>
        <xsl:when test = "$k = 'AC'">Zarf, Kağıt</xsl:when>
        <xsl:when test = "$k = 'MR'">Zarf, Metal</xsl:when>
        <xsl:when test = "$k = 'PR'">Zarf, Plastik</xsl:when>
        <xsl:when test = "$k = 'MW'">Zarf, Plastik Geçirilmiş</xsl:when>
        <xsl:when test = "$k = 'AD'">Zarf, Yün</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select = "$k"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "gonderim_bicimlendir">
    <xsl:param name = "g"/>
    <xsl:if test = "$g != ''">
      <xsl:choose>
        <xsl:when test = "$g = 1">DenizYolu</xsl:when>
        <xsl:when test = "$g = 2">DemirYolu</xsl:when>
        <xsl:when test = "$g = 3">KaraYolu</xsl:when>
        <xsl:when test = "$g = 4">HavaYolu</xsl:when>
        <xsl:when test = "$g = 5">Posta</xsl:when>
        <xsl:when test = "$g = 6">Çok Araçlı</xsl:when>
        <xsl:when test = "$g = 7">Sabit Taşıma Tesisleri</xsl:when>
        <xsl:when test = "$g = 8">İç Su Taşımacılığı</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select = "$g"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "dizeyi_degistir">
    <xsl:param name = "dize"/>
    <xsl:param name = "bul"/>
    <xsl:param name = "degistir"/>
    <xsl:choose>
      <xsl:when test = "contains($dize, $bul)">
        <xsl:value-of disable-output-escaping = "yes" select = "substring-before($dize, $bul)"/>
        <xsl:value-of disable-output-escaping = "yes" select = "$degistir"/>
        <xsl:call-template name = "dizeyi_degistir">
          <xsl:with-param name = "dize" select = "substring-after($dize, $bul)"/>
          <xsl:with-param name = "bul" select = "$bul"/>
          <xsl:with-param name = "degistir" select = "$degistir"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of  disable-output-escaping = "yes" select = "$dize"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name = "deger_bul">
    <xsl:param name = "deger"/>
    <xsl:param name = "anahtar_kelime"/>
    <xsl:variable name = "dgr" select = "substring-after($deger, substring-before($deger, '#'))"/>
    <xsl:variable name = "ilk_oge" select = "substring-before($dgr, $oge_ayiraci)"/>
    <xsl:choose>
      <xsl:when test = "$ilk_oge != ''">
        <xsl:choose>
          <xsl:when test = "substring-before($ilk_oge, $deger_ayiraci) = $anahtar_kelime">
            <xsl:value-of select = "substring-after($ilk_oge, $deger_ayiraci)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name = "deger_bul">
              <xsl:with-param name = "deger" select = "substring-after($deger, $oge_ayiraci)"/>
              <xsl:with-param name = "anahtar_kelime" select = "$anahtar_kelime"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test = "contains($deger, $anahtar_kelime) and contains($deger, $deger_ayiraci) and not(contains($deger, $oge_ayiraci)) and (substring-after($deger, $deger_ayiraci) != '')">
        <xsl:value-of select = "substring-after($deger, $deger_ayiraci)"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name = "taraf_goruntule">
    <xsl:param name = "taraf"/>
    <xsl:param name = "tablo"/>
    <xsl:param name = "unvan"/>
    <xsl:param name = "adres"/>
    <xsl:param name = "telefon"/>
    <xsl:param name = "faks"/>
    <xsl:param name = "eposta"/>
    <xsl:param name = "web"/>
    <xsl:param name = "vergi_dairesi"/>
    <xsl:param name = "vkn"/>
    <xsl:param name = "tckn"/>
    <xsl:param name = "ticaret_sicil_no"/>
    <xsl:param name = "mersis_no"/>
    <xsl:param name = "bayi_no"/>
    <xsl:param name = "sube_no"/>
    <xsl:param name = "musteri_no"/>
    <xsl:param name = "mal_veren_no"/>
    <xsl:variable
      name = "taraf_unvani"
      select = "$taraf/cac:PartyName/cbc:Name"/>
    <xsl:variable
      name = "taraf_kisi"
      select = "$taraf/cac:Person"/>
    <xsl:variable
      name = "taraf_kisi_on_ek"
      select = "$taraf_kisi/cbc:Title"/>
    <xsl:variable
      name = "taraf_kisi_ilk_isim"
      select = "$taraf_kisi/cbc:FirstName"/>
    <xsl:variable
      name = "taraf_kisi_ikinci_isim"
      select = "$taraf_kisi/cbc:MiddleName"/>
    <xsl:variable
      name = "taraf_kisi_soy_isim"
      select = "$taraf_kisi/cbc:FamilyName"/>
    <xsl:variable
      name = "taraf_kisi_son_ek"
      select = "$taraf_kisi/cbc:NameSuffix"/>
    <xsl:variable
      name = "taraf_adres"
      select = "$taraf/cac:PostalAddress"/>
    <xsl:variable
      name = "taraf_adres_sokak"
      select = "$taraf_adres/cbc:StreetName"/>
    <xsl:variable
      name = "taraf_adres_bina_adi"
      select = "$taraf_adres/cbc:BuildingName"/>
    <xsl:variable
      name = "taraf_adres_dis_kapi_no"
      select = "$taraf_adres/cbc:BuildingNumber"/>
    <xsl:variable
      name = "taraf_adres_ic_kapi_no"
      select = "$taraf_adres/cbc:Room"/>
    <xsl:variable
      name = "taraf_adres_posta_kodu"
      select = "$taraf_adres/cbc:PostalZone"/>
    <xsl:variable
      name = "taraf_adres_ilce"
      select = "$taraf_adres/cbc:CitySubdivisionName"/>
    <xsl:variable
      name = "taraf_adres_il"
      select = "$taraf_adres/cbc:CityName"/>
    <xsl:variable
      name = "taraf_adres_ulke"
      select = "$taraf_adres/cac:Country/cbc:Name"/>
    <xsl:variable
      name = "taraf_iletisim"
      select = "$taraf/cac:Contact"/>
    <xsl:variable
      name = "taraf_iletisim_telefon"
      select = "$taraf_iletisim/cbc:Telephone"/>
    <xsl:variable
      name = "taraf_iletisim_faks"
      select = "$taraf_iletisim/cbc:Telefax"/>
    <xsl:variable
      name = "taraf_iletisim_eposta"
      select = "$taraf_iletisim/cbc:ElectronicMail"/>
    <xsl:variable
      name = "taraf_web"
      select = "$taraf/cbc:WebsiteURI"/>
    <xsl:variable
      name = "taraf_vergi_dairesi"
      select = "$taraf/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
    <xsl:variable
      name = "taraf_kimlik"
      select = "$taraf/cac:PartyIdentification"/>
    <xsl:variable
      name = "taraf_bayi_kimlik"
      select = "$taraf/cac:AgentParty/cac:PartyIdentification"/>
    <xsl:variable
      name = "xml_araci_kurum"
      select = "$xml_belge/cac:TaxRepresentativeParty/cac:PartyIdentification"/>
    <hr id = "hr_{$tablo}"/>
    <table id = "tbl_{$tablo}">
      <tbody>
        <xsl:if test = "$unvan = 1">
          <tr>
            <th class = "bas_{$tablo}">
              <xsl:variable name = "baslik">
                <xsl:choose>
                  <xsl:when test = "$tablo = 'satici_merkez'">
                    <xsl:value-of select = "$bas_satici_merkez"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'satici_sube'">
                    <xsl:value-of select = "$bas_satici_sube"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_merkez'">
                    <xsl:value-of select = "$bas_alici_merkez"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_sube'">
                    <xsl:value-of select = "$bas_alici_sube"/>
                  </xsl:when>
                </xsl:choose>
              </xsl:variable>
              <xsl:call-template name = "baslik_bicimlendir">
                <xsl:with-param name = "baslik" select = "$baslik"/>
                <xsl:with-param name = "yuzde" select = "-1"/>
              </xsl:call-template>
            </th>
            <th class = "bas_yatay" style = "text-align: left; white-space: normal;">
              <xsl:if test = "$taraf_unvani != ''">
                <xsl:value-of select = "$taraf_unvani"/>
              </xsl:if>
              <xsl:if test = "(($tablo = 'satici_merkez') and ($satici_merkez_kisi = 1)) or (($tablo = 'satici_sube') and ($satici_sube_kisi = 1)) or (($tablo = 'alici_merkez') and ($alici_merkez_kisi = 1)) or (($tablo = 'alici_sube') and ($alici_sube_kisi = 1))">
                <xsl:if test = "$taraf_unvani != ''">
                  <br/>
                </xsl:if>
                <xsl:call-template name = "isim_bicimlendir">
                  <xsl:with-param name = "on_ek" select = "$taraf_kisi_on_ek"/>
                  <xsl:with-param name = "ilk_isim" select = "$taraf_kisi_ilk_isim"/>
                  <xsl:with-param name = "ikinci_isim" select = "$taraf_kisi_ikinci_isim"/>
                  <xsl:with-param name = "soy_isim" select = "$taraf_kisi_soy_isim"/>
                  <xsl:with-param name = "son_ek" select = "$taraf_kisi_son_ek"/>
                </xsl:call-template>
              </xsl:if>
            </th>
          </tr>
        </xsl:if>
        <xsl:if test = "$adres = 1">
          <tr>
            <th class = "bas_dikey">
              <xsl:variable name = "baslik">
                <xsl:choose>
                  <xsl:when test = "$tablo = 'satici_merkez'">
                    <xsl:value-of select = "$bas_satici_merkez_adres"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'satici_sube'">
                    <xsl:value-of select = "$bas_satici_sube_adres"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_merkez'">
                    <xsl:value-of select = "$bas_alici_merkez_adres"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_sube'">
                    <xsl:value-of select = "$bas_alici_sube_adres"/>
                  </xsl:when>
                </xsl:choose>
              </xsl:variable>
              <xsl:call-template name = "baslik_bicimlendir">
                <xsl:with-param name = "baslik" select = "$baslik"/>
                <xsl:with-param name = "yuzde" select = "-1"/>
              </xsl:call-template>
            </th>
            <td style = "white-space: normal;">
              <xsl:call-template name = "adres_bicimlendir">
                <xsl:with-param name = "sokak" select = "$taraf_adres_sokak"/>
                <xsl:with-param name = "bina_adi" select = "$taraf_adres_bina_adi"/>
                <xsl:with-param name = "dis_kapi_no" select = "$taraf_adres_dis_kapi_no"/>
                <xsl:with-param name = "ic_kapi_no" select = "$taraf_adres_ic_kapi_no"/>
                <xsl:with-param name = "posta_kodu" select = "$taraf_adres_posta_kodu"/>
                <xsl:with-param name = "ilce" select = "$taraf_adres_ilce"/>
                <xsl:with-param name = "il" select = "$taraf_adres_il"/>
                <xsl:with-param name = "ulke" select = "$taraf_adres_ulke"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test = "($telefon = 1) or ($faks = 1)">
          <xsl:if test = "($taraf_iletisim_telefon != '') or ($taraf_iletisim_faks != '')">
            <tr>
              <th class = "bas_dikey">
                <xsl:variable name = "baslik">
                  <xsl:choose>
                    <xsl:when test = "$tablo = 'satici_merkez'">
                      <xsl:value-of select = "$bas_satici_merkez_telefon"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'satici_sube'">
                      <xsl:value-of select = "$bas_satici_sube_telefon"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'alici_merkez'">
                      <xsl:value-of select = "$bas_alici_merkez_telefon"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'alici_sube'">
                      <xsl:value-of select = "$bas_alici_sube_telefon"/>
                    </xsl:when>
                  </xsl:choose>
                </xsl:variable>
                <xsl:call-template name = "baslik_bicimlendir">
                  <xsl:with-param name = "baslik" select = "$baslik"/>
                  <xsl:with-param name = "yuzde" select = "-1"/>
                </xsl:call-template>
              </th>
              <td>
                <xsl:if test = "$telefon = 1">
                  <xsl:if test = "$taraf_iletisim_telefon != ''">
                    <xsl:value-of select = "$taraf_iletisim_telefon"/>
                    <xsl:if test = "$faks = 1">
                      <xsl:if test = "$taraf_iletisim_faks != ''">
                        <xsl:text>&#160;/&#160;</xsl:text>
                      </xsl:if>
                    </xsl:if>
                  </xsl:if>
                </xsl:if>
                <xsl:if test = "$faks = 1">
                  <xsl:if test = "$taraf_iletisim_faks != ''">
                    <xsl:value-of select = "$taraf_iletisim_faks"/>
                  </xsl:if>
                </xsl:if>
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
        <xsl:if test = "($eposta = 1) or ($web = 1)">
          <xsl:if test = "($taraf_iletisim_eposta != '') or ($taraf_web != '')">
            <tr>
              <th class = "bas_dikey">
                <xsl:variable name = "baslik">
                  <xsl:choose>
                    <xsl:when test = "$tablo = 'satici_merkez'">
                      <xsl:value-of select = "$bas_satici_merkez_eposta"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'satici_sube'">
                      <xsl:value-of select = "$bas_satici_sube_eposta"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'alici_merkez'">
                      <xsl:value-of select = "$bas_alici_merkez_eposta"/>
                    </xsl:when>
                    <xsl:when test = "$tablo = 'alici_sube'">
                      <xsl:value-of select = "$bas_alici_sube_eposta"/>
                    </xsl:when>
                  </xsl:choose>
                </xsl:variable>
                <xsl:call-template name = "baslik_bicimlendir">
                  <xsl:with-param name = "baslik" select = "$baslik"/>
                  <xsl:with-param name = "yuzde" select = "-1"/>
                </xsl:call-template>
              </th>
              <td>
                <xsl:if test = "$eposta = 1">
                  <xsl:if test = "$taraf_iletisim_eposta != ''">
                    <a href = "mailto:{$taraf_iletisim_eposta}" target = "_blank">
                      <xsl:value-of select = "$taraf_iletisim_eposta"/>
                    </a>
                    <xsl:if test = "$web = 1">
                      <xsl:if test = "$taraf_web != ''">
                        <xsl:text>&#160;/&#160;</xsl:text>
                      </xsl:if>
                    </xsl:if>
                  </xsl:if>
                </xsl:if>
                <xsl:if test = "$web = 1">
                  <xsl:if test = "$taraf_web != ''">
                    <a href = "{$taraf_web}" target = "_blank">
                      <xsl:value-of select = "$taraf_web"/>
                    </a>
                  </xsl:if>
                </xsl:if>
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
        <xsl:if test = "($tckn = 1) or ($vkn = 1) or ($vergi_dairesi = 1)">
          <tr>
            <th class = "bas_dikey">
              <xsl:variable name = "baslik">
                <xsl:choose>
                  <xsl:when test = "$tablo = 'satici_merkez'">
                    <xsl:value-of select = "$bas_satici_merkez_vkn"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'satici_sube'">
                    <xsl:value-of select = "$bas_satici_sube_vkn"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_merkez'">
                    <xsl:value-of select = "$bas_alici_merkez_vkn"/>
                  </xsl:when>
                  <xsl:when test = "$tablo = 'alici_sube'">
                    <xsl:value-of select = "$bas_alici_sube_vkn"/>
                  </xsl:when>
                </xsl:choose>
              </xsl:variable>
              <xsl:call-template name = "baslik_bicimlendir">
                <xsl:with-param name = "baslik" select = "$baslik"/>
                <xsl:with-param name = "yuzde" select = "-1"/>
              </xsl:call-template>
            </th>
            <td>
              <xsl:if test = "$tckn = 1">
                <xsl:for-each select = "$taraf_kimlik">
                  <xsl:if test = "cbc:ID/@schemeID = 'TCKN'">
                    <xsl:if test = "cbc:ID != ''">
                      <xsl:value-of select = "cbc:ID"/>
                    </xsl:if>
                  </xsl:if>
                </xsl:for-each>
              </xsl:if>
              <xsl:if test = "$vkn = 1">
                <xsl:for-each select = "$taraf_kimlik">
                  <xsl:if test = "cbc:ID/@schemeID = 'VKN'">
                    <xsl:if test = "cbc:ID != ''">
                      <xsl:value-of select = "cbc:ID"/>
                    </xsl:if>
                  </xsl:if>
                </xsl:for-each>
              </xsl:if>
              <xsl:if test = "$vergi_dairesi = 1">
                <xsl:if test = "$taraf_vergi_dairesi != ''">
                  <xsl:text>&#160;/&#160;</xsl:text>
                  <xsl:value-of select = "$taraf_vergi_dairesi"/>
                </xsl:if>
              </xsl:if>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test = "$ticaret_sicil_no = 1">
          <xsl:for-each select = "$taraf_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'TICARETSICILNO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_ticaret_sicil_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_ticaret_sicil_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_ticaret_sicil_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_ticaret_sicil_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$mersis_no = 1">
          <xsl:for-each select = "$taraf_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'MERSISNO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_mersis_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_mersis_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_mersis_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_mersis_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$bayi_no = 1">
          <xsl:for-each select = "$taraf_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'BAYINO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_bayi_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$mal_veren_no = 1">
          <xsl:for-each select = "$taraf_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'MUSTERINO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_mal_veren_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_mal_veren_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_mal_veren_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_mal_veren_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$bayi_no = 1">
          <xsl:for-each select = "$taraf_bayi_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'BAYINO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_bayi_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_bayi_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$sube_no = 1">
          <xsl:for-each select = "$taraf_bayi_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'SUBENO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_sube_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_sube_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_sube_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_sube_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$musteri_no = 1">
          <xsl:for-each select = "$taraf_bayi_kimlik">
            <xsl:if test = "cbc:ID/@schemeID = 'MUSTERINO'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:variable name = "baslik">
                      <xsl:choose>
                        <xsl:when test = "$tablo = 'satici_merkez'">
                          <xsl:value-of select = "$bas_satici_merkez_musteri_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'satici_sube'">
                          <xsl:value-of select = "$bas_satici_sube_musteri_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_merkez'">
                          <xsl:value-of select = "$bas_alici_merkez_musteri_no"/>
                        </xsl:when>
                        <xsl:when test = "$tablo = 'alici_sube'">
                          <xsl:value-of select = "$bas_alici_sube_musteri_no"/>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$baslik"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$araci_kurum_unvani = 1">
          <xsl:for-each select = "$xml_araci_kurum">
            <xsl:if test = "cbc:ID/@schemeID = 'ARACIKURUM'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$bas_araci_kurum_unvani"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "../cac:PartyName/cbc:Name"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test = "$araci_kurum_vkn = 1">
          <xsl:for-each select = "$xml_araci_kurum">
            <xsl:if test = "cbc:ID/@schemeID = 'ARACIKURUMVKN'">
              <xsl:if test = "cbc:ID != ''">
                <tr>
                  <th class = "bas_dikey">
                    <xsl:call-template name = "baslik_bicimlendir">
                      <xsl:with-param name = "baslik" select = "$bas_araci_kurum_vkn"/>
                      <xsl:with-param name = "yuzde" select = "-1"/>
                    </xsl:call-template>
                  </th>
                  <td>
                    <xsl:value-of select = "cbc:ID"/>
                  </td>
                </tr>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name = "sutunlari_goruntule">
    <xsl:param name = "sutun_sirasi"/>
    <xsl:param name = "dil"/>
    <xsl:if test = "($sutun_sirasi != '') and ($sutun_sirasi != ' ') and ($sutun_sirasi != $oge_ayiraci)">
      <xsl:variable name = "sutun" select = "substring-before($sutun_sirasi, $oge_ayiraci)"/>
      <xsl:variable name = "kalan" select = "substring-after($sutun_sirasi, $oge_ayiraci)"/>
      <xsl:if test = "$sutun = 'stn_sira_no'">
        <xsl:if test = "$stn_sira_no = 1">
          <th class = "bas_yatay stn_sira_no">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_sira_no"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_gtip_no'">
        <xsl:if test = "$stn_gtip_no = 1">
          <th class = "bas_yatay stn_gtip_no">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_gtip_no"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_parti_no'">
        <xsl:if test = "$stn_parti_no = 1">
          <th class = "bas_yatay stn_parti_no">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_parti_no"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_satici_urun_hizmet_kodu'">
        <xsl:if test = "$stn_satici_urun_hizmet_kodu = 1">
          <th class = "bas_yatay stn_satici_urun_hizmet_kodu">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_satici_urun_hizmet_kodu"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_alici_urun_hizmet_kodu'">
        <xsl:if test = "$stn_alici_urun_hizmet_kodu = 1">
          <th class = "bas_yatay stn_alici_urun_hizmet_kodu">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_alici_urun_hizmet_kodu"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_urun_hizmet_adi'">
        <xsl:if test = "$stn_urun_hizmet_adi = 1">
          <th class = "bas_yatay stn_urun_hizmet_adi">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_urun_hizmet_adi"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_miktar_birim'">
        <xsl:if test = "$stn_miktar_birim = 1">
          <th class = "bas_yatay stn_miktar_birim">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_miktar_birim"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_ulke_kodu'">
        <xsl:if test = "$stn_ulke_kodu = 1">
          <th class = "bas_yatay stn_ulke_kodu">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ulke_kodu"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_seri_no'">
        <xsl:if test = "$stn_seri_no = 1">
          <th class = "bas_yatay stn_seri_no">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_seri_no"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_son_kullanma_tarihi'">
        <xsl:if test = "$stn_son_kullanma_tarihi = 1">
          <th class = "bas_yatay stn_son_kullanma_tarihi">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_son_kullanma_tarihi"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_vade_tarihi'">
        <xsl:if test = "$stn_vade_tarihi = 1">
          <th class = "bas_yatay stn_vade_tarihi">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_vade_tarihi"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_marka'">
        <xsl:if test = "$stn_marka = 1">
          <th class = "bas_yatay stn_marka">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_marka"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_model'">
        <xsl:if test = "$stn_model = 1">
          <th class = "bas_yatay stn_model">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_model"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_renk'">
        <xsl:if test = "$stn_renk = 1">
          <th class = "bas_yatay stn_renk">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_renk"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut'">
        <xsl:if test = "$stn_boyut = 1">
          <th class = "bas_yatay stn_boyut">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_boyut"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_nitelik'">
        <xsl:if test = "$stn_nitelik = 1">
          <th class = "bas_yatay stn_nitelik">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_nitelik"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_1'">
        <xsl:if test = "$stn_boyut_1 = 1">
          <th class = "bas_yatay stn_boyut_1">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_boyut_1"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_2'">
        <xsl:if test = "$stn_boyut_2 = 1">
          <th class = "bas_yatay stn_boyut_2">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_boyut_2"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_3'">
        <xsl:if test = "$stn_boyut_3 = 1">
          <th class = "bas_yatay stn_boyut_3">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_boyut_3"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_hacim'">
        <xsl:if test = "$stn_hacim = 1">
          <th class = "bas_yatay stn_hacim">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_hacim"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_alan'">
        <xsl:if test = "$stn_alan = 1">
          <th class = "bas_yatay stn_alan">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_alan"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_ilk_birim'">
        <xsl:if test = "$stn_ilk_birim = 1">
          <th class = "bas_yatay stn_ilk_birim">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_ilk_birim"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_on_birim'">
        <xsl:if test = "$stn_on_birim = 1">
          <th class = "bas_yatay stn_on_birim">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_on_birim"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_brut'">
        <xsl:if test = "$stn_brut = 1">
          <th class = "bas_yatay stn_brut">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_brut"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_brut_kg'">
        <xsl:if test = "$stn_brut_kg = 1">
          <th class = "bas_yatay stn_brut_kg">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_brut_kg"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_net'">
        <xsl:if test = "$stn_net = 1">
          <th class = "bas_yatay stn_net">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_net"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_net_kg'">
        <xsl:if test = "$stn_net_kg = 1">
          <th class = "bas_yatay stn_net_kg">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_net_kg"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_siparis_satir_no'">
        <xsl:if test = "$stn_siparis_satir_no = 1">
          <th class = "bas_yatay stn_siparis_satir_no">
            <xsl:call-template name = "baslik_bicimlendir">
              <xsl:with-param name = "baslik" select = "$bas_siparis_satir_no"/>
              <xsl:with-param name = "yuzde" select = "-1"/>
              <xsl:with-param name = "dil" select = "$dil"/>
            </xsl:call-template>
          </th>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$kalan">
        <xsl:call-template name = "sutunlari_goruntule">
          <xsl:with-param name = "sutun_sirasi" select = "$kalan"/>
          <xsl:with-param name = "dil" select = "$dil"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template name = "satirlari_goruntule">
    <xsl:param name = "xml_fs_sira_no"/>
    <xsl:param name = "xml_fs_gtip_no"/>
    <xsl:param name = "xml_fs_satici_urun_hizmet_kodu"/>
    <xsl:param name = "xml_fs_alici_urun_hizmet_kodu"/>
    <xsl:param name = "xml_fs_urun_hizmet_adi"/>
    <xsl:param name = "xml_fs_urun_hizmet_markasi"/>
    <xsl:param name = "xml_fs_urun_hizmet_modeli"/>
    <xsl:param name = "xml_fs_miktar_birim"/>
    <xsl:param name = "xml_fs_paketleme"/>
    <xsl:param name = "xml_fs_notu"/>
    <xsl:param name = "xml_fs_ulke_kodu"/>
    <xsl:param name = "xml_fs_kap_cinsi"/>
    <xsl:param name = "xml_fs_kap_no"/>
    <xsl:param name = "xml_fs_kap_sayisi"/>
    <xsl:param name = "xml_fs_siparis_satir_no"/>
    <xsl:param name = "sutun_sirasi"/>
    <xsl:if test = "($sutun_sirasi != '') and ($sutun_sirasi != ' ') and ($sutun_sirasi != $oge_ayiraci)">
      <xsl:variable name = "sutun" select = "substring-before($sutun_sirasi, $oge_ayiraci)"/>
      <xsl:variable name = "kalan" select = "substring-after($sutun_sirasi, $oge_ayiraci)"/>
      <xsl:if test = "$sutun = 'stn_sira_no'">
        <xsl:if test = "$stn_sira_no = 1">
          <td class = "stn_sira_no">
            <xsl:value-of select = "$xml_fs_sira_no"/>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_gtip_no'">
        <xsl:if test = "$stn_gtip_no = 1">
          <td class = "stn_gtip_no">
            <xsl:value-of select = "$xml_fs_gtip_no"/>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_parti_no'">
        <xsl:if test = "$stn_parti_no = 1">
          <td class = "stn_parti_no">
            <xsl:call-template name = "satir_bicimlendir">
              <xsl:with-param name = "satir" select = "$xml_fs_urun_hizmet_markasi"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_satici_urun_hizmet_kodu'">
        <xsl:if test = "$stn_satici_urun_hizmet_kodu = 1">
          <td class = "stn_satici_urun_hizmet_kodu">
            <xsl:value-of select = "$xml_fs_satici_urun_hizmet_kodu"/>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_alici_urun_hizmet_kodu'">
        <xsl:if test = "$stn_alici_urun_hizmet_kodu = 1">
          <td class = "stn_alici_urun_hizmet_kodu">
            <xsl:value-of select = "$xml_fs_alici_urun_hizmet_kodu"/>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_urun_hizmet_adi'">
        <xsl:if test = "$stn_urun_hizmet_adi = 1">
          <td class = "stn_urun_hizmet_adi">
            <xsl:call-template name = "satir_bicimlendir">
              <xsl:with-param name = "satir" select = "$xml_fs_urun_hizmet_adi"/>
            </xsl:call-template>
            <xsl:if test = "$stn_urun_hizmet_markasi = 1">
              <xsl:if test = "$xml_fs_urun_hizmet_markasi != ''">
                <xsl:if test = "$xml_fs_urun_hizmet_adi != ''">
                  <br/>
                </xsl:if>
                <xsl:value-of select = "$xml_fs_urun_hizmet_markasi"/>
              </xsl:if>
            </xsl:if>
            <xsl:if test = "$stn_urun_hizmet_modeli = 1">
              <xsl:if test = "($xml_fs_urun_hizmet_adi != '') or ($xml_fs_urun_hizmet_markasi != '')">
                <xsl:if test = "$xml_fs_urun_hizmet_modeli != ''">
                  <br/>
                  <xsl:value-of select = "$xml_fs_urun_hizmet_modeli"/>
                </xsl:if>
              </xsl:if>
            </xsl:if>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_miktar_birim'">
        <xsl:if test = "$stn_miktar_birim = 1">
          <td class = "stn_miktar_birim">
            <xsl:value-of select = "format-number($xml_fs_miktar_birim, $bicim_miktar_birim, $bolge)"/>
            <xsl:call-template name = "birim_bicimlendir">
              <xsl:with-param name = "b" select = "$xml_fs_miktar_birim/@unitCode"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_ulke_kodu'">
        <xsl:if test = "$stn_ulke_kodu = 1">
          <td class = "stn_ulke_kodu">
            <xsl:choose>
              <xsl:when test = "$xml_fs_ulke_kodu != ''">
                <xsl:value-of select = "$xml_fs_ulke_kodu"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:for-each select = "$xml_fs_notu">
                  <xsl:if test = "contains(., $degisken_ulke_kodu)">
                    <xsl:value-of select = "substring-after(., $degisken_ulke_kodu)"/>
                  </xsl:if>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_seri_no'">
        <xsl:if test = "$stn_seri_no = 1">
          <td class = "stn_seri_no">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:variable name = "seri_no" select = "substring-after(., $degisken_seri_no)"/>
              <xsl:call-template name = "satir_bicimlendir">
                <xsl:with-param name = "satir" select = "$seri_no"/>
              </xsl:call-template>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_son_kullanma_tarihi'">
        <xsl:if test = "$stn_son_kullanma_tarihi = 1">
          <td class = "stn_son_kullanma_tarihi">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_son_kullanma_tarihi)">
                <xsl:value-of select = "substring-after(., $degisken_son_kullanma_tarihi)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_vade_tarihi'">
        <xsl:if test = "$stn_vade_tarihi = 1">
          <td class = "stn_vade_tarihi">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_vade_tarihi)">
                <xsl:value-of select = "substring-after(., $degisken_vade_tarihi)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_marka'">
        <xsl:if test = "$stn_marka = 1">
          <td class = "stn_marka">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_marka)">
                <xsl:value-of select = "substring-after(., $degisken_marka)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_model'">
        <xsl:if test = "$stn_model = 1">
          <td class = "stn_model">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_model)">
                <xsl:value-of select = "substring-after(., $degisken_model)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_renk'">
        <xsl:if test = "$stn_renk = 1">
          <td class = "stn_renk">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_renk)">
                <xsl:value-of select = "substring-after(., $degisken_renk)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut'">
        <xsl:if test = "$stn_boyut = 1">
          <td class = "stn_boyut">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_boyut)">
                <xsl:value-of select = "substring-after(., $degisken_boyut)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_nitelik'">
        <xsl:if test = "$stn_nitelik = 1">
          <td class = "stn_nitelik">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_nitelik)">
                <xsl:value-of select = "substring-after(., $degisken_nitelik)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_1'">
        <xsl:if test = "$stn_boyut_1 = 1">
          <td class = "stn_boyut_1">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_boyut_1)">
                <xsl:value-of select = "substring-after(., $degisken_boyut_1)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_2'">
        <xsl:if test = "$stn_boyut_2 = 1">
          <td class = "stn_boyut_2">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_boyut_2)">
                <xsl:value-of select = "substring-after(., $degisken_boyut_2)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_boyut_3'">
        <xsl:if test = "$stn_boyut_3 = 1">
          <td class = "stn_boyut_3">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_boyut_3)">
                <xsl:value-of select = "substring-after(., $degisken_boyut_3)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_hacim'">
        <xsl:if test = "$stn_hacim = 1">
          <td class = "stn_hacim">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_hacim)">
                <xsl:value-of select = "substring-after(., $degisken_hacim)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_alan'">
        <xsl:if test = "$stn_alan = 1">
          <td class = "stn_alan">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_alan)">
                <xsl:value-of select = "substring-after(., $degisken_alan)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_ilk_birim'">
        <xsl:if test = "$stn_ilk_birim = 1">
          <td class = "stn_ilk_birim">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_ilk_birim)">
                <xsl:value-of select = "substring-after(., $degisken_ilk_birim)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_on_birim'">
        <xsl:if test = "$stn_on_birim = 1">
          <td class = "stn_on_birim">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_on_birim)">
                <xsl:value-of select = "substring-after(., $degisken_on_birim)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_brut'">
        <xsl:if test = "$stn_brut = 1">
          <td class = "stn_brut">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_brut)">
                <xsl:value-of select = "substring-after(., $degisken_brut)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_brut_kg'">
        <xsl:if test = "$stn_brut_kg = 1">
          <td class = "stn_brut_kg">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_brut_kg)">
                <xsl:value-of select = "substring-after(., $degisken_brut_kg)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_net'">
        <xsl:if test = "$stn_net = 1">
          <td class = "stn_net">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_net)">
                <xsl:value-of select = "substring-after(., $degisken_net)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_net_kg'">
        <xsl:if test = "$stn_net_kg = 1">
          <td class = "stn_net_kg">
            <xsl:for-each select = "$xml_fs_notu">
              <xsl:if test = "contains(., $degisken_net_kg)">
                <xsl:value-of select = "substring-after(., $degisken_net_kg)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$sutun = 'stn_siparis_satir_no'">
        <xsl:if test = "$stn_siparis_satir_no = 1">
          <td class = "stn_siparis_satir_no">
            <xsl:for-each select = "$xml_fs_siparis_satir_no">
              <xsl:if test = "substring(., 1, 12) = $degisken_siparis_satir_no">
                <xsl:value-of select = "substring(., 14, string-length(.) - 13)"/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </xsl:if>
      </xsl:if>
      <xsl:if test = "$kalan">
        <xsl:call-template name = "satirlari_goruntule">
          <xsl:with-param name = "xml_fs_sira_no" select = "$xml_fs_sira_no"/>
          <xsl:with-param name = "xml_fs_gtip_no" select = "$xml_fs_gtip_no"/>
          <xsl:with-param name = "xml_fs_satici_urun_hizmet_kodu" select = "$xml_fs_satici_urun_hizmet_kodu"/>
          <xsl:with-param name = "xml_fs_alici_urun_hizmet_kodu" select = "$xml_fs_alici_urun_hizmet_kodu"/>
          <xsl:with-param name = "xml_fs_urun_hizmet_adi" select = "$xml_fs_urun_hizmet_adi"/>
          <xsl:with-param name = "xml_fs_urun_hizmet_markasi" select = "$xml_fs_urun_hizmet_markasi"/>
          <xsl:with-param name = "xml_fs_urun_hizmet_modeli" select = "$xml_fs_urun_hizmet_modeli"/>
          <xsl:with-param name = "xml_fs_miktar_birim" select = "$xml_fs_miktar_birim"/>
          <xsl:with-param name = "xml_fs_paketleme" select = "$xml_fs_paketleme"/>
          <xsl:with-param name = "xml_fs_notu" select = "$xml_fs_notu"/>
          <xsl:with-param name = "xml_fs_ulke_kodu" select = "$xml_fs_ulke_kodu"/>
          <xsl:with-param name = "xml_fs_kap_cinsi" select = "$xml_fs_kap_cinsi"/>
          <xsl:with-param name = "xml_fs_kap_no" select = "$xml_fs_kap_no"/>
          <xsl:with-param name = "xml_fs_kap_sayisi" select = "$xml_fs_kap_sayisi"/>
          <xsl:with-param name = "xml_fs_siparis_satir_no" select = "$xml_fs_siparis_satir_no"/>
          <xsl:with-param name = "sutun_sirasi" select = "$kalan"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match = "//n1:DespatchAdvice/cac:DespatchLine">
    <xsl:variable
      name = "xml_fs_sira_no"
      select = "cbc:ID"/>
    <xsl:variable
      name = "xml_fs_gtip_no"
      select = "cac:Delivery/cac:Shipment/cac:GoodsItem/cbc:RequiredCustomsID"/>
    <xsl:variable
      name = "xml_fs_satici_urun_hizmet_kodu"
      select = "cac:Item/cac:SellersItemIdentification/cbc:ID"/>
    <xsl:variable
      name = "xml_fs_alici_urun_hizmet_kodu"
      select = "cac:Item/cac:BuyersItemIdentification/cbc:ID"/>
    <xsl:variable
      name = "xml_fs_urun_hizmet_adi"
      select = "cac:Item/cbc:Name"/>
    <xsl:variable
      name = "xml_fs_urun_hizmet_markasi"
      select = "cac:Item/cbc:BrandName"/>
    <xsl:variable
      name = "xml_fs_urun_hizmet_modeli"
      select = "cac:Item/cbc:ModelName"/>
    <xsl:variable
      name = "xml_fs_miktar_birim"
      select = "cbc:DeliveredQuantity"/>
    <xsl:variable
      name = "xml_fs_paketleme"
      select = "cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage"/>
    <xsl:variable
      name = "xml_fs_notu"
      select = "cbc:Note"/>
    <xsl:variable
      name = "xml_fs_ulke_kodu"
      select = "cac:Item/cac:OriginCountry/cbc:IdentificationCode"/>
    <xsl:variable
      name = "xml_fs_kap_cinsi"
      select = "$xml_fs_paketleme/cbc:PackagingTypeCode"/>
    <xsl:variable
      name = "xml_fs_kap_no"
      select = "$xml_fs_paketleme/cbc:ID"/>
    <xsl:variable
      name = "xml_fs_kap_sayisi"
      select = "$xml_fs_paketleme/cbc:Quantity"/>
    <xsl:variable
      name = "xml_fs_siparis_satir_no"
      select = "cbc:Note"/>
    <tr>
      <xsl:call-template name = "satirlari_goruntule">
        <xsl:with-param name = "xml_fs_sira_no" select = "$xml_fs_sira_no"/>
        <xsl:with-param name = "xml_fs_gtip_no" select = "$xml_fs_gtip_no"/>
        <xsl:with-param name = "xml_fs_satici_urun_hizmet_kodu" select = "$xml_fs_satici_urun_hizmet_kodu"/>
        <xsl:with-param name = "xml_fs_alici_urun_hizmet_kodu" select = "$xml_fs_alici_urun_hizmet_kodu"/>
        <xsl:with-param name = "xml_fs_urun_hizmet_adi" select = "$xml_fs_urun_hizmet_adi"/>
        <xsl:with-param name = "xml_fs_urun_hizmet_markasi" select = "$xml_fs_urun_hizmet_markasi"/>
        <xsl:with-param name = "xml_fs_urun_hizmet_modeli" select = "$xml_fs_urun_hizmet_modeli"/>
        <xsl:with-param name = "xml_fs_miktar_birim" select = "$xml_fs_miktar_birim"/>
        <xsl:with-param name = "xml_fs_paketleme" select = "$xml_fs_paketleme"/>
        <xsl:with-param name = "xml_fs_notu" select = "$xml_fs_notu"/>
        <xsl:with-param name = "xml_fs_ulke_kodu" select = "$xml_fs_ulke_kodu"/>
        <xsl:with-param name = "xml_fs_kap_cinsi" select = "$xml_fs_kap_cinsi"/>
        <xsl:with-param name = "xml_fs_kap_no" select = "$xml_fs_kap_no"/>
        <xsl:with-param name = "xml_fs_kap_sayisi" select = "$xml_fs_kap_sayisi"/>
        <xsl:with-param name = "xml_fs_siparis_satir_no" select = "$xml_fs_siparis_satir_no"/>
        <xsl:with-param name = "sutun_sirasi" select = "$sutun_sirasi_satirlar"/>
      </xsl:call-template>
    </tr>
  </xsl:template>

</xsl:stylesheet>