<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
	xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
	xmlns:ccts="urn:un:unece:uncefact:documentation:2"
	xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001"
	xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988"
	xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001"
	xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase"
	xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
	xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
	xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
	xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:ns8="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2"
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi ext ds ns8 xades">
  <xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN=""/>
  <xsl:output version="4.0" method="html" indent="no" encoding="UTF-8"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
  <xsl:param name="SV_OutputFormat" select="'HTML'"/>
  <xsl:variable name="XML" select="/"/>
  <xsl:template match="/">


    <!-- XSLT_DEF:e85d1abd119796f05a2a7ef32c381412 -->
    <!--DEGISKENLER-->
    <xsl:variable name="ublversiyon" select="//n1:Invoice/cbc:UBLVersionID"></xsl:variable>
    <xsl:variable name="ublversiyon_str" select="concat(//n1:Invoice/cbc:CustomizationID,' / UBL ',//n1:Invoice/cbc:UBLVersionID)"></xsl:variable>
    <xsl:variable name="ubl21" >
      <xsl:choose>
        <xsl:when test="$ublversiyon = '2.1'">
          <xsl:value-of select="'1'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="0"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="my_nl2">
      <xsl:text>&#xa;</xsl:text>
    </xsl:variable>
    <xsl:variable name="my_br">
      <xsl:text disable-output-escaping="yes">&lt;br/&gt;</xsl:text>
    </xsl:variable>
    <xsl:variable name="musteri_adi" select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name"></xsl:variable>
    <xsl:variable name="firma_adi" select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyName/cbc:Name"></xsl:variable>
    <xsl:variable name="firma_adresi" select="concat('',//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:StreetName,'&#160;',//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingName,'&#160;',//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber,'&#160;',//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:PostalZone,'&#160;',$my_br,//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName,' / ',//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CityName)"></xsl:variable>

    <xsl:variable name="fatura_no" select="//n1:Invoice/cbc:ID"></xsl:variable>
    <xsl:variable name="fatura_id" select="//n1:Invoice/cbc:UUID"></xsl:variable>
    <xsl:variable name="fatura_tarihi" select="//n1:Invoice/cbc:IssueDate"></xsl:variable>
    <xsl:variable name="fatura_zamani" select="//n1:Invoice/cbc:IssueTime"></xsl:variable>
    <xsl:variable name="fatura_tipi" select="//n1:Invoice/cbc:InvoiceTypeCode"></xsl:variable>
    <xsl:variable name="fatura_profili" select="//n1:Invoice/cbc:ProfileID"></xsl:variable>
    <xsl:variable name="fatura_doviz_kodu" select="//n1:Invoice/cbc:DocumentCurrencyCode"></xsl:variable>
    <xsl:variable name="fatura_dovizi" >
      <xsl:choose>
        <xsl:when test="$fatura_doviz_kodu = 'TRL' or $fatura_doviz_kodu = 'TRY'">
          <xsl:value-of select="'TL'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="//n1:Invoice/cbc:DocumentCurrencyCode"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="firma_adi2">
      <xsl:text disable-output-escaping="yes">Paket Taşımacılık Sistemleri ve Tur.Bil.Tic.A.Ş.</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_adresi2">
      <xsl:text disable-output-escaping="yes">Merkez : Yenibosna Merkez Mah. Cemal Ulusoy Cad. No:57/2 &lt;br&gt;Bahçelievler İstanbul &lt;br&gt;Şube : Şerifali Mah. Tavukçuyolu Cad. Hendem Sok. No:13/1 &lt;br&gt;Yukarıdudullu 34775 Ümraniye İstanbul</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_vkno_alt1">
      <xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID">
        <xsl:if test="@schemeID = 'TCKN' and position() = 1">
          <xsl:value-of select="." disable-output-escaping="yes" />
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="firma_vkno_alt2">
      <xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID">
        <xsl:if test="@schemeID = 'VKN' and position() = 1">
          <xsl:value-of select="." disable-output-escaping="yes" />
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="firma_vkno">
      <xsl:choose>
        <xsl:when test="$firma_vkno_alt1 and $firma_vkno_alt1!=''">
          <xsl:value-of select="$firma_vkno_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_vkno_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_vkno2">
      <xsl:text disable-output-escaping="yes">7190041528</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_vdaire_alt1">
      <xsl:text disable-output-escaping="yes">Marmara Kurumlar</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_vdaire_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_vdaire">
      <xsl:choose>
        <xsl:when test="$firma_vdaire_alt1 and $firma_vdaire_alt1!=''">
          <xsl:value-of select="$firma_vdaire_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_vdaire_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_tel_alt1">
      <xsl:text disable-output-escaping="yes">444 0 787 / 0850-480 0 787</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_tel_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_tel">
      <xsl:choose>
        <xsl:when test="$firma_tel_alt1 and $firma_tel_alt1!=''">
          <xsl:value-of select="$firma_tel_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_tel_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_fax_alt1">
      <xsl:text disable-output-escaping="yes">0212-651 6606</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_fax_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_fax">
      <xsl:choose>
        <xsl:when test="$firma_fax_alt1 and $firma_fax_alt1!=''">
          <xsl:value-of select="$firma_fax_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_fax_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_mersis_alt1">
      <xsl:text disable-output-escaping="yes">0719004152800018</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_mersis_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'MERSISNO']" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_mersis">
      <xsl:choose>
        <xsl:when test="$firma_mersis_alt1 and $firma_mersis_alt1!=''">
          <xsl:value-of select="$firma_mersis_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_mersis_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_email_alt1">
      <xsl:text disable-output-escaping="yes">muhasebe@pts.net</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_email_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_email">
      <xsl:choose>
        <xsl:when test="$firma_email_alt1 and $firma_email_alt1!=''">
          <xsl:value-of select="$firma_email_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_email_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_web_alt1">
      <xsl:text disable-output-escaping="yes">www.pts.net</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_web_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_web">
      <xsl:choose>
        <xsl:when test="$firma_web_alt1 and $firma_web_alt1!=''">
          <xsl:value-of select="$firma_web_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_web_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="firma_ticaretno_alt1">
      <xsl:text disable-output-escaping="yes">369416</xsl:text>
    </xsl:variable>
    <xsl:variable name="firma_ticaretno_alt2">
      <xsl:value-of select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'TICARETSICILNO']" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:variable name="firma_ticaretno">
      <xsl:choose>
        <xsl:when test="$firma_ticaretno_alt1 and $firma_ticaretno_alt1!=''">
          <xsl:value-of select="$firma_ticaretno_alt1" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$firma_ticaretno_alt2" disable-output-escaping="yes" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="satir_sayisi" select="count(//n1:Invoice/cac:InvoiceLine)" />
    <xsl:variable name="bos_satir" select="500 - count(//n1:Invoice/cac:InvoiceLine)" />
    <xsl:variable name="bos_satir_olsun" select="0" />
    <html>
      <title>
        <xsl:value-of select="$musteri_adi"/> Fatura No:<xsl:value-of select="$fatura_no"/>
      </title>
      <head>
        <style type="text/css">
          *{
          font-family: "Tahoma", "Times New Roman", Times, serif;
          font-size:10px;
          color:#2a2a2a;
          }
          body{ margin:0px; padding:0px; padding-left:4px;}
          .page_container{ width:800px;  }
          .pw{ width:800px; }
          .fatura_head_table{ }
          img.logo{ border:0px; }
          .firma_adi{ display:block; color:#07468d; font-size:1.2em; font-weight:bold; margin-top:10px;}
          .firma_adresi{ display:block; }
          .cerceve_ust{ position: relative; width:400px; height:15px; margin-top:5px;  }
          .cerceve_alt{ position: relative; width:400px; height:15px; margin-bottom:5px; }
          span.cerceve_box{ display: inline-block; width:15px; height:15px;  }
          .corner_tl{ position: absolute; top:0px;left:0px; border:0px none; border-top:2px solid #cccccc; border-left:2px solid #cccccc; }
          .corner_tr{ position: absolute; top:0px;right:0px; border:0px none; border-top:2px solid #cccccc; border-right:2px solid #cccccc; }
          .corner_bl{ position: absolute; top:0px;left:0px; border:0px none; border-bottom:2px solid #cccccc; border-left:2px solid #cccccc; }
          .corner_br{ position: absolute; top:0px;right:0px; border:0px none; border-bottom:2px solid #cccccc; border-right:2px solid #cccccc; }
          .cerceve_orta{ padding-right:10px; padding-left:10px; padding-top:0px; padding-bottom:0px; }
          .efatura_cap_div{ border-radius:6px; width: 100%; padding: 8px; background:#b90504; color:#ffffff }
          .firma_vd{ }
          .pair_key{ display: inline-block; width:100px; font-weight: bold; }
          .pair_seperator{ display: inline-block; width: 10px; text-align: left; }
          .pair_value{ display: inline-block; }
          .cerceve{ border-radius:6px; border:1px solid #cccccc; margin-top:5px;margin-bottom:5px; width:100%; }
          .pad6px,.pad6x{ padding:6px; }
          .pad10px,.pad10x{ padding:10px; }
          .tablo_satir{ width:800px; border-spacing:0px; }
          td{ vertical-align: top; }
          .alt_toplam_tablosu{ width:800px; }
          .alt_toplam_key{
          display: inline-block;
          width:250px;
          font-weight: bold;
          }
          .alt_toplam_sep{ display: inline-block;}
          .alt_toplam_val{ display: inline-block; width:120px; margin-left:3px; text-align:right; }
          .toplam_satiri{ padding:3px; }
          .row_banka{ font-weight: bold; color:#eb0712; }
          a{ text-decoration: none; color:#020b5f; }
          a:hover{ font-weight:bold; color:#07468d; }
          .alt_toplam_key{ color:#2a2a2a; }
          .alt_toplam_val{  color:#2a2a2a; }
          .fatura_not_container{ color:#2a2a2a; }
          .satir_miktar span{ white-space: nowrap; }
          span.span_satir_miktar{ white-space: nowrap !important; display:inline-block !important; }
          span.span_satir_miktar span{ display:inline !important; }
          .span_satir_bfiyat,.span_satir_kdv_oran,.span_satir_kdv_tutar,.span_satir_toplam,span.span_satir_miktar{white-space: nowrap !important; display:block !important;  text-align:right;  }
          .fatura_bilgi{ min-width: 210px !important; }
          .row_banka_cap{ display: inline-block; width:100px;   }
          .row_banka_cap2{ display: inline-block; width:160px;   }
          .row_banka_cap3{ display: inline-block; width:220px;   }
          .row_banka_cap4{ display: inline-block; width:350px;   }
          .row_banka{ margin-bottom:5px;   }
          .row_banka_sep{ display: inline-block; width:10px; }
          .fatura_not_container_w_box{
          border:1px solid #cccccc; padding:8px; border-radius:6px; margin-top:4px;
          overflow: visible;
          overflow-wrap: break-word;
          word-wrap: break-word;
          max-width: 780px;
          }
          .efatura_text{ text-align: center; color:#000000; font-weight:bold; font-size:12px; }#tablo_satir{border:1px solid #b0b0b0; }
          div.irsaliye_item_container{ margin-top:14px; margin-bottom:10px; display: block; visibility: visible; }
          span.alt_irsaliye_item{ padding:4px; margin-right:3px; border:1px solid #dddddd; background:#eeeeee;  margin-top:10px; display: inline-block; }
          .gib_logo_container{ text-align: center; }
          .span_satir_iskonto_oran div,.span_satir_iskonto_tutar div{ padding-right:4px; white-space: nowrap !important; display:block !important;  text-align:right;   }
          .myright, .myright div{ text-align: right; }
          .fatura_not_container_w_box_cap{
          background:#eeeeee;
          color:#1e1e1e;
          font-size:14px;
          font-weight:bold;
          padding:4px;
          border-radius:6px;
          border:1px solid #cccccc;
          }
          .fatura_not_container_w_box_cap2{
          font-size:12px;
          font-weight:bold;
          padding:4px;
          }
          .earsiv_iade_pair{ font-weight:bold; }
          .earsiv_iade_pair_bosluk{ height:30px; }
          .earsiv_iade_tablosu{ border:2px solid #cccccc; }
          .fatura_not_container_w_box_capheadaer{ padding:6px; color:#ffffff; background:#666666; }
          tr.earsiv_iade_odd,tr.earsiv_iade_even{ height:20px; }
          tr.earsiv_iade_odd{ background:#eeeeee; }
          .mytext_bold{ font-weight:bold; }
          .bos_satir{ min-width:30px; min-height:16px; display:block; }#tablo_satir{
          border:1px solid #020b5f;
          }
          .kolon_baslik{
          border-bottom : 1px solid  #020b5f;
          border-right:1px solid  #020b5f;
          background: #020b5f;
          color:#ffffff;
          }

          tr.tr_baslik td:last-child, tr.satir td:last-child {    border-right:0px none; }
          .kolon_baslik span{
          display:block; text-align:center;
          color:#ffffff;
          font-weight:bold;
          padding:3px;
          }
          tr.satir td{
          border-bottom : 1px solid  #020b5f;
          border-right:1px solid  #020b5f;
          }
          td.kolon_deger span { display:block; padding:2px; }
          .tablo_satir tr:last-child td{  border-bottom:0px none;  }

          .myframe{
          margin-top:5px;
          margin-bottom:5px;
          border : 1px solid  #020b5f; padding:6px; border-radius:6px;
          }
          .frmbanka{
          margin-top:5px;
          margin-bottom:5px;
          border : 1px solid  #020b5f; padding:6px; border-radius:6px;
          }
          tr.odd{
          background: #ededed;
          }
          tr.even{
          background: #ffffff;
          }
        </style>
      </head>
      <body>
        <div class="page_container" >
          <table class="pw fatura_head_table" width="800" cellpadding="0px">
            <tbody>
              <tr>
                <td>
                  <div class="pad10px">
                    <div class="firma_adi" >
                      <xsl:choose>
                        <xsl:when test="$firma_adi and $firma_adi!=''">
                          <xsl:value-of select="$firma_adi" disable-output-escaping="yes" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="$firma_adi2" disable-output-escaping="yes" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </div>
                    <div class="firma_adresi" >
                      <xsl:choose>
                        <xsl:when test="$firma_adresi and $firma_adresi!=''">
                          <xsl:value-of select="$firma_adresi" disable-output-escaping="yes" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="$firma_adresi2" disable-output-escaping="yes" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </div>
                    <div class="firma_vd">
                      <div>
                        <span class="pair_key">Vergi No</span>
                        <span class="pair_seperator">:</span>
                        <span class="pair_value">
                          <xsl:choose>
                            <xsl:when test="$firma_vkno and $firma_vkno != '' and $firma_vkno = '123'" >
                              <xsl:value-of select="$firma_vkno2"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="$firma_vkno"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </span>
                      </div>
                      <xsl:if test="$firma_vdaire != '' and $firma_vdaire != 'null'" >
                        <div>
                          <span class="pair_key">Vergi Dairesi</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="$firma_vdaire"/>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:if test="$firma_ticaretno != '' and $firma_ticaretno != 'null'" >
                        <div>
                          <span class="pair_key">Ticaret Sicil No</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="$firma_ticaretno"/>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:if test="$firma_mersis != '' and $firma_mersis != 'null'" >
                        <div>
                          <span class="pair_key">Mersis No</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="$firma_mersis"/>
                          </span>
                        </div>
                      </xsl:if>
                    </div>
                    <div class="firma_tel">
                      <xsl:if test="$firma_tel != '' and $firma_tel != 'null'" >
                        <div>
                          <span class="pair_key">Tel</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="$firma_tel"/>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:if test="$firma_fax != '' and $firma_fax != 'null'" >
                        <div>
                          <span class="pair_key">Fax</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="$firma_fax"/>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:if test="$firma_email != '' and $firma_email != 'null'" >
                        <div>
                          <span class="pair_key">E-Posta</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <a>
                              <xsl:attribute name="href">
                                mailto:<xsl:value-of select="$firma_email"/>
                              </xsl:attribute>
                              <xsl:value-of select="$firma_email"/>
                            </a>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:if test="$firma_web != '' and $firma_web != 'null'" >
                        <div>
                          <span class="pair_key">İnternet Sitesi</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <a>
                              <xsl:attribute name="href">
                                <xsl:if test="not(contains( $firma_web ,'http'))" >
                                  <xsl:value-of select="'http://'"/>
                                </xsl:if>
                                <xsl:value-of select="$firma_web"/>
                              </xsl:attribute>
                              <xsl:value-of select="$firma_web"/>
                            </a>
                          </span>
                        </div>
                      </xsl:if>
                    </div>

                  </div>
                </td>
                <td>
                  <div>
                    <div class="gib_logo_container" >
                      <br/>
                      <br/>
                      <br/>
                      <img src="data:image/png;base64,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"  class="gib_logo"  border="0" />
                      <br/>

                      <img src="data:image/png;base64,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"  border="0" />
                    </div>
                    <div class="efatura_text" >E-FATURA</div>
                  </div>
                </td>
                <td class="myright" >
                  <div>
                    <img src="data:image/png;base64,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"  class="logo"  border="0" />
                  </div>
                </td>
              </tr>
              <tr>
                <td colspan="2" >
                  <div class="cerceve_ust">
                    <span class="cerceve_box corner_tl"></span>
                    <span class="cerceve_box corner_tr"></span>
                  </div>
                  <div class="cerceve_orta">
                    <div class="musteri_adi" >
                      <xsl:call-template name="printMusteriAdi"></xsl:call-template>
                    </div>
                    <div class="musteri_adres" >
                      <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:StreetName" disable-output-escaping="yes" /><xsl:text>&#160;</xsl:text><xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingName" disable-output-escaping="yes" /><xsl:text>&#160;</xsl:text><xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber" >
                        No : <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber" disable-output-escaping="yes" />
                      </xsl:if><xsl:text disable-output-escaping="yes">&lt;br/&gt;</xsl:text><xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName" disable-output-escaping="yes" /><xsl:text>&#160;</xsl:text>/<xsl:text>&#160;</xsl:text><xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cbc:CityName" disable-output-escaping="yes" /><xsl:call-template name="firma_adres_extra"></xsl:call-template>
                    </div>
                    <div class="musteri_vd" >
                      <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name != '' and //n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name != 'null'" >
                        <div>
                          <span class="pair_key">Vergi Dairesi</span>
                          <span class="pair_seperator">:</span>
                          <span class="pair_value">
                            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cac:TaxScheme/cbc:Name"/>
                          </span>
                        </div>
                      </xsl:if>
                      <xsl:call-template name="printMusteriVergiNo"></xsl:call-template>
                    </div>
                  </div>
                  <div class="cerceve_alt">
                    <span class="cerceve_box corner_bl"></span>
                    <span class="cerceve_box corner_br"></span>
                  </div>
                </td>
                <td >
                  <br/>
                  <br/>
                  <div class="cerceve">
                    <div class="pad6x">
                      <div class="fatura_bilgi">
                        <xsl:if test="$ublversiyon_str != '' and $ublversiyon_str != 'null'" >
                          <div>
                            <span class="pair_key">Versiyon</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="$ublversiyon_str"/>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cbc:ProfileID != '' and //n1:Invoice/cbc:ProfileID != 'null'" >
                          <div>
                            <span class="pair_key">Senaryo</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="//n1:Invoice/cbc:ProfileID"/>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cbc:InvoiceTypeCode != '' and //n1:Invoice/cbc:InvoiceTypeCode != 'null'" >
                          <div>
                            <span class="pair_key">Fatura Tipi</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="//n1:Invoice/cbc:InvoiceTypeCode"/>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cbc:ID != '' and //n1:Invoice/cbc:ID != 'null'" >
                          <div>
                            <span class="pair_key">Fatura No</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="//n1:Invoice/cbc:ID"/>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cbc:IssueDate != '' and //n1:Invoice/cbc:IssueDate != 'null'" >
                          <div>
                            <span class="pair_key">Fatura Tarihi</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:if test="//n1:Invoice/cbc:IssueDate != '' and //n1:Invoice/cbc:IssueDate != 'null'" >
                                <xsl:for-each select="//n1:Invoice/cbc:IssueDate">
                                  <xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)" />-<xsl:value-of select="substring(.,1,4)"/>
                                </xsl:for-each>
                              </xsl:if>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:for-each select="//n1:Invoice/cac:DespatchDocumentReference">
                          <xsl:if test="./cbc:ID != '' and ./cbc:ID != 'null'" >
                            <div>
                              <span class="pair_key">İrsaliye No</span>
                              <span class="pair_seperator">:</span>
                              <span class="pair_value">
                                <xsl:value-of select="./cbc:ID"/>
                              </span>
                            </div>
                          </xsl:if>
                          <xsl:if test="./cbc:IssueDate != '' and ./cbc:IssueDate != 'null'" >
                            <div>
                              <span class="pair_key">İrsaliye Tarihi</span>
                              <span class="pair_seperator">:</span>
                              <span class="pair_value">
                                <xsl:if test="./cbc:IssueDate != '' and ./cbc:IssueDate != 'null'" >
                                  <xsl:for-each select="./cbc:IssueDate">
                                    <xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)" />-<xsl:value-of select="substring(.,1,4)"/>
                                  </xsl:for-each>
                                </xsl:if>
                              </span>
                            </div>
                          </xsl:if>
                        </xsl:for-each>
                        <xsl:if test="//n1:Invoice/cac:OrderReference/cbc:ID != '' and //n1:Invoice/cac:OrderReference/cbc:ID != 'null'" >
                          <div>
                            <span class="pair_key">Sipariş No</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="//n1:Invoice/cac:OrderReference/cbc:ID"/>
                            </span>
                          </div>
                        </xsl:if>
                        <xsl:if test="//n1:Invoice/cac:OrderReference/cbc:IssueDate != '' and //n1:Invoice/cac:OrderReference/cbc:IssueDate != 'null'" >
                          <div>
                            <span class="pair_key">Sipariş Tarihi</span>
                            <span class="pair_seperator">:</span>
                            <span class="pair_value">
                              <xsl:value-of select="//n1:Invoice/cac:OrderReference/cbc:IssueDate"/>
                            </span>
                          </div>
                        </xsl:if>
                      </div>
                    </div>
                  </div>
                </td>
              </tr>
            </tbody>
          </table>
          <div class="tablo_bosluk"></div>
          <table border="0" id="tablo_satir" borderspacing="0" cellpadding="0" class="tablo_satir" >
            <tbody>
              <tr class="tr_baslik">
                <td class="satir_mal kolon_baslik" >
                  <span>Mal/Hizmet</span>
                </td>
                <td class="satir_toplam kolon_baslik" >
                  <span>Toplam</span>
                </td>
              </tr>

              <xsl:for-each select="//n1:Invoice/cac:InvoiceLine">
                <xsl:call-template name="fatura_satir"></xsl:call-template>
              </xsl:for-each>
            </tbody>
          </table>
          <table border="0" id="alt_toplam_tablosu" borderspacing="0" cellpadding="0" class="alt_toplam_tablosu" >
            <tbody>
              <tr>
                <td width="50%" class="alt_toplam_col1" >
                  <div class="myframe ettn_container" >
                    <span class="ettn" >
                      ETTN : <xsl:value-of select="//n1:Invoice/cbc:UUID"/>
                    </span>
                  </div>
                  <div class="myframe yazi_container" >
                    <span class="yazi_ile" >
                      Yalnız:
                      <xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
                        <xsl:call-template name="dovizi_oku">
                          <xsl:with-param name="doviz" select="@currencyID" />
                        </xsl:call-template>
                      </xsl:for-each>
                    </span>
                  </div>
				  <xsl:if test="//n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate &gt; 0">
                  <div class="myframe yazi_container" >
                    <span class="yazi_ile" >
                      Yalnız:
                      <xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate">
                        <xsl:call-template name="dovizi_oku">
                          <xsl:with-param name="doviz" select="'TRY'" />
                        </xsl:call-template>
                      </xsl:for-each>
                    </span>
                  </div>
				  </xsl:if>
                  <xsl:call-template name="doviz_kuru_goster"></xsl:call-template>
                  <xsl:call-template name="alt_notlar"></xsl:call-template>
                </td>
                <td width="50%" class="alt_toplam_col2">
                  <div class="myframe" >
                    <xsl:call-template name="alt_toplam"></xsl:call-template>
                  </div>
                </td>
              </tr>
            </tbody>
          </table>
          <xsl:call-template name="fatura_notlari_yazdir"></xsl:call-template>
          <div class="frmbanka">
            <div class="CSSTableGenerator" >
              <table>
                <tr>
                  <td>Banka</td>
                  <td>Şube</td>
                  <td>Şube Kodu</td>
                  <td>Hesap No</td>
                  <td>IBAN</td>
                </tr>
                <tr>
                  <td>Halkbank</td>
                  <td>Güneşli</td>
                  <td>9816</td>
                  <td>10260627</td>
                  <td>TR29 0001 2009 8160 0010 2606 27</td>
                </tr>
                <tr>
                  <td>Garanti Bankası</td>
                  <td>Sefaköy</td>
                  <td>432</td>
                  <td>6290568</td>
                  <td>TR59 0006 2000 4320 0006 2905 68</td>
                </tr>
                <tr>
                  <td>Denizbank</td>
                  <td>Elmadağ</td>
                  <td>9050</td>
                  <td>17195986-351</td>
                  <td>TR79 0013 4000 0171 9598 6000 01</td>
                </tr>
                <tr>
                  <td>Kuveyt Türk Katılım Bankası</td>
                  <td>İkitelli Metro Şubesi</td>
                  <td>364</td>
                  <td>93724076 - 1</td>
                  <td>TR89 0020 5000 0937 2407 6000 01</td>
                </tr>
                <tr>
                  <td>Ziraat Bankası</td>
                  <td>İkitelli/İstanbul Şubesi</td>
                  <td>2406</td>
                  <td>63563022-5001</td>
                  <td>TR65 0001 0024 0663 5630 2250 01</td>
                </tr>

              </table>
            </div>
            <div style="font-size:12px;	font-family:Trebuchet MS;">
              <br/>Banka talimatınızda ödeme yaptığınız fatura numarasını ve firmanızın tam unvanını mutlaka belirtiniz
              <br/>Vadesinde ödenmeyen faturalara aylık %5 vade farkı uygulanır
              <br/>6475 sayılı Posta Hizmetleri Kanunu gereği brüt aǧırlıǧı 30 kg´a ya da hacmi 300 desimetreküpe kadar olan tüm gönderiler için %2.35 oranında Evrensel Posta Hizmeti Bedeli uygulanır
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="mytest">
    <xsl:text>&#160;</xsl:text>
  </xsl:template>
  <xsl:template name="firma_adres_extra">
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail" >
      <div>
        <span class="pair_key">E-Posta</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail"/>
        </span>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template name="printMusteriVergiNo">
    <xsl:choose>
      <xsl:when test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='VKN']">
        <div>
          <span class="pair_key">Vergi No</span>
          <span class="pair_seperator">:</span>
          <span class="pair_value">
            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='VKN']"/>
          </span>
        </div>
      </xsl:when>
      <xsl:when test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='TCKN']">
        <div>
          <span class="pair_key">TC Kimlik  No</span>
          <span class="pair_seperator">:</span>
          <span class="pair_value">
            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='TCKN']"/>
          </span>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>Vergi no bulunamadı !</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='HIZMETNO']">
      <div>
        <span class="pair_key">Hizmet No</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='HIZMETNO']"/>
        </span>
      </div>
    </xsl:if>
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='MUSTERINO']">
      <div>
        <span class="pair_key">Müşteri No</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='MUSTERINO']"/>
        </span>
      </div>
    </xsl:if>
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='TESISATNO']">
      <div>
        <span class="pair_key">Tesisat No</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='TESISATNO']"/>
        </span>
      </div>
    </xsl:if>
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='BAYINO']">
      <div>
        <span class="pair_key">Bayi No</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='BAYINO']"/>
        </span>
      </div>
    </xsl:if>
    <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='DOSYANO']">
      <div>
        <span class="pair_key">Dosya No</span>
        <span class="pair_seperator">:</span>
        <span class="pair_value">
          <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='DOSYANO']"/>
        </span>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="html_newline">
    <xsl:value-of disable-output-escaping="yes" select="'&lt;br&gt;'"/>
  </xsl:template>
  <xsl:template name="is_ubl21">
    <xsl:choose>
      <xsl:when test="//n1:Invoice/cbc:UBLVersionID = '2.1'">
        <xsl:value-of select="'1'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="dovizi_oku">
    <xsl:param name="doviz" />
    <xsl:variable name="okunacak" select="." />
    <xsl:variable name="noktadan_sonra" select="round(($okunacak - floor($okunacak)) * 100)" />
    <xsl:call-template name="sayi_oku" >
      <xsl:with-param name="okunacak"  select="." />
    </xsl:call-template>
    <xsl:if test="$doviz">
      <xsl:choose>
        <xsl:when test="$doviz =  'TRL' or $doviz =  'TRY'">
          <xsl:value-of select="' Türk Lirası'" />
          <xsl:if test="$noktadan_sonra &gt; 0">
            <xsl:value-of select="' '" />
            <xsl:call-template name="sayi_oku" >
              <xsl:with-param name="okunacak"  select="$noktadan_sonra" />
            </xsl:call-template>
            <xsl:value-of select="' Kuruş'" />
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>&#160;</xsl:text>
          <xsl:value-of select="$doviz" />
          <xsl:if test="$noktadan_sonra &gt; 0">
            <xsl:value-of select="' '" />
            <xsl:call-template name="sayi_oku" >
              <xsl:with-param name="okunacak"  select="$noktadan_sonra" />
            </xsl:call-template>
            <xsl:value-of select="' Cent'" />
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="sayi_oku">
    <xsl:param name="okunacak" />
    <xsl:variable name="tam_sayi" select="floor($okunacak)" />
    <xsl:variable name="birler"   select="floor($okunacak) mod 10" />
    <xsl:variable name="onlar"    select="floor(floor($tam_sayi mod 100) div 10)" />
    <xsl:variable name="yuzler"   select="floor(floor($tam_sayi mod 1000) div 100)" />
    <xsl:variable name="binler"   select="floor(floor($tam_sayi mod 1000000) div 1000)" />
    <xsl:variable name="milyonlar"   select="floor(floor($tam_sayi mod 1000000000) div 1000000)" />
    <xsl:variable name="milyarlar"   select="floor(floor($tam_sayi mod 1000000000000) div 1000000000)" />

    <xsl:if test="$milyarlar &gt; 0">
      <xsl:call-template name="sayi_oku_3hane" >
        <xsl:with-param name="sayi"  select="$milyarlar" />
      </xsl:call-template> Milyar
    </xsl:if>
    <xsl:if test="$milyonlar &gt; 0">
      <xsl:call-template name="sayi_oku_3hane" >
        <xsl:with-param name="sayi"  select="$milyonlar" />
      </xsl:call-template> Milyon
    </xsl:if>
    <xsl:if test="$binler &gt; 0">
      <xsl:if test="$binler = 1">Bin </xsl:if>
      <xsl:if test="$binler > 1">
        <xsl:call-template name="sayi_oku_3hane" >
          <xsl:with-param name="sayi"  select="$binler" />
        </xsl:call-template> Bin
      </xsl:if>
    </xsl:if>

    <xsl:call-template name="yuzler_oku" >
      <xsl:with-param name="sayi"  select="$yuzler" />
    </xsl:call-template>
    <xsl:call-template name="onlar_oku" >
      <xsl:with-param name="sayi"  select="$onlar" />
    </xsl:call-template>
    <xsl:call-template name="birler_oku" >
      <xsl:with-param name="sayi"  select="$birler" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="sayi_oku_3hane">
    <xsl:param name="sayi" />
    <xsl:variable name="tam_sayi" select="floor($sayi)" />
    <xsl:variable name="birler"   select="floor($sayi) mod 10" />
    <xsl:variable name="onlar"    select="floor(floor($tam_sayi mod 100) div 10)" />
    <xsl:variable name="yuzler"   select="floor(floor($tam_sayi mod 1000) div 100)" />
    <xsl:call-template name="yuzler_oku" >
      <xsl:with-param name="sayi"  select="$yuzler" />
    </xsl:call-template>
    <xsl:call-template name="onlar_oku" >
      <xsl:with-param name="sayi"  select="$onlar" />
    </xsl:call-template>
    <xsl:call-template name="birler_oku" >
      <xsl:with-param name="sayi"  select="$birler" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="birler_oku">
    <xsl:param name="sayi" />
    <xsl:choose>
      <xsl:when test="$sayi =  1">Bir </xsl:when>
      <xsl:when test="$sayi =  2">İki </xsl:when>
      <xsl:when test="$sayi =  3">Üç </xsl:when>
      <xsl:when test="$sayi =  4">Dört </xsl:when>
      <xsl:when test="$sayi =  5">Beş </xsl:when>
      <xsl:when test="$sayi =  6">Altı </xsl:when>
      <xsl:when test="$sayi =  7">Yedi </xsl:when>
      <xsl:when test="$sayi =  8">Sekiz </xsl:when>
      <xsl:when test="$sayi =  9">Dokuz </xsl:when>
      <xsl:otherwise> </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="onlar_oku">
    <xsl:param name="sayi" />
    <xsl:choose>
      <xsl:when test="$sayi =  1">On </xsl:when>
      <xsl:when test="$sayi =  2">Yirmi </xsl:when>
      <xsl:when test="$sayi =  3">Otuz </xsl:when>
      <xsl:when test="$sayi =  4">Kırk </xsl:when>
      <xsl:when test="$sayi =  5">Elli </xsl:when>
      <xsl:when test="$sayi =  6">Altmış </xsl:when>
      <xsl:when test="$sayi =  7">Yetmiş </xsl:when>
      <xsl:when test="$sayi =  8">Seksen </xsl:when>
      <xsl:when test="$sayi =  9">Doksan </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="yuzler_oku">
    <xsl:param name="sayi" />
    <xsl:choose>
      <xsl:when test="$sayi =  1">Yüz </xsl:when>
      <xsl:when test="$sayi =  2">İki Yüz </xsl:when>
      <xsl:when test="$sayi =  3">Üç Yüz </xsl:when>
      <xsl:when test="$sayi =  4">Dört Yüz </xsl:when>
      <xsl:when test="$sayi =  5">Beş Yüz </xsl:when>
      <xsl:when test="$sayi =  6">Altı Yüz </xsl:when>
      <xsl:when test="$sayi =  7">Yedi Yüz </xsl:when>
      <xsl:when test="$sayi =  8">Sekiz Yüz </xsl:when>
      <xsl:when test="$sayi =  9">Dokuz Yüz </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="binler_oku">
    <xsl:param name="sayi" />
    <xsl:choose>
      <xsl:when test="$sayi =  1">Bin </xsl:when>
      <xsl:when test="$sayi =  2">İki Bin </xsl:when>
      <xsl:when test="$sayi =  3">Üç Bin </xsl:when>
      <xsl:when test="$sayi =  4">Dört Bin </xsl:when>
      <xsl:when test="$sayi =  5">Beş Bin </xsl:when>
      <xsl:when test="$sayi =  6">Altı Bin </xsl:when>
      <xsl:when test="$sayi =  7">Yedi Bin </xsl:when>
      <xsl:when test="$sayi =  8">Sekiz Bin </xsl:when>
      <xsl:when test="$sayi =  9">Dokuz Bin </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="onbinler_oku">
    <xsl:param name="sayi" />
    <xsl:if test="$sayi &gt; 0">
      <xsl:call-template name="onlar_oku" >
        <xsl:with-param name="sayi"  select="$sayi" />
      </xsl:call-template>Bin
    </xsl:if>
  </xsl:template>

  <xsl:template name="parcala">
    <xsl:param name="csv"/>
    <xsl:param name="isaret"/>
    <xsl:variable  name="first-item" select="normalize-space(substring-before( concat( $csv, '|'), '|'))"/>
    <xsl:if test="$csv">
      <xsl:if test="normalize-space(substring-after(concat($first-item, ''), $isaret))">
        <xsl:value-of disable-output-escaping="yes" select="normalize-space(substring-after(concat($first-item, ''), $isaret))"/>
      </xsl:if>
      <xsl:call-template name="parcala">
        <xsl:with-param name="csv" select="substring-after($csv,'|')"/>
        <xsl:with-param name="isaret" select="$isaret"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <xsl:template name="ek_aciklamayi_al">
    <xsl:param name="org"/>
    <xsl:param name="aciklama"/>
    <xsl:param name="keyfield"/>
    <xsl:param name="forcedfield"/>
    <xsl:variable name="myvar1" >
      <xsl:call-template name="parcala">
        <xsl:with-param name="csv">
          <xsl:value-of select="$aciklama" disable-output-escaping="yes" />
        </xsl:with-param>
        <xsl:with-param name="isaret" select="$keyfield"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="myvar2" >
      <xsl:call-template name="parcala">
        <xsl:with-param name="csv">
          <xsl:value-of select="$aciklama" disable-output-escaping="yes" />
        </xsl:with-param>
        <xsl:with-param name="isaret" select="$forcedfield"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="myvar_aciklama" >
      <xsl:call-template name="aciklamayi_al">
        <xsl:with-param name="csv">
          <xsl:value-of select="$org" />
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$myvar2 and $myvar2 != ''">
        <xsl:value-of disable-output-escaping="yes" select="$myvar2"/>
      </xsl:when>
      <xsl:when test="$myvar1 and $myvar1 != ''">
        <xsl-if test="$myvar_aciklama" >
          <xsl:value-of disable-output-escaping="yes" select="concat($myvar_aciklama,' ')"/>
        </xsl-if>
        <xsl:value-of disable-output-escaping="yes" select="$myvar1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of disable-output-escaping="yes" select="$myvar_aciklama" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="aciklamayi_al">
    <xsl:param name="csv"/>
	<xsl:if test = "substring($csv, 1, 1) != '#'">
		<xsl:variable name="tmp1">
		  <xsl:value-of disable-output-escaping="yes" select="$csv" />
		  <xsl:value-of disable-output-escaping="yes" select="'|'"/>
		</xsl:variable>
		<xsl:variable name="first-item"   >
		  <xsl:value-of disable-output-escaping="yes" select="normalize-space(substring-before( $tmp1 , '|'))" />
		</xsl:variable>
		<xsl:if test="$first-item">
		  <xsl:value-of select="$first-item"/>
		</xsl:if>
	</xsl:if>
  </xsl:template>

  <xsl:template name="parcalabol">
    <xsl:param name="csv"/>
    <xsl:param name="isaret"/>
    <xsl:variable name="first-item"  select="normalize-space(substring-before( concat( $csv, '|'), '|'))"/>
    <xsl:if test="$first-item">
      <xsl:if test="normalize-space(substring-after(concat($first-item, ''), $isaret))">
        <xsl:value-of disable-output-escaping="yes" select="normalize-space(substring-after(concat($first-item, ''), $isaret))"/>
      </xsl:if>
      <br/>
      <xsl:call-template name="parcala">
        <xsl:with-param name="csv" select="substring-after($csv,'|')"/>
        <xsl:with-param name="isaret" select="$isaret"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="doviz">
    <xsl:param name="doviz_id" />
    <xsl:if test="$doviz_id and $doviz_id != '' and $doviz_id != 'null'" >
      <xsl:choose>
        <xsl:when test="$doviz_id =  'TRL' or $doviz_id =  'TRY'">
          <xsl:text>&#160;</xsl:text>
          <xsl:value-of select="'TL'" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>&#160;</xsl:text>
          <xsl:value-of select="$doviz_id" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>

  </xsl:template>

  <xsl:template name="alt_toplam">
    <xsl:variable name="is_ubl_21" >
      <xsl:call-template name="is_ubl21" ></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="op_tv2" >
      <xsl:call-template name="optevkifat2" ></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="op_tv3" >
      <xsl:call-template name="optevkifat3" ></xsl:call-template>
    </xsl:variable>

    <div class="toplam_satiri" >
      <span class="alt_toplam_key" >Mal Hizmet Toplam Tutarı</span>
      <span class="alt_toplam_sep">:</span>
      <span class="alt_toplam_val" >
        <xsl:value-of
					select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
        <xsl:call-template name="doviz" >
          <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID" />
        </xsl:call-template>
      </span>
    </div>

    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount and //n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount &gt; 0">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Toplam İskonto</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of
            select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount, '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID" />
          </xsl:call-template>
        </span>
      </div>
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Matrah</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of
            select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount, '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount/@currencyID" />
          </xsl:call-template>
        </span>
      </div>
    </xsl:if>
    <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >
          Hesaplanan <xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/> ( % <xsl:value-of select="cbc:Percent"/> )
        </span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
            <xsl:text> </xsl:text>
            <xsl:value-of
              select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
            <xsl:call-template name="doviz" >
              <xsl:with-param name="doviz_id"  select="../../cbc:TaxAmount/@currencyID" />
            </xsl:call-template>
          </xsl:for-each>
        </span>
      </div>
    </xsl:for-each>

    <xsl:if test="sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount)>0">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Tutarı</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >

          <xsl:value-of select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Üzerinden Hes. KDV</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifat Sonrası Kalan KDV</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of select="format-number(
													sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=0015]/cbc:TaxAmount)
													-sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxAmount)
													, '###.##0,00', 'european')"/>
          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
            <xsl:text>TL</xsl:text>
          </xsl:if>
          <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
            <xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
          </xsl:if>
        </span>
      </div>

    </xsl:if>

    <xsl:for-each select="n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >
          Hesaplanan KDV Tevkifat
          <xsl:text>(%</xsl:text>
          <xsl:value-of select="cbc:Percent"/>
          <xsl:text>)</xsl:text>
        </span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
            <xsl:text> </xsl:text>
            <xsl:value-of
              select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
            <xsl:if test="../../cbc:TaxAmount/@currencyID">
              <xsl:text> </xsl:text>
              <xsl:call-template name="doviz" >
                <xsl:with-param name="doviz_id"  select="../../cbc:TaxAmount/@currencyID" />
              </xsl:call-template>
            </xsl:if>
          </xsl:for-each>
        </span>
      </div>
    </xsl:for-each>

    <xsl:if test="sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount)>0">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Tutarı</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Üzerinden Hes. KDV</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:value-of select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
    </xsl:if>

    <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Tutarı</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
            <xsl:value-of
              select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
          </xsl:if>
          <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
            <xsl:value-of
              select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
          </xsl:if>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >Tevkifata Tabi İşlem Üzerinden Hes. KDV</span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
            <xsl:value-of
              select="format-number(sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
          </xsl:if>
          <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
            <xsl:value-of
              select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
          </xsl:if>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="n1:Invoice/cbc:DocumentCurrencyCode" />
          </xsl:call-template>
        </span>
      </div>
    </xsl:if>


    <div class="toplam_satiri" >
      <span class="alt_toplam_key" >Vergiler Dahil Toplam Tutar</span>
      <span class="alt_toplam_sep">:</span>
      <span class="alt_toplam_val" >
        <xsl:choose>
          <xsl:when test="//n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme] and $op_tv3 = '1'">
            <xsl:value-of	select="format-number(  //n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount + sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxAmount), '###.##0,00', 'european')"/>
          </xsl:when>
          <xsl:when test="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos; and $op_tv3 = '1'">
            <xsl:value-of	select="format-number(  //n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount + sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxAmount), '###.##0,00', 'european')"/>
            <xsl:value-of	select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount + sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of	select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount, '###.##0,00', 'european')"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="doviz" >
          <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID" />
        </xsl:call-template>
      </span>
    </div>




    <xsl:choose>
      <xsl:when test="$op_tv2 = '1'">
        <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
          <div class="toplam_satiri" >
            <span class="alt_toplam_key" >Tevkifat Sonrası Kalan KDV</span>
            <span class="alt_toplam_sep">:</span>
            <span class="alt_toplam_val" >
              <xsl:value-of	select="format-number( sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxableAmount) -  sum(n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme]/cbc:TaxAmount) 	, '###.##0,00', 'european')"/>
              <xsl:call-template name="doviz" >
                <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID" />
              </xsl:call-template>
            </span>
          </div>
        </xsl:if>
        <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
          <div class="toplam_satiri" >
            <span class="alt_toplam_key" >Tevkifat Sonrası Kalan KDV</span>
            <span class="alt_toplam_sep">:</span>
            <span class="alt_toplam_val" >
              <xsl:value-of	select="format-number(sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=0015]/cbc:TaxAmount) - sum(n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:TaxableAmount), '###.##0,00', 'european')"/>
              <xsl:call-template name="doviz" >
                <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID" />
              </xsl:call-template>
            </span>
          </div>
        </xsl:if>

      </xsl:when>
      <xsl:otherwise>

      </xsl:otherwise>
    </xsl:choose>


    <xsl:variable name="tutar_vergi_dahil" select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount" />
    <xsl:variable name="tutar_odenecek" select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount" />
    <xsl:variable name="tutar_toplam" select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount" />


    <div class="toplam_satiri" >
      <span class="alt_toplam_key" >Ödenecek Tutar</span>
      <span class="alt_toplam_sep">:</span>
      <span class="alt_toplam_val" >
        <xsl:value-of select="format-number($tutar_odenecek, '###.##0,00', 'european')"/>
        <xsl:if
					test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID">
          <xsl:text> </xsl:text>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID" />
          </xsl:call-template>

        </xsl:if>
      </span>
    </div>

    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRL' and //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">


      <div class="toplam_satiri" >
        <span class="alt_toplam_key" >
          <xsl:text>Mal Hizmet Toplam Tutarı (TL)</xsl:text>
        </span>
        <span class="alt_toplam_sep">:</span>
        <span class="alt_toplam_val" >
          <xsl:choose>
            <xsl:when test = "count(//n1:Invoice/cac:AdditionalDocumentReference[cbc:DocumentTypeCode = 'DOVIZ_BAKIYESI']) > 0">
              <xsl:for-each select = "//n1:Invoice/cac:AdditionalDocumentReference">
                <xsl:if test = "cbc:DocumentTypeCode = 'DOVIZ_BAKIYESI'">
                  <xsl:value-of select = "cbc:DocumentType"/>
                </xsl:if>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:text> TL</xsl:text>
        </span>
      </div>
      
      <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
        <div class="toplam_satiri" >
          <span class="alt_toplam_key" >
            <xsl:text>Hesaplanan </xsl:text>
            <xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
            <xsl:text>(%</xsl:text>
            <xsl:value-of select="cbc:Percent"/>
            <xsl:text>) (TL)</xsl:text>
          </span>
          <span class="alt_toplam_sep">:</span>
          <span class="alt_toplam_val" >
            <xsl:value-of
              select="format-number(cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
            <xsl:text> TL</xsl:text>
          </span>
        </div>
      </xsl:for-each>
      
      <div class="toplam_satiri" ><span class="alt_toplam_key" >
        <xsl:text>Vergiler Dahil Toplam Tutar(TL)</xsl:text>
      </span>
      <span class="alt_toplam_sep">:</span>
      <span class="alt_toplam_val" >
      <xsl:value-of
        select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
      <xsl:text> TL</xsl:text>
      </span></div>

      <div class="toplam_satiri" ><span class="alt_toplam_key" >
        <xsl:text>Ödenecek Tutar(TL)</xsl:text>
      </span>
      <span class="alt_toplam_sep">:</span>
      <span class="alt_toplam_val" >
        <xsl:value-of
          select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
        <xsl:text> TL</xsl:text>																	
      </span></div>

    </xsl:if>
    
  </xsl:template>

  <xsl:template name="print_satir_urun_kodu">
    <xsl:variable name="kod_aciklama" >
      <xsl:call-template name="ek_aciklamayi_al">
        <xsl:with-param name="org" select="deneme" />
        <xsl:with-param name="aciklama" select="./cbc:Note" />
        <xsl:with-param name="keyfield" select="'urunkodu'" />
        <xsl:with-param name="forcedfield" select="'urunkodu2'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$kod_aciklama and $kod_aciklama!=''">
        <div>
          <xsl:value-of select="$kod_aciklama" />
        </div>
      </xsl:when>
      <xsl:when test="cac:Item and cac:Item/cac:SellersItemIdentification and cac:Item/cac:SellersItemIdentification/cbc:ID">
        <div>
          <xsl:value-of select="cac:Item/cac:SellersItemIdentification/cbc:ID" />
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div> </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="print_satir_toplam">
    <xsl:value-of select="format-number(./cbc:LineExtensionAmount, '###.##0,00', 'european')"/>
    <xsl:call-template name="doviz" >
      <xsl:with-param name="doviz_id"  select="./cbc:LineExtensionAmount/@currencyID" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="print_diger_vergiler">
    <xsl:variable name="is_ubl_21" >
      <xsl:call-template name="is_ubl21" ></xsl:call-template>
    </xsl:variable>
    <xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
      <xsl:if test="cbc:TaxTypeCode!='0015' ">
        <div>
          <xsl:if test="position() = 1">
            <xsl:attribute name="class">hasdata</xsl:attribute>
          </xsl:if>
          <xsl:value-of select="cbc:Name"/>
          <xsl:if test="../../cbc:Percent">
            <xsl:text> (%</xsl:text>
            <xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
            <xsl:text>)=</xsl:text>
          </xsl:if>
          <xsl:value-of 	select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="../../cbc:TaxAmount/@currencyID" />
          </xsl:call-template>
        </div>
      </xsl:if>
    </xsl:for-each>

    <xsl:for-each select="./cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
      <div>
        <xsl:text>KDV TEVKİFAT </xsl:text>
        <xsl:if test="../../cbc:Percent">
          <xsl:text> (%</xsl:text>
          <xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
          <xsl:text>)=</xsl:text>
        </xsl:if>
        <xsl:value-of	select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
        <xsl:if test="../../cbc:TaxAmount/@currencyID">
          <xsl:text> </xsl:text>
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="../../cbc:TaxAmount/@currencyID" />
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="./cbc:Name">
          <xsl:call-template name="html_newline" ></xsl:call-template>
          <xsl:value-of	select="./cbc:Name"/>
        </xsl:if>
      </div>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="print_kdv_tutar">
    <xsl:for-each
      select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
      <xsl:if test="cbc:TaxTypeCode='0015' ">
        <xsl:text> </xsl:text>
        <xsl:value-of
          select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
        <xsl:call-template name="doviz" >
          <xsl:with-param name="doviz_id"  select="../../cbc:TaxAmount/@currencyID" />
        </xsl:call-template>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="print_kdv_oran">
    <xsl:for-each
      select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
      <xsl:if test="cbc:TaxTypeCode='0015' ">
        <xsl:text> </xsl:text>
        <xsl:if test="../../cbc:Percent">
          <xsl:text> % </xsl:text>
          <xsl:value-of select="format-number(../../cbc:Percent, '###.##0', 'european')"
								/>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="mytag">
    <xsl:param name="tag" />
    <xsl:value-of disable-output-escaping="yes" select="concat('&lt;',$tag,'&gt;')" />
  </xsl:template>
  <xsl:template name="myhtml">
    <xsl:param name="tag" />
    <xsl:param name="text" />
    <xsl:value-of disable-output-escaping="yes" select="concat('&lt;',$tag,'&gt;',$text,'&lt;','/',$tag,'&gt;')" />
  </xsl:template>
  <!-- 
<xsl:call-template name="mytag" ><xsl:with-param name="tag"  select="'div'" /></xsl:call-template>
<xsl:call-template name="myhtml" ><xsl:with-param name="tag"  select="'b'" /><xsl:with-param name="text"  select="'deneme'" /></xsl:call-template>
-->
  <xsl:template name="print_iskonto_tutar" >
    <xsl:for-each select="./cac:AllowanceCharge">
      <xsl:choose>
        <xsl:when test="./cbc:ChargeIndicator and ./cbc:ChargeIndicator='true'">
        </xsl:when>
        <xsl:when test="./cbc:Amount and ./cbc:Amount &gt; 0">
          <xsl:call-template name="mytag" >
            <xsl:with-param name="tag"  select="'div'" />
          </xsl:call-template>
          <xsl:value-of select="format-number(./cbc:Amount, '###.##0,00', 'european')" />
          <xsl:call-template name="doviz" >
            <xsl:with-param name="doviz_id"  select="./cbc:Amount/@currencyID" />
          </xsl:call-template>
          <xsl:call-template name="mytag" >
            <xsl:with-param name="tag"  select="'/div'" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="./cbc:MultiplierFactorNumeric">
          <xsl:for-each select="./cbc:MultiplierFactorNumeric">
            <xsl:call-template name="mytag" >
              <xsl:with-param name="tag"  select="'div'" />
            </xsl:call-template>
            <xsl:value-of select="format-number(../../cbc:Amount, '###.##0,00', 'european')" />
            <xsl:call-template name="doviz" >
              <xsl:with-param name="doviz_id"  select="./cbc:Amount/@currencyID" />
            </xsl:call-template>
            <xsl:call-template name="mytag" >
              <xsl:with-param name="tag"  select="'/div'" />
            </xsl:call-template>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="myhtml" >
            <xsl:with-param name="tag"  select="'div'" />
            <xsl:with-param name="text"  select="' '" />
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="myisktoplam">
    <xsl:param name="isk" />
    <xsl:param name="pos" />
    <xsl:if test="$pos &gt; 0 ">
      <xsl:if test="$pos = 1 ">
        <xsl:value-of select="$isk[1]/cbc:Amount" />
      </xsl:if>
      <xsl:if test="$pos > 1 ">
        <xsl:variable name="prev" >
          <xsl:call-template name="myisktoplam" >
            <xsl:with-param name="isk"  select="$isk" />
            <xsl:with-param name="pos"  select="$pos - 1" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$isk[$pos]/cbc:Amount + $prev" />
      </xsl:if>
    </xsl:if>
    <xsl:if test="$pos &lt;= 0 ">
      <xsl:value-of select="'0'" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="print_iskonto_oran">
    <xsl:variable name="toplamindirim"  select="sum(./cac:AllowanceCharge/cbc:Amount)" />
    <xsl:for-each select="./cac:AllowanceCharge">
      <xsl:choose>
        <xsl:when test="./cbc:ChargeIndicator and ./cbc:ChargeIndicator='true'">

        </xsl:when>
        <xsl:when test="./cbc:MultiplierFactorNumeric">
          <xsl:call-template name="mytag" >
            <xsl:with-param name="tag"  select="'div'" />
          </xsl:call-template>
          <xsl:text> %</xsl:text>
          <xsl:value-of select="format-number(./cbc:MultiplierFactorNumeric * 100, '###.##0,00', 'european')" />
          <xsl:call-template name="mytag" >
            <xsl:with-param name="tag"  select="'/div'" />
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="./cbc:Amount and ./cbc:Amount &gt; 0 and ../cbc:LineExtensionAmount &gt;= 0 ">
            <xsl:call-template name="mytag" >
              <xsl:with-param name="tag"  select="'div'" />
            </xsl:call-template>
            <xsl:text> % </xsl:text>
            <xsl:variable name="matrah" >
              <xsl:call-template name="myisktoplam" >
                <xsl:with-param name="isk"  select="../cac:AllowanceCharge" />
                <xsl:with-param name="pos"  select="position()-1" />
              </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="format-number( (./cbc:Amount div (../cbc:LineExtensionAmount + $toplamindirim - $matrah )) * 100, '###.##0,00', 'european')" />
            <xsl:call-template name="mytag" >
              <xsl:with-param name="tag"  select="'/div'" />
            </xsl:call-template>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="print_birim_fiyat">
    <xsl:value-of select="format-number(./cac:Price/cbc:PriceAmount, '###.##0,########', 'european')"/>

    <xsl:call-template name="doviz" >
      <xsl:with-param name="doviz_id"  select="./cac:Price/cbc:PriceAmount/@currencyID" />
    </xsl:call-template>

  </xsl:template>
  <xsl:template name="print_satir_notu">
    <xsl:if test="./cbc:Note">
      <span class="satir_notu">
        <xsl:call-template name="aciklamayi_al">
          <xsl:with-param name="csv">
            <xsl:value-of select="./cbc:Note"/>
          </xsl:with-param>
        </xsl:call-template>
      </span>
    </xsl:if>
  </xsl:template>
  <xsl:template name="print_miktar_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_miktar" />
    </xsl:variable>

    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'miktar'" />
      <xsl:with-param name="forcedfield" select="'miktar2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_birim_fiyat_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_birim_fiyat" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'birimfiyat'" />
      <xsl:with-param name="forcedfield" select="'birimfiyat2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_iskonto_oran_adv">
    <xsl:variable name="org_deger"  >
      <xsl:call-template name="print_iskonto_oran" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'iskontooran'" />
      <xsl:with-param name="forcedfield" select="'iskontooran2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_iskonto_tutar_adv" >
    <xsl:variable name="org_deger">
      <xsl:call-template name="print_iskonto_tutar" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'iskontotutar'" />
      <xsl:with-param name="forcedfield" select="'iskontotutar2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_kdv_oran_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_kdv_oran" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'kdvoran'" />
      <xsl:with-param name="forcedfield" select="'kdvoran2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_kdv_tutar_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_kdv_tutar" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'kdvtutar'" />
      <xsl:with-param name="forcedfield" select="'kdvtutar2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_diger_vergiler_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_diger_vergiler" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'diger'" />
      <xsl:with-param name="forcedfield" select="'diger2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="print_satir_toplam_adv">
    <xsl:variable name="org_deger" >
      <xsl:call-template name="print_satir_toplam" />
    </xsl:variable>
    <xsl:call-template name="ek_aciklamayi_al">
      <xsl:with-param name="org" select="$org_deger" />
      <xsl:with-param name="aciklama" select="./cbc:Note" />
      <xsl:with-param name="keyfield" select="'toplam'" />
      <xsl:with-param name="forcedfield" select="'toplam2'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="duzenleme_tarihi"  >
    <xsl:variable name="tarih" >
      <xsl:value-of select="//n1:Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/ds:Signature/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$tarih and $tarih != ''">
        <div>
          <xsl:value-of disable-output-escaping="yes" select="substring($tarih,9,2)"/>-<xsl:value-of disable-output-escaping="yes" select="substring($tarih,6,2)"/>-<xsl:value-of disable-output-escaping="yes" select="substring($tarih,1,4)"/>
          Saat : <xsl:value-of disable-output-escaping="yes" select="substring($tarih,12,2)"/>:<xsl:value-of disable-output-escaping="yes" select="substring($tarih,15,2)"/>:<xsl:value-of disable-output-escaping="yes" select="substring($tarih,18,2)"/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of disable-output-escaping="yes" select="//n1:Invoice/cbc:IssueDate"/> 09:00
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="print_basit_tarih">
    <xsl:param name="tarih" />
    <xsl:value-of disable-output-escaping="yes" select="substring($tarih,9,2)"/>-<xsl:value-of disable-output-escaping="yes" select="substring($tarih,6,2)"/>-<xsl:value-of disable-output-escaping="yes" select="substring($tarih,1,4)"/>
  </xsl:template>
  <xsl:template name="print_miktar_birim">
    <xsl:param name="birim" />
    <xsl:value-of disable-output-escaping="yes" select="' '" />
    <xsl:choose>
      <xsl:when test="$birim  = '26'">Ton</xsl:when>
      <xsl:when test="$birim  = 'BX'">Kutu</xsl:when>
      <xsl:when test="$birim  = 'LTR'">LT</xsl:when>
      <xsl:when test="$birim  = 'C62'">Adet</xsl:when>
      <xsl:when test="$birim  = 'NIU'">Adet</xsl:when>
      <xsl:when test="$birim  = 'EA'">Adet</xsl:when>
      <xsl:when test="$birim  = 'KGM'">KG</xsl:when>
      <xsl:when test="$birim  = 'KJO'">kJ</xsl:when>
      <xsl:when test="$birim  = 'GRM'">G</xsl:when>
      <xsl:when test="$birim  = 'MGM'">MG</xsl:when>
      <xsl:when test="$birim  = 'NT'">Net Ton</xsl:when>
      <xsl:when test="$birim  = 'GT'">GT</xsl:when>
      <xsl:when test="$birim  = 'MTR'">M</xsl:when>
      <xsl:when test="$birim  = 'MMT'">MM</xsl:when>
      <xsl:when test="$birim  = 'KTM'">KM</xsl:when>
      <xsl:when test="$birim  = 'MLT'">ML</xsl:when>
      <xsl:when test="$birim  = 'MMQ'">MM3</xsl:when>
      <xsl:when test="$birim  = 'CLT'">CL</xsl:when>
      <xsl:when test="$birim  = 'CMK'">CM2</xsl:when>
      <xsl:when test="$birim  = 'CMQ'">CM3</xsl:when>
      <xsl:when test="$birim  = 'CMT'">CM</xsl:when>
      <xsl:when test="$birim  = 'MTK'">M2</xsl:when>
      <xsl:when test="$birim  = 'MTQ'">M3</xsl:when>
      <xsl:when test="$birim  = 'DAY'">Gün</xsl:when>
      <xsl:when test="$birim  = 'MIN'">Dakika</xsl:when>
      <xsl:when test="$birim  = 'SEC'">Saniye</xsl:when>
      <xsl:when test="$birim  = 'HUR'">Saat</xsl:when>
      <xsl:when test="$birim  = 'ANN'">Yıl</xsl:when>
      <xsl:when test="$birim  = 'MON'">Ay</xsl:when>
      <xsl:when test="$birim  = 'PA'">Paket</xsl:when>
      <xsl:when test="$birim  = 'KWH'">KWHl</xsl:when>
      <xsl:otherwise>
        Evr : <xsl:value-of select="$birim"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="printMusteriAdi">
    <xsl:choose>
      <xsl:when test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName and //n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name and string-length(//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name) &gt; 2">
        <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyName/cbc:Name"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person">
          <div>
            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:FirstName"/>
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:MiddleName"/>
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:Person/cbc:FamilyName"/>
          </div>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="print_miktar">
    <xsl:call-template name="mytag" >
      <xsl:with-param name="tag"  select="'span'" />
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="floor(./cbc:InvoicedQuantity) = ./cbc:InvoicedQuantity ">
        <xsl:value-of select="format-number(./cbc:InvoicedQuantity,'###.##0,##', 'european')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="format-number(./cbc:InvoicedQuantity,'###.##0,00', 'european')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="print_miktar_birim" >
      <xsl:with-param name="birim"  select="./cbc:InvoicedQuantity/@unitCode" />
    </xsl:call-template>
    <xsl:call-template name="mytag" >
      <xsl:with-param name="tag"  select="'/span'" />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="alt_notlar">
    <xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
      <xsl:if	test="(cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' or ../../cbc:InvoiceTypeCode='OZELMATRAH') and cac:TaxCategory/cbc:TaxExemptionReason">
        <div class="fatura_not_container">
          <b>Vergi İstisna Muafiyet Sebebi: </b>
          <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/>
          <xsl:text>-</xsl:text>
          <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
        </div>
      </xsl:if>
      <xsl:if	test="starts-with(cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode,'007') and cac:TaxCategory/cbc:TaxExemptionReason">
        <div class="fatura_not_container">
          <b>ÖTV İstisna Muafiyet Sebebi: </b>
          <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/>
          <xsl:text>-</xsl:text>
          <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
        </div>
      </xsl:if>
    </xsl:for-each>
    <xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
      <div class="fatura_not_container">
        <b>Tevkifat Sebebi: </b>
        <xsl:value-of select="cbc:TaxTypeCode"/>
        <xsl:text>-</xsl:text>
        <xsl:choose>
          <xsl:when test="cbc:Name and cbc:Name!=''">
            <xsl:value-of select="cbc:Name"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="tevkifat_aciklamasi" >
              <xsl:with-param name="p1"  select="cbc:TaxTypeCode" />
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>

      </div>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="my_replace">
    <xsl:param name="text" />
    <xsl:param name="replace" />
    <xsl:param name="by" />
    <xsl:choose>
      <xsl:when test="contains($text, $replace)">
        <xsl:value-of select="substring-before($text,$replace)" />
        <xsl:value-of select="$by" disable-output-escaping="yes" />
        <xsl:call-template name="my_replace">
          <xsl:with-param name="text" select="substring-after($text,$replace)" />
          <xsl:with-param name="replace" select="$replace" />
          <xsl:with-param name="by" select="$by" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="my_replace_html">
    <xsl:param name="text" />

    <xsl:variable name="text1" >
      <xsl:call-template name="my_replace" >
        <xsl:with-param name="text" select="$text" />
        <xsl:with-param name="replace" select="'||'" />
        <xsl:with-param name="by" select="'&lt;br/&gt;'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="text2" >
      <xsl:call-template name="my_replace" >
        <xsl:with-param name="text" select="$text1" />
        <xsl:with-param name="replace" select="'%br'" />
        <xsl:with-param name="by" select="'&lt;br/&gt;'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="text3" >
      <xsl:call-template name="my_replace" >
        <xsl:with-param name="text" select="$text2" />
        <xsl:with-param name="replace" select="'%lt'" />
        <xsl:with-param name="by" select="'&lt;'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="text4" >
      <xsl:call-template name="my_replace" >
        <xsl:with-param name="text" select="$text3" />
        <xsl:with-param name="replace" select="'%gt'" />
        <xsl:with-param name="by" select="'&gt;'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$text4"  disable-output-escaping="yes" />
  </xsl:template>
  <xsl:template name="doviz_kuru_goster">
    <xsl:if test="//n1:Invoice/cac:PricingExchangeRate/cbc:SourceCurrencyCode" >
      <xsl:if test="//n1:Invoice/cac:PricingExchangeRate/cbc:SourceCurrencyCode != 'TRY'" >
        <div class="myframe yazi_container" >
          <span class="yazi_ile" >
            1 <xsl:value-of select="//n1:Invoice/cac:PricingExchangeRate/cbc:SourceCurrencyCode"  disable-output-escaping="yes" /> =
            <xsl:value-of select="//n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate"  disable-output-escaping="yes" />
            <xsl:call-template name="doviz" >
              <xsl:with-param name="doviz_id"  select="//n1:Invoice/cac:PricingExchangeRate/cbc:TargetCurrencyCode" />
            </xsl:call-template>
          </span>
        </div>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template name="irsaliyeleri_yazdir">
    <xsl:if test="//n1:Invoice/cac:DespatchDocumentReference and count(//n1:Invoice/cac:DespatchDocumentReference)>0">
      <div class="fatura_not_container_w_box" >
        <xsl:if test="//n1:Invoice/cac:DespatchDocumentReference and count(//n1:Invoice/cac:DespatchDocumentReference)>1">
          <div>
            <b>İRSALİYELER : </b>
          </div>
        </xsl:if>
        <xsl:if test="//n1:Invoice/cac:DespatchDocumentReference and count(//n1:Invoice/cac:DespatchDocumentReference)=1">
          <div>
            <b>İRSALİYE :</b>
          </div>
        </xsl:if>
        <div class="irsaliye_item_container" >
          <xsl:for-each select="//n1:Invoice/cac:DespatchDocumentReference">
            <span class="alt_irsaliye_item">
              <b>No :</b>&#160;<xsl:value-of select="./cbc:ID"  disable-output-escaping="yes" />
              &#160;&#160;
              <br/><b>Tarih: &#160;</b>
              <xsl:call-template name="print_basit_tarih">
                <xsl:with-param name="tarih" select="./cbc:IssueDate" />
              </xsl:call-template>
            </span>
          </xsl:for-each>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="fatura_notlari_yazdir">
    <xsl:param name="tip" />

    <xsl:choose>
      <xsl:when test="$tip and $tip = '0'">
        <div class="fatura_not_container_w_box" >
          <xsl:for-each select="//n1:Invoice/cbc:Note">
            <xsl:if test=". != '' and . != 'null'" >
              <div>
                <b>
                  Açıklama # <xsl:value-of select="position()"  disable-output-escaping="yes" /> :
                </b>
                <br/>
                <xsl:call-template name="my_replace_html" >
                  <xsl:with-param name="text" select="." />
                </xsl:call-template>
              </div>
            </xsl:if>
          </xsl:for-each>
        </div>
      </xsl:when>
      <xsl:when test="$tip and $tip = '2'">
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="//n1:Invoice/cbc:Note">
          <xsl:if test=". != '' and . != 'null'" >
            <div class="fatura_not_container_w_box" >
              <b>
                Açıklama # <xsl:value-of select="position()"  disable-output-escaping="yes" /> :
              </b>
              <br/>
              <xsl:call-template name="my_replace_html" >
                <xsl:with-param name="text" select="." />
              </xsl:call-template>
            </div>
          </xsl:if>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="//n1:Invoice/cac:PaymentMeans and count(//n1:Invoice/cac:PaymentMeans)>0">
      <div class="fatura_not_container_w_box" >
        <b>Ödeme Koşulları:</b>
        <br/>
        <xsl:for-each select="//n1:Invoice/cac:PaymentMeans">
          <div>
            <xsl:if test=". != '' and . != 'null'" >
              <xsl:choose>
                <xsl:when test="cbc:InstructionNote and string-length(cbc:InstructionNote)>0">
                  <xsl:value-of select="cbc:InstructionNote"  disable-output-escaping="yes" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="cbc:PaymentMeansCode"  disable-output-escaping="yes" /> : <xsl:value-of select="cbc:PaymentDueDate"  disable-output-escaping="yes" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </div>
        </xsl:for-each>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="optevkifat2">
    <xsl:value-of select="'1'"/>
  </xsl:template>
  <xsl:template name="optevkifat3">
    <xsl:value-of select="'1'"/>
  </xsl:template>
  <xsl:template name="tevkifat_aciklamasi">
    <xsl:param name="p1" />
    <xsl:if test="$p1">
      <xsl:choose>
        <xsl:when test="$p1 =  '601'">YAPIM İŞLERİ İLE BU İŞLERLE BİRLİKTE İFA EDİLEN MÜHENDİSLİK-MİMARLIK VE ETÜT-PROJE HİZMETLERİ *GT 117-Bölüm (3.2.1)+</xsl:when>
        <xsl:when test="$p1 =  '602'">ETÜT, PLAN-PROJE, DANIŞMANLIK, DENETİM VE BENZERİ HİZMETLER*GT 117-Bölüm (3.2.2)+</xsl:when>
        <xsl:when test="$p1 =  '603'">MAKİNE, TEÇHİZAT, DEMİRBAŞ VE TAŞITLARA AİT TADİL, BAKIM VE ONARIM HİZMETLERİ *GT 117-Bölüm (3.2.3)</xsl:when>
        <xsl:when test="$p1 =  '604'">YEMEK SERVİS HİZMETİ *GT 117-Bölüm (3.2.4)+</xsl:when>
        <xsl:when test="$p1 =  '605'">ORGANİZASYON HİZMETİ *GT 117-Bölüm (3.2.4)+</xsl:when>
        <xsl:when test="$p1 =  '606'">İŞGÜCÜ TEMİN HİZMETLERİ *GT 117-Bölüm (3.2.5)+</xsl:when>
        <xsl:when test="$p1 =  '607'">ÖZEL GÜVENLİK HİZMETİ *GT 117-Bölüm (3.2.5)+</xsl:when>
        <xsl:when test="$p1 =  '608'">YAPI DENETİM HİZMETLERİ *GT 117-Bölüm (3.2.6)+</xsl:when>
        <xsl:when test="$p1 =  '609'">FASON OLARAK YAPTIRILAN TEKSTİL VE KONFEKSİYON İŞLERİ, ÇANTA VE AYAKKABI DİKİM İŞLERİ VE BU İŞLERE ARACILIK HİZMETLERİ *GT 117-Bölüm (3.2.7)+</xsl:when>
        <xsl:when test="$p1 =  '610'">TURİSTİK MAĞAZALARA VERİLEN MÜŞTERİ BULMA / GÖTÜRME HİZMETLERİ *GT 117-Bölüm (3.2.8)+</xsl:when>
        <xsl:when test="$p1 =  '611'">SPOR KULÜPLERİNİN YAYIN, REKLÂM VE İSİM HAKKI GELİRLERİNE KONU İŞLEMLERİ *GT 117-Bölüm (3.2.9)+</xsl:when>
        <xsl:when test="$p1 =  '612'">TEMİZLİK HİZMETİ *GT 117-Bölüm (3.2.10)+</xsl:when>
        <xsl:when test="$p1 =  '613'">ÇEVRE VE BAHÇE BAKIM HİZMETLERİ *GT 117-Bölüm (3.2.10)+</xsl:when>
        <xsl:when test="$p1 =  '614'">SERVİS TAŞIMACILIĞI HİZMETİ *GT 117-Bölüm (3.2.11)+</xsl:when>
        <xsl:when test="$p1 =  '615'">HER TÜRLÜ BASKI VE BASIM HİZMETLERİ *GT 117-Bölüm (3.2.12)+</xsl:when>
        <xsl:when test="$p1 =  '616'">5018 SAYILI KANUNA EKLİ CETVELLERDEKİ İDARE, KURUM VE KURUŞLARA YAPILAN DİĞER HİZMETLER *GT 117-Bölüm (3.2.13)+</xsl:when>
        <xsl:when test="$p1 =  '617'">HURDA METALDEN ELDE EDİLEN KÜLÇE TESLİMLERİ *GT 117-Bölüm (3.3.1)+</xsl:when>
        <xsl:when test="$p1 =  '618'">HURDA METALDEN ELDE EDİLENLER DIŞINDAKİ BAKIR, ÇİNKO VE ALÜMİNYUM KÜLÇE TESLİMLERİ *GT 117-Bölüm (3.3.1)+</xsl:when>
        <xsl:when test="$p1 =  '619'">BAKIR, ÇİNKO VE ALÜMİNYUM ÜRÜNLERİNİN TESLİMİ *GT 117-Bölüm (3.3.2)+</xsl:when>
        <xsl:when test="$p1 =  '620'">İSTİSNADAN VAZGEÇENLERİN HURDA VE ATIK TESLİMİ *GT 117-Bölüm (3.3.3)+</xsl:when>
        <xsl:when test="$p1 =  '621'">METAL, PLASTİK, LASTİK, KAUÇUK, KÂĞIT VE CAM HURDA VE ATIKLARDAN ELDE EDİLEN HAMMADDE TESLİMİ *GT 117-Bölüm (3.3.4)]</xsl:when>
        <xsl:when test="$p1 =  '622'">PAMUK, TİFTİK, YÜN VE YAPAĞI İLE HAM POST VE DERİ TESLİMLERİ *GT 117-Bölüm (3.3.5)+</xsl:when>
        <xsl:when test="$p1 =  '623'">AĞAÇ VE ORMAN ÜRÜNLERİ TESLİMİ *GT 117-Bölüm (3.3.6)+</xsl:when>
        <xsl:when test="$p1 =  '650'">DİĞERLERİ</xsl:when>
      </xsl:choose>
    </xsl:if>

  </xsl:template>
  <xsl:template name="fatura_satir" >
    <xsl:param name="el"/>
    <tr>
      <xsl:attribute name="class">
        <xsl:choose>
          <xsl:when test="position() mod 2 = 1">satir odd</xsl:when>
          <xsl:otherwise>satir even</xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <td class="satir_mal kolon_deger" >
        <div class="span_satir_mal">
          <xsl:if test="./cac:Item/cbc:Name != '' and ./cac:Item/cbc:Name != 'null'" >
            <xsl:value-of select="./cac:Item/cbc:Name" disable-output-escaping="yes" />
          </xsl:if>
          <xsl:if test="./cac:Item/cbc:BrandName != '' and ./cac:Item/cbc:BrandName != 'null'" >
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="./cac:Item/cbc:BrandName" disable-output-escaping="yes" />
          </xsl:if>
          <xsl:if test="./cac:Item/cbc:ModelName != '' and ./cac:Item/cbc:ModelName != 'null'" >
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="./cac:Item/cbc:ModelName" disable-output-escaping="yes" />
          </xsl:if>
          <xsl:if test="./cac:Item/cbc:Description != '' and ./cac:Item/cbc:Description != 'null'" >
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="./cac:Item/cbc:Description" disable-output-escaping="yes" />
          </xsl:if>
          <xsl:call-template name="print_satir_notu"></xsl:call-template>
        </div>
      </td>
      <td class="satir_toplam kolon_deger" >
        <div class="span_satir_toplam">
          <xsl:call-template name="print_satir_toplam_adv"></xsl:call-template>
        </div>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>